/*
	$Id: selection_list.h,v 1.17 2001/09/08 19:12:52 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_selection_list
#define header_selection_list

#include "API/GUI/component.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "API/GUI/stylemanager_default.h"

class CL_Font;
class CL_Scrollbar;

class CL_SelectionList : public CL_Component
{
public:
	CL_SelectionList(
		const CL_ComponentOptions &options,
		CL_Component *parent,
		CL_StyleManager_Default *style,
		CL_Font *font,
		const std::list<std::string> &selection_list);

	virtual ~CL_SelectionList() { ; }

	void cancel();

	CL_Signal_v1<int> sig_activated;
	CL_Signal_v0 sig_cancelled;

private:
	void on_paint();
	void on_key_down(CL_Component *comp, CL_InputDevice *device, CL_Key key);
	void on_mouse_move(CL_Component *comp, CL_InputDevice *device, int x, int y);

	CL_Slot slot_paint, slot_key_down, slot_moouse_move;
	
	CL_StyleManager_Default *style;
	CL_Font *font;
	int highlighted_option;

	bool has_scrollbar;
	unsigned int max_height;
	int scroll_offset;
	void on_scroll_change(int new_offset);
	CL_Scrollbar *scrollbar;

	std::list<std::string> selection_list;
};

#endif

