/*
	$Id: menuitem.cpp,v 1.31 2001/12/22 19:46:24 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/GUI/menuitem.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "menuitem_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_MenuItem::CL_MenuItem(
	const CL_ComponentOptions &options,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_Component(options, parent, style),
	impl(NULL)
{
	init(options);
}

CL_MenuItem::CL_MenuItem(
	const std::string &text,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_Component(
		CL_MenuItem_Generic::create_options(text, false, false, false),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_MenuItem_Generic::create_options(text, false, false, false);
	init(options);
}

CL_MenuItem::CL_MenuItem(
	const std::string &text,
	bool checked,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_Component(
		CL_MenuItem_Generic::create_options(text, true, checked, false),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_MenuItem_Generic::create_options(text, true, checked, false);
	init(options);
}

CL_MenuItem::CL_MenuItem(
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_Component(
		CL_MenuItem_Generic::create_options("", false, false, true),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_MenuItem_Generic::create_options("", false, false, true);
	init(options);
}

void CL_MenuItem::init(const CL_ComponentOptions &options)
{
	impl = new CL_MenuItem_Generic(this, options, get_style_manager());
	get_style_manager()->connect_styles("menuitem", options, this);

	find_preferred_size();
}

CL_MenuItem::~CL_MenuItem()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

bool CL_MenuItem::is_checkable() const
{
	return impl->is_checkable();
}

bool CL_MenuItem::is_separator() const
{
	return impl->is_separator();
}

bool CL_MenuItem::is_checked() const
{
	return impl->is_checked();
}

bool CL_MenuItem::is_highlighted() const
{
	return impl->is_highlighted();
}

bool CL_MenuItem::has_submenu() const
{
	return impl->has_submenu();
}

const std::string &CL_MenuItem::get_text() const
{
	return impl->get_text();
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

void CL_MenuItem::set_text(const std::string &text)
{
	impl->set_text(text);
}

/////////////////////////////////////////////////////////////////////////////
// Signals:

CL_Signal_v0 &CL_MenuItem::sig_clicked()
{
	return impl->sig_clicked;
}

