/*
	$Id: menudata_generic.h,v 1.3 2001/09/08 19:12:51 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef header_menudata_generic
#define header_menudata_generic

#include <API/Core/Math/rect.h>

#include <string>

//class CL_MenuItem;
//class CL_PopupMenu;
//class CL_Surface;

class CL_ComponentOptions;
class CL_StyleManager;
class CL_MenuData;

class CL_MenuData_Generic
{
// Construction
public:
	static CL_ComponentOptions create_options(
		const CL_Rect &pos);

	CL_MenuData_Generic(CL_MenuData *self, const CL_ComponentOptions &options, CL_StyleManager *style);
	~CL_MenuData_Generic() {};

// Attributes:
public:
	unsigned int get_count() const;

	const std::string &get_text(int id) const;

	bool is_item_enabled(int id) const;

	bool is_item_checked(int id) const;

	int get_index(int id) const;

	int get_id(int index) const;

// Operations:
public:
	int insert_item(const std::string &text, int id = -1, int index = -1);

	int insert_separator(int id = -1, int index = -1);

	void remove_item(int id);

	void remove_item_at(int index);

	void clear();

	void change_item(const std::string &text, int id);

	void enable_item(int id, bool enable);

	void check_item(int id, bool check);

	void set_id(int index, int id);

// Implementation:
protected:
//	virtual void on_item_activated(CL_MenuItem *item, CL_PopupMenu *child) {};
//	virtual void on_item_highlighted(CL_MenuItem *item) {};

//	CL_Component *real_parent;

	CL_MenuData *menudata;

private:
	int generate_id(int id);
	// Returns a new available ID
	// Doesn't generate a new id if (id == -1)
};  

#endif
