/*
	$Id: menudata.cpp,v 1.9 2001/09/08 19:12:51 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/GUI/menudata.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "menudata_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_MenuData::CL_MenuData(
	const CL_ComponentOptions &options,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_Component(options, parent, style),
	impl(NULL)
{
	impl = new CL_MenuData_Generic(this, options, get_style_manager());
}
	
CL_MenuData::~CL_MenuData()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

unsigned int CL_MenuData::get_count() const
{
	return impl->get_count();
}

const std::string &CL_MenuData::get_text(int id) const
{
	return impl->get_text(id);
}

bool CL_MenuData::is_item_enabled(int id) const
{
	return impl->is_item_enabled(id);
}

bool CL_MenuData::is_item_checked(int id) const
{
	return impl->is_item_checked(id);
}

int CL_MenuData::get_index(int id) const
{
	return impl->get_index(id);
}

int CL_MenuData::get_id(int index) const
{
	return impl->get_id(index);
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

int CL_MenuData::insert_item(const std::string &text, int id, int index)
{
	return impl->insert_item(text, id, index);
}

int CL_MenuData::insert_separator(int id, int index)
{
	return impl->insert_separator(id, index);
}

void CL_MenuData::remove_item(int id)
{
	impl->remove_item(id);
}

void CL_MenuData::remove_item_at(int index)
{
	impl->remove_item_at(index);
}

void CL_MenuData::clear()
{
	impl->clear();
}

void CL_MenuData::change_item(const std::string &text, int id)
{
	impl->change_item(text, id);
}

void CL_MenuData::enable_item(int id, bool enable)
{
	impl->enable_item(id, enable);
}

void CL_MenuData::check_item(int id, bool check)
{
	impl->check_item(id, check);
}

void CL_MenuData::set_id(int index, int id)
{
	impl->set_id(index, id);
}
