/*
	$Id: menuitem.h,v 1.34 2001/10/10 12:17:10 sphair Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	See http://www.clanlib.org
	------------------------------------------------------------------------
*/

//! clanGUI="Controls"
//! header=gui.h

#ifndef header_menuitem
#define header_menuitem

#include "component.h"

class CL_MenuItem_Generic;

//: MenuItem component
class CL_MenuItem : public CL_Component
{
//! Construction:
public:
	//: Menu Item Constructor
	CL_MenuItem(
		const CL_ComponentOptions &options,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: Menu Item Constructor
	CL_MenuItem(
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: Menu Item Constructor
	CL_MenuItem(
		const std::string &text,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: Menu Item Constructor
	CL_MenuItem(
		const std::string &text,
		bool checked,
		CL_Component *parent,
		CL_StyleManager *style = NULL);

	//: Menu Item Destructor
	virtual ~CL_MenuItem();

//! Attributes:
public:
	//: Is checkable
	bool is_checkable() const;

	//: Is separator
	bool is_separator() const;

	//: Is checked
	bool is_checked() const;

	//: Is highlighted
	bool is_highlighted() const;

	//: Has submenu
	bool has_submenu() const;

	//: Returns the item label.
	//- Returns - The item label.
	const std::string &get_text() const;

//! Operations:
public:
	//: Sets the item label.
	//- text - The item label.
	void set_text(const std::string &text);

//! Signals:
public:
	//: This signal is emitted when the item is clicked on.
	CL_Signal_v0 &sig_clicked();

//! Implementation:
private:
	void init(const CL_ComponentOptions &options);

	CL_MenuItem(const CL_MenuItem &copy) : CL_Component(NULL, NULL) { return; } // disallow copy construction.
	CL_MenuItem_Generic *impl;
};

#endif
