#include "cp_types.h"
#include "cp_proto.h"

/* build edgelist from v1 to v2 through up to 'lgth' hex interior 
vertices (if possible). */

struct Edgelist *get_extended_edge(struct p_data *p,int v1,int v2,int lgth)
{
  int next=0,i,dir,w;
  struct Edgelist *elist=NULL,*trace;
  struct K_data *pK_ptr;

  if (!p->status || v1==v2) return NULL ;
  pK_ptr=p->packK_ptr;
  if ((dir=nghb(p,v1,v2))!=-1) /* immediate neighbor */
    {
      elist=(struct Edgelist *)calloc((size_t)1,
				      sizeof(struct Edgelist));
      elist->v=v1;
      elist->w=v2;
      return elist;
    }
  for (dir=0;dir<pK_ptr[v1].num+pK_ptr[v1].bdry_flag;dir++)
    /* search in this direction */
    {
      elist=(struct Edgelist *)calloc((size_t)1,sizeof(struct Edgelist));
      elist->v=v1;
      elist->w=pK_ptr[v1].flower[dir];
      trace=elist;
      i=1;
      while (i<lgth && (next=hex_proj(p,trace->w,trace->v)) 
	     && next!=v2)
	{
	  w=trace->w;
	  trace=trace->next=
	    (struct Edgelist *)calloc((size_t)1,sizeof(struct Edgelist));
	  trace->v=w;
	  trace->w=next;
	  i++;
	}
      if (next==v2)   /* found it! */
	{
	  w=trace->w;
	  trace=trace->next=
	    (struct Edgelist *)calloc((size_t)1,sizeof(struct Edgelist));
	  trace->v=w;
	  trace->w=next;
	  return elist;
	}
      edge_free(&elist);
    }
  return NULL;
} /* get_extended_edge */
