////////////////////////////////////////////////////////////////////////////////
// checkstyle: Checks Java source code for adherence to a set of rules.
// Copyright (C) 2001-2014  Oliver Burn
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.BaseCheckTestSupport;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import org.junit.Test;

public class EmptyLineSeparatorCheckTest
    extends BaseCheckTestSupport
{

    @Test
    public void testDefault() throws Exception
    {
        DefaultConfiguration checkConfig = createCheckConfig(EmptyLineSeparatorCheck.class);

        final String[] expected = {
            "20: 'import' should be separated from previous statement.",
            "33: 'CLASS_DEF' should be separated from previous statement.",
            "36: 'VARIABLE_DEF' should be separated from previous statement.",
            "37: 'STATIC_INIT' should be separated from previous statement.",
            "75: 'INTERFACE_DEF' should be separated from previous statement.",
        };
        verify(checkConfig, getPath("whitespace/InputEmptyLineSeparatorCheck.java"), expected);
    }

    @Test
    public void testAllowNoEmptyLineBetweenFields() throws Exception
    {

        DefaultConfiguration checkConfig = createCheckConfig(EmptyLineSeparatorCheck.class);
        checkConfig.addAttribute("allowNoEmptyLineBetweenFields", "true");

        final String[] expected = {
            "20: 'import' should be separated from previous statement.",
            "33: 'CLASS_DEF' should be separated from previous statement.",
            "37: 'STATIC_INIT' should be separated from previous statement.",
            "75: 'INTERFACE_DEF' should be separated from previous statement.",
        };
        verify(checkConfig, getPath("whitespace/InputEmptyLineSeparatorCheck.java"), expected);
    }

    @Test
    public void testHeader() throws Exception
    {
        DefaultConfiguration checkConfig = createCheckConfig(EmptyLineSeparatorCheck.class);
        final String[] expected = {
            "19: 'package' should be separated from previous statement.",
        };
        verify(checkConfig, getPath("whitespace/InputEmptyLineSeparatorCheckHeader.java"), expected);
    }
}
