#ifndef CAMSTREAMAPP_HPP
#define CAMSTREAMAPP_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qapplication.h>
#include <qcolor.h>
#include <qdict.h>
#include <qdir.h>
#include <qdom.h>
#include <qfile.h>
#include <qfont.h>
#include <qstring.h>

/** \file CamStreamApp.h
    Include file for main object; contains some global stuff, including
    the configuration file (which is an XML document)
 */


/** \enum FileTypeEnum
  Enumeration for image file types we support.

  Current supported formats: JPG, PNG, PPM, BMP (but only if the proper
  libaries are linked in)
 */
enum FileTypeEnum
{
   file_jpeg,
   file_png,
   file_ppm,
   file_bmp,

   file_MAX
};


class CCamStreamApp: public QApplication
{
private:
   QDir m_ConfigDir;
   QFile m_ConfigFile;
   QDir m_TempDir;
   int m_TempFileNumber;
   QString m_ShareDir;

   int snap_bitmask;	/* possible file formats */

   QDict<QString> VisiblePanels;

   void InitFileTypes();

   void UpdateConfiguration();
   void ReadConfigFile();
   void SaveConfigFile();

public:
   /** \internal */
   struct _Configuration {
     QDomDocument Document;
     QDomElement Root;
     QDomElement Defaults;
     QDomElement VideoDevices;
     QDomElement AudioDevices;
   } Configuration;

   CCamStreamApp(int argc, char *argv[]);
   ~CCamStreamApp();

   QString GetShareDir() const;

   //const QDir &GetConfigDir() const;
   const QString GetTempFileName(const QString &extension = QString::null);

   /* File name and type for saved images */
   int GetNumberOfFileTypes() const;
   int GetFileTypeMask() const;
   static QString GetFileTypeExtension(int n);
   static QString GetFileTypeFormatStr(int n);
   static int FormatStrToEnum(const QString &);
   static QString FormatStrToExtension(const QString &);

   QDomNode FindVideoDeviceConfig(const QString &name, const QString &node, bool create = false);
   QDomNode FindAudioDeviceConfig(const QString &name, const QString &node, bool create = false);

   void DumpConfigFile();
};

/// Global pointer to the one and only CCamStreamApp instance
extern CCamStreamApp *g_pCamApp;

#endif

