/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

public class Rectangle {

    protected double x;

    protected double y;

    protected double width;

    protected double height;

    /**
     * Constructs a new Rectangle object defined by four bounding
     * coordinates, (x1, y1) and (x2, y2)
     *
     * @param x1
     *            x coordinate of the upper-left point of the rectangle
     * @param y1
     *            y coordinate of the upper-left point of the rectangle
     * @param x2
     *            x coordinate of the lower-right point of the rectangle
     * @param y2
     *            y coordinate of the lower-right point of the rectangle
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public Rectangle(double x1, double y1, double x2, double y2) {
        if (x1 <= x2) {
            this.x = x1;
            this.width = x2 - x1;
        } else {
            this.x = x2;
            this.width = x1 - x2;
        }

        if (y1 <= y2) {
            this.y = y1;
            this.height = y2 - y1;
        } else {
            this.y = y2;
            this.height = y1 - y2;
        }
    }

    /**
     * Constructs a new Rectangle object defined by two Point objects,
     * which specify the upper-left and lower-right coordinates of the
     * rectangle
     *
     * @param upperLeft
     *            x coordinate of the upper-left point of the rectangle
     * @param lowerRight
     *            y coordinate of the lower-right point of the rectangle
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public Rectangle(Point upperLeft, Point lowerRight) {
        this(upperLeft.getX(), upperLeft.getY(),
            lowerRight.getX(), lowerRight.getY());
    }

    /**
     * Constructs a new Rectangle object with position and size
     * set to 0.
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public Rectangle() {
        this.x = this.y = this.width = this.height = 0;
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setSize(Point size) {
        this.width = size.getX();
        this.height = size.getY();
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setOrigin(Point origin) {
        this.x = origin.getX();
        this.y = origin.getY();
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #getX}.
     *
     * @see #getX
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public double getX1() {
        return x;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #setX}.
     *
     * @see #setX
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public void setX1(double x1) {
        this.x = x1;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #getWidth}.
     *
     * @see #getWidth
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public double getX2() {
        return x + width;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #setWidth}.
     *
     * @see #setWidth
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public void setX2(double x2) {
        if (x2 >= this.x) {
            this.width = x2 - this.x;
        } else {
            this.width = this.x - x2;
            this.x = x2;
        }
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #getY}.
     *
     * @see #getY
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public double getY1() {
        return y;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #setY}.
     *
     * @see #setY
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public void setY1(double y1) {
        this.y = y1;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #getHeight}.
     *
     * @see #getHeight
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public double getY2() {
        return y + height;
    }

    /**
     * @deprecated This method is deprecated in favor of
     *             {@link #setHeight}.
     *
     * @see #setHeight
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    public void setY2(double y2) {
        if (y2 >= this.y) {
            this.height = y2 - this.y;
        } else {
            this.height = this.y - y2;
            this.y = y2;
        }
    }
}
