#include <vector>
#include <list>

template <typename Iter>
concept bool InputIterator()
{
    return
        requires(Iter type)             // two conjoint requires expressions,
        {                               // each defining its own Iter params
            {++type} -> Iter &;         // This cannot be defined by one
            {type++} -> Iter;           // specifying two nested requires
            *type;                      // expressions, or comparable
            type.operator->();
        }
        &&
        requires(Iter lhs, Iter rhs)
        {
            {lhs == rhs} -> bool;
            {lhs != rhs} -> bool;
        };
}

//RAI
template <typename Iter>
concept bool RandomAccessIterator()
{
    return requires(Iter type, int step)
    {
        requires InputIterator<Iter>();
        {type + step} -> Iter;
        {type += step} -> Iter &;
    };
}
//=

template <RandomAccessIterator RAI>
void fun(RAI iter)
{};

template <InputIterator Iter>
void inputFun(Iter iter)
{};


struct MyIter
{
    int operator*() const;
    int const *operator->() const;
    MyIter &operator++();
    MyIter operator++(int);
    MyIter &operator+=(int step);
};

MyIter operator+(MyIter lhs, int rhs);
bool operator==(MyIter lhs, MyIter rhs);
bool operator!=(MyIter lhs, MyIter rhs);

using namespace std;

int main()
{
    MyIter myIter;
    inputFun(myIter);

    fun(myIter);

    vector<int> vi;
    fun(vi.begin());

    list<int> li;
//    fun(li.begin());
}
