// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "Url.h"

int main()
{
	Url base( "http://a/b/c/d;p?q#f" );
	
	static char* urls[] = {
		"g:h",
		  "g",
		  "./g",
		  "g/",
		  "/g",
		  "//g",
		  "?y",
		  "g?y",
		  "g?y/./x",
		  "#s",
		  "g#s",
		  "g#s/./x",
		  "g?y#s",
		  ";x",
		  "g;x",
		  "g;x?y#s",
		  ".",
		  "./",
		  "..",
		  "../",
		  "../g",
		  "../..",
		  "../../",
		  "../../g",
		  "",
		  "../../../g",
		  "../../../../g",
		  "/./g",
		  "/../g",
		  "g.",
		  ".g",
		  "g..",
		  "..g",
		  "./../g",
		  "./g/.",
		  "g/./h",
		  "g/../h",
		  "http:g",
		  "http:",
		  0
	};
	
	static char* answers[] = {
		"g:h",
		  "http://a/b/c/g",
		  "http://a/b/c/g",
		  "http://a/b/c/g/",
		  "http://a/g",
		  "http://g",
		  "http://a/b/c/d;p?y",
		  "http://a/b/c/g?y",
		  "http://a/b/c/g?y/./x",
		  "http://a/b/c/d;p?q#s",
		  "http://a/b/c/g#s",
		  "http://a/b/c/g#s/./x",
		  "http://a/b/c/g?y#s",
		  "http://a/b/c/d;x",
		  "http://a/b/c/g;x",
		  "http://a/b/c/g;x?y#s",
		  "http://a/b/c/",
		  "http://a/b/c/",
		  "http://a/b/",
		  "http://a/b/",
		  "http://a/b/g",
		  "http://a/",
		  "http://a/",
		  "http://a/g",
		  "http://a/b/c/d;p?q#f",
		  "http://a/../g",
		  "http://a/../../g",
		  "http://a/./g",
		  "http://a/../g",
		  "http://a/b/c/g.",
		  "http://a/b/c/.g",
		  "http://a/b/c/g..",
		  "http://a/b/c/..g",
		  "http://a/b/g",
		  "http://a/b/c/g/",
		  "http://a/b/c/g/h",
		  "http://a/b/c/h",
		  "http:g",
		  "http:",
		0
	};
	
	for ( int i = 0; urls[i]; i++ ) {
		Url url( &base, urls[i] );
		if ( url.url() != answers[i] ) {
			debug( "*** url = '%s', expected = '%s'", (const char*)url.url(), answers[i] );
		}
	}
}
