#include "StyleAttrProto.h"

StyleAttrProto::~StyleAttrProto()
{
    while ( _enumMap.first() ) {
	delete _enumMap.first();
	_enumMap.remove();
    }
}

int StyleAttrProto::tokenToValue( const QString& token ) const
{
    QListIterator<EnumMap> i( _enumMap );
    for ( i.toFirst(); i.current(); ++i ) {
        if ( i.current()->token == token ) {
            return i.current()->value;
        }
    }
    return -1;
}

const QString* StyleAttrProto::valueToToken( int value ) const
{
    QListIterator<EnumMap> i( _enumMap );
    for ( i.toFirst(); i.current(); ++i ) {
        if ( i.current()->value ==value ) {
            return &i.current()->token;
        }
    }
    return 0;
}
