// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _KPPPLoad_h_
#define _KPPPLoad_h_

#include <qstring.h>

#include <ktopwidget.h>

class KPopupMenu;

class Graph;
class PPPStats;

class KPPPLoad : public KTopLevelWidget {
    Q_OBJECT
    PPPStats*   _pppstats;
    Graph*      _graph;
    KPopupMenu* _popup;
    int         _connectTime;

    QString toString( uint bytes );
private slots:
    void updateStats( uint rxDelta, uint txDelta, uint rxTotal, uint txTotal );
    void linkDown();
    void linkUp();
    void configStatusBar();
    void configGraph();
    void configPPPStats();
    void doOptions();
    void doExit();
protected:
    void timerEvent( QTimerEvent* e );
public:
    KPPPLoad();
    ~KPPPLoad();
public slots:
    void popupMenu( const QPoint& pos );
};

#endif
