# Copyright(c) 1986 Association of Universities for Research in Astronomy Inc.

include <math/gsurfit.h>
include "dgsurfitdef.h"

# GSSAVE -- Procedure to save the surface fit for later use by the
# evaluate routines. After a call to GSSAVE the first eight elements
# of fit contain the surface type, xorder (or number of polynomial pieces
# in x), yorder (or the number of polynomial pieces in y), xterms, xmin,
# xmax, ymin, and ymax. The remaining spaces are filled by the GS_NCOEFF(sf)
# coefficients.

procedure dgssave (sf, fit)

pointer	sf		# pointer to the surface descriptor
double	fit[ARB]	# array for storing fit

begin
	# get the surface parameters
	if (sf == NULL)
	    return

	# order is surface type dependent
	switch (GS_TYPE(sf)) {
	case GS_LEGENDRE, GS_CHEBYSHEV, GS_POLYNOMIAL:
	    GS_SAVEXORDER(fit) = GS_XORDER(sf)
	    GS_SAVEYORDER(fit) = GS_YORDER(sf)
	default:
	    call error (0, "GSSAVE: Unknown surface type.")
	}

	# save remaining parameters
	GS_SAVETYPE(fit) = GS_TYPE(sf)
	GS_SAVEXMIN(fit) = GS_XMIN(sf)
	GS_SAVEXMAX(fit) = GS_XMAX(sf)
	GS_SAVEYMIN(fit) = GS_YMIN(sf)
	GS_SAVEYMAX(fit) = GS_YMAX(sf)
	GS_SAVEXTERMS(fit) = GS_XTERMS(sf)

	# save the coefficients
	call amovd (COEFF(GS_COEFF(sf)), fit[GS_SAVECOEFF+1], GS_NCOEFF(sf))
end
