use strict;
use warnings;

use RT::Test::GnuPG
  tests => undef,
  gnupg_options => {
    passphrase    => 'rt-test',
    'trust-model' => 'always',
  };

RT::Test->import_gnupg_key('rt-recipient@example.com');
RT::Test->import_gnupg_key( 'rt-test@example.com', 'public' );

my $queue = RT::Test->load_or_create_queue(
    Name              => 'GPG',
    CorrespondAddress => 'rt-recipient@example.com',
    CommentAddress    => 'rt-recipient@example.com',
    Sign              => 0,
);
ok $queue && $queue->id, 'loaded or created queue';

{
    my $mail = <<EOF;
From: root\@localhost
Subject: a ticket

That sounds like a great idea!
EOF

    my ($status, $id) = RT::Test->send_via_mailgate($mail, queue => "GPG");
    ok $id, "created a ticket";

    my ($reply) = RT::Test->fetch_caught_mails;
    ok( defined $reply, "Got a message" );
    unlike( $reply, qr/BEGIN PGP SIGNATURE/, "It is not signed");
}

{
    my $mail = <<EOF;
From: root\@localhost
Subject: a ticket
X-RT-Sign: 1

That sounds like a great idea!
EOF

    my ($status, $id) = RT::Test->send_via_mailgate($mail, queue => "GPG");
    ok $id, "created a ticket";

    my ($reply) = RT::Test->fetch_caught_mails;
    ok( defined $reply, "Got a message" );
    unlike( $reply, qr/BEGIN PGP SIGNATURE/, "It is not signed");
}

done_testing;
