﻿
# game/tutorial_quickstart.rpy:28
translate piglatin tutorial_create_27048c11:

    # e "When you're ready to use Ren'Py to create your visual novel, the first step is to create a new project."
    e "Henway ouyay'eray eadyray otay useay Enray'Ypay otay reatecay ouryay isualvay ovelnay, hetay irstfay epstay isay otay reatecay aay ewnay rojectpay."

# game/tutorial_quickstart.rpy:30
translate piglatin tutorial_create_bae6289c:

    # e "You can create a new project by clicking 'Create New Project' on the front screen of the launcher."
    e "Ouyay ancay reatecay aay ewnay rojectpay ybay ickingclay 'Reatecay Ewnay Rojectpay' onay hetay ontfray creensay ofay hetay auncherlay."

# game/tutorial_quickstart.rpy:32
translate piglatin tutorial_create_45915fcb:

    # e "If this is your first time using Ren'Py, it'll ask you for the place you want to keep your projects. The best place is always somewhere that's frequently backed up."
    e "Fiay histay isay ouryay irstfay imetay usingay Enray'Ypay, itay'llay askay ouyay orfay hetay aceplay ouyay antway otay eepkay ouryay rojectspay. Hetay estbay aceplay isay alwaysay omewheresay hattay'say equentlyfray ackedbay upay."

# game/tutorial_quickstart.rpy:36
translate piglatin tutorial_create_55e30cb5:

    # e "After that, Ren'Py will ask for a name for your project. You'll have to stick to English letters and numbers, as zip files can't handle anything more than that."
    e "Fteraay hattay, Enray'Ypay illway askay orfay aay amenay orfay ouryay rojectpay. Ouyay'llay avehay otay ickstay otay Nglisheay etterslay anday umbersnay, asay ipzay ilesfay ancay'tay andlehay anythingay oremay hantay hattay."

# game/tutorial_quickstart.rpy:40
translate piglatin tutorial_create_dea3e5c2:

    # e "The next thing Ren'Py will ask for is the resolution the visual novel will run at. This controls how large or small you'll have to make your game's artwork."
    e "Hetay extnay hingtay Enray'Ypay illway askay orfay isay hetay esolutionray hetay isualvay ovelnay illway unray atay. Histay ontrolscay owhay argelay oray mallsay ouyay'llay avehay otay akemay ouryay amegay'say artworkay."

# game/tutorial_quickstart.rpy:44
translate piglatin tutorial_create_3289ea75:

    # e "Finally, Ren'Py will ask you to select a color scheme. You can change this after the game has been created, so just pick a color that's pleasing."
    e "Inallyfay, Enray'Ypay illway askay ouyay otay electsay aay olorcay chemesay. Ouyay ancay angechay histay afteray hetay amegay ashay eenbay reatedcay, osay ustjay ickpay aay olorcay hattay'say easingplay."

# game/tutorial_quickstart.rpy:48
translate piglatin tutorial_create_6b9e3b96:

    # e "Once that's done, Ren'Py will work for a bit and return you to the main menu with the new project selected. Now, when you click Launch, Ren'Py will start your new game."
    e "Nceoay hattay'say oneday, Enray'Ypay illway orkway orfay aay itbay anday eturnray ouyay otay hetay ainmay enumay ithway hetay ewnay rojectpay electedsay. Ownay, henway ouyay ickclay Aunchlay, Enray'Ypay illway artstay ouryay ewnay amegay."

# game/tutorial_quickstart.rpy:50
translate piglatin tutorial_create_bdf94f9b:

    # e "To get back here, you can choose 'Tutorial' to switch to this tutorial game."
    e "Otay etgay ackbay erehay, ouyay ancay oosechay 'Utorialtay' otay witchsay otay histay utorialtay amegay."

# game/tutorial_quickstart.rpy:52
translate piglatin tutorial_create_22f516df:

    # e "You'll also need to edit the games script to make changes. To do that, click 'script.rpy' on the front page of the launcher."
    e "Ouyay'llay alsoay eednay otay editay hetay amesgay criptsay otay akemay angeschay. Otay oday hattay, ickclay 'criptsay.pyray' onay hetay ontfray agepay ofay hetay auncherlay."

# game/tutorial_quickstart.rpy:54
translate piglatin tutorial_create_18cd1d9d:

    # e "If it's your first time doing so, Ren'Py will ask you to select a text editor. Editra might be a safe choice, but read the descriptions to be sure."
    e "Fiay itay'say ouryay irstfay imetay oingday osay, Enray'Ypay illway askay ouyay otay electsay aay exttay editoray. Ditraeay ightmay ebay aay afesay oicechay, utbay eadray hetay escriptionsday otay ebay uresay."

# game/tutorial_quickstart.rpy:56
translate piglatin tutorial_create_bfbd6220:

    # e "After the text editor is downloaded, the script will open up and you can start to change what characters are saying."
    e "Fteraay hetay exttay editoray isay ownloadedday, hetay criptsay illway openay upay anday ouyay ancay artstay otay angechay hatway aracterschay areay ayingsay."

# game/tutorial_quickstart.rpy:69
translate piglatin tutorial_dialogue_112ff505:

    # e "Probably the most common thing a creator does with Ren'Py is to write dialogue for the player to read."
    e "Robablypay hetay ostmay ommoncay hingtay aay reatorcay oesday ithway Enray'Ypay isay otay riteway ialogueday orfay hetay ayerplay otay eadray."

# game/tutorial_quickstart.rpy:71
translate piglatin tutorial_dialogue_be2be31a:

    # e "But before I can show you how to write dialogue, let me show you how we present script examples."
    e "Utbay eforebay Iay ancay owshay ouyay owhay otay riteway ialogueday, etlay emay owshay ouyay owhay eway resentpay criptsay examplesay."

# game/tutorial_quickstart.rpy:74
translate piglatin tutorial_dialogue_7b6be28e:

    # "Eileen" "Examples will show up in a window like the one above. You'll need to click outside of the example window in order to advance the tutorial."
    "Eileen" "Xampleseay illway owshay upay inay aay indowway ikelay hetay oneay aboveay. Ouyay'llay eednay otay ickclay outsideay ofay hetay exampleay indowway inay orderay otay advanceay hetay utorialtay."

# game/tutorial_quickstart.rpy:76
translate piglatin tutorial_dialogue_5269d005:

    # "Eileen" "When an example is bigger than the screen, you can scroll around in it using the mouse wheel or by simply dragging the mouse."
    "Eileen" "Henway anay exampleay isay iggerbay hantay hetay creensay, ouyay ancay crollsay arounday inay itay usingay hetay ousemay heelway oray ybay implysay raggingday hetay ousemay."

# game/tutorial_quickstart.rpy:78
translate piglatin tutorial_dialogue_241c0c74:

    # "Eileen" "Script might seem scary at first, but if you look you'll see it's easy to match it up to what I'm saying."
    "Eileen" "Criptsay ightmay eemsay carysay atay irstfay, utbay ifay ouyay ooklay ouyay'llay eesay itay'say easyay otay atchmay itay upay otay hatway Iay'may ayingsay."

# game/tutorial_quickstart.rpy:82
translate piglatin tutorial_dialogue_f0d66410:

    # e "Let's see the simplest possible Ren'Py game."
    e "Etlay'say eesay hetay implestsay ossiblepay Enray'Ypay amegay."

# game/tutorial_quickstart.rpy:89
translate piglatin tutorial_dialogue_3e6b0068:

    # "Wow, It's really really dark in here."
    "Owway, Tiay'say eallyray eallyray arkday inay erehay."

# game/tutorial_quickstart.rpy:91
translate piglatin tutorial_dialogue_5072a404:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Etterbay atchway outay. Ouyay onday'tay antway otay ebay eatenay ybay aay Ruegay."

# game/tutorial_quickstart.rpy:99
translate piglatin tutorial_dialogue_d39d1b2b:

    # e "I'll show you the script of that example."
    e "Iay'llay owshay ouyay hetay criptsay ofay hattay exampleay."

# game/tutorial_quickstart.rpy:101
translate piglatin tutorial_dialogue_f51ecf1f:

    # e "This script demonstrates two kinds of Ren'Py statements, labels and say statements."
    e "Histay criptsay emonstratesday wotay indskay ofay Enray'Ypay atementsstay, abelslay anday aysay atementsstay."

# game/tutorial_quickstart.rpy:103
translate piglatin tutorial_dialogue_bc7ec147:

    # e "The first line is a label statement. The label statement is used to give a name to a place in the program."
    e "Hetay irstfay inelay isay aay abellay atementstay. Hetay abellay atementstay isay useday otay ivegay aay amenay otay aay aceplay inay hetay rogrampay."

# game/tutorial_quickstart.rpy:105
translate piglatin tutorial_dialogue_b20db833:

    # e "In this case, we're naming a place \"start\". The start label is special, as it marks the place a game begins running."
    e "Niay histay asecay, eway'eray amingnay aay aceplay \"artstay\". Hetay artstay abellay isay pecialsay, asay itay arksmay hetay aceplay aay amegay eginsbay unningray."

# game/tutorial_quickstart.rpy:107
translate piglatin tutorial_dialogue_b0afbe96:

    # e "The next line is a simple say statement. It consists of a string beginning with a double-quote, and ending at the next double-quote."
    e "Hetay extnay inelay isay aay implesay aysay atementstay. Tiay onsistscay ofay aay ringstay eginningbay ithway aay oubleday-uoteqay, anday endingay atay hetay extnay oubleday-uoteqay."

# game/tutorial_quickstart.rpy:109
translate piglatin tutorial_dialogue_628c9e4c:

    # e "Special characters in strings can be escaped with a backslash. To include \" in a string, we have to write \\\"."
    e "Pecialsay aracterschay inay ringsstay ancay ebay escapeday ithway aay ackslashbay. Otay includeay \" inay aay ringstay, eway avehay otay riteway \\\"."

# game/tutorial_quickstart.rpy:116
translate piglatin tutorial_dialogue_3e6b0068_1:

    # "Wow, It's really really dark in here."
    "Owway, Tiay'say eallyray eallyray arkday inay erehay."

# game/tutorial_quickstart.rpy:125
translate piglatin tutorial_dialogue_d7f0b5b7:

    # e "When Ren'Py sees a single string on a line by itself, it uses the narrator to say that string. So a single string can be used to express a character's thoughts."
    e "Henway Enray'Ypay eessay aay inglesay ringstay onay aay inelay ybay itselfay, itay usesay hetay arratornay otay aysay hattay ringstay. Osay aay inglesay ringstay ancay ebay useday otay expressay aay aracterchay'say houghtstay."

# game/tutorial_quickstart.rpy:131
translate piglatin tutorial_dialogue_5072a404_1:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Etterbay atchway outay. Ouyay onday'tay antway otay ebay eatenay ybay aay Ruegay."

# game/tutorial_quickstart.rpy:139
translate piglatin tutorial_dialogue_9dd2d543:

    # e "When we have two strings separated by a space, the first is used as the character's name, and the second is what the character is saying."
    e "Henway eway avehay wotay ringsstay eparatedsay ybay aay pacesay, hetay irstfay isay useday asay hetay aracterchay'say amenay, anday hetay econdsay isay hatway hetay aracterchay isay ayingsay."

# game/tutorial_quickstart.rpy:141
translate piglatin tutorial_dialogue_64ffe685:

    # e "This two-argument form of the say statement is used for dialogue, where a character is speaking out loud."
    e "Histay wotay-argumentay ormfay ofay hetay aysay atementstay isay useday orfay ialogueday, hereway aay aracterchay isay peakingsay outay oudlay."

# game/tutorial_quickstart.rpy:143
translate piglatin tutorial_dialogue_97a33275:

    # e "If you'd like, you can run this game yourself by erasing everything in your project's script.rpy file, and replacing it with the code in the box above."
    e "Fiay ouyay'day ikelay, ouyay ancay unray histay amegay ourselfyay ybay erasingay everythingay inay ouryay rojectpay'say criptsay.pyray ilefay, anday eplacingray itay ithway hetay odecay inay hetay oxbay aboveay."

# game/tutorial_quickstart.rpy:145
translate piglatin tutorial_dialogue_c5e70d7e:

    # e "Be sure to preserve the spacing before lines. That's known as indentation, and it's used to help Ren'Py group lines of script into blocks."
    e "Ebay uresay otay reservepay hetay pacingsay eforebay ineslay. Hattay'say nownkay asay indentationay, anday itay'say useday otay elphay Enray'Ypay oupgray ineslay ofay criptsay intoay ocksblay."

# game/tutorial_quickstart.rpy:149
translate piglatin tutorial_dialogue_90719f73:

    # e "Using a string for a character's name is inconvenient, for two reasons."
    e "Singuay aay ringstay orfay aay aracterchay'say amenay isay inconvenientay, orfay wotay easonsray."

# game/tutorial_quickstart.rpy:151
translate piglatin tutorial_dialogue_910f286a:

    # e "The first is that's it's a bit verbose. While typing \"Lucy\" isn't so bad, imagine if you had to type \"Eileen Richardson\" thousands of times."
    e "Hetay irstfay isay hattay'say itay'say aay itbay erbosevay. Hileway ypingtay \"Ucylay\" isnay'tay osay adbay, imagineay ifay ouyay adhay otay ypetay \"Ileeneay Ichardsonray\" housandstay ofay imestay."

# game/tutorial_quickstart.rpy:153
translate piglatin tutorial_dialogue_9c9d59c2:

    # e "The second is that it doesn't leave any place to put styling, which can change the look of a character."
    e "Hetay econdsay isay hattay itay oesnday'tay eavelay anyay aceplay otay utpay ylingstay, hichway ancay angechay hetay ooklay ofay aay aracterchay."

# game/tutorial_quickstart.rpy:155
translate piglatin tutorial_dialogue_2a2d1e51:

    # e "To solve these problems, Ren'Py lets you define Characters."
    e "Otay olvesay hesetay roblemspay, Enray'Ypay etslay ouyay efineday Haracterscay."

# game/tutorial_quickstart.rpy:159
translate piglatin tutorial_dialogue_16e8c5fd:

    # e "Here's an example Character definition. It begins with the word \"define\". That tells Ren'Py that we are defining something."
    e "Erehay'say anay exampleay Haractercay efinitionday. Tiay eginsbay ithway hetay ordway \"efineday\". Hattay ellstay Enray'Ypay hattay eway areay efiningday omethingsay."

# game/tutorial_quickstart.rpy:161
translate piglatin tutorial_dialogue_34fe5aa0:

    # e "Define is followed by a short name for the character, like \"l\". We'll be able to use that short name when writing dialogue."
    e "Efineday isay ollowedfay ybay aay ortshay amenay orfay hetay aracterchay, ikelay \"lay\". Eway'llay ebay ableay otay useay hattay ortshay amenay henway ritingway ialogueday."

# game/tutorial_quickstart.rpy:163
translate piglatin tutorial_dialogue_67f90201:

    # e "This is followed by an equals sign, and the thing that we're defining. In this case, it's a Character."
    e "Histay isay ollowedfay ybay anay equalsay ignsay, anday hetay hingtay hattay eway'eray efiningday. Niay histay asecay, itay'say aay Haractercay."

# game/tutorial_quickstart.rpy:165
translate piglatin tutorial_dialogue_4e454a89:

    # e "On the first line, the character's name is given to be \"Lucy\", and her name will be drawn a reddish color."
    e "Noay hetay irstfay inelay, hetay aracterchay'say amenay isay ivengay otay ebay \"Ucylay\", anday erhay amenay illway ebay rawnday aay eddishray olorcay."

# game/tutorial_quickstart.rpy:167
translate piglatin tutorial_dialogue_db11f026:

    # e "These short names are case-sensitive. Capital L is a different name from lower-case l, so you'll need to be careful about that."
    e "Hesetay ortshay amesnay areay asecay-ensitivesay. Apitalcay Lay isay aay ifferentday amenay omfray owerlay-asecay lay, osay ouyay'llay eednay otay ebay arefulcay aboutay hattay."

# game/tutorial_quickstart.rpy:171
translate piglatin tutorial_dialogue_1d161320:

    # e "Now that we have a character defined, we can use it to say dialogue."
    e "Ownay hattay eway avehay aay aracterchay efinedday, eway ancay useay itay otay aysay ialogueday."

# game/tutorial_quickstart.rpy:178
translate piglatin tutorial_dialogue_3710169c:

    # l "Why are you trying to put words into my mouth? And who are you calling \"it\"?"
    l "Hyway areay ouyay yingtray otay utpay ordsway intoay ymay outhmay? Ndaay howay areay ouyay allingcay \"itay\"?"

# game/tutorial_quickstart.rpy:180
translate piglatin tutorial_dialogue_6d463776:

    # l "What's more, what are you going to do about the Grue problem? Are you just going to leave me here?"
    l "Hatway'say oremay, hatway areay ouyay oinggay otay oday aboutay hetay Ruegay roblempay? Reaay ouyay ustjay oinggay otay eavelay emay erehay?"

# game/tutorial_quickstart.rpy:188
translate piglatin tutorial_dialogue_023bcd31:

    # e "Here's the full game, including the two new lines of dialogue, both of which use the Character we defined to say dialogue."
    e "Erehay'say hetay ullfay amegay, includingay hetay wotay ewnay ineslay ofay ialogueday, othbay ofay hichway useay hetay Haractercay eway efinedday otay aysay ialogueday."

# game/tutorial_quickstart.rpy:190
translate piglatin tutorial_dialogue_48bb9547:

    # e "The one-argument form of the say statement is unchanged, but in the two-argument form, instead of the first string we can use a short name."
    e "Hetay oneay-argumentay ormfay ofay hetay aysay atementstay isay unchangeday, utbay inay hetay wotay-argumentay ormfay, insteaday ofay hetay irstfay ringstay eway ancay useay aay ortshay amenay."

# game/tutorial_quickstart.rpy:192
translate piglatin tutorial_dialogue_56a9936f:

    # e "When this say statement is run, Ren'Py will look up the short name, which is really a Python variable. It will then use the associated Character to show the dialogue."
    e "Henway histay aysay atementstay isay unray, Enray'Ypay illway ooklay upay hetay ortshay amenay, hichway isay eallyray aay Ythonpay ariablevay. Tiay illway hentay useay hetay associateday Haractercay otay owshay hetay ialogueday."

# game/tutorial_quickstart.rpy:194
translate piglatin tutorial_dialogue_d5984a21:

    # e "The Character object controls who is speaking, the color of their name, and many other properties of the dialogue."
    e "Hetay Haractercay objectay ontrolscay howay isay peakingsay, hetay olorcay ofay heirtay amenay, anday anymay otheray ropertiespay ofay hetay ialogueday."

# game/tutorial_quickstart.rpy:198
translate piglatin tutorial_dialogue_a5bcac8b:

    # e "Since the bulk of a visual novel is dialogue, we've tried to make it as easy to write as possible."
    e "Incesay hetay ulkbay ofay aay isualvay ovelnay isay ialogueday, eway'evay iedtray otay akemay itay asay easyay otay riteway asay ossiblepay."

# game/tutorial_quickstart.rpy:200
translate piglatin tutorial_dialogue_6b9a42d0:

    # e "Hopefully, by allowing the use of short names for characters, we've succeeded."
    e "Opefullyhay, ybay allowingay hetay useay ofay ortshay amesnay orfay aracterschay, eway'evay ucceededsay."

# game/tutorial_quickstart.rpy:206
translate piglatin tutorial_images_e09ac970:

    # e "A visual novel isn't much without images. So let's add some images to our little game."
    e "Aay isualvay ovelnay isnay'tay uchmay ithoutway imagesay. Osay etlay'say adday omesay imagesay otay ouray ittlelay amegay."

# game/tutorial_quickstart.rpy:208
translate piglatin tutorial_images_40140793:

    # e "Before we can show images, we must first choose image names, then place the image files into the images directory."
    e "Eforebay eway ancay owshay imagesay, eway ustmay irstfay oosechay imageay amesnay, hentay aceplay hetay imageay ilesfay intoay hetay imagesay irectoryday."

# game/tutorial_quickstart.rpy:210
translate piglatin tutorial_images_d73388f8:

    # e "An image name is something like 'bg cave' or 'lucy happy', with one or more parts separated by spaces."
    e "Naay imageay amenay isay omethingsay ikelay 'gbay avecay' oray 'ucylay appyhay', ithway oneay oray oremay artspay eparatedsay ybay pacessay."

# game/tutorial_quickstart.rpy:212
translate piglatin tutorial_images_2d5596d4:

    # e "Each part should start with a lower-case letter, and then contain lower-case letters, numbers, and underscores."
    e "Acheay artpay ouldshay artstay ithway aay owerlay-asecay etterlay, anday hentay ontaincay owerlay-asecay etterslay, umbersnay, anday underscoresay."

# game/tutorial_quickstart.rpy:214
translate piglatin tutorial_images_e02c0c82:

    # e "The first part of an image is called the tag. For 'bg cave' the tag is 'bg', while for 'lucy happy' the tag is 'lucy'."
    e "Hetay irstfay artpay ofay anay imageay isay alledcay hetay agtay. Orfay 'gbay avecay' hetay agtay isay 'gbay', hileway orfay 'ucylay appyhay' hetay agtay isay 'ucylay'."

# game/tutorial_quickstart.rpy:216
translate piglatin tutorial_images_d5eafcf2:

    # e "You can open the images directory by clicking the appropriate button in the Ren'Py launcher."
    e "Ouyay ancay openay hetay imagesay irectoryday ybay ickingclay hetay appropriateay uttonbay inay hetay Enray'Ypay auncherlay."

# game/tutorial_quickstart.rpy:218
translate piglatin tutorial_images_e4b12fb6:

    # e "The files in the images directory should have the same name as the image, followed by an extension like .jpg, .png, or .webp."
    e "Hetay ilesfay inay hetay imagesay irectoryday ouldshay avehay hetay amesay amenay asay hetay imageay, ollowedfay ybay anay extensionay ikelay .pgjay, .ngpay, oray .ebpway."

# game/tutorial_quickstart.rpy:220
translate piglatin tutorial_images_a3bd89b2:

    # e "Our example uses 'bg cave.jpg', 'lucy happy.png', and 'lucy mad.png'."
    e "Uroay exampleay usesay 'gbay avecay.pgjay', 'ucylay appyhay.ngpay', anday 'ucylay admay.ngpay'."

# game/tutorial_quickstart.rpy:224
translate piglatin tutorial_images_76b954de:

    # e "Let's see what those look like in the game."
    e "Etlay'say eesay hatway hosetay ooklay ikelay inay hetay amegay."

# game/tutorial_quickstart.rpy:230
translate piglatin tutorial_images_f04e72ea:

    # l "Now that the lights are on, we don't have to worry about Grues anymore."
    l "Ownay hattay hetay ightslay areay onay, eway onday'tay avehay otay orryway aboutay Ruesgay anymoreay."

# game/tutorial_quickstart.rpy:234
translate piglatin tutorial_images_d77ffa1c:

    # l "But what's the deal with me being in a cave? Eileen gets to be out in the sun, and I'm stuck here!"
    l "Utbay hatway'say hetay ealday ithway emay eingbay inay aay avecay? Ileeneay etsgay otay ebay outay inay hetay unsay, anday Iay'may uckstay erehay!"

# game/tutorial_quickstart.rpy:242
translate piglatin tutorial_images_6c0c938b:

    # e "Here's the script for that scene. Notice how it includes two new statements, the scene and show statement."
    e "Erehay'say hetay criptsay orfay hattay cenesay. Oticenay owhay itay includesay wotay ewnay atementsstay, hetay cenesay anday owshay atementstay."

# game/tutorial_quickstart.rpy:244
translate piglatin tutorial_images_1a4660b9:

    # e "The scene statement clears the screen, and then adds a background image."
    e "Hetay cenesay atementstay earsclay hetay creensay, anday hentay addsay aay ackgroundbay imageay."

# game/tutorial_quickstart.rpy:246
translate piglatin tutorial_images_672c8cb8:

    # e "The show statement adds a background image on top of all the other images on the screen."
    e "Hetay owshay atementstay addsay aay ackgroundbay imageay onay optay ofay allay hetay otheray imagesay onay hetay creensay."

# game/tutorial_quickstart.rpy:248
translate piglatin tutorial_images_2fc7baee:

    # e "If there was already an image with the same tag, the new image is used to replace the old one."
    e "Fiay heretay asway alreadyay anay imageay ithway hetay amesay agtay, hetay ewnay imageay isay useday otay eplaceray hetay olday oneay."

# game/tutorial_quickstart.rpy:250
translate piglatin tutorial_images_802825f2:

    # e "Changes to the list of shown images take place instantly, so in the example, the user won't see the background by itself."
    e "Hangescay otay hetay istlay ofay ownshay imagesay aketay aceplay instantlyay, osay inay hetay exampleay, hetay useray onway'tay eesay hetay ackgroundbay ybay itselfay."

# game/tutorial_quickstart.rpy:252
translate piglatin tutorial_images_b246dfdd:

    # e "The second show statement has an at clause, which gives a location on the screen. Common locations are left, right, and center, but you can define many more."
    e "Hetay econdsay owshay atementstay ashay anay atay auseclay, hichway ivesgay aay ocationlay onay hetay creensay. Ommoncay ocationslay areay eftlay, ightray, anday entercay, utbay ouyay ancay efineday anymay oremay."

# game/tutorial_quickstart.rpy:257
translate piglatin tutorial_images_82fceeb8:

    # e "In this example, we show an image named logo base, and we show it at a creator-defined position, rightish."
    e "Niay histay exampleay, eway owshay anay imageay amednay ogolay asebay, anday eway owshay itay atay aay reatorcay-efinedday ositionpay, ightishray."

# game/tutorial_quickstart.rpy:259
translate piglatin tutorial_images_9defda43:

    # e "We also specify that it should be shown behind another image, in this case eileen. That's me."
    e "Eway alsoay pecifysay hattay itay ouldshay ebay ownshay ehindbay anotheray imageay, inay histay asecay eileenay. Hattay'say emay."

# game/tutorial_quickstart.rpy:264
translate piglatin tutorial_images_73d331f7:

    # e "Finally, there's the hide statement, which hides the image with the given tag."
    e "Inallyfay, heretay'say hetay idehay atementstay, hichway ideshay hetay imageay ithway hetay ivengay agtay."

# game/tutorial_quickstart.rpy:266
translate piglatin tutorial_images_f34f62d5:

    # e "Since the show statement replaces an image, and the scene statement clears the scene, it's pretty rare to hide an image."
    e "Incesay hetay owshay atementstay eplacesray anay imageay, anday hetay cenesay atementstay earsclay hetay cenesay, itay'say rettypay areray otay idehay anay imageay."

# game/tutorial_quickstart.rpy:268
translate piglatin tutorial_images_e06fa53a:

    # e "The main use is for when a character or prop leaves before the scene is over."
    e "Hetay ainmay useay isay orfay henway aay aracterchay oray roppay eaveslay eforebay hetay cenesay isay overay."

# game/tutorial_quickstart.rpy:282
translate piglatin tutorial_simple_positions_b492e793:

    # e "When the standard positions that come with Ren'Py aren't enough for you, you can create your own. Here, I'll show you the easy way to do it."
    e "Henway hetay andardstay ositionspay hattay omecay ithway Enray'Ypay arenay'tay enoughay orfay ouyay, ouyay ancay reatecay ouryay ownay. Erehay, Iay'llay owshay ouyay hetay easyay ayway otay oday itay."

# game/tutorial_quickstart.rpy:291
translate piglatin tutorial_simple_positions_04e3bc44:

    # e "The first way to do it is to show an image followed by a colon. Then indented on the next couple of lines are the xalign and yalign transform properties."
    e "Hetay irstfay ayway otay oday itay isay otay owshay anay imageay ollowedfay ybay aay oloncay. Hentay indenteday onay hetay extnay ouplecay ofay ineslay areay hetay alignxay anday alignyay ansformtray ropertiespay."

# game/tutorial_quickstart.rpy:293
translate piglatin tutorial_simple_positions_3ecad5f8:

    # e "Each of the transform properties is a name followed by a value. For xalign and yalign, the values are numbers."
    e "Acheay ofay hetay ansformtray ropertiespay isay aay amenay ollowedfay ybay aay aluevay. Orfay alignxay anday alignyay, hetay aluesvay areay umbersnay."

# game/tutorial_quickstart.rpy:295
translate piglatin tutorial_simple_positions_61c1b124:

    # e "The xalign transform property is the important one, as it controls where the image is placed horizontally on the screen."
    e "Hetay alignxay ansformtray ropertypay isay hetay importantay oneay, asay itay ontrolscay hereway hetay imageay isay acedplay orizontallyhay onay hetay creensay."

# game/tutorial_quickstart.rpy:305
translate piglatin tutorial_simple_positions_67ebea97:

    # e "An xalign of 0.0 is the left side."
    e "Naay alignxay ofay 0ay.0ay isay hetay eftlay idesay."

# game/tutorial_quickstart.rpy:315
translate piglatin tutorial_simple_positions_bd4f56d8:

    # e "0.5 is the center."
    e "0ay.5ay isay hetay entercay."

# game/tutorial_quickstart.rpy:324
translate piglatin tutorial_simple_positions_fb2c48f2:

    # e "And 1.0 is the right. The decimal place is important and has to be there. Just 1 by itself won't work the same."
    e "Ndaay 1ay.0ay isay hetay ightray. Hetay ecimalday aceplay isay importantay anday ashay otay ebay heretay. Ustjay 1ay ybay itselfay onway'tay orkway hetay amesay."

# game/tutorial_quickstart.rpy:333
translate piglatin tutorial_simple_positions_8eebc9a7:

    # e "Of course, you can pick any position in between."
    e "Foay oursecay, ouyay ancay ickpay anyay ositionpay inay etweenbay."

# game/tutorial_quickstart.rpy:335
translate piglatin tutorial_simple_positions_4cd917f6:

    # e "The yalign property is the same way, with 0.0 being the top of the screen and 1.0 being the bottom. Since most sprites stick to the bottom, it's almost always 1.0."
    e "Hetay alignyay ropertypay isay hetay amesay ayway, ithway 0ay.0ay eingbay hetay optay ofay hetay creensay anday 1ay.0ay eingbay hetay ottombay. Incesay ostmay pritessay ickstay otay hetay ottombay, itay'say almostay alwaysay 1ay.0ay."

# game/tutorial_quickstart.rpy:341
translate piglatin tutorial_simple_positions_fbd1a3eb:

    # e "While being able to write positions like this is useful, having to repeatedly do so isn't. So Ren'Py lets you define a transform once, and reuse it."
    e "Hileway eingbay ableay otay riteway ositionspay ikelay histay isay usefulay, avinghay otay epeatedlyray oday osay isnay'tay. Osay Enray'Ypay etslay ouyay efineday aay ansformtray onceay, anday euseray itay."

# game/tutorial_quickstart.rpy:345
translate piglatin tutorial_simple_positions_2377e3b3:

    # e "Usually transforms are defined at the top of a file, right after the characters. But it doesn't matter to Ren'Py where you define them."
    e "Suallyuay ansformstray areay efinedday atay hetay optay ofay aay ilefay, ightray afteray hetay aracterschay. Utbay itay oesnday'tay attermay otay Enray'Ypay hereway ouyay efineday hemtay."

# game/tutorial_quickstart.rpy:347
translate piglatin tutorial_simple_positions_3ce7e367:

    # e "The transform is given a name, slightleft, and then the xalign and yalign properties."
    e "Hetay ansformtray isay ivengay aay amenay, ightleftslay, anday hentay hetay alignxay anday alignyay ropertiespay."

# game/tutorial_quickstart.rpy:355
translate piglatin tutorial_simple_positions_82d640d9:

    # e "Once a transform has been defined, you can use it in the at clause of the show statement."
    e "Nceoay aay ansformtray ashay eenbay efinedday, ouyay ancay useay itay inay hetay atay auseclay ofay hetay owshay atementstay."

# game/tutorial_quickstart.rpy:360
translate piglatin tutorial_simple_positions_16b66785:

    # e "Transforms are sticky. If you replace an image without using a transform, Ren'Py will keep the same transforms it had been using."
    e "Ransformstay areay ickystay. Fiay ouyay eplaceray anay imageay ithoutway usingay aay ansformtray, Enray'Ypay illway eepkay hetay amesay ansformstray itay adhay eenbay usingay."

# game/tutorial_quickstart.rpy:364
translate piglatin tutorial_simple_positions_5d5e0cfd:

    # e "Of course, there's a lot more to transforms than this. If you want to learn more, you can read the sections on Position Properties, Transforms and Animation, and Transform Properties."
    e "Foay oursecay, heretay'say aay otlay oremay otay ansformstray hantay histay. Fiay ouyay antway otay earnlay oremay, ouyay ancay eadray hetay ectionssay onay Ositionpay Ropertiespay, Ransformstay anday Nimationaay, anday Ransformtay Ropertiespay."

# game/tutorial_quickstart.rpy:366
translate piglatin tutorial_simple_positions_e65da9bf:

    # e "But for many visual novels, xalign and yalign are the only properties that matter."
    e "Utbay orfay anymay isualvay ovelsnay, alignxay anday alignyay areay hetay onlyay ropertiespay hattay attermay."

# game/tutorial_quickstart.rpy:381
translate piglatin tutorial_transitions_9b8c714c:

    # e "It can be somewhat jarring for the game to jump from place to place."
    e "Tiay ancay ebay omewhatsay arringjay orfay hetay amegay otay umpjay omfray aceplay otay aceplay."

# game/tutorial_quickstart.rpy:388
translate piglatin tutorial_transitions_3e290ea8:

    # e "To help take some of edge off a change in scene, Ren'Py supports the use of transitions. Let's try that scene change again, but this time we'll use transitions."
    e "Otay elphay aketay omesay ofay edgeay offay aay angechay inay cenesay, Enray'Ypay upportssay hetay useay ofay ansitionstray. Etlay'say ytray hattay cenesay angechay againay, utbay histay imetay eway'llay useay ansitionstray."

# game/tutorial_quickstart.rpy:402
translate piglatin tutorial_transitions_9c0a86c4:

    # e "That's much smoother. Here's some example code showing how we include transitions in our game."
    e "Hattay'say uchmay moothersay. Erehay'say omesay exampleay odecay owingshay owhay eway includeay ansitionstray inay ouray amegay."

# game/tutorial_quickstart.rpy:404
translate piglatin tutorial_transitions_3e490d40:

    # e "It uses the with statement. The with statement causes the scene to transition from the last things shown to the things currently being shown."
    e "Tiay usesay hetay ithway atementstay. Hetay ithway atementstay ausescay hetay cenesay otay ansitiontray omfray hetay astlay hingstay ownshay otay hetay hingstay urrentlycay eingbay ownshay."

# game/tutorial_quickstart.rpy:406
translate piglatin tutorial_transitions_a43847df:

    # e "It takes a transition as an argument. In this case, we're using the Dissolve transition. This transition takes as an argument the amount of time the dissolve should take."
    e "Tiay akestay aay ansitiontray asay anay argumentay. Niay histay asecay, eway'eray usingay hetay Issolveday ansitiontray. Histay ansitiontray akestay asay anay argumentay hetay amountay ofay imetay hetay issolveday ouldshay aketay."

# game/tutorial_quickstart.rpy:408
translate piglatin tutorial_transitions_6fcee414:

    # e "In this case, each transition takes half a second."
    e "Niay histay asecay, eachay ansitiontray akestay alfhay aay econdsay."

# game/tutorial_quickstart.rpy:412
translate piglatin tutorial_transitions_033042cc:

    # e "We can define a short name for a transition, using the define statement. Here, we're defining slowdissolve to be a dissolve that takes a whole second."
    e "Eway ancay efineday aay ortshay amenay orfay aay ansitiontray, usingay hetay efineday atementstay. Erehay, eway'eray efiningday owdissolveslay otay ebay aay issolveday hattay akestay aay holeway econdsay."

# game/tutorial_quickstart.rpy:427
translate piglatin tutorial_transitions_0ba82f00:

    # e "Once a transition has been given a short name, we can use it in our game."
    e "Nceoay aay ansitiontray ashay eenbay ivengay aay ortshay amenay, eway ancay useay itay inay ouray amegay."

# game/tutorial_quickstart.rpy:431
translate piglatin tutorial_transitions_51ff9600:

    # e "Ren'Py defines some transitions for you, like dissolve, fade, and move. For more complex or customized transitions, you'll have to define your own."
    e "Enray'Ypay efinesday omesay ansitionstray orfay ouyay, ikelay issolveday, adefay, anday ovemay. Orfay oremay omplexcay oray ustomizedcay ansitionstray, ouyay'llay avehay otay efineday ouryay ownay."

# game/tutorial_quickstart.rpy:433
translate piglatin tutorial_transitions_1528f73f:

    # e "If you're interested, check out the Transitions Gallery section of this tutorial."
    e "Fiay ouyay'eray interesteday, eckchay outay hetay Ransitionstay Allerygay ectionsay ofay histay utorialtay."

# game/tutorial_quickstart.rpy:439
translate piglatin tutorial_music_8b92efb7:

    # e "Another important part of a visual novel or simulation game is the soundtrack."
    e "Notheraay importantay artpay ofay aay isualvay ovelnay oray imulationsay amegay isay hetay oundtracksay."

# game/tutorial_quickstart.rpy:441
translate piglatin tutorial_music_53910317:

    # e "Ren'Py breaks sound up into channels. The channel a sound is played on determines if the sound loops, and if it is saved and restored with the game."
    e "Enray'Ypay eaksbray oundsay upay intoay annelschay. Hetay annelchay aay oundsay isay ayedplay onay eterminesday ifay hetay oundsay oopslay, anday ifay itay isay avedsay anday estoredray ithway hetay amegay."

# game/tutorial_quickstart.rpy:443
translate piglatin tutorial_music_a1e37712:

    # e "When a sound is played on the music channel, it is looped, and it is saved when the game is saved."
    e "Henway aay oundsay isay ayedplay onay hetay usicmay annelchay, itay isay oopedlay, anday itay isay avedsay henway hetay amegay isay avedsay."

# game/tutorial_quickstart.rpy:445
translate piglatin tutorial_music_d9086d22:

    # e "When the channel named sound is used, the sound is played once and then stopped. It isn't saved."
    e "Henway hetay annelchay amednay oundsay isay useday, hetay oundsay isay ayedplay onceay anday hentay oppedstay. Tiay isnay'tay avedsay."

# game/tutorial_quickstart.rpy:447
translate piglatin tutorial_music_3555b640:

    # e "The sounds themselves are stored in audio files. Ren'Py supports the Opus, Ogg Vorbis, and mp3 formats."
    e "Hetay oundssay hemselvestay areay oredstay inay audioay ilesfay. Enray'Ypay upportssay hetay Pusoay, Ggoay Orbisvay, anday p3may ormatsfay."

# game/tutorial_quickstart.rpy:449
translate piglatin tutorial_music_a776b6ad:

    # e "Let's check out some of the commands that can effect the music channel."
    e "Etlay'say eckchay outay omesay ofay hetay ommandscay hattay ancay effectay hetay usicmay annelchay."

# game/tutorial_quickstart.rpy:454
translate piglatin tutorial_music_8b606a55:

    # e "The play music command replaces the currently playing music, and replaces it with the named filename."
    e "Hetay ayplay usicmay ommandcay eplacesray hetay urrentlycay ayingplay usicmay, anday eplacesray itay ithway hetay amednay ilenamefay."

# game/tutorial_quickstart.rpy:456
translate piglatin tutorial_music_18650fe7:

    # e "If you specify the currently-playing song, it will restart it."
    e "Fiay ouyay pecifysay hetay urrentlycay-ayingplay ongsay, itay illway estartray itay."

# game/tutorial_quickstart.rpy:458
translate piglatin tutorial_music_413d91fc:

    # e "If the optional fadeout clause is given, it will fade out the currently playing music before starting the new music."
    e "Fiay hetay optionalay adeoutfay auseclay isay ivengay, itay illway adefay outay hetay urrentlycay ayingplay usicmay eforebay artingstay hetay ewnay usicmay."

# game/tutorial_quickstart.rpy:463
translate piglatin tutorial_music_a282a0e3:

    # e "The queue statement also adds music to the named channel, but it waits until the currently-playing song is finished before playing the new music."
    e "Hetay ueueqay atementstay alsoay addsay usicmay otay hetay amednay annelchay, utbay itay aitsway untilay hetay urrentlycay-ayingplay ongsay isay inishedfay eforebay ayingplay hetay ewnay usicmay."

# game/tutorial_quickstart.rpy:468
translate piglatin tutorial_music_01ca6bad:

    # e "The third statement is the stop statement. It stops the music playing on a channel. It too takes the fadeout clause."
    e "Hetay hirdtay atementstay isay hetay opstay atementstay. Tiay opsstay hetay usicmay ayingplay onay aay annelchay. Tiay ootay akestay hetay adeoutfay auseclay."

# game/tutorial_quickstart.rpy:473
translate piglatin tutorial_music_384937da:

    # e "Unlike the music channel, playing a sound on the sound channel causes it to play only once."
    e "Nlikeuay hetay usicmay annelchay, ayingplay aay oundsay onay hetay oundsay annelchay ausescay itay otay ayplay onlyay onceay."

# game/tutorial_quickstart.rpy:480
translate piglatin tutorial_music_1d3e9fd2:

    # e "You can queue up multiple sounds on the sound channel, but the sounds will only play one at a time."
    e "Ouyay ancay ueueqay upay ultiplemay oundssay onay hetay oundsay annelchay, utbay hetay oundssay illway onlyay ayplay oneay atay aay imetay."

# game/tutorial_quickstart.rpy:486
translate piglatin tutorial_music_aa01c19d:

    # e "Ren'Py has separate mixers for sound, music, and voices, so the player can adjust them as they like."
    e "Enray'Ypay ashay eparatesay ixersmay orfay oundsay, usicmay, anday oicesvay, osay hetay ayerplay ancay adjustay hemtay asay heytay ikelay."

# game/tutorial_quickstart.rpy:492
translate piglatin tutorial_menus_0426904b:

    # e "Many visual novels require the player to make choices from in-game menus. These choices can add some challenge to the game, or adjust it to the player's preferences."
    e "Anymay isualvay ovelsnay equireray hetay ayerplay otay akemay oiceschay omfray inay-amegay enusmay. Hesetay oiceschay ancay adday omesay allengechay otay hetay amegay, oray adjustay itay otay hetay ayerplay'say referencespay."

# game/tutorial_quickstart.rpy:494
translate piglatin tutorial_menus_431eeff0:

    # e "Do you like to play visual novels with choices in them?"
    e "Oday ouyay ikelay otay ayplay isualvay ovelsnay ithway oiceschay inay hemtay?"

# game/tutorial_quickstart.rpy:509
translate piglatin choice1_yes_f6d95df8:

    # e "While creating a multi-path visual novel can be a bit more work, it can yield a unique experience."
    e "Hileway reatingcay aay ultimay-athpay isualvay ovelnay ancay ebay aay itbay oremay orkway, itay ancay ieldyay aay uniqueay experienceay."

# game/tutorial_quickstart.rpy:517
translate piglatin choice1_no_72958b50:

    # e "Games without menus are called kinetic novels, and there are dozens of them available to play."
    e "Amesgay ithoutway enusmay areay alledcay inetickay ovelsnay, anday heretay areay ozensday ofay hemtay availableay otay ayplay."

# game/tutorial_quickstart.rpy:528
translate piglatin choice1_done_acba9504:

    # e "Here, you can see the code for that menu. If you scroll down, you can see the code we run after the menu."
    e "Erehay, ouyay ancay eesay hetay odecay orfay hattay enumay. Fiay ouyay crollsay ownday, ouyay ancay eesay hetay odecay eway unray afteray hetay enumay."

# game/tutorial_quickstart.rpy:530
translate piglatin choice1_done_f9fa6889:

    # e "Menus are introduced by the menu statement. The menu statement takes an indented block, in which there can be one line of dialogue and multiple choices."
    e "Enusmay areay introduceday ybay hetay enumay atementstay. Hetay enumay atementstay akestay anay indenteday ockblay, inay hichway heretay ancay ebay oneay inelay ofay ialogueday anday ultiplemay oiceschay."

# game/tutorial_quickstart.rpy:532
translate piglatin choice1_done_ebb2db38:

    # e "Each choice must end with a colon, as each choice has its own block of Ren'Py code, that is run when that choice is selected."
    e "Acheay oicechay ustmay enday ithway aay oloncay, asay eachay oicechay ashay itsay ownay ockblay ofay Enray'Ypay odecay, hattay isay unray henway hattay oicechay isay electedsay."

# game/tutorial_quickstart.rpy:534
translate piglatin choice1_done_59cac95d:

    # e "Here, each block jumps to a label. While you could put small amounts of Ren'Py code inside a menu label, it's probably good practice to usually jump to a bigger block of code."
    e "Erehay, eachay ockblay umpsjay otay aay abellay. Hileway ouyay ouldcay utpay mallsay amountsay ofay Enray'Ypay odecay insideay aay enumay abellay, itay'say robablypay oodgay racticepay otay usuallyay umpjay otay aay iggerbay ockblay ofay odecay."

# game/tutorial_quickstart.rpy:536
translate piglatin choice1_done_2851a313:

    # e "Scrolling down past the menu, you can see the labels that the menu jumps to. There are three labels here, named choice1_yes, choice1_no, and choice1_done."
    e "Crollingsay ownday astpay hetay enumay, ouyay ancay eesay hetay abelslay hattay hetay enumay umpsjay otay. Heretay areay hreetay abelslay erehay, amednay oice1_yeschay, oice1_nochay, anday oice1_donechay."

# game/tutorial_quickstart.rpy:538
translate piglatin choice1_done_ff761b03:

    # e "When the first menu choice is picked, we jump to the choice1_yes, which runs two lines of script before jumping to choice1_done."
    e "Henway hetay irstfay enumay oicechay isay ickedpay, eway umpjay otay hetay oice1_yeschay, hichway unsray wotay ineslay ofay criptsay eforebay umpingjay otay oice1_donechay."

# game/tutorial_quickstart.rpy:540
translate piglatin choice1_done_664fe702:

    # e "Similarly, picking the second choice jumps us to choice1_no, which also runs two lines of script."
    e "Imilarlysay, ickingpay hetay econdsay oicechay umpsjay usay otay oice1_nochay, hichway alsoay unsray wotay ineslay ofay criptsay."

# game/tutorial_quickstart.rpy:542
translate piglatin choice1_done_31d12b1e:

    # e "The lines beginning with the dollar sign are lines of python code, which are used to set a flag based on the user's choice."
    e "Hetay ineslay eginningbay ithway hetay ollarday ignsay areay ineslay ofay ythonpay odecay, hichway areay useday otay etsay aay agflay asedbay onay hetay useray'say oicechay."

# game/tutorial_quickstart.rpy:544
translate piglatin choice1_done_88398d3e:

    # e "The flag is named menu_flag, and it's set to True or False based on the user's choice. The if statement can be used to test a flag, so the game can remember the user's choices."
    e "Hetay agflay isay amednay enu_flagmay, anday itay'say etsay otay Ruetay oray Alsefay asedbay onay hetay useray'say oicechay. Hetay ifay atementstay ancay ebay useday otay esttay aay agflay, osay hetay amegay ancay ememberray hetay useray'say oiceschay."

# game/tutorial_quickstart.rpy:549
translate piglatin choice1_done_2828dbfc:

    # e "For example, I remember that you plan to use menus in your game."
    e "Orfay exampleay, Iay ememberray hattay ouyay anplay otay useay enusmay inay ouryay amegay."

# game/tutorial_quickstart.rpy:553
translate piglatin choice1_done_503786e4:

    # e "For example, I remember that you're planning to make a kinetic novel, without menus."
    e "Orfay exampleay, Iay ememberray hattay ouyay'eray anningplay otay akemay aay inetickay ovelnay, ithoutway enusmay."

# game/tutorial_quickstart.rpy:555
translate piglatin choice1_done_819e234a:

    # e "Here's an example that shows how we can test a flag, and do different things if it is true or not."
    e "Erehay'say anay exampleay hattay owsshay owhay eway ancay esttay aay agflay, anday oday ifferentday hingstay ifay itay isay uetray oray otnay."

# game/tutorial_quickstart.rpy:559
translate piglatin choice1_done_461e6a59:

    # e "Finally, this shows how you can show dialogue and menus at the same time. Understand?" nointeract
    e "Inallyfay, histay owsshay owhay ouyay ancay owshay ialogueday anday enusmay atay hetay amesay imetay. Nderstanduay?" nointeract

# game/tutorial_quickstart.rpy:564
translate piglatin choice1_done_a32e30fd:

    # e "Great."
    e "Reatgay."

# game/tutorial_quickstart.rpy:568
translate piglatin choice1_done_fbd1dbc1:

    # e "If you look at the example, before the first choice, there's an indented say statement."
    e "Fiay ouyay ooklay atay hetay exampleay, eforebay hetay irstfay oicechay, heretay'say anay indenteday aysay atementstay."

# game/tutorial_quickstart.rpy:574
translate piglatin menu3_done_47fa2268:

    # e "Although we won't demonstrate it here, Ren'Py supports making decisions based on a combinations of points, flags, and other factors."
    e "Lthoughaay eway onway'tay emonstrateday itay erehay, Enray'Ypay upportssay akingmay ecisionsday asedbay onay aay ombinationscay ofay ointspay, agsflay, anday otheray actorsfay."

# game/tutorial_quickstart.rpy:576
translate piglatin menu3_done_826a600b:

    # e "One of Ren'Py's big advantages is the flexibility using a scripting language like Python provides us. It lets us easily scale from kinetic novels to complex simulation games."
    e "Neoay ofay Enray'Ypay'say igbay advantagesay isay hetay exibilityflay usingay aay criptingsay anguagelay ikelay Ythonpay rovidespay usay. Tiay etslay usay easilyay calesay omfray inetickay ovelsnay otay omplexcay imulationsay amesgay."

# game/tutorial_quickstart.rpy:585
translate piglatin tutorial_input_066611c5:

    # e "Some games might prompt the player for input."
    e "Omesay amesgay ightmay romptpay hetay ayerplay orfay inputay."

# game/tutorial_quickstart.rpy:599
translate piglatin tutorial_input_dc3b4560:

    # e "That's done with Python, and especially the renpy.input function. The first line of this example prompts the player for some texts, and sticks it in the name variable."
    e "Hattay'say oneday ithway Ythonpay, anday especiallyay hetay enpyray.inputay unctionfay. Hetay irstfay inelay ofay histay exampleay romptspay hetay ayerplay orfay omesay extstay, anday icksstay itay inay hetay amenay ariablevay."

# game/tutorial_quickstart.rpy:601
translate piglatin tutorial_input_c88b3f4e:

    # e "Often times, you'll want to clean the name up before you use it. The last line does that, by calling the strip method to remove whitespace, and replacing the name with a default if it's missing."
    e "Ftenoay imestay, ouyay'llay antway otay eanclay hetay amenay upay eforebay ouyay useay itay. Hetay astlay inelay oesday hattay, ybay allingcay hetay ripstay ethodmay otay emoveray hitespaceway, anday eplacingray hetay amenay ithway aay efaultday ifay itay'say issingmay."

# game/tutorial_quickstart.rpy:605
translate piglatin tutorial_input_1236e9da:

    # e "To interpolate a variable, write it in square brackets. Isn't that right, [name]?"
    e "Otay interpolateay aay ariablevay, riteway itay inay quaresay acketsbray. Sniay'tay hattay ightray, [name]?"

# game/tutorial_quickstart.rpy:609
translate piglatin tutorial_input_c1f7a808:

    # e "Variable names can also be shown in character names. To do that, just include the variable in square brackets in the character's name. Got it?"
    e "Ariablevay amesnay ancay alsoay ebay ownshay inay aracterchay amesnay. Otay oday hattay, ustjay includeay hetay ariablevay inay quaresay acketsbray inay hetay aracterchay'say amenay. Otgay itay?"

# game/tutorial_quickstart.rpy:612
translate piglatin tutorial_input_f7757a8e:

    # g "I think I do."
    g "Iay hinktay Iay oday."

# game/tutorial_quickstart.rpy:619
translate piglatin tutorial_input_0548d3e2:

    # e "Variable interpolation also works with other variables. Here, the answer is [answer] and the flag is [flag]."
    e "Ariablevay interpolationay alsoay orksway ithway otheray ariablesvay. Erehay, hetay answeray isay [answer] anday hetay agflay isay [flag]."

translate piglatin strings:

    # tutorial_quickstart.rpy:2
    old "Lucy"
    new "Ucylay"

    # tutorial_quickstart.rpy:497
    old "Yes, I do."
    new "Esyay, Iay oday."

    # tutorial_quickstart.rpy:497
    old "No, I don't."
    new "Onay, Iay onday'tay."

    # tutorial_quickstart.rpy:589
    old "What's your name?"
    new "Hatway'say ouryay amenay?"

    # tutorial_quickstart.rpy:591
    old "Guy Shy"
    new "Uygay Hysay"

