/* Generated by re2c */

#include <stdio.h>
#include <stdlib.h> /* malloc, free */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line344
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line344: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line344: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line344()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line344.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line344.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych >= 0x0080) goto yy4;
        YYSKIP ();
        status = action_line344(i, keys, input, token, &cursor, 0);
        continue;
yy4:
        YYSKIP ();
        status = action_line344(i, keys, input, token, &cursor, 254);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line344: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line344: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line351
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line351: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line351: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line351()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line351.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line351.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x007F) goto yy8;
        if (yych <= 0x00FF) goto yy10;
yy8:
        YYSKIP ();
        status = action_line351(i, keys, input, token, &cursor, 254);
        continue;
yy10:
        YYSKIP ();
        status = action_line351(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line351: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line351: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line358
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line358: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line358: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line358()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line358.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line358.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x00FF) goto yy14;
        if (yych <= 0x017F) goto yy16;
yy14:
        YYSKIP ();
        status = action_line358(i, keys, input, token, &cursor, 254);
        continue;
yy16:
        YYSKIP ();
        status = action_line358(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line358: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line358: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line365
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line365: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line365: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line365()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line365.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line365.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x017F) goto yy20;
        if (yych <= 0x024F) goto yy22;
yy20:
        YYSKIP ();
        status = action_line365(i, keys, input, token, &cursor, 254);
        continue;
yy22:
        YYSKIP ();
        status = action_line365(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line365: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line365: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line372
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line372: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line372: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line372()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line372.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line372.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x024F) goto yy26;
        if (yych <= 0x02AF) goto yy28;
yy26:
        YYSKIP ();
        status = action_line372(i, keys, input, token, &cursor, 254);
        continue;
yy28:
        YYSKIP ();
        status = action_line372(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line372: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line372: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line379
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line379: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line379: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line379()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line379.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line379.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x02AF) goto yy32;
        if (yych <= 0x02FF) goto yy34;
yy32:
        YYSKIP ();
        status = action_line379(i, keys, input, token, &cursor, 254);
        continue;
yy34:
        YYSKIP ();
        status = action_line379(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line379: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line379: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line386
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line386: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line386: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line386()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line386.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line386.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x02FF) goto yy38;
        if (yych <= 0x036F) goto yy40;
yy38:
        YYSKIP ();
        status = action_line386(i, keys, input, token, &cursor, 254);
        continue;
yy40:
        YYSKIP ();
        status = action_line386(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line386: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line386: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line393
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line393: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line393: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line393()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line393.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line393.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x036F) goto yy44;
        if (yych <= 0x03FF) goto yy46;
yy44:
        YYSKIP ();
        status = action_line393(i, keys, input, token, &cursor, 254);
        continue;
yy46:
        YYSKIP ();
        status = action_line393(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line393: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line393: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line400
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line400: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line400: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line400()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line400.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line400.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x03FF) goto yy50;
        if (yych <= 0x04FF) goto yy52;
yy50:
        YYSKIP ();
        status = action_line400(i, keys, input, token, &cursor, 254);
        continue;
yy52:
        YYSKIP ();
        status = action_line400(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line400: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line400: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line407
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line407: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line407: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line407()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line407.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line407.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x04FF) goto yy56;
        if (yych <= 0x052F) goto yy58;
yy56:
        YYSKIP ();
        status = action_line407(i, keys, input, token, &cursor, 254);
        continue;
yy58:
        YYSKIP ();
        status = action_line407(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line407: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line407: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line414
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line414: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line414: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line414()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line414.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line414.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x052F) goto yy62;
        if (yych <= 0x058F) goto yy64;
yy62:
        YYSKIP ();
        status = action_line414(i, keys, input, token, &cursor, 254);
        continue;
yy64:
        YYSKIP ();
        status = action_line414(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line414: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line414: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line421
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line421: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line421: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line421()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line421.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line421.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x058F) goto yy68;
        if (yych <= 0x05FF) goto yy70;
yy68:
        YYSKIP ();
        status = action_line421(i, keys, input, token, &cursor, 254);
        continue;
yy70:
        YYSKIP ();
        status = action_line421(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line421: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line421: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line428
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line428: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line428: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line428()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line428.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line428.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x05FF) goto yy74;
        if (yych <= 0x06FF) goto yy76;
yy74:
        YYSKIP ();
        status = action_line428(i, keys, input, token, &cursor, 254);
        continue;
yy76:
        YYSKIP ();
        status = action_line428(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line428: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line428: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line435
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line435: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line435: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line435()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line435.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line435.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x06FF) goto yy80;
        if (yych <= 0x074F) goto yy82;
yy80:
        YYSKIP ();
        status = action_line435(i, keys, input, token, &cursor, 254);
        continue;
yy82:
        YYSKIP ();
        status = action_line435(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line435: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line435: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line442
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line442: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line442: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line442()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line442.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line442.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x077F) goto yy86;
        if (yych <= 0x07BF) goto yy88;
yy86:
        YYSKIP ();
        status = action_line442(i, keys, input, token, &cursor, 254);
        continue;
yy88:
        YYSKIP ();
        status = action_line442(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line442: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line442: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line449
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line449: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line449: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line449()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line449.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line449.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x08FF) goto yy92;
        if (yych <= 0x097F) goto yy94;
yy92:
        YYSKIP ();
        status = action_line449(i, keys, input, token, &cursor, 254);
        continue;
yy94:
        YYSKIP ();
        status = action_line449(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line449: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line449: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line456
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line456: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line456: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line456()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line456.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line456.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x097F) goto yy98;
        if (yych <= 0x09FF) goto yy100;
yy98:
        YYSKIP ();
        status = action_line456(i, keys, input, token, &cursor, 254);
        continue;
yy100:
        YYSKIP ();
        status = action_line456(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line456: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line456: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line463
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line463: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line463: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line463()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line463.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line463.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x09FF) goto yy104;
        if (yych <= 0x0A7F) goto yy106;
yy104:
        YYSKIP ();
        status = action_line463(i, keys, input, token, &cursor, 254);
        continue;
yy106:
        YYSKIP ();
        status = action_line463(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line463: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line463: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line470
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line470: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line470: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line470()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line470.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line470.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0A7F) goto yy110;
        if (yych <= 0x0AFF) goto yy112;
yy110:
        YYSKIP ();
        status = action_line470(i, keys, input, token, &cursor, 254);
        continue;
yy112:
        YYSKIP ();
        status = action_line470(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line470: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line470: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line477
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line477: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line477: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line477()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line477.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line477.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0AFF) goto yy116;
        if (yych <= 0x0B7F) goto yy118;
yy116:
        YYSKIP ();
        status = action_line477(i, keys, input, token, &cursor, 254);
        continue;
yy118:
        YYSKIP ();
        status = action_line477(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line477: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line477: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line484
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line484: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line484: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line484()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line484.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line484.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0B7F) goto yy122;
        if (yych <= 0x0BFF) goto yy124;
yy122:
        YYSKIP ();
        status = action_line484(i, keys, input, token, &cursor, 254);
        continue;
yy124:
        YYSKIP ();
        status = action_line484(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line484: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line484: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line491
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line491: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line491: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line491()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line491.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line491.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0BFF) goto yy128;
        if (yych <= 0x0C7F) goto yy130;
yy128:
        YYSKIP ();
        status = action_line491(i, keys, input, token, &cursor, 254);
        continue;
yy130:
        YYSKIP ();
        status = action_line491(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line491: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line491: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line498
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line498: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line498: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line498()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line498.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line498.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0C7F) goto yy134;
        if (yych <= 0x0CFF) goto yy136;
yy134:
        YYSKIP ();
        status = action_line498(i, keys, input, token, &cursor, 254);
        continue;
yy136:
        YYSKIP ();
        status = action_line498(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line498: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line498: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line505
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line505: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line505: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line505()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line505.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line505.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0CFF) goto yy140;
        if (yych <= 0x0D7F) goto yy142;
yy140:
        YYSKIP ();
        status = action_line505(i, keys, input, token, &cursor, 254);
        continue;
yy142:
        YYSKIP ();
        status = action_line505(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line505: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line505: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line512
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line512: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line512: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line512()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line512.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line512.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0D7F) goto yy146;
        if (yych <= 0x0DFF) goto yy148;
yy146:
        YYSKIP ();
        status = action_line512(i, keys, input, token, &cursor, 254);
        continue;
yy148:
        YYSKIP ();
        status = action_line512(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line512: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line512: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line519
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line519: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line519: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line519()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line519.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line519.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0DFF) goto yy152;
        if (yych <= 0x0E7F) goto yy154;
yy152:
        YYSKIP ();
        status = action_line519(i, keys, input, token, &cursor, 254);
        continue;
yy154:
        YYSKIP ();
        status = action_line519(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line519: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line519: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line526
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line526: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line526: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line526()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line526.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line526.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0E7F) goto yy158;
        if (yych <= 0x0EFF) goto yy160;
yy158:
        YYSKIP ();
        status = action_line526(i, keys, input, token, &cursor, 254);
        continue;
yy160:
        YYSKIP ();
        status = action_line526(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line526: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line526: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line533
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line533: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line533: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line533()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line533.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line533.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0EFF) goto yy164;
        if (yych <= 0x0FFF) goto yy166;
yy164:
        YYSKIP ();
        status = action_line533(i, keys, input, token, &cursor, 254);
        continue;
yy166:
        YYSKIP ();
        status = action_line533(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line533: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line533: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line540
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line540: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line540: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line540()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line540.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line540.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x0FFF) goto yy170;
        if (yych <= 0x109F) goto yy172;
yy170:
        YYSKIP ();
        status = action_line540(i, keys, input, token, &cursor, 254);
        continue;
yy172:
        YYSKIP ();
        status = action_line540(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line540: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line540: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line547
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line547: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line547: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line547()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line547.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line547.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x109F) goto yy176;
        if (yych <= 0x10FF) goto yy178;
yy176:
        YYSKIP ();
        status = action_line547(i, keys, input, token, &cursor, 254);
        continue;
yy178:
        YYSKIP ();
        status = action_line547(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line547: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line547: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line554
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line554: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line554: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line554()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line554.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line554.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x10FF) goto yy182;
        if (yych <= 0x11FF) goto yy184;
yy182:
        YYSKIP ();
        status = action_line554(i, keys, input, token, &cursor, 254);
        continue;
yy184:
        YYSKIP ();
        status = action_line554(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line554: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line554: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line561
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line561: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line561: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line561()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line561.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line561.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x11FF) goto yy188;
        if (yych <= 0x137F) goto yy190;
yy188:
        YYSKIP ();
        status = action_line561(i, keys, input, token, &cursor, 254);
        continue;
yy190:
        YYSKIP ();
        status = action_line561(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line561: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line561: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line568
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line568: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line568: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line568()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line568.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line568.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x139F) goto yy194;
        if (yych <= 0x13FF) goto yy196;
yy194:
        YYSKIP ();
        status = action_line568(i, keys, input, token, &cursor, 254);
        continue;
yy196:
        YYSKIP ();
        status = action_line568(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line568: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line568: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line575
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line575: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line575: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line575()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line575.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line575.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x13FF) goto yy200;
        if (yych <= 0x167F) goto yy202;
yy200:
        YYSKIP ();
        status = action_line575(i, keys, input, token, &cursor, 254);
        continue;
yy202:
        YYSKIP ();
        status = action_line575(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line575: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line575: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line582
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line582: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line582: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line582()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line582.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line582.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x167F) goto yy206;
        if (yych <= 0x169F) goto yy208;
yy206:
        YYSKIP ();
        status = action_line582(i, keys, input, token, &cursor, 254);
        continue;
yy208:
        YYSKIP ();
        status = action_line582(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line582: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line582: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line589
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line589: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line589: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line589()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line589.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line589.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x169F) goto yy212;
        if (yych <= 0x16FF) goto yy214;
yy212:
        YYSKIP ();
        status = action_line589(i, keys, input, token, &cursor, 254);
        continue;
yy214:
        YYSKIP ();
        status = action_line589(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line589: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line589: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line596
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line596: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line596: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line596()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line596.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line596.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x16FF) goto yy218;
        if (yych <= 0x171F) goto yy220;
yy218:
        YYSKIP ();
        status = action_line596(i, keys, input, token, &cursor, 254);
        continue;
yy220:
        YYSKIP ();
        status = action_line596(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line596: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line596: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line603
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line603: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line603: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line603()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line603.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line603.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x171F) goto yy224;
        if (yych <= 0x173F) goto yy226;
yy224:
        YYSKIP ();
        status = action_line603(i, keys, input, token, &cursor, 254);
        continue;
yy226:
        YYSKIP ();
        status = action_line603(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line603: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line603: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line610
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line610: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line610: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line610()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line610.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line610.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x173F) goto yy230;
        if (yych <= 0x175F) goto yy232;
yy230:
        YYSKIP ();
        status = action_line610(i, keys, input, token, &cursor, 254);
        continue;
yy232:
        YYSKIP ();
        status = action_line610(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line610: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line610: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line617
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line617: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line617: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line617()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line617.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line617.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x175F) goto yy236;
        if (yych <= 0x177F) goto yy238;
yy236:
        YYSKIP ();
        status = action_line617(i, keys, input, token, &cursor, 254);
        continue;
yy238:
        YYSKIP ();
        status = action_line617(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line617: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line617: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line624
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line624: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line624: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line624()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line624.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line624.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x177F) goto yy242;
        if (yych <= 0x17FF) goto yy244;
yy242:
        YYSKIP ();
        status = action_line624(i, keys, input, token, &cursor, 254);
        continue;
yy244:
        YYSKIP ();
        status = action_line624(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line624: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line624: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line631
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line631: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line631: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line631()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line631.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line631.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x17FF) goto yy248;
        if (yych <= 0x18AF) goto yy250;
yy248:
        YYSKIP ();
        status = action_line631(i, keys, input, token, &cursor, 254);
        continue;
yy250:
        YYSKIP ();
        status = action_line631(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line631: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line631: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line638
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line638: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line638: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line638()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line638.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line638.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x18FF) goto yy254;
        if (yych <= 0x194F) goto yy256;
yy254:
        YYSKIP ();
        status = action_line638(i, keys, input, token, &cursor, 254);
        continue;
yy256:
        YYSKIP ();
        status = action_line638(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line638: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line638: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line645
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line645: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line645: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line645()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line645.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line645.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x194F) goto yy260;
        if (yych <= 0x197F) goto yy262;
yy260:
        YYSKIP ();
        status = action_line645(i, keys, input, token, &cursor, 254);
        continue;
yy262:
        YYSKIP ();
        status = action_line645(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line645: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line645: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line652
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line652: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line652: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line652()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line652.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line652.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x19DF) goto yy266;
        if (yych <= 0x19FF) goto yy268;
yy266:
        YYSKIP ();
        status = action_line652(i, keys, input, token, &cursor, 254);
        continue;
yy268:
        YYSKIP ();
        status = action_line652(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line652: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line652: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line659
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line659: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line659: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line659()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line659.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line659.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x1CFF) goto yy272;
        if (yych <= 0x1D7F) goto yy274;
yy272:
        YYSKIP ();
        status = action_line659(i, keys, input, token, &cursor, 254);
        continue;
yy274:
        YYSKIP ();
        status = action_line659(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line659: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line659: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line666
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line666: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line666: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line666()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line666.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line666.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x1DFF) goto yy278;
        if (yych <= 0x1EFF) goto yy280;
yy278:
        YYSKIP ();
        status = action_line666(i, keys, input, token, &cursor, 254);
        continue;
yy280:
        YYSKIP ();
        status = action_line666(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line666: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line666: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line673
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line673: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line673: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line673()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line673.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line673.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x1EFF) goto yy284;
        if (yych <= 0x1FFF) goto yy286;
yy284:
        YYSKIP ();
        status = action_line673(i, keys, input, token, &cursor, 254);
        continue;
yy286:
        YYSKIP ();
        status = action_line673(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line673: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line673: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line680
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line680: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line680: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line680()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line680.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line680.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x1FFF) goto yy290;
        if (yych <= 0x206F) goto yy292;
yy290:
        YYSKIP ();
        status = action_line680(i, keys, input, token, &cursor, 254);
        continue;
yy292:
        YYSKIP ();
        status = action_line680(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line680: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line680: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line687
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line687: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line687: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line687()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line687.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line687.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x206F) goto yy296;
        if (yych <= 0x209F) goto yy298;
yy296:
        YYSKIP ();
        status = action_line687(i, keys, input, token, &cursor, 254);
        continue;
yy298:
        YYSKIP ();
        status = action_line687(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line687: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line687: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line694
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line694: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line694: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line694()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line694.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line694.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x209F) goto yy302;
        if (yych <= 0x20CF) goto yy304;
yy302:
        YYSKIP ();
        status = action_line694(i, keys, input, token, &cursor, 254);
        continue;
yy304:
        YYSKIP ();
        status = action_line694(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line694: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line694: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line701
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line701: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line701: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line701()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line701.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line701.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x20CF) goto yy308;
        if (yych <= 0x20FF) goto yy310;
yy308:
        YYSKIP ();
        status = action_line701(i, keys, input, token, &cursor, 254);
        continue;
yy310:
        YYSKIP ();
        status = action_line701(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line701: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line701: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line708
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line708: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line708: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line708()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line708.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line708.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x20FF) goto yy314;
        if (yych <= 0x214F) goto yy316;
yy314:
        YYSKIP ();
        status = action_line708(i, keys, input, token, &cursor, 254);
        continue;
yy316:
        YYSKIP ();
        status = action_line708(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line708: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line708: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line715
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line715: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line715: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line715()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line715.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line715.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x214F) goto yy320;
        if (yych <= 0x218F) goto yy322;
yy320:
        YYSKIP ();
        status = action_line715(i, keys, input, token, &cursor, 254);
        continue;
yy322:
        YYSKIP ();
        status = action_line715(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line715: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line715: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line722
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line722: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line722: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line722()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line722.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line722.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x218F) goto yy326;
        if (yych <= 0x21FF) goto yy328;
yy326:
        YYSKIP ();
        status = action_line722(i, keys, input, token, &cursor, 254);
        continue;
yy328:
        YYSKIP ();
        status = action_line722(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line722: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line722: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line729
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line729: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line729: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line729()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line729.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line729.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x21FF) goto yy332;
        if (yych <= 0x22FF) goto yy334;
yy332:
        YYSKIP ();
        status = action_line729(i, keys, input, token, &cursor, 254);
        continue;
yy334:
        YYSKIP ();
        status = action_line729(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line729: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line729: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line736
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line736: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line736: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line736()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line736.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line736.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x22FF) goto yy338;
        if (yych <= 0x23FF) goto yy340;
yy338:
        YYSKIP ();
        status = action_line736(i, keys, input, token, &cursor, 254);
        continue;
yy340:
        YYSKIP ();
        status = action_line736(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line736: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line736: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line743
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line743: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line743: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line743()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line743.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line743.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x23FF) goto yy344;
        if (yych <= 0x243F) goto yy346;
yy344:
        YYSKIP ();
        status = action_line743(i, keys, input, token, &cursor, 254);
        continue;
yy346:
        YYSKIP ();
        status = action_line743(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line743: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line743: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line750
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line750: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line750: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line750()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line750.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line750.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x243F) goto yy350;
        if (yych <= 0x245F) goto yy352;
yy350:
        YYSKIP ();
        status = action_line750(i, keys, input, token, &cursor, 254);
        continue;
yy352:
        YYSKIP ();
        status = action_line750(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line750: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line750: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line757
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line757: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line757: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line757()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line757.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line757.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x245F) goto yy356;
        if (yych <= 0x24FF) goto yy358;
yy356:
        YYSKIP ();
        status = action_line757(i, keys, input, token, &cursor, 254);
        continue;
yy358:
        YYSKIP ();
        status = action_line757(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line757: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line757: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line764
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line764: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line764: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line764()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line764.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line764.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x24FF) goto yy362;
        if (yych <= 0x257F) goto yy364;
yy362:
        YYSKIP ();
        status = action_line764(i, keys, input, token, &cursor, 254);
        continue;
yy364:
        YYSKIP ();
        status = action_line764(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line764: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line764: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line771
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line771: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line771: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line771()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line771.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line771.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x257F) goto yy368;
        if (yych <= 0x259F) goto yy370;
yy368:
        YYSKIP ();
        status = action_line771(i, keys, input, token, &cursor, 254);
        continue;
yy370:
        YYSKIP ();
        status = action_line771(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line771: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line771: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line778
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line778: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line778: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line778()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line778.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line778.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x259F) goto yy374;
        if (yych <= 0x25FF) goto yy376;
yy374:
        YYSKIP ();
        status = action_line778(i, keys, input, token, &cursor, 254);
        continue;
yy376:
        YYSKIP ();
        status = action_line778(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line778: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line778: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line785
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line785: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line785: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line785()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line785.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line785.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x25FF) goto yy380;
        if (yych <= 0x26FF) goto yy382;
yy380:
        YYSKIP ();
        status = action_line785(i, keys, input, token, &cursor, 254);
        continue;
yy382:
        YYSKIP ();
        status = action_line785(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line785: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line785: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line792
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line792: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line792: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line792()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line792.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line792.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x26FF) goto yy386;
        if (yych <= 0x27BF) goto yy388;
yy386:
        YYSKIP ();
        status = action_line792(i, keys, input, token, &cursor, 254);
        continue;
yy388:
        YYSKIP ();
        status = action_line792(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line792: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line792: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line799
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line799: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line799: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line799()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line799.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line799.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x27BF) goto yy392;
        if (yych <= 0x27EF) goto yy394;
yy392:
        YYSKIP ();
        status = action_line799(i, keys, input, token, &cursor, 254);
        continue;
yy394:
        YYSKIP ();
        status = action_line799(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line799: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line799: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line806
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line806: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line806: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line806()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line806.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line806.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x27EF) goto yy398;
        if (yych <= 0x27FF) goto yy400;
yy398:
        YYSKIP ();
        status = action_line806(i, keys, input, token, &cursor, 254);
        continue;
yy400:
        YYSKIP ();
        status = action_line806(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line806: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line806: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line813
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line813: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line813: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line813()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line813.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line813.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x27FF) goto yy404;
        if (yych <= 0x28FF) goto yy406;
yy404:
        YYSKIP ();
        status = action_line813(i, keys, input, token, &cursor, 254);
        continue;
yy406:
        YYSKIP ();
        status = action_line813(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line813: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line813: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line820
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line820: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line820: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line820()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line820.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line820.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x28FF) goto yy410;
        if (yych <= 0x297F) goto yy412;
yy410:
        YYSKIP ();
        status = action_line820(i, keys, input, token, &cursor, 254);
        continue;
yy412:
        YYSKIP ();
        status = action_line820(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line820: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line820: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line827
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line827: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line827: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line827()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line827.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line827.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x297F) goto yy416;
        if (yych <= 0x29FF) goto yy418;
yy416:
        YYSKIP ();
        status = action_line827(i, keys, input, token, &cursor, 254);
        continue;
yy418:
        YYSKIP ();
        status = action_line827(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line827: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line827: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line834
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line834: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line834: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line834()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line834.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line834.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x29FF) goto yy422;
        if (yych <= 0x2AFF) goto yy424;
yy422:
        YYSKIP ();
        status = action_line834(i, keys, input, token, &cursor, 254);
        continue;
yy424:
        YYSKIP ();
        status = action_line834(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line834: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line834: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line841
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line841: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line841: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line841()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line841.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line841.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x2AFF) goto yy428;
        if (yych <= 0x2BFF) goto yy430;
yy428:
        YYSKIP ();
        status = action_line841(i, keys, input, token, &cursor, 254);
        continue;
yy430:
        YYSKIP ();
        status = action_line841(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line841: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line841: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line848
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line848: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line848: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line848()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line848.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line848.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x2E7F) goto yy434;
        if (yych <= 0x2EFF) goto yy436;
yy434:
        YYSKIP ();
        status = action_line848(i, keys, input, token, &cursor, 254);
        continue;
yy436:
        YYSKIP ();
        status = action_line848(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line848: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line848: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line855
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line855: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line855: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line855()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line855.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line855.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x2EFF) goto yy440;
        if (yych <= 0x2FDF) goto yy442;
yy440:
        YYSKIP ();
        status = action_line855(i, keys, input, token, &cursor, 254);
        continue;
yy442:
        YYSKIP ();
        status = action_line855(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line855: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line855: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line862
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line862: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line862: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line862()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line862.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line862.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x2FEF) goto yy446;
        if (yych <= 0x2FFF) goto yy448;
yy446:
        YYSKIP ();
        status = action_line862(i, keys, input, token, &cursor, 254);
        continue;
yy448:
        YYSKIP ();
        status = action_line862(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line862: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line862: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line869
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line869: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line869: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line869()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line869.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line869.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x2FFF) goto yy452;
        if (yych <= 0x303F) goto yy454;
yy452:
        YYSKIP ();
        status = action_line869(i, keys, input, token, &cursor, 254);
        continue;
yy454:
        YYSKIP ();
        status = action_line869(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line869: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line869: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line876
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line876: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line876: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line876()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line876.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line876.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x303F) goto yy458;
        if (yych <= 0x309F) goto yy460;
yy458:
        YYSKIP ();
        status = action_line876(i, keys, input, token, &cursor, 254);
        continue;
yy460:
        YYSKIP ();
        status = action_line876(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line876: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line876: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line883
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line883: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line883: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line883()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line883.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line883.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x309F) goto yy464;
        if (yych <= 0x30FF) goto yy466;
yy464:
        YYSKIP ();
        status = action_line883(i, keys, input, token, &cursor, 254);
        continue;
yy466:
        YYSKIP ();
        status = action_line883(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line883: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line883: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line890
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line890: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line890: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line890()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line890.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line890.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x30FF) goto yy470;
        if (yych <= 0x312F) goto yy472;
yy470:
        YYSKIP ();
        status = action_line890(i, keys, input, token, &cursor, 254);
        continue;
yy472:
        YYSKIP ();
        status = action_line890(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line890: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line890: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line897
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line897: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line897: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line897()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line897.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line897.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x312F) goto yy476;
        if (yych <= 0x318F) goto yy478;
yy476:
        YYSKIP ();
        status = action_line897(i, keys, input, token, &cursor, 254);
        continue;
yy478:
        YYSKIP ();
        status = action_line897(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line897: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line897: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line904
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line904: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line904: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line904()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line904.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line904.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x318F) goto yy482;
        if (yych <= 0x319F) goto yy484;
yy482:
        YYSKIP ();
        status = action_line904(i, keys, input, token, &cursor, 254);
        continue;
yy484:
        YYSKIP ();
        status = action_line904(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line904: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line904: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line911
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line911: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line911: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line911()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line911.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line911.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x319F) goto yy488;
        if (yych <= 0x31BF) goto yy490;
yy488:
        YYSKIP ();
        status = action_line911(i, keys, input, token, &cursor, 254);
        continue;
yy490:
        YYSKIP ();
        status = action_line911(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line911: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line911: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line918
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line918: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line918: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line918()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line918.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line918.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x31EF) goto yy494;
        if (yych <= 0x31FF) goto yy496;
yy494:
        YYSKIP ();
        status = action_line918(i, keys, input, token, &cursor, 254);
        continue;
yy496:
        YYSKIP ();
        status = action_line918(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line918: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line918: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line925
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line925: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line925: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line925()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line925.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line925.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x31FF) goto yy500;
        if (yych <= 0x32FF) goto yy502;
yy500:
        YYSKIP ();
        status = action_line925(i, keys, input, token, &cursor, 254);
        continue;
yy502:
        YYSKIP ();
        status = action_line925(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line925: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line925: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line932
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line932: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line932: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line932()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line932.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line932.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x32FF) goto yy506;
        if (yych <= 0x33FF) goto yy508;
yy506:
        YYSKIP ();
        status = action_line932(i, keys, input, token, &cursor, 254);
        continue;
yy508:
        YYSKIP ();
        status = action_line932(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line932: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line932: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line939
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line939: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line939: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line939()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line939.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line939.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x33FF) goto yy512;
        if (yych <= 0x4DBF) goto yy514;
yy512:
        YYSKIP ();
        status = action_line939(i, keys, input, token, &cursor, 254);
        continue;
yy514:
        YYSKIP ();
        status = action_line939(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line939: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line939: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line946
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line946: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line946: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line946()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line946.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line946.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x4DBF) goto yy518;
        if (yych <= 0x4DFF) goto yy520;
yy518:
        YYSKIP ();
        status = action_line946(i, keys, input, token, &cursor, 254);
        continue;
yy520:
        YYSKIP ();
        status = action_line946(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line946: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line946: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line953
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line953: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line953: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line953()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line953.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line953.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x4DFF) goto yy524;
        if (yych <= 0x9FFF) goto yy526;
yy524:
        YYSKIP ();
        status = action_line953(i, keys, input, token, &cursor, 254);
        continue;
yy526:
        YYSKIP ();
        status = action_line953(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line953: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line953: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line960
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line960: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line960: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line960()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line960.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line960.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x9FFF) goto yy530;
        if (yych <= 0xA48F) goto yy532;
yy530:
        YYSKIP ();
        status = action_line960(i, keys, input, token, &cursor, 254);
        continue;
yy532:
        YYSKIP ();
        status = action_line960(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line960: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line960: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line967
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line967: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line967: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line967()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line967.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line967.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xA48F) goto yy536;
        if (yych <= 0xA4CF) goto yy538;
yy536:
        YYSKIP ();
        status = action_line967(i, keys, input, token, &cursor, 254);
        continue;
yy538:
        YYSKIP ();
        status = action_line967(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line967: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line967: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line974
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line974: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line974: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line974()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line974.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line974.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xABFF) goto yy542;
        if (yych <= 0xD7AF) goto yy544;
yy542:
        YYSKIP ();
        status = action_line974(i, keys, input, token, &cursor, 254);
        continue;
yy544:
        YYSKIP ();
        status = action_line974(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line974: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line974: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line981
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line981: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line981: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line981()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line981.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line981.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xD7FF) goto yy548;
        if (yych <= 0xDB7F) goto yy550;
yy548:
        YYSKIP ();
        status = action_line981(i, keys, input, token, &cursor, 254);
        continue;
yy550:
        YYSKIP ();
        status = action_line981(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line981: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line981: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line988
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line988: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line988: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line988()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line988.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line988.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xDB7F) goto yy554;
        if (yych <= 0xDBFF) goto yy556;
yy554:
        YYSKIP ();
        status = action_line988(i, keys, input, token, &cursor, 254);
        continue;
yy556:
        YYSKIP ();
        status = action_line988(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line988: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line988: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line995
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line995: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line995: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line995()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line995.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line995.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xDBFF) goto yy560;
        if (yych <= 0xDFFF) goto yy562;
yy560:
        YYSKIP ();
        status = action_line995(i, keys, input, token, &cursor, 254);
        continue;
yy562:
        YYSKIP ();
        status = action_line995(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line995: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line995: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1002
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1002: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1002: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1002()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1002.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1002.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xDFFF) goto yy566;
        if (yych <= 0xF8FF) goto yy568;
yy566:
        YYSKIP ();
        status = action_line1002(i, keys, input, token, &cursor, 254);
        continue;
yy568:
        YYSKIP ();
        status = action_line1002(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1002: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1002: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1009
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1009: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1009: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1009()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1009.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1009.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xF8FF) goto yy572;
        if (yych <= 0xFAFF) goto yy574;
yy572:
        YYSKIP ();
        status = action_line1009(i, keys, input, token, &cursor, 254);
        continue;
yy574:
        YYSKIP ();
        status = action_line1009(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1009: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1009: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1016
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1016: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1016: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1016()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1016.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1016.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFAFF) goto yy578;
        if (yych <= 0xFB4F) goto yy580;
yy578:
        YYSKIP ();
        status = action_line1016(i, keys, input, token, &cursor, 254);
        continue;
yy580:
        YYSKIP ();
        status = action_line1016(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1016: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1016: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1023
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1023: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1023: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1023()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1023.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1023.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFB4F) goto yy584;
        if (yych <= 0xFDFF) goto yy586;
yy584:
        YYSKIP ();
        status = action_line1023(i, keys, input, token, &cursor, 254);
        continue;
yy586:
        YYSKIP ();
        status = action_line1023(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1023: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1023: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1030
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1030: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1030: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1030()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1030.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1030.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFDFF) goto yy590;
        if (yych <= 0xFE0F) goto yy592;
yy590:
        YYSKIP ();
        status = action_line1030(i, keys, input, token, &cursor, 254);
        continue;
yy592:
        YYSKIP ();
        status = action_line1030(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1030: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1030: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1037
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1037: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1037: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1037()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1037.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1037.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFE1F) goto yy596;
        if (yych <= 0xFE2F) goto yy598;
yy596:
        YYSKIP ();
        status = action_line1037(i, keys, input, token, &cursor, 254);
        continue;
yy598:
        YYSKIP ();
        status = action_line1037(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1037: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1037: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1044
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1044: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1044: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1044()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1044.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1044.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFE2F) goto yy602;
        if (yych <= 0xFE4F) goto yy604;
yy602:
        YYSKIP ();
        status = action_line1044(i, keys, input, token, &cursor, 254);
        continue;
yy604:
        YYSKIP ();
        status = action_line1044(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1044: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1044: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1051
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1051: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1051: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1051()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1051.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1051.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFE4F) goto yy608;
        if (yych <= 0xFE6F) goto yy610;
yy608:
        YYSKIP ();
        status = action_line1051(i, keys, input, token, &cursor, 254);
        continue;
yy610:
        YYSKIP ();
        status = action_line1051(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1051: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1051: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1058
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1058: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1058: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1058()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1058.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1058.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFE6F) goto yy614;
        if (yych <= 0xFEFF) goto yy616;
yy614:
        YYSKIP ();
        status = action_line1058(i, keys, input, token, &cursor, 254);
        continue;
yy616:
        YYSKIP ();
        status = action_line1058(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1058: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1058: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1065
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1065: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1065: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1065()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1065.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1065.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0xFEFF) goto yy620;
        if (yych <= 0xFFEF) goto yy622;
yy620:
        YYSKIP ();
        status = action_line1065(i, keys, input, token, &cursor, 254);
        continue;
yy622:
        YYSKIP ();
        status = action_line1065(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1065: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1065: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1072
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1072: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1072: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1072()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1072.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1072.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych >= 0xFFF0) goto yy628;
        YYSKIP ();
        status = action_line1072(i, keys, input, token, &cursor, 254);
        continue;
yy628:
        YYSKIP ();
        status = action_line1072(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1072: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1072: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned short
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line1079
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line1079: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line1079: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line1079()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1079.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    for (i = 0; i < input_len; ++i) {
        /* from little-endian to host-endian */
        unsigned char *p = (unsigned char*)&input[i];
        input[i] = p[0] + (p[1] << 8u);
    }

    keys = (YYKEYTYPE *) read_file
        ("unicode_blocks.x--skeleton--encoding-policy(ignore).c.line1079.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych <= 0x1D7F) {
            if (yych <= 0x139F) {
                if (yych <= 0x07BF) {
                    if (yych <= 0x074F) goto yy632;
                    if (yych <= 0x077F) goto yy634;
                } else {
                    if (yych <= 0x08FF) goto yy634;
                    if (yych >= 0x1380) goto yy634;
                }
            } else {
                if (yych <= 0x197F) {
                    if (yych <= 0x18AF) goto yy632;
                    if (yych <= 0x18FF) goto yy634;
                } else {
                    if (yych <= 0x19DF) goto yy634;
                    if (yych <= 0x19FF) goto yy632;
                    if (yych <= 0x1CFF) goto yy634;
                }
            }
        } else {
            if (yych <= 0x31EF) {
                if (yych <= 0x2E7F) {
                    if (yych <= 0x1DFF) goto yy634;
                    if (yych >= 0x2C00) goto yy634;
                } else {
                    if (yych <= 0x2FDF) goto yy632;
                    if (yych <= 0x2FEF) goto yy634;
                    if (yych >= 0x31C0) goto yy634;
                }
            } else {
                if (yych <= 0xD7AF) {
                    if (yych <= 0xA4CF) goto yy632;
                    if (yych <= 0xABFF) goto yy634;
                } else {
                    if (yych <= 0xD7FF) goto yy634;
                    if (yych <= 0xFE0F) goto yy632;
                    if (yych <= 0xFE1F) goto yy634;
                }
            }
        }
yy632:
        YYSKIP ();
        status = action_line1079(i, keys, input, token, &cursor, 0);
        continue;
yy634:
        YYSKIP ();
        status = action_line1079(i, keys, input, token, &cursor, 254);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line1079: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line1079: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line1002() != 0) {
        return 1;
    }
    if(lex_line1009() != 0) {
        return 1;
    }
    if(lex_line1016() != 0) {
        return 1;
    }
    if(lex_line1023() != 0) {
        return 1;
    }
    if(lex_line1030() != 0) {
        return 1;
    }
    if(lex_line1037() != 0) {
        return 1;
    }
    if(lex_line1044() != 0) {
        return 1;
    }
    if(lex_line1051() != 0) {
        return 1;
    }
    if(lex_line1058() != 0) {
        return 1;
    }
    if(lex_line1065() != 0) {
        return 1;
    }
    if(lex_line1072() != 0) {
        return 1;
    }
    if(lex_line1079() != 0) {
        return 1;
    }
    if(lex_line344() != 0) {
        return 1;
    }
    if(lex_line351() != 0) {
        return 1;
    }
    if(lex_line358() != 0) {
        return 1;
    }
    if(lex_line365() != 0) {
        return 1;
    }
    if(lex_line372() != 0) {
        return 1;
    }
    if(lex_line379() != 0) {
        return 1;
    }
    if(lex_line386() != 0) {
        return 1;
    }
    if(lex_line393() != 0) {
        return 1;
    }
    if(lex_line400() != 0) {
        return 1;
    }
    if(lex_line407() != 0) {
        return 1;
    }
    if(lex_line414() != 0) {
        return 1;
    }
    if(lex_line421() != 0) {
        return 1;
    }
    if(lex_line428() != 0) {
        return 1;
    }
    if(lex_line435() != 0) {
        return 1;
    }
    if(lex_line442() != 0) {
        return 1;
    }
    if(lex_line449() != 0) {
        return 1;
    }
    if(lex_line456() != 0) {
        return 1;
    }
    if(lex_line463() != 0) {
        return 1;
    }
    if(lex_line470() != 0) {
        return 1;
    }
    if(lex_line477() != 0) {
        return 1;
    }
    if(lex_line484() != 0) {
        return 1;
    }
    if(lex_line491() != 0) {
        return 1;
    }
    if(lex_line498() != 0) {
        return 1;
    }
    if(lex_line505() != 0) {
        return 1;
    }
    if(lex_line512() != 0) {
        return 1;
    }
    if(lex_line519() != 0) {
        return 1;
    }
    if(lex_line526() != 0) {
        return 1;
    }
    if(lex_line533() != 0) {
        return 1;
    }
    if(lex_line540() != 0) {
        return 1;
    }
    if(lex_line547() != 0) {
        return 1;
    }
    if(lex_line554() != 0) {
        return 1;
    }
    if(lex_line561() != 0) {
        return 1;
    }
    if(lex_line568() != 0) {
        return 1;
    }
    if(lex_line575() != 0) {
        return 1;
    }
    if(lex_line582() != 0) {
        return 1;
    }
    if(lex_line589() != 0) {
        return 1;
    }
    if(lex_line596() != 0) {
        return 1;
    }
    if(lex_line603() != 0) {
        return 1;
    }
    if(lex_line610() != 0) {
        return 1;
    }
    if(lex_line617() != 0) {
        return 1;
    }
    if(lex_line624() != 0) {
        return 1;
    }
    if(lex_line631() != 0) {
        return 1;
    }
    if(lex_line638() != 0) {
        return 1;
    }
    if(lex_line645() != 0) {
        return 1;
    }
    if(lex_line652() != 0) {
        return 1;
    }
    if(lex_line659() != 0) {
        return 1;
    }
    if(lex_line666() != 0) {
        return 1;
    }
    if(lex_line673() != 0) {
        return 1;
    }
    if(lex_line680() != 0) {
        return 1;
    }
    if(lex_line687() != 0) {
        return 1;
    }
    if(lex_line694() != 0) {
        return 1;
    }
    if(lex_line701() != 0) {
        return 1;
    }
    if(lex_line708() != 0) {
        return 1;
    }
    if(lex_line715() != 0) {
        return 1;
    }
    if(lex_line722() != 0) {
        return 1;
    }
    if(lex_line729() != 0) {
        return 1;
    }
    if(lex_line736() != 0) {
        return 1;
    }
    if(lex_line743() != 0) {
        return 1;
    }
    if(lex_line750() != 0) {
        return 1;
    }
    if(lex_line757() != 0) {
        return 1;
    }
    if(lex_line764() != 0) {
        return 1;
    }
    if(lex_line771() != 0) {
        return 1;
    }
    if(lex_line778() != 0) {
        return 1;
    }
    if(lex_line785() != 0) {
        return 1;
    }
    if(lex_line792() != 0) {
        return 1;
    }
    if(lex_line799() != 0) {
        return 1;
    }
    if(lex_line806() != 0) {
        return 1;
    }
    if(lex_line813() != 0) {
        return 1;
    }
    if(lex_line820() != 0) {
        return 1;
    }
    if(lex_line827() != 0) {
        return 1;
    }
    if(lex_line834() != 0) {
        return 1;
    }
    if(lex_line841() != 0) {
        return 1;
    }
    if(lex_line848() != 0) {
        return 1;
    }
    if(lex_line855() != 0) {
        return 1;
    }
    if(lex_line862() != 0) {
        return 1;
    }
    if(lex_line869() != 0) {
        return 1;
    }
    if(lex_line876() != 0) {
        return 1;
    }
    if(lex_line883() != 0) {
        return 1;
    }
    if(lex_line890() != 0) {
        return 1;
    }
    if(lex_line897() != 0) {
        return 1;
    }
    if(lex_line904() != 0) {
        return 1;
    }
    if(lex_line911() != 0) {
        return 1;
    }
    if(lex_line918() != 0) {
        return 1;
    }
    if(lex_line925() != 0) {
        return 1;
    }
    if(lex_line932() != 0) {
        return 1;
    }
    if(lex_line939() != 0) {
        return 1;
    }
    if(lex_line946() != 0) {
        return 1;
    }
    if(lex_line953() != 0) {
        return 1;
    }
    if(lex_line960() != 0) {
        return 1;
    }
    if(lex_line967() != 0) {
        return 1;
    }
    if(lex_line974() != 0) {
        return 1;
    }
    if(lex_line981() != 0) {
        return 1;
    }
    if(lex_line988() != 0) {
        return 1;
    }
    if(lex_line995() != 0) {
        return 1;
    }
    return 0;
}
   `@  	
`@ 
 `@  `@  ` @! " ##$%&`'@( ) **+,-`.@/ 0 11234`5@6 7 889:;`<@= > ??@AB`C@D E FFGHI`J@K L MMNOP`Q@R S TTUVW`X@Y Z [[\]^`_@` a bbcde`f@g h iijkl`m@n o ppqrs`t@u v wwxyz`{@| } ~~`@  `@  `@  `@  `@  `@  `@  `@  `@  `@  Šƀ`@  ̠̀`@  ӠԀ`@  ڠۀ`@  #*18?FMT[bipw~
&-4;BIPW^elsz
")07>ELSZahov}	%,3:AHOV]dkry!(/6=DKRY`gnu|$+29@GNU\cjqx '.5<CJQX_fmt{ 2Kd},E^w
&?Xq 9Rk3Le~-F_x'@Yr!:Sl4Mf.G`y(AZs	";Tm5Ng/Haz)B[t
#<Un6Oh0Ib{*C\u$=Vo7Pi1Jc|+D]v%>Wp8Qj                                                                                                                                                                                                                                                                    	

{tmf_XQJC<5.'  !"##$%&'()*+,-./012345x6q7j8c9\:U;N<G=@>9?2@+A$BCDEFGGHIJKLMNOPQRSTUVWX|YuZn[g\`]Y^R_K`Da=b6c/d(e!fghijjklmnopqrstuvwxyz{|y}r~kd]VOHA:3,%	ߒؓєʕÖ}vohaZSLE>70)"
ܶշθǹzsle^WPIB;4-&
ݽ޶߯~wpib[TMF?81*# 
#(-27<AFKPUZ_dinsx}	"',16;@EJOTY^chmrw|
!&+05:?DINSX]bglqv{ %*/49>CHMRW\afkpuz$).38=BGLQV[`ejoty~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~                                                                                                                                                                                                                                                                    	

~ytoje`[ V!Q"L#G$B%=&8'3(.))*$+,-./01223456789:;<=>?@ABCDEFGHIJKzLuMpNkOfPaQ\RWSRTMUHVCW>X9Y4Z/[*\%] ^_`abcddefghijklmnopqrstuvwxyz{|}{~vqlgb]XSNID?:50+&!
۝֞џ̠ǡ¢|wrmhc^YTOJE@;61,'"	Ծչִׯت٥ڠۛܖݑތ߇}xsnid_ZUPKFA<72-(#
PUZ_dinsx}	"',16;@EJOTY^chmrw|
!&+05:?DINSX]bglqv{ %*/49>CHMRW\afkpuz$).38=BGLQV[`ejoty~ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNO                                                                                   	

| x!t"p#l$h%d&`'\(X)T*P+L,H-D.@/<0814203,4(5$6 789:;<=> ??@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^|_x`tapblchdde`f\gXhTiPjLkHlDm@n<o8p4q0r,s(t$u vwxyz{|} ~~܆؇ԈЉ̊ȋČ|xtplhd`\XTPLHD@<840,($  ̼͸δϰЬѨҤӠԜ՘֔א،وڄۀ|xtplhd`\XTPLHD@<840,($ O 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~PSVY\_behknqtwz}

"%(+.147:=@CFILORUX[^adgjmpsvy| 	!$'*-0369<?BEHKNQTWZ]`cfilorux{~                                                                                                                                                                                                                                         	

 !"#$%&'()*+,-./0123456789:;<=>?~@|AzBxCvDtErFpGnHlIjJhKfLdMbN`O^P\QZRXSVTTURVPWNXLYJZH[F\D]B^@_>`<a:b8c6d4e2f0g.h,i*j(k&l$m"n opqrstuvwxy
z{|}~ ޏܐڑؒ֓ԔҕЖΗ̘ʙȚƛĜ~|zxvtrpnljhfdb`^\ZXVTRPNLJHFDB@><:86420.,*(&$" 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 	

                   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ !"#$%&'()*+,-./                   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	/PRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~0123456789:;<=>?@ABCDEFGHIJKLMNO                                   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	Oprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~PQRSTUVWXYZ[\]^_`abcdefghijklmno                                   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	o 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~pqrstuvwxyz{|}~                                                                                                                                                   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                           	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                                        ( 0 8 @ H P X ` h p x                   (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HO 			!	,	7	B	M	X	c	n	y													


)
4
?
J
U
`
k
v












&1<GR]hs~
#.9DOZep{


 
+
6
A
L
W
b
m
x












(3>IT_ju%0;FQ\gr}"-8CNYdoz	*5@KValw'2=HS^it$/:EP[fq| $*06<BHNTZ`flrx~ &,28>DJPV\bhntz
"(.4:@FLRX^djpv| $*06<BHNTZ`flrx~ &,28>DJPV\bhntz 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ *8FTbp~
&4BP^lz  " 0 > L Z h v          !!!,!:!H!V!d!r!!!!!!!!!!!""("6"D"R"`"n"|""""""""""##$#2#@#N#\#j#x##########$$ $.$<$J$X$f$t$$$$$$$$$$ %%%*%8%F%T%b%p%~%%%%%%%%%%
&&&&4&B&P&^&l&z&&&&&&&&&&''"'0'>'L'Z'h'v''''''''''(((,(:(H(V(d(r((((((((((())()6)D)R)`)n)|))))))))))**$*2*@*N*\*j*x**********++ +.+<+J+X+f+t+++++++++++................................................................ /////
/////////// /"/$/&/(/*/,/./0/2/4/6/8/:/</>/@/B/D/F/H/J/L/N/P/R/T/V/X/Z/\/^/`/b/d/f/h/j/l/n/p/r/t/v/x/z/|/~////////////////////////////////////////////////////////// 00000
00000000000 0"0$0&0(0*0,0.00020406080:0<0>0@0B0D0F0H0J0L0N0P0R0T0V0X0Z0\0^0`0b0d0f0h0j0l0n0p0r0t0v0x0z0|0~00000000000000000000000000000000000000000000000000000000000000000 11111
11111111111 1"1$1&1(1*1,1.10121416181:1<1>1@1B1D1F1H1J1L1N1P1R1T1V1X1Z1\1^1`1b1d1f1h1j1l1n1p1r1t1v1x1z1|1~11111111111111111111111111111111111c22I33/44555n66T77:88 99:y::_;;E<<+==>>>j??P@@6AABBCuCC[DDAEE'FF
GGGfHHLII2JJKKKqLLWMM=NN#OO	P|PPbQQHRR.SSTTTmUUSVV9WWXXYxYY^ZZD[[*\\]]]i^^O__5``aabtbbZcc@dd&eefffeggKhh1iijjjpkkVll<mm"nno{ooappGqq-rrssslttRuu8vvwwxwxx]yyCzz){{|||h}}N~~4 sŶ?%~d׆J0oUȋ;!z`ӏF,kޓQĔ7v\ϘB(gڜM3rXˡ>$
}Ϥ ,Xܬ4`<hDpȯ Lxа(Tر0\8d@lĴHt̵$P|Զ ,Xܷ4`<hDpȺ Lxл(Tؼ0\8d@lĿHt$P| ,X°4`Ìø<hĔDpŜ LxƤ(TǀǬ0\Ȉȴ8dɐɼ@lʘHtˠ$P|̨ ,Ẍ́Ͱ4`Όθ<hϔDpМ LxѤ(TҀҬ0\ӈӴ8dԐԼ@l՘Ht֠$P|רׯ 'Nu؜8_ن٭"Ipڗھ3ZہۨDkܒܹ.U|ݣ?fލ޴)Pwߞ:a$Kr5\Fm	0W~Ah+Ry<c&Mt7^!Ho2YCj-T{>e(Ov9`#Jq
4[El/V}@g*Qx;b%Ls6] Gn
1XBi,Sz "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~PQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 	!$'*-0369<?BEHKNQTWZ]`cfilorux{~ #&),/258;>ADGJMPSVY\_behknqtwz}

"%(+.147:=@CFILORUX[^adgjmpsvy| ,,,	,,,,,,,,!,$,',*,-,0,3,6,9,<,?,B,E,H,K,N,Q,T,W,Z,],`,c,f,i,l,o,r,u,x,{,~,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,---------- -#-&-)-,-/-2-5-8-;->-A-D-G-J-M-P-S-V-Y-\-_-b-e-h-k-n-q-t-w-z-}--------------------------------------------...
.
.......".%.(.+...1.4.7.:.=.@.C.F.I.L.O.R.U.X.[.^.a.d.g.j.m.p.s.v.y.|..////////////////111111111111111111111111111111111111111111111111Фؤ  (08@HPX`hpxȥХإ  (08@HPX`hpxȦЦئ  (08@HPX`hpxȧЧا  (08@HPX`hpxȨШب  (08@HPX`hpxȩЩة  (08@HPX`hpxȪЪت  (08@HPX`hpxȫЫثױײ׳״׵׶׷׸׹׺׻׼׽׾׿                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ÀĀŀƀǀȀɀʀˀ̀̀΀πЀрҀӀԀՀր׀؀ـڀۀ܀݀ހ߀                                                                                                                                          	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~}|{zyxwvutsrqponmlkjihgfedcba`_^]\[ZYXWVUTSRQPONMLKJIHGFEDCBA@?>=<;:9876543210/.-,+*)('&%$#"! 

	                                                                                                                                                                                                                                                                          	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                  ~}|{zyx	w
vut
srqponmlkjihgfedcba `!_"^#]$\%[&Z'Y(X)W*V+U,T-S.R/Q0P1O2N3M4L5K6J7I8H9G:F;E<D=C>B?A@@A?B>C=D<E;F:G9H8I7J6K5L4M3N2O1P0Q/R.S-T,U+V*W)X(Y'Z&[%\$]#^"_!` abcdefghijklmnopqrs
tuv
w	xyz{|}~ ߡޢݣܤۥڦ٧بש֪իԬӭҮѯаϱβͳ̴˵ʶɷȸǹƺŻļý¾½üĻźƹǸȷɶʵ˴̳ͲαϰЯѮҭӬԫժ֩רا٦ڥۤܣݢޡߠ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                      
             " $ & ( * , . 0 2 4 6 8 : < > @ B D F H J L N P R T V X Z \ ^ ` b d f h j l n p r t v x z | ~                                                                  
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~PNLJHFDB	@
><:
86420.,*(&$"  !"#$
%&'() **+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghi~j|kzlxmvntorppqnrlsjthufvdwbx`y^z\{Z|X}V~TRPNLJHFDB@><:86420.,*(&$" 
 ޹ܺڻؼֽԾҿȾɼʺ˸̶ʹβϰЮѬҪӨԦդ֢נ؞ٜښۘܖݔޒߐ~|zxvtrpnljhfdb`^\ZXVTR 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNO                                                                                                                                                                                                                    	        ! $ ' * - 0 3 6 9 < ? B E H K N Q T W Z ] ` c f i l o r u x { ~                                             #&),/258;>ADGJMPSVY\_behknqtwz}

"%(+.147:=@CFILO	

~|zxvt r!p"n#l$j%h&f'd(b)`*^+\,Z-X.V/T0R1P2N3L4J5H6F7D8B9@:>;<<:=8>6?4@2A0B.C,D*E(F&G$H"I JKLMNOPQRST
UVWXY ZZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~~|zxvtrpnljhfdb`^\ZXVTRPNLJHFDB@><:86420.,*(&$" 
 PQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                    	        ! $ ' * - 0 3 6 9 < ? B E H K N Q T W Z ] ` c f i l o r u x { ~                                             #&),/258;>ADGJMPSVY\_behknqtwz}

"%(+.147:=@CFILORUX[^adgjmpsvy| 	

 !"#$%&'()*+,-|.y/v0s1p2m3j4g5d6a7^8[9X:U;R<O=L>I?F@CA@B=C:D7E4F1G.H+I(J%K"LMNOPQR
S
TUVWWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~}zwtqnkheb_\YVSPMJGDA>;852/,)&# ޶۷ظչҺϻ̼ɽƾÿ·ôıŮƫǨȥɢʟ˜̙͖ΓϐЍъ҇ӄԁ~{xurolifc`]ZWTQNKHEB?<9630-*'$!	                                                                                    	        ! $ ' * - 0 3 6 9 < ? B E H K N Q T W Z ] ` c f i l o r u x { ~                                             #&),/258;>ADGJMPSVY\_behknqtwz}

"%(+.147:=@CFILORUX[^adgjmpsvy|pmjgda^	[
XUR
OLIFC@=:741.+(%" !"#
$
%&'(()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQR}SzTwUtVqWnXkYhZe[b\_]\^Y_V`SaPbMcJdGeDfAg>h;i8j5k2l/m,n)o&p#q rstuvwxyz{||}~އۈ؉Պҋό̍ɎƏÐ~{xurolifc`]ZWTQNKHEB?<9630-*'$!	 |yvs 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmno                                                                                                                           $ ( , 0 4 8 < @ D H L P T X \ ` d h l p t x |                                   $(,048<@DHLPTX\`dhlptx|  $(,048<@DHLPTX\`dhlptx|  $(,048<@DHLPTX\`dhlo 	

 !"#|$x%t&p'l(h)d*`+\,X-T.P/L0H1D2@3<4854607,8(9$: ;<=>?@AB CCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ab|cxdtepflghhdi`j\kXlTmPnLoHpDq@r<s8t4u0v,w(x$y z{|}~ ܊؋ԌЍ̎ȏĐ|xtplhd`\XTPLHD@<840,($  мѸҴӰԬը֤נ؜٘ڔې܌݈ބ߀|xtplhd`\XTPLHD@<840,($ pqrstuvwxyz{|}~                                                                                                                                                           $ ( , 0 4 8 < @ D H L P T X \ ` d h l p t x |                                   $(,048<@DHLPTX\`dhlptx|  $(,048<@DHLPTX\`dhlptx|  $(,048<@DHLPTX\`dhlptx| 	

~yt o!j"e#`$[%V&Q'L(G)B*=+8,3-..)/$01234567789:;<=>?@ABCDEFGHIJKLMNOPzQuRpSkTfUaV\WWXRYMZH[C\>]9^4_/`*a%b cdefghiijklmnopqrstuvwxyz{|}~{vqlgb]XSNID?:50+&!
֣ۢѤ̥Ǧ§|wrmhc^YTOJE@;61,'"	پڹ۴ܯݪޥߠ}xsnid_ZUPKFA<72-(#
 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                   
     # ( - 2 7 < A F K P U Z _ d i n s x }                           	"',16;@EJOTY^chmrw|
!&+05:?DINSX]bglqv{ %*/49>CHMRW\afkpuz$).38=BGLQV[`ejoty~0+&!	


 !"#$%&'|(w)r*m+h,c-^.Y/T0O1J2E3@4;56617,8'9":;<=>	?@@ABCDEFGHIJKLMNOPQRSTUVWXY}Zx[s\n]i^d__`ZaUbPcKdFeAf<g7h2i-j(k#lmnop
qr sstuvwxyz{|}~~ytoje`[VQLGB=83.)$ޫ٬ԭϮʯŰzupkfa\WRMHC>94/*% {vqlgb]XSNID?:5 	

 !"#$%&'()*+,-./                                                       $ * 0 6 < B H N T Z ` f l r x ~                       &,28>DJPV\bhntz
"(.4:@FLRX^djpv| $*06<BHNTZ`flrx~ &,28>DJPV\bhntz
"(./|	w
rmh
c^YTOJE@;61,'"	 !!"#$%&'()*+,-./0123456789:};x<s=n>i?d@_AZBUCPDKEFFAG<H7I2J-K(L#MNOPQ
RS TTUVWXYZ[\]^_`abcdefghijkl~myntoopjqer`s[tVuQvLwGxBy=z8{3|.})~$ތٍԎϏʐőzupkfa\WRMHC>94/*% ߾ڿļŷƲǭȨɣʞ˙̔͏ΊυЀ{vqlgb]XSNID?:50+&!
0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                       $ * 0 6 < B H N T Z ` f l r x ~                       &,28>DJPV\bhntz
"(.4:@FLRX^djpv| $*06<BHNTZ`flrx~ &,28>DJPV\bhntz
"(.4:@FLRX^djpv| 	

|vpjd^ X!R"L#F$@%:&4'.(()"*+,-
.//0123456789:;<=>?@ABCDzEtFnGhHbI\JVKPLJMDN>O8P2Q,R&S TUVWXYYZ[\]^_`abcdefghijklm~nxorplqfr`sZtTuNvHwBx<y6z0{*|$}~ ܈։ЊʋČ|vpjd^XRLF@:4.("
ڲԳδȵ¶ztnhb\VPJD>82,& ~xrlf`ZTNHB<60*$                                                                                                                       $ * 0 6 < B H N T Z ` f l r x ~                       &,28>DJPV\bhntz
"(.4:@FLRX^djpv| $*06<BHNTZ`flrx~ &,28>DJPV\bhntz
"(.4:@FLRX^djpv| 	

{tmf_XQJ C!<"5#.$'% &'()**+,-./0123456789:;<x=q>j?c@\AUBNCGD@E9F2G+H$IJKLMNNOPQRSTUVWXYZ[\]^_|`uanbgc`dYeRfKgDh=i6j/k(l!mnopqqrstuvwxyz{|}~yrkd]VOHA:3,%	ߙؚћʜÝ}vohaZSLE>70)"
ܽվο²ëĤŝƖǏȈɁzsle^WPIB;4-&
~wpib[TMF?81*# 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                      # * 1 8 ? F M T [ b i p w ~                   
&-4;BIPW^elsz
")07>ELSZahov}	%,3:AHOV]dkry!(/6=DKRY`gnu|$+29@GNU\cjqx '.5<CJQX_fmt{PIB	;
4-&

 !"#~$w%p&i'b([)T*M+F,?-8.1/*0#12345 66789:;<=>?@ABCDEFG{HtImJfK_LXMQNJOCP<Q5R.S'T UVWXYYZ[\]^_`abcdefghijkxlqmjnco\pUqNrGs@t9u2v+w$xyz{|}}~ށׂЃɄ|ung`YRKD=6/(!ۥԦͧƨyrkd]VOHA:3,%	̼͵ήϧРљҒӋԄ}vohaZSLE>70)"
zsle^W 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNO                                                                                       ( 0 8 @ H P X ` h p x                   (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx  (08@HPX`hpx	

zsle^WPIB;4-& 
!""#$%&'()*+,-./0123~4w5p6i7b8[9T:M;F<?=8>1?*@#ABCDE FFGHIJKLMNOPQRSTUVW{XtYmZf[_\X]Q^J_C`<a5b.c'd efghiijklmnopqrstuvwxyz{x|q}j~c\UNG@92+$ޑגГɔ|ung`YRKD=6/(!۵ԶͷƸyrkd]VOHA:3,%	ܼݵޮߧ}vohaZSLE>70)"
                                                                  	   $ - 6 ? H Q Z c l u ~                )2;DMV_hqz
%.7@IR[dmv!*3<ENW`ir{&/8AJS\enw"+4=FOXajs|'09BKT]fox#,5>GPYbkt}
(1:CLU^gpy	w
ne\
SJA8/& !"#${%r&i'`(W)N*E+<,3-*.!/01223456789:;<=>?@vAmBdC[DREIF@G7H.I%JKL
MNNOPQRSTUVWXYZ[z\q]h^__V`MaDb;c2d)e fghiijklmnopqrstuv~wuxlyczZ{Q|H}?~6-$	 ܈Ӊʊypg^ULC:1(
פΥŦ}tkbYPG>5,#ۿ·îĥŜƓǊȁxof]TKB90'ݻ޲ߩ|sjaXOF=4+" 											
			
																			 	!	"	#	$	%	&	'	(	)	*	+	,	-	.	/	0	1	2	3	4	5	6	7	8	9	:	;	<	=	>	?	@	A	B	C	D	E	F	G	H	I	J	K	L	M	N	O	P	Q	R	S	T	U	V	W	X	Y	Z	[	\	]	^	_	`	a	b	c	d	e	f	g	h	i	j	k	l	m	n	o	p	q	r	s	t	u	v	w	x	y	z	{	|	}	~		                                                                                                                                  
   ( 2 < F P Z d n x              ",6@JT^hr|&0:DNXblv *4>HR\fpz$.8BLV`jt~ 
(2<FPZdnx",6@JT^hr|&0:DNXblv *4>HR\fpz			$	.	8	B	L	V	`	j	t	~		 


~tj`VLB8.$ !""#$%&'()*+,-.z/p0f1\2R3H4>546*7 89:;;<=>?@ABCDEFGvHlIbJXKNLDM:N0O&PQRSSTUVWXYZ[\]^_|`rahb^cTdJe@f6g,h"ijkllmnopqrstuvwxxynzd{Z|P}F~<2(
 ؈ΉĊ~tj`VLB8.$ޠԡʢzpf\RH>4* ڹкƻvlbXND:0&Ըծ֤ךؐن|rh^TJ@6,"xndZPF<2(
																																																																																																																																                                                                                                                                  
   ( 2 < F P Z d n x              ",6@JT^hr|&0:DNXblv *4>HR\fpz$.8BLV`jt~ 
(2<FPZdnx",6@JT^hr|&0:DNXblv *4>HR\fpz			$	.	8	B	L	V	`	j	t	~														
vlb
XND:0& !"|#r$h%^&T'J(@)6*,+",-.//0123456789:;x<n=d>Z?P@FA<B2C(DEF
G HHIJKLMNOPQRS~TtUjV`WVXLYBZ8[.\$]^_``abcdefghijklzmpnfo\pRqHr>s4t*u vwxyyz{|}~vlbXND:0&̖֕|rh^TJ@6,"ܭҮȯxndZPF<2(
 Ⱥɰʦ˜͈̒~tj`VLB8.$zpf\RH>4*  








	























 
!
"
#
$
%
&
'
(
)
*
+
,
-
.
/
0
1
2
3
4
5
6
7
8
9
:
;
<
=
>
?
@
A
B
C
D
E
F
G
H
I
J
K
L
M
N
O
P
Q
R
S
T
U
V
W
X
Y
Z
[
\
]
^
_
`
a
b
c
d
e
f
g
h
i
j
k
l
m
n
o
p
q
r
s
t
u
v
w
x
y
z
{
|
}
~

                                                                                                                                    ! , 7 B M X c n y             )4?JU`kv&1<GR]hs~
#.9DOZep{
 +6ALWbmx(3>IT_ju%0;FQ\gr}"-8CNYdoz	*5@KValw			'	2	=	H	S	^	i	t													


$
/
:
E
P
[
f
q
|

 
|qf[PE:/$ !!"#$%&'()*+,t-i.^/S0H1=223'4567789:;<=>?@ABwClDaEVFKG@H5I*JKL	MMNOPQRSTUVWXzYoZd[Y\N]C^8_-`"abcddefghijklmn}orpgq\rQsFt;u0v%wxyzz{|}~uj_TI>3(ۓДŕxmbWLA6+ 
ީӪȫ{peZOD9.#
µêğŔƉ~sh]RG<1&ظ٭ڢۗ܌݁vk`UJ?4)yncXMB7,!































































































































                                                                                                                                    ! , 7 B M X c n y             )4?JU`kv&1<GR]hs~
#.9DOZep{
 +6ALWbmx(3>IT_ju%0;FQ\gr}"-8CNYdoz	*5@KValw			'	2	=	H	S	^	i	t													


$
/
:
E
P
[
f
q
|












uj
_TI>3( !x"m#b$W%L&A'6(+) *+
,,-./01234567{8p9e:Z;O<D=9>.?#@A
BCCDEFGHIJKLM~NsOhP]QRRGS<T1U&VWXYYZ[\]^_`abcdvekf`gUhJi?j4k)lmnoopqrstuvwxyzy{n|c}X~MB7,! ߈ԉɊ|qf[PE:/$ן̠ti^SH=2'ڵ϶ķwlaVK@5*	ͼαϦЛѐ҅zodYNC8-"}rg\QF;0% 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                    $ 0 < H T ` l x             ,8DP\ht(4@LXdp| $0<HT`lx ,8DP\ht(4@LXdp| $0<HT`lx ,8DP\ht(4@LXdp| 			$	0	<	H	T	`	l	x												

 
,
8
D
P
\
h
t











(4@LXdp| 
|pdXL@4(  !"#$%&'()*t+h,\-P.D/80,1 234456789:;<=>x?l@`ATBHC<D0E$FGH IIJKLMNOPQR|SpTdUXVLW@X4Y(Z[\]]^_`abcdefgthhi\jPkDl8m,n opqqrstuvwxyz{x|l}`~TH<0$ ܈ЉĊ|pdXL@4(ԝȞth\PD8, ر̲xl`TH<0$ ǸȬɠʔˈ|pdXL@4(ۼܰݤޘߌth\PD8, xl`TH<0$                                                                                                                                    $ 0 < H T ` l x             ,8DP\ht(4@LXdp| $0<HT`lx ,8DP\ht(4@LXdp| $0<HT`lx ,8DP\ht(4@LXdp| 			$	0	<	H	T	`	l	x												

 
,
8
D
P
\
h
t











(4@LXdp|t
h\PD8,  x!l"`#T$H%<&0'$()* ++,-./01234|5p6d7X8L9@:4;(<=>??@ABCDEFGHItJhK\LPMDN8O,P QRSSTUVWXYZ[\]x^l_``TaHb<c0d$efg hhijklmnopq|rpsdtXuLv@w4x(yz{||}~Ȁth\PD8, ؓ̔xl`TH<0$ ܧШĩ|pdXL@4(ԼȽth\PD8, ҴӨԜՐքxl`TH<0$ |pdXL@4( 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                  
  ' 4 A N [ h u           +8ER_ly"/<IVcp}&3@MZgt*7DQ^kx!.;HUbo|%2?LYfs)6CP]jw -:GTan{
		$	1	>	K	X	e	r											


(
5
B
O
\
i
v










,9FS`mz	#0=JWdq~ 

~qdWJ=0#	 !"#$%&'(z)m*`+S,F-9.,/01223456789:;v<i=\>O?B@5A(BCDEEFGHIJKLMNrOePXQKR>S1T$UV
WWXYZ[\]^_`{anbacTdGe:f-g hijjklmnopqrswtju]vPwCx6y)z{|}}~΀sfYL?2%גʓ|obUH;.!ӥƦxk^QD7*ܷϸ¹tgZM@3&˾̱ͤΗϊ}pcVI</"޺߭yl_RE8+uh[NA4'
                                                                                                                                  
  ' 4 A N [ h u           +8ER_ly"/<IVcp}&3@MZgt*7DQ^kx!.;HUbo|%2?LYfs)6CP]jw -:GTan{
		$	1	>	K	X	e	r											


(
5
B
O
\
i
v










,9FS`mz	#0=JWdq~
sfYL?2%| o!b"U#H$;%.&!'())*+,-./012x3k4^5Q6D778*9:;<<=>?@ABCDEtFgGZHMI@J3K&LMNNOPQRSTUVW}XpYcZV[I\<]/^"_`aabcdefghijykll_mRnEo8p+qrsttuvwxyz{|}u~h[NA4'
 ى̊~qdWJ=0#	՜ȝzm`SF9,ޮѯİvi\OB5(óĦřƌreXK>1$
ռ֯עؕو{naTG:- wj]PC6) 








	























 
!
"
#
$
%
&
'
(
)
*
+
,
-
.
/
0
1
2
3
4
5
6
7
8
9
:
;
<
=
>
?
@
A
B
C
D
E
F
G
H
I
J
K
L
M
N
O
P
Q
R
S
T
U
V
W
X
Y
Z
[
\
]
^
_
`
a
b
c
d
e
f
g
h
i
j
k
l
m
n
o
p
q
r
s
t
u
v
w
x
y
z
{
|
}
~

                                                                                                                                    * 8 F T b p ~          
&4BP^lz"0>LZhv,:HVdr(6DR`n|$2@N\jx .<JXft *8FTbp~
&4BP^lz		"	0	>	L	Z	h	v										


,
:
H
V
d
r










(6DR`n|$2@N\jx

 
.
<
J
X
f
t

 tfXJ<.  !"#$%&'x(j)\*N+@,2-$./0012345678|9n:`;R<D=6>(?@AABCDEFGHIJrKdLVMHN:O,PQRSSTUVWXYZ[v\h]Z^L_>`0a"bcddefghijklzmln^oPpBq4r&st
uuvwxyz{|}~~pbTF8* ։ȊtfXJ<. ښ̛xj\N@2$ޫЬ­|n`RD6(ԽƾrdVH:,ϼЮѠҒӄvhZL>0"zl^PB4&
~pbTF8*































































































































                                                                                                                                    * 8 F T b p ~          
&4BP^lz"0>LZhv,:HVdr(6DR`n|$2@N\jx .<JXft *8FTbp~
&4BP^lz		"	0	>	L	Z	h	v										


,
:
H
V
d
r










(6DR`n|$2@N\jx

 
.
<
J
X
f
t










rdVH:,v h!Z"L#>$0%"&'(()*+,-./0z1l2^3P4B546&78
99:;<=>?@A~BpCbDTEFF8G*HIJ KKLMNOPQRStTfUXVJW<X.Y Z[\\]^_`abcdxejf\gNh@i2j$klmmnopqrstu|vnw`xRyDz6{(|}~~ԁƂrdVH:,ؒʓvhZL>0"ܣΤzl^PB4&
ҵĶ~pbTF8* ǺȬɞʐ˂tfXJ<. ؾٰڢ۔܆xj\N@2$|n`RD6( 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                    - < K Z i x          ,;JYhw
+:IXgv*9HWfu)8GVet
(7FUds	'6ETcr&5DSbq%4CRap		$	3	B	Q	`	o	~									

#
2
A
P
_
n
}








"1@O^m|!0?N]l{

 
/
>
M
\
k
z








.=L[jy yj[L=. !"#$%&z'k(\)M*>+/, -.//0123456{7l8]9N:?;0<!=>??@ABCDEF|GmH^IOJ@K1L"MNOOPQRSTUV}WnX_YPZA[2\#]^__`abcdef~goh`iQjBk3l$mnoopqrstuvwpxayRzC{4|%}~ځ˂qbSD5&ۑ̒rcTE6'	ܡ͢sdUF7(
ݱβteVG8)ñĢœƄufWH9*ӲԣՔօvgXI:+
whYJ;,xiZK<-                                                                                                                                    - < K Z i x          ,;JYhw
+:IXgv*9HWfu)8GVet
(7FUds	'6ETcr&5DSbq%4CRap		$	3	B	Q	`	o	~									

#
2
A
P
_
n
}








"1@O^m|!0?N]l{

 
/
>
M
\
k
z








.=L[jy p`P@0   !"#$%&p'`(P)@*0+ ,- ../012345p6`7P8@90: ;< ==>?@ABCDpE`FPG@H0I JK LLMNOPQRSpT`UPV@W0X YZ [[\]^_`abpc`dPe@f0g hi jjklmnopqpr`sPt@u0v wx yyz{|}~p`P@0  Њp`P@0  Йp`P@0  Шp`P@0  зp`P@0  ǰȠɐʀp`P@0  ְנؐـp`P@0  p`P@0  p`P@0  	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                     0 @ P ` p           0@P`p  0@P`p  0@P`p  0@P`p  0@P`p  0@P`p  0@P`p  0@P`p 		 	0	@	P	`	p									 

 
0
@
P
`
p








  0@P`p  0@P`p 

 
0
@
P
`
p








  0@P`p  0@P`pp`P@0   !p"`#P$@%0& '( ))*+,-./0p1`2P3@405 67 889:;<=>?p@`APB@C0D EF GGHIJKLMNpO`PPQ@R0S TU VVWXYZ[\]p^`_P`@a0b cd eefghijklpm`nPo@p0q rs ttuvwxyz{p|`}P~@0  Ѕp`P@0  Дp`P@0  Уp`P@0  вp`P@0  °àĐŀp`P@0  ѰҠӐԀp`P@0  p`P@0  p`P@0   	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                   " 3 D U f w         !2CTev 1BSdu0ARct
/@Qbs.?Par->O`q
,=N_p	+<M^o		*	;	L	]	n									

)
:
K
\
m
~







(9J[l}'8IZk|

&
7
H
Y
j
{







%6GXiz$5FWhy#4EVgx xgVE4# !"#$%y&h'W(F)5*$+,--./0123z4i5X6G768%9:;;<=>?@A{BjCYDHE7F&GHIIJKLMNO|PkQZRIS8T'UVWWXYZ[\]}^l_[`Ja9b(cdeefghijk~lmm\nKo:p)qrsstuvwxyzn{]|L};~*ՃĄo^M<+	֑Œp_N=,
ןƠq`O>-حǮraP?.ٻȼsbQ@/
ʸ˧̖ͅtcRA0ع٨ڗۆudSB1 veTC2!wfUD3"                                                                                                   " 3 D U f w         !2CTev 1BSdu0ARct
/@Qbs.?Par->O`q
,=N_p	+<M^o		*	;	L	]	n									

)
:
K
\
m
~







(9J[l}'8IZk|

&
7
H
Y
j
{







%6GXiz$5FWhy#4EVgx p^L:( !"#$%t&b'P(>),*+,,-./012x3f4T5B607899:;<=>?|@jAXBFC4D"EFFGHIJKLMnN\OJP8Q&RSTTUVWXYZr[`\N]<^*_`aabcdefgvhdiRj@k.lm
nnopqrstzuhvVwDx2y z{{|}~~lZH6$ ܊ʋp^L:(ΘtbP>,ҥxfTB0ֲĳ|jXF4"ڿÀn\J8&ͺΨϖЄr`N<*ھ۬ܚ݈vdR@.
zhVD2 ~lZH6$ 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                   $ 6 H Z l ~         2DVhz
.@Rdv*<N`r&8J\n"4FXj|0BTfx,>Pbt(:L^p 		$	6	H	Z	l	~								
 
2
D
V
h
z








.@Rdv*<N`r

&
8
J
\
n








"4FXj|0BTfx,>Pbt(:L^pmZG4!v c!P"=#*$%&&'()*+,l-Y.F/30 1
22345678u9b:O;<<)=>??@ABCD~EkFXGEH2IJKKLMNOPQtRaSNT;U(VWXXYZ[\]}^j_W`Da1bcddefghijsk`lMm:n'opqqrstuv|wixVyCz0{|
}}~r_L9& ڋǌ{hUB/	Иq^K8%٤ƥzgTA.ϱp]J7$ؽžyfS@-ʻ˨͂̕o\I6#ױ؞ًxeR?,n[H5"wdQ>+ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~ 
 "$&(*,.02468:<>@BDFHJLNPRTVXZ\^`bdfhjlnprtvxz|~                                                                                                                                                                                                    ( < P d x       ,@Th|0DXl 4H\p$8L`t (<Pdx,@Th|0DXl 4H\p	$	8	L	`	t							 

(
<
P
d
x






,@Th|0DXl
 
4
H
\
p







$8L`t (<Pdx,@Th|0DXl 4H\p$8L`t t`L8$ !"#$%p&\'H(4) *++,-./01l2X3D40567789:;<|=h>T?@@,ABCCDEFGHxIdJPK<L(MN OOPQRSTtU`VLW8X$YZZ[\]^_`pa\bHc4d effghijkllmXnDo0pqrrstuvw|xhyTz@{,|}~~ȀxdP<( ؋Čt`L8$ԗp\H4 УlXD0̯|hT@,ܺȻxdP<( ǰȜɈt`L8$ӬԘՄp\H4 ޼ߨlXD0|hT@,xdP<(                                                                                                   ( < P d x       ,@Th|0DXl 4H\p$8L`t (<Pdx,@Th|0DXl 4H\p	$	8	L	`	t							 

(
<
P
d
x






,@Th|0DXl
 
4
H
\
p







$8L`t (<Pdx,@Th|0DXl 4H\p$8L`tjT>( x!b"L#6$ %
&&'()*+p,Z-D../0112345~6h7R8<9&:;;<=>?@vA`BJC4DEFFGHIJKnLXMBN,OP QQRSTU|VfWPX:Y$Z[[\]^_`ta^bHc2deffghijkllVm@n*oppqrstuzvdwNx8y"z{{|}~r\F0؇jT>(ВxbL6 
ޜȝpZD.֧~hR<&βv`J4ܼƽnXB, ǾȨɒ|fP:$ҶӠԊt^H2ݮޘ߂lV@*zdN8"r\F0 	!$'*-0369<?BEHKNQTWZ]`cfilorux{~ #&),/258;>ADGJMPSVY\_behknqtwz}

"%(+.147:=@CFILORUX[^adgjmpsvy|                                                                                                                                                                                                                         . E \ s       +BYp(?Vm%<Sj"9Pg~6Md{3Jax0G^u-D[r	*	A	X	o							
'
>
U
l







$;Ri
!8Of}

5
L
c
z





2I`w/F]t,CZq)@Wn&=Tk#:Qh	 7Ne|4Kby1H_vt^H2 !"l#V$@%*&''()*+,z-d.N/80"12234567r8\9F:0;<==>?@ABjCTD>E(FGGHIJKLxMbNLO6P Q
RRSTUVWpXZYDZ.[\]]^_`a~bhcRd<e&fgghijklvm`nJo4pqrrstuvwnxXyBz,{| }}~|fP:$̉t^H2ړĔlV@*ҞzdN8"ʩr\F0س´jT>(оxbL6 
ɲʜˆpZD.ԪՔ~hR<&޸ߢv`J4nXB, |fP:$                                   . E \ s       +BYp(?Vm%<Sj"9Pg~6Md{3Jax0G^u-D[r	*	A	X	o							
'
>
U
l







$;Ri
!8Of}

5
L
c
z





2I`w/F]t,CZq)@Wn&=Tk#:Qh	 7Ne|4Kby1H_v v_H1 !!"#$%y&b'K(4)*++,-./|0e1N273 4	556789:h;Q<:=#>??@ABCDkETF=G&HIIJKLMNnOWP@Q)RSSTUVWXqYZZC[,\]]^_`abtc]dFe/fghhijklwm`nIo2pqrrstuvzwcxLy5z{||}~}fO8!
܇ňiR;$
ߑȒlU>'˜oXA*Φr[D-Ѱu^G0ԺxaJ3ũƒ{dM6ϬЕ~gP9"ٯژہjS<%mV?(pYB+s\E.                                                                                                   . E \ s       +BYp(?Vm%<Sj"9Pg~6Md{3Jax0G^u-D[r	*	A	X	o							
'
>
U
l







$;Ri
!8Of}

5
L
c
z





2I`w/F]t,CZq)@Wn&=Tk#:Qh	 7Ne|4Kby1H_v 	hQ: #!""#$%&'k(T)=*&+,,-./01n2W3@4)566789:;q<Z=C>,?@@ABCDEtF]GFH/IJKKLMNOwP`QIR2STUUVWXYzZc[L\5]^__`abc}dfeOf8g!h
iijklmnioRp;q$r
sstuvwxlyUz>{'|}}~oXA*Ήr[D-ѓu^G0ԝxaJ3ק{dM6ڱò~gP9"ݻƼjS<%ƲǛȄmV?(еў҇pYB+ڸۡ܊s\E. v_H1ybK4|eN7 	

                                   0 H ` x       8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 		0	H	`	x						
 
8
P
h






(@Xp 0H`x
 
8
P
h






(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph@)qZ C!,"##$%&'(t)]*F+/,-../012w3`4I5267889:;<z=c>L?5@ABBCDEF}GfHOI8J!K
LLMNOPQiRRS;T$U
VVWXYZ[l\U]>^'_``abcdeofXgAh*ijjklmnorp[qDr-sttuvwxyuz^{G|0}~ԀxaJ3׊{dM6ڔÕ~gP9"ݞƟjS<%ɩmV?(̳pYB+Ͻs\E. ǻȤɍv_H1ѾҧӐybK4ܪݓ|eN7 	hQ:#kT=&nW !"#$%&'()*+,-./0123456789:;<=>?                                   0 H ` x       8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 		0	H	`	x						
 
8
P
h






(@Xp 0H`x
 
8
P
h






(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(?`I2z c!L"5#$%%&'()}*f+O,8-!.
//01234i5R6;7$8
99:;<=>l?U@>A'BCCDEFGHoIXJAK*LMMNOPQRrS[TDU-VWWXYZ[\u]^^G_0`abbcdefxgahJi3jkllmnop{qdrMs6tuvvwxyz~{g|P}9~"݁ƂjS<%ɌmV?(̖pYB+Ϡs\E. Ҫv_H1մybK4ؾ|eN7 	ɭʖhQ:#ӰԙՂkT=&ݳޜ߅nW@)qZC,t]F/w@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_                                   0 H ` x       8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 		0	H	`	x						
 
8
P
h






(@Xp 0H`x
 
8
P
h






(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@X_iR;$
 !l"U#>$'%&&'()*+o,X-A.*/0012345r6[7D8-9::;<=>?u@^AGB0CDEEFGHIxJaKJL3MNOOPQRS{TdUMV6WXYYZ[\]~^g_P`9a"bccdefghjiSj<k%lmmnopqrmsVt?u(vwwxyz{|p}Y~B+σs\E. ҍv_H1՗ybK4ء|eN7 	۫ĬhQ:#޵ǶkT=&nW@)ʶ˟̈qZC,Թբ֋t]F/޼ߥw`I2zcL5}fO8!
`abcdefghijklmnopqrstuvwxyz{|}~                                   0 H ` x       8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 		0	H	`	x						
 
8
P
h






(@Xp 0H`x
 
8
P
h






(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp pX@( !!"#$%&h'P(8) *++,-./x0`1H2034 556789p:X;@<(=>>?@ABChDPE8F GHHIJKLxM`NHO0PQ RRSTUVpWXX@Y(Z[[\]^_`haPb8c deefghixj`kHl0mn oopqrsptXu@v(wxxyz{|}h~P8 ؃x`H0 ЍpX@(ȗhP8 ؠx`H0 ЪpX@(ȴhP8 ؽx`H0 ǸȠɈpX@(ѰҘӀhP8 ۨܐx`H0 pX@(hP8 x`H0                                                                                                                                   0 H ` x       8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 		0	H	`	x						
 
8
P
h






(@Xp 0H`x
 
8
P
h






(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@Xp 0H`x 8Ph(@XphP8  !"#x$`%H&0'( ))*+,-p.X/@0(12234567h8P98: ;<<=>?@xA`BHC0DE FFGHIJpKXL@M(NOOPQRSThUPV8W XYYZ[\]x^`_H`0ab ccdefgphXi@j(kllmnopqhrPs8t uvvwxyzx{`|H}0~ ЁpX@(ȋhP8 ؔx`H0 ОpX@(ȨhP8 رx`H0 лpX@(ŰƘǀhP8 ϨАx`H0 ظ٠ڈpX@(hP8 x`H0 pX@( 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                   2 K d }      ,E^w
&?Xq 9Rk3Le~-F_x'@Yr!:Sl4Mf	.	G	`	y						
(
A
Z
s





	";Tm5Ng
/
H
a
z





)B[t
#<Un6Oh0Ib{*C\u$=Vo7Pi1Jc|+D]v%>Wp8QjP7 o!V"=#$$%%&'()u*\+C,*-../012{3b4I5067789:;<h=O>6?@AABCDEnFUG<H#I
JJKLMNtO[PBQ)RSSTUVWzXaYHZ/[\\]^_`agbNc5deffghijmkTl;m"n	oopqrsstZuAv(wxxyz{|y}`~G.ʃfM4ЌlS:!֕rY@'ܞßx_F-ɨ~eL3ϱkR9 պqX?&
ĩŐw^E,ͯΖ}dK2 ֵל؃jQ8߻pW>%v]D+|cJ1i 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNO                                                                                   4 N h      8Rl"<Vp&@Zt*D^x.Hb|2Lf6Pj :Tn
	$	>	X	r						
(
B
\
v





,F`z0Jd~ 

4
N
h





8Rl"<Vp&@Zt*D^x.Hb|2Lf6Pj :Tn
$>Xr(B\v,F`z0JOgN5 !"m#T$;%"&	''()*+s,Z-A.(/001234y5`6G7.899:;<=>f?M@4ABCCDEFGlHSI:J!KLLMNOPrQYR@S'TUUVWXYxZ_[F\-]^^_`ab~cedLe3fghhijklkmRn9o pqqrstuqvXw?x&y
zz{|}~w^E,ȅ}dK2 ΎjQ8ԗpW>%ڠv]D+Ǫ|cJ1ͳiP7ӼoV=$Ƨǎu\C*ϭД{bI0سٚځhO6nU<#
t[B)zaH/PQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                   4 N h      8Rl"<Vp&@Zt*D^x.Hb|2Lf6Pj :Tn
	$	>	X	r						
(
B
\
v





,F`z0Jd~ 

4
N
h





8Rl"<Vp&@Zt*D^x.Hb|2Lf6Pj :Tn
$>Xr(B\v,F`z0Jd~ ~dJ 0!""#$%&z'`(F),*++,-./v0\1B2(3445678r9X:>;$<
==>?@AnBTC:D EFFGHIJjKPL6MNOOPQRSfTLU2VWWXYZ[|\b]H^._``abcdxe^fDg*hiijklmtnZo@p&qrrstuvpwVx<y"z{{|}~lR8ЅhN4 ̎~dJ0ȗz`F,ޟĠv\B(ڨrX>$
ֱnT: ҺjP6ôĚŀfL2̰͖|bH.լ֒x^D*ިߎtZ@&pV<"lR8hN4                                   : W t     "?\y
'Da~,If1Nk6Sp;Xu#@]z(Eb	-	J	g						
2
O
l





7Tq<Yv
$
A
^
{




)Fc.Kh3Pm8Ur =Zw%B_|
*Gd/Li4Qn9Vs!>[x	&C`}+He0Mj5RocF) !!"#${%^&A'$())*+,v-Y.</011234q5T677889:;<l=O>2?@@ABCDgEJF-GHHIJKLbMEN(OPPQRSzT]U@V#WXXYZ[u\X];^_``abcpdSe6fgghijkklNm1noopqrsftIu,vwwxyz~{a|D}'~
Ѐy\?"ˈtW: ƐoR5ޗjM0ٟeH+ԧ}`C&	ϯx[>!ʷsV9ſnQ4ǣȆiL/λϞЁdG*
ֶי|_B%ޱߔwZ= rU8mP3hK. 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                   < Z x     ,Jh:Xv*Hf8Vt
(Fd6Tr&Db4Rp	$	B	`	~					
2
P
n




"@^|0Nl
 
>
\
z




.Lj <Zx,Jh:Xv*Hf8Vt
(Fd6Tr&Db4Rp$B`~2Pn"@^|0Nl >\z.Lj  !"e#F$'%&&'()m*N+/,--./0u1V27344567}8^9?: ;<<=>?f@GA(B	CCDEFnGOH0IJJKLMvNWO8PQQRST~U_V@W!XYYZ[\g]H^)_
``abcodPe1fgghijwkXl9mnnopqr`sAt"uvvwxyhzI{*|}}~pQ2ՅxY:݌aB#ƔiJ+ΛqR3֢yZ;ީbC$ǱjK,
ϸrS4׿z[<ǡȂcD%ΩϊkL-ձ֒sT5ܹݚ{\=dE&lM.tU6|]> 	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                   > ] |     6Ut.Ml&Ed=\{5Ts-Lk%Dc<[z	4	S	r					
,
K
j




$Cb;Zy
3
R
q




+Ji#Ba:Yx2Qp*Ih"A`9Xw1Po
)Hg!@_~8Wv0On	(Gf ?^}7Vu/Nm'Fe   !"#`$@% & ''()*`+@, - ../01`2@3 4 55678`9@: ; <<=>?`@@A B CCDEF`G@H I JJKLM`N@O P QQRST`U@V W XXYZ[`\@] ^ __`ab`c@d e ffghi`j@k l mmnop`q@r s ttuvw`x@y z {{|}~`@  `@  `@  `@  `@  `@  `@  `@  `@  `@   À`@  ɠʀ`@  Рр`@  נ؀`@  ޠ߀`@  `@  `@  `@  `@  	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                    @ `       @`  @`  @`  @`  @`  @`  @`  @` 	 	@	`					 
 
@
`




  @`  @` 
 
@
`




  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`p P!0"##$%&p'P(0)**+,-p.P/0011234p5P607889:;p<P=0>??@ABpCPD0EFFGHIpJPK0LMMNOPpQPR0STTUVWpXPY0Z[[\]^p_P`0abbcdepfPg0hiijklpmPn0oppqrsptPu0vwwxyzp{P|0}~~pP0ІpP0ЍpP0ДpP0ЛpP0ТpP0ЩpP0аpP0зpP0оpP0ŰƐpP0̰͐pP0ӰԐpP0ڰېpP0pP0pP0pP0pP0          	 
   
                     ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o                                                                                                                   ! B c     )Jk1Rs9Z{ Ab(Ij0Qr8Yz@a	'	H	i					
/
P
q




7Xy?`
&
G
h





.Op6Wx>_%Fg-No5Vw=^$Ef,Mn4Uv<]~#De
+Lm3Tu;\}"Cd	*Kl2St : [ o  !`"@# $ %%&'(`)@* + ,,-./`0@1 2 33456`7@8 9 ::;<=`>@? @ AABCD`E@F G HHIJK`L@M N OOPQR`S@T U VVWXY`Z@[ \ ]]^_``a@b c ddefg`h@i j kklmn`o@p q rrstu`v@w x yyz{|`}@~  `@  `@  `@  `@  `@  `@  `@  `@  `@  `@  ǠȀ`@  Ππ`@  ՠր`@  ܠ݀`@  `@  `@  `@  `@  p q r s t u v w x y z { | } ~                                                                                    ! B c     )Jk1Rs9Z{ Ab(Ij0Qr8Yz@a	'	H	i					
/
P
q




7Xy?`
&
G
h





.Op6Wx>_%Fg-No5Vw=^$Ef,Mn4Uv<]~#De
+Lm3Tu;\}"Cd	*Kl2St : [ |    !"p#P$0%&&'()p*P+0,--./0p1P20344567p8P90:;;<=>p?P@0ABBCDEpFPG0HIIJKLpMPN0OPPQRSpTPU0VWWXYZp[P\0]^^_`apbPc0deefghpiPj0kllmnoppPq0rsstuvpwPx0yzz{|}p~P0ЂpP0ЉpP0АpP0ЗpP0ОpP0ХpP0ЬpP0гpP0кpP0pP0ȰɐpP0ϰАpP0ְאpP0ݰސpP0pP0pP0pP0pP0                                                                                                  ! B c     )Jk1Rs9Z{ Ab(Ij0Qr8Yz@a	'	H	i					
/
P
q




7Xy?`
&
G
h





.Op6Wx>_%Fg-No5Vw=^$Ef,Mn4Uv<]~#De
+Lm3Tu;\}"Cd	*Kl2St : [ |     !!"#|$[%:&''()*t+S,2-../01l2K3*4	55678d9C:";<<=>}?\@;ABBCDEuFTG3HIIJKLmMLN+O
PPQRSeTDU#VWWXY~Z][<\]]^_`vaUb4cddefgnhMi,jkklmnfoEp$qrrstu^v=wxxyz{w|V}5~ҀoN-ʇgF%_>۔xW6ӛpO.
ˢhG&é`?ܯyX7ԶqP/̽iH'ģła@ʼ˛zY8ѴғrQ0جًjI(ߤbA {Z9sR1kJ)cB!                                                                                                  ! B c     )Jk1Rs9Z{ Ab(Ij0Qr8Yz@a	'	H	i					
/
P
q




7Xy?`
&
G
h





.Op6Wx>_%Fg-No5Vw=^$Ef,Mn4Uv<]~#De
+Lm3Tu;\}"Cd	*Kl2St : [ |     P!/"##$%&i'H(')**+,-a.@/00123z4Y5867789:r;Q<0=>>?@AjBIC(DEEFGHbIAJ KKLMN{OZP9QRRSTUsVRW1XYYZ[\k]J^)_``abccdBe!f gghi|j[k:lmmnoptqSr2sttuvwlxKy*z	{{|}~dC"}\;؉uT3АmL+
ȗeD#~]<٤vU4ѫnM,ɲfE$^=ڿwV5ƱǐoN-ͩΈgF%ԡՀ_>ںۙxW6pO.
hG&`?yX7q !!!!!!!!!	!
!!!
!!!!!!!!!!!!!!!!!!! !!!"!#!$!%!&!'!(!)!*!+!,!-!.!/!0!1!2!3!4!5!6!7!8!9!:!;!<!=!>!?!@!A!B!C!D!E!F!G!H!I!J!K!L!M!N!O!                                                                                  " D f     2Tv Bd0Rt@b.Pr>`
,Np<^	*	L	n					
:
\
~



(Jl8Z|
&
H
j




6Xz$Fh4Vx "Df2Tv Bd0Rt@b.Pr>`
,Np<^*Ln:\~(Jl8Z|&Hj6Xz $ F h     !4!O!!o"N#-$%%&'(g)F*%+,,-./_0>122345x6W76899:;<p=O>.?
@@ABChDGE&FGGHIJ`K?LMMNOPyQXR7STTUVWqXPY/Z[[\]^i_H`'abbcdeaf@ghhijkzlYm8noopqrrsQt0uvvwxyjzI{(|}}~bA ބ{Z9֋sR1ΒkJ)ƙcB! ߟ|[:צtS2ϭlK*	ǴdC"຿}\;uT3ȯɎmL+
ϧІeD#֟~]<ܸݗvU4nM,fE$^=wV5P!Q!R!S!T!U!V!W!X!Y!Z![!\!]!^!_!`!a!b!c!d!e!f!g!h!i!j!k!l!m!n!o!p!q!r!s!t!u!v!w!x!y!z!{!|!}!~!!!!!!!!!!!!!!!!!!                                                                  " D f     2Tv Bd0Rt@b.Pr>`
,Np<^	*	L	n					
:
\
~



(Jl8Z|
&
H
j




6Xz$Fh4Vx "Df2Tv Bd0Rt@b.Pr>`
,Np<^*Ln:\~(Jl8Z|&Hj6Xz $ F h     !4!V!x!! ""#$x%V&4'(()*+h,F-$.//01z2X36455678j9H:&;<<=>|?Z@8ABBCDElFJG(HIIJK~L\M:NOOPQRnSLT*UVVWXY^Z<[\\]^_p`Na,b
ccdef`g>hiijklrmPn.oppqrsbt@uvvwxytzR{0|}}~dB ܄vT2̋fD" ޑxV4ΘhF$zX6ХjH&|Z8ҲlJ(¹~\:ԿnL*Ƣǀ^<̴͒pN,
ӤԂ`>ٶڔrP.b@tR0dB vT2fD"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!                                                                                                                  " D f     2Tv Bd0Rt@b.Pr>`
,Np<^	*	L	n					
:
\
~



(Jl8Z|
&
H
j




6Xz$Fh4Vx "Df2Tv Bd0Rt@b.Pr>`
,Np<^*Ln:\~(Jl8Z|&Hj6Xz $ F h     !4!V!x!!!!! ##$%t&Q'.())*+,\-9.//012g3D4!55678r9O:,;	<<=>}?Z@7ABBCDEeFBGHHIJKpLMM*NOOPQ{RXS5TUUVWXcY@Z[[\]^n_K`(abbcdyeVf3ghhijkal>mnnopqlrIs&tuuvwwxTy1z{{|}~_<ӂjG$ވuR/Ə]:ѕhE"ܛsP-
Ģ~[8ϨfC ڮqN+µ|Y6ͻdAoL)ȝzW4Ψυb?ԳՐmJ'ھۛxU2`=kH%vS0
^;iF# """""""""	"
"""
""""""""""""""""""" "!"""#"$"%"&"'"(")"*"+","-"."/"0"1"2"3"4"5"6"7"8"9":";"<"=">"?"@"A"B"C"D"E"F"G"H"I"J"K"L"M"N"O"P"Q"R"S"T"U"V"W"X"Y"Z"["\"]"^"_"`"a"b"c"d"e"f"g"h"i"j"k"l"m"n"o"p"q"r"s"t"u"v"w"x"y"z"{"|"}"~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""                                                                                                                                                                                                                                                                  # F i     ;^
0Sv%Hk=`2Ux'Jm?b4Wz	)	L	o					
A
d




6Y|+Nq 
C
f




8[~
-Ps"Eh:]/Ru$Gj<_1Tw&Il>a3Vy(Kn@c5X{*MpBe7Z}	,Or! D g     !9!\!!!!!"."Q"t""""" $$%&p'L(()**+,t-P.,/0012x3T4056678|9X:4;<<=>?\@8ABBCDE`F<GHHIJKdL@MNNOPQhRDS TTUVWlXHY$Z [[\]p^L_(`aabctdPe,fgghixjTk0lmmno|pXq4rsstuv\w8xyyz{|`}<~Ѐd@ԆhD ،lH$ ܒpL(tP,xT0ĥ|X4ȫ\8̱`<зd@ԽhD ôĐlH$ ɸʔpL(ϼИtP,֜xT0ܠ|X4\8`<d@hD lH$ #########	#
###
################### #!#"###$#%#&#'#(#)#*#+#,#-#.#/#0#1#2#3#4#5#6#7#8#9#:#;#<#=#>#?#@#A#B#C#D#E#F#G#H#I#J#K#L#M#N#O#P#Q#R#S#T#U#V#W#X#Y#Z#[#\#]#^#_#`#a#b#c#d#e#f#g#h#i#j#k#l#m#n#o#p#q#r#s#t#u#v#w#x#y#z#{#|#}#~##################################################################################################################################                                                                                                                                                                                                                                                                  $ H l      Dh@d<`8\4X|0Tx,Pt(Lp 	$	H	l					 
D
h




@d<`
8
\




4X|0Tx,Pt(Lp $Hl Dh@d<`8\4X|0Tx,Pt(Lp $Hl Dh@d<`8\ 4 X |    !0!T!x!!!!","P"t""""#(#L#p#####@$%%&'(h)D* ++,-.l/H0$1 2234p5L6(7889:t;P<,=>>?@xATB0CDDEF|GXH4IJJKLM\N8OPPQRS`T<UVVWXYdZ@[\\]^_h`Da bbcdelfHg$h iijkplLm(noopqtrPs,tuuvwxxTy0z{{|}|~X4Ȃ\8̈`<Ўd@ԔhD ؚlH$ ܠpL(়tP,xT0ĳ|X4ȹ\8̿`<Ŭƈd@˰̌hD ѴҐlH$ ׸ؔpL(ݼޘtP,xT0|X4\8`<d $$$$$$$$$	$
$$$
$$$$$$$$$$$$$$$$$$$ $!$"$#$$$%$&$'$($)$*$+$,$-$.$/$0$1$2$3$4$5$6$7$8$9$:$;$<$=$>$?$                                                                  % J o    (Mr+Pu	.Sx1V{4Y~7\:_=b	@	e					
C
h




!Fk$In
'
L
q



*Ot-Rw0Uz3X}6[9^<a?dBg Ej#Hm&Kp)Ns,Qv
/Ty
2W|5Z8] ; `     !>!c!!!!!"A"f"""""#D#i#####"$?$`$<%&&'()d*@+,,-./h0D1 22345l6H7$8 99:;p<L=(>??@AtBPC,DEEFGxHTI0JKKLM|NXO4PQQRST\U8VWWXYZ`[<\]]^_`da@bccdefhgDh iijkllmHn$o ppqrpsLt(uvvwxtyPz,{||}~xT0ă|X4ȉ\8̏`<Еd@ԛhD ءlH$ ܧpL(୼tP,xT0ĺ|X4\8ƨǄ`<̬͈d@ҰӌhD شِlH$ ޸ߔpL(tP,xT0|X4\8@$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z$[$\$]$^$_$                                  % J o    (Mr+Pu	.Sx1V{4Y~7\:_=b	@	e					
C
h




!Fk$In
'
L
q



*Ot-Rw0Uz3X}6[9^<a?dBg Ej#Hm&Kp)Ns,Qv
/Ty
2W|5Z8] ; `     !>!c!!!!!"A"f"""""#D#i#####"$G$_$ %%&'l(G)"**+,-i.D/00123f4A566789c:>;<<=>?`@;ABBCDE]F8GHHIJKZL5MNNOP|QWR2S
TTUVyWTX/Y
ZZ[\v]Q^,_``abscNd)effghpiKj&kllmnmoHp#qqrstjuEv wwxyzg{B|}}~d?Єa<͊^9ʐ[6ǖ}X3ĜzU0wR-㧾tO*୻qL'ݳnI$ڹkF!׿hCůƊe@ˬ̇b=ѩ҄_:צ؁\7ݣ~Y4{V1xS.	uP+rM(oJ%`$a$b$c$d$e$f$g$h$i$j$k$l$m$n$o$p$q$r$s$t$u$v$w$x$y$z${$|$}$~$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$                                                                                                                                                                  % J o    (Mr+Pu	.Sx1V{4Y~7\:_=b	@	e					
C
h




!Fk$In
'
L
q



*Ot-Rw0Uz3X}6[9^<a?dBg Ej#Hm&Kp)Ns,Qv
/Ty
2W|5Z8] ; `     !>!c!!!!!"A"f"""""#D#i#####"$G$l$$$$$%[&6'(()*}+X,3-../0z1U2034456w7R8-9::;<t=O>*?@@ABqCLD'EFFGHnIIJ$KKLMNkOFP!QQRSThUCVWWXYZe[@\]]^_`ba=bccdef_g:hiijkl\m7noopq~rYs4tuuvw{xVy1z{{|}x~S.	䁿uP+ᇼrM(ލoJ% ۓlG"ؙiD՟fAҥc>ϫ`;̱]8ɷZ5ƽ|W2
ÞyT/
ɛvQ,νϘsN)ԺՕpK&ڷےmH#jE gBd?a<^9 %%%%%%%%%	%
%%%
%%%%%%%%%%%%%%%%%%% %!%"%#%$%%%&%'%(%)%*%+%,%-%.%/%0%1%2%3%4%5%6%7%8%9%:%;%<%=%>%?%@%A%B%C%D%E%F%G%H%I%J%K%L%M%N%O%P%Q%R%S%T%U%V%W%X%Y%Z%[%\%]%^%_%`%a%b%c%d%e%f%g%h%i%j%k%l%m%n%o%p%q%r%s%t%u%v%w%x%y%z%{%|%}%~%%                                                                                                                                  & L r    
0V|:`Dj(Nt2X~<b Fl*Pv	4	Z					
>
d




"Hn,Rx
6
\




@f$Jp.Tz8^Bh &Lr
0V|:`Dj(Nt2X~<b Fl*Pv4Z>d"Hn,Rx 6 \     !@!f!!!!!$"J"p""""#.#T#z####$8$^$$$$$%B%h%%%{&V'1())*+x,S-..	//01u2P3+45567r8M9(:;;<=o>J?%@ AABClDGE"FFGHIiJDKLLMNOfPAQRRSTUcV>WXXYZ[`\;]^^_`a]b8cddefgZh5ijjkl|mWn2o
ppqrysTt/u
vvwxvyQz,{||}~sN)߂pK&܈mH#َjE ֔gBӚd?Рa<ͦ^9ʬ[6ǲ}X3ĸzU0wR-þętO*ɻʖqL'ϸГnI$յ֐kF!۲܍hCe@b=_:\7~Y4%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                  & L r    
0V|:`Dj(Nt2X~<b Fl*Pv	4	Z					
>
d




"Hn,Rx
6
\




@f$Jp.Tz8^Bh &Lr
0V|:`Dj(Nt2X~<b Fl*Pv4Z>d"Hn,Rx 6 \     !@!f!!!!!$"J"p""""#.#T#z####$8$^$$$$$%B%h%%% &&'(h)B*++,-.^/801123z4T5.67789p:J;$<<=>?f@@ABBCDE\F6GHHIJxKRL,MNNOPnQHR"SSTUVdW>XYYZ[\Z]4^__`avbPc*deefglhFi jjklmbn<oppqr~sXt2uvvwxtyNz({||}~jD҂`:Ȉ|V0
䍾rL& ړhBЙ^8ƟzT.⤼pJ$تf@ΰ\6ĶxR,໺nH"d>ǦȀZ4͜vP*ҸӒlF خوb<ޤ~X2tN(jD`:|V0
rL&%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                                                                                                  & L r    
0V|:`Dj(Nt2X~<b Fl*Pv	4	Z					
>
d




"Hn,Rx
6
\




@f$Jp.Tz8^Bh &Lr
0V|:`Dj(Nt2X~<b Fl*Pv4Z>d"Hn,Rx 6 \     !@!f!!!!!$"J"p""""#.#T#z####$8$^$$$$$%B%h%%%%% ''()d*=+,,-.z/S0,12234i5B67789:X;1<
==>?n@GA BBCDE]F6GHHIJsKLL%MMNOPbQ;RSSTUxVQW*XYYZ[g\@]^^_`}aVb/cddeflgEhiijkl[m4n
oopqqrJs#ttuvw`x9yzz{|v}O~(ڀe>Ɇ{T-ߋjCΑY2䖽oH!Ӝ^7¢tM&اc<ǭyR+ݲhA̸~W0	⽻mFêă\5ərK$ίψa:ԞwP)ٴڍf?ߣ|U.kDZ3pI"_8uN' &&&&&&&&&	&
&&&
&&&&&&&&&&&&&&&&&&& &!&"&#&$&%&&&'&(&)&*&+&,&-&.&/&0&1&2&3&4&5&6&7&8&9&:&;&<&=&>&?&@&A&B&C&D&E&F&G&H&I&J&K&L&M&N&O&P&Q&R&S&T&U&V&W&X&Y&Z&[&\&]&^&_&`&a&b&c&d&e&f&g&h&i&j&k&l&m&n&o&p&q&r&s&t&u&v&w&x&y&z&{&|&}&~&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&                                                                                                                                                                                                                                                                  ' N u    8_"Ip3ZDk.U|?f)Pw:a$	K	r				
5
\




Fm	0W~
A
h



+Ry<c&Mt7^!Ho2YCj-T{>e(Ov9`#Jq
4[El/V}@g*Qx;b% L s    !6!]!!!!! "G"n""""
#1#X#####$B$i$$$$%,%S%z%%%%&=&d&&&&&'(r)K*$++,-.a/:01123w4P5)67789f:?;<<=>|?U@.ABBCDkEDFGGHIJZK3LMMNOpPIQ"RRSTU_V8WXXYZu[N\'] ^^_`da=bccdezfSg,hiijkilBmnnopqXr1s
ttuvnwGx yyz{|]}6~sL%ׅb;ƋxQ*ܐg@˖}V/᛺lEС[4
榿qJ#լ`9ĲvO(ڷe>ɽ{T-¸ÑjCȧɀY2ͽΖoH!Ӭԅ^7ٛtM&ޱߊc<yR+hA~W0	mF\5 '''''''''	'
'''
''''''''''''''''''' '!'"'#'$'%'&'''(')'*'+','-'.'/'0'1'2'3'4'5'6'7'8'9':';'<'='>'?'@'A'B'C'D'E'F'G'H'I'J'K'L'M'N'O'P'Q'R'S'T'U'V'W'X'Y'Z'['\']'^'_'`'a'b'c'd'e'f'g'h'i'j'k'l'm'n'o'p'q'r's't'u'v'w'x'y'z'{'|'}'~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''                                                                                                                                                                                                  ( P x    @h0X Hp8` (Px@h0X Hp	8	`				 
(
P
x



@h0X 
H
p



8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h 0 X      !H!p!!!!"8"`"""" #(#P#x####$@$h$$$$%0%X%%%%% &H&p&&&&'8'`'''''(){*T+-,--./j0C122345Y627889:o;H<!==>?@^A7BCCDEtFMG&HHIJKcL<MNNOPyQRR+STTUVhWAXYYZ[~\W]0^	__`ambFcddefg\h5ijjklrmKn$oopqras:tuuvwwxPy)z{{|}f~?ʁ|U.kDόZ3呾pI"ԗ_8ÝuN' ٢d=ȨzS,ޭiBͳX1
㸼nG Ҿ]6ĚsL%ɰʉb;ϟxQ*ԵՎg@ڤ}V/ߺlE[4
qJ#`9vO(e>''''''''''''''''''''''''''''''''''''''''''''''''                                                  ( P x    @h0X Hp8` (Px@h0X Hp	8	`				 
(
P
x



@h0X 
H
p



8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h 0 X      !H!p!!!!"8"`"""" #(#P#x####$@$h$$$$%0%X%%%%% &H&p&&&&'8'`''''' (()*`+8,--./p0H1 22345X607889:h;@<==>?x@PA(B CCDE`F8GHHIJpKHL MMNOPXQ0RSSTUhV@WXXYZx[P\(] ^^_``a8bccdepfHg hhijkXl0mnnophq@rsstuxvPw(x yyz{`|8}~~pH ЄX0h@ȏxP( ؔ`8pH ПX0सh@ȪxP( د`8pH кX0࿸h@ŠxP( ʰˈ`8ИpH ըրX0ڸېh@xP( `8pH X0h@xP(''''''''''''''''                  ( P x    @h0X Hp8` (Px@h0X Hp	8	`				 
(
P
x



@h0X 
H
p



8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h0X Hp8` (Px@h 0 X      !H!p!!!!"8"`"""" #(#P#x####$@$h$$$$%0%X%%%%% &H&p&&&&'8'`''''' ))*+\,3-
../0f1=23345p6G7889:z;Q<(==>?@[A2B	CCDEeF<GHHIJoKFLMMNOyPPQ'RRSTUZV1WXXYZd[;\]]^_n`EabbcdxeOf&gghijYk0lmmnocp:qrrstmuDvwwxywzN{%||}~X/݂b9燾lCȍvM$ҒW.ܗa8朽kBǢuL#ѧV-۬`7屼jAƷtK"м~U,_6
ƻǒi@̜sJ!Ѧ}T+ְׇ^5ۺܑh?rI |S*]4g>qH{R) (((((((((	(
(((
((((((((((((((((((( (!("(#($(%(&('((()(*(+(,(-(.(/(0(1(2(3(4(5(6(7(8(9(:(;(<(=(>(?(@(A(B(C(D(E(F(G(H(I(J(K(L(M(N(O(P(Q(R(S(T(U(V(W(X(Y(Z([(\(](^(_(`(a(b(c(d(e(f(g(h(i(j(k(l(m(n(o(p(q(r(s(t(u(v(w(x(y(z({(|(}(~((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((                                                                                                                                                                                                                                                                  ) R {    Hq>g4]*S| Ir?h5^+T}!	J	s				
@
i




6_,U~"
K
t



Aj7`-V#LuBk8a.W$MvCl9b/X%NwDm:c0Y&OxEn;d 1 Z     '!P!y!!!!"F"o""""#<#e####	$2$[$$$$$(%Q%z%%%%&G&p&&&&'='f''''
(3(\((((()W*.+,,-.a/801123k4B56678u9L:#;;<=>V?-@AABC`D7EFFGHjIAJKKLMtNKO"PPQR~SUT,UVVWX_Y6Z
[[\]i^@_``abscJd!eefg}hTi+jkklm^n5oppqrhs?tuuvwrxIy zz{||}S~*؀]4ⅹg>ËqH͐{R) ו\3
ᚸf= pG̥zQ(֪[2	௷e<oF˺yP'տZ1Ķōd;ʗnEϡxO&ԫՂY0ٵڌc:޿ߖmDwN%X/b9lCvM$ )))))))))	)
)))
))))))))))))))))))) )!)")#)$)%)&)')()))*)+),)-).)/)0)1)2)3)4)5)6)7)8)9):);)<)=)>)?)@)A)B)C)D)E)F)G)H)I)J)K)L)M)N)O)P)Q)R)S)T)U)V)W)X)Y)Z)[)\)])^)_)`)a)b)c)d)e)f)g)h)i)j)k)l)m)n)o)p)q)r)s)t)u)v)w)x)y)z){)|)})~))                                                                                                                                  * T ~    &Pz"LvHrDn@j<f8b
4^	0	Z				
,
V




(R|$Nx 
J
t



FpBl>h:d6`2\.X *T~&Pz"LvHrDn@j<f8b
4^0Z,V( R |    $!N!x!!!! "J"t""""#F#p####$B$l$$$$%>%h%%%%&:&d&&&&'6'`''''(2(\(((().)X)) **+,X-..//01\2234456`76899:;d<:=>>?@hA>BCCDElFBGHHIJpKFLMMNOtPJQ RRSTxUNV$WWXY|ZR[(\\]^_V`,abbcdZe0fgghi^j4k
llmnbo8pqqrsft<uvvwxjy@z{{|}n~DƁrHʆvL"΋zP&Ґ~T* ֕X.ښ\2ޟ`6⤸d:橼h>lBĴpFȹtJ ̾xN$æ|R(ȪɀV,ͮ΄Z0Ҳӈ^4
׶،b8ܺݐf<j@nDrHvL"zP&~T*))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))                                                                                                                                  * T ~    &Pz"LvHrDn@j<f8b
4^	0	Z				
,
V




(R|$Nx 
J
t



FpBl>h:d6`2\.X *T~&Pz"LvHrDn@j<f8b
4^0Z,V( R |    $!N!x!!!! "J"t""""#F#p####$B$l$$$$%>%h%%%%&:&d&&&&'6'`''''(2(\(((().)X))))) ++,-T.)//01}2R3'4456{7P8%99:;y<N=#>>?@wALB!CCDEuFJGHHIJsKHLMMNOqPFQRRSToUDVWWXYmZB[\\]^k_@`aabcid>effghgi<jkklmen:oppqrcs8t
uuvwax6yzz{|_}4~	]2܄[0ډY.؎W,֓U*Ԙ~S(ҝ|Q&ТzO$ΧxM"̬vK ʱtIȶrGƻpEnCŗlAʕj?ξϓh=Ӽԑf;غُd9ݸލb7`5
^3\1Z/X-V+ *********	*
***
******************* *!*"*#*$*%*&*'*(*)***+*,*-*.*/*0*1*2*3*4*5*6*7*8*9*:*;*<*=*>*?*@*A*B*C*D*E*F*G*H*I*J*K*L*M*N*O*P*Q*R*S*T*U*V*W*X*Y*Z*[*\*]*^*_*`*a*b*c*d*e*f*g*h*i*j*k*l*m*n*o*p*q*r*s*t*u*v*w*x*y*z*{*|*}*~**********************************************************************************************************************************                                                                                                                                                                                                                                                                  + V    -X/Z1\3^
5`7b9d;f	=	h				
?
j



AlCn
E
p



GrIt Kv"Mx$Oz&Q|(S~*U,W.Y0[2]	4_6a
8c:e<g>i @ k    !B!m!!!!"D"o""""#F#q####$H$s$$$$%J%u%%%%!&L&w&&&&#'N'y''''%(P({((((')R)})))))*T***** ,,-|.P/$0012t3H45567l8@9::;<d=8>??@A\B0CDDEFTG(HHIJxKLL MMNOpPDQRRSThU<VWWXY`Z4[\\]^X_,` aab|cPd$eefgthHijjkllm@noopqdr8sttuv\w0xyyz{T|(}}~xL ȃpDh<䌸`4ܑX, Ԗ|P$̛tHĠl@褼d8ੴ\0خT(гxL ȸpDh<`4ưǄX, ˨|P$РtH՘l@ټڐd8޴߈\0T(xL pDh<`4X, +++++++++	+
+++
+++++++++++++++++++ +!+"+#+$+%+&+'+(+)+*+++,+-+.+/+0+1+2+3+4+5+6+7+8+9+:+;+<+=+>+?+@+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z+[+\+]+^+_+`+a+b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+r+s+t+u+v+w+x+y+z+{+|+}+~++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++                                                                                                                                                                                                                                                                  / ^    Ix4cN}
9h$S>m)XCr.	]				
H
w


3bM|	
8
g



#R=l(WBq-\Gv2aL{7f"Q
<k'VAp,[Fu1`Kz6e! P    !;!j!!!!&"U""""#@#o####+$Z$$$$%E%t%%%&0&_&&&&'J'y'''(5(d(((( )O)~)))*:*i****%+T++++,?,n,,,,*-Y----.D.s.. //0s1D23345Y6*7789n:?;<<=>T?%@@ABiC:DEEF~GOH IIJKdL5MNNOyPJQRRST_U0VWWXtYEZ[[\]Z^+__`aob@cddefUg&hhijjk;lmmnoPp!qqrset6uvvwzxKyzz{|`}1~uF胹[,ΈpA㌴V'ɑk<
ޕQ"Ěf7ٞ{La2ԧvG髺\-ϰqB䴵W(ʹl=߽R#g8	ƫ|Mˑb3ϦwHӻԌ].ءrCܶ݇X)m>S$h9
}Nc4xI^/................................................................................................................................                                                                                                                                  / ^    Ix4cN}
9h$S>m)XCr.	]				
H
w


3bM|	
8
g



#R=l(WBq-\Gv2aL{7f"Q
<k'VAp,[Fu1`Kz6e! P    !;!j!!!!&"U""""#@#o####+$Z$$$$%E%t%%%&0&_&&&&'J'y'''(5(d(((( )O)~)))*:*i****%+T++++,?,n,,,,*-Y----.D.s..../01S2$3345h697
889}:N;<<=>c?4@AABxCIDEEFG^H/I JJKsLDMNNOPYQ*RRSTnU?VWWXYTZ%[[\]i^:_``a~bOc ddefdg5hiijykJlmmno_p0qrrsttEuvvwxZy+zz{|o}@~U&Ȅj;݈P!Íe6ؑzK핾`1ӚuF螹[,ΣpA㧴V'ɬk<
ްQ"ĵf7ٹ{La2¥vGƺǋ\-ˠqBϵІW(ԛl=ذفR#ݖg8	|Mb3wH].rCX)m> /////////	/
///
/////////////////// /!/"/#/$/%/&/'/(/)/*/+/,/-/.///0/1/2/3/4/5/6/7/8/9/:/;/</=/>/?/@/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/[/\/]/^/_/`/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/{/|/}/~//////////////////////////////////////////////////////////////////////////////////////////////////                                                                                                                                                                                                                                  0 `     P@p 0` P@p 0` P@p 	0	`				 
P



@p 0` 
P



@p 0` P@p 0` P@p 0` P@p 0` P@p 0` P@p 0` P @ p    !0!`!!!! "P""""#@#p### $0$`$$$$ %P%%%%&@&p&&& '0'`'''' (P(((()@)p))) *0*`**** +P++++,@,p,,, -0-`---- .P..../@/p//// 001p2@34456P7 889:`;0< ==>p?@@AABCPD EEFG`H0I JJKpL@MNNOPPQ RRST`U0V WWXpY@Z[[\]P^ __`a`b0c ddepf@ghhijPk llmn`o0p qqrps@tuuvwPx yyz{`|0} ~~p@P `0 Ћp@P `0 Иp@P `0 Хp@ੰP `0 вp@ධP `0 пp@ðĀP Ȑ`0 ̠p@арP Ր`0 ٠p@ݰހP `0 p@P `0 p@P `0////////////////                  0 `     P@p 0` P@p 0` P@p 	0	`				 
P



@p 0` 
P



@p 0` P@p 0` P@p 0` P@p 0` P@p 0` P@p 0` P @ p    !0!`!!!! "P""""#@#p### $0$`$$$$ %P%%%%&@&p&&& '0'`'''' (P(((()@)p))) *0*`**** +P++++,@,p,,, -0-`---- .P..../@/p////@01123P4 5567`809 ::;p<@=>>?@PA BBCD`E0F GGHpI@JKKLMPN OOPQ`R0S TTUpV@WXXYZP[ \\]^`_0` aabpc@deefgPh iijk`l0m nnopp@qrrstPu vvwx`y0z {{|p}@~P `0 Јp@P `0 Еp@P `0 Тp@রP `0 Яp@೰P `0 мp@P Ő`0 ɠp@Ͱ΀P Ґ`0 ֠p@ڰۀP ߐ`0 p@P `0 p@P `0 p 000000000	0
000
0000000000000000000 0!0"0#0$0%0&0'0(0)0*0+0,0-0.0/000102030405060708090:0;0<0=0>0?0                                                                  1 b    &WL}Ar6g+\ QFw
;l0	a				%
V



K|@q
5
f



*[PEv	:k/`$UJ{?p4e)ZODu9j._#TIz
>o3d( Y    !N!!!!"C"t"""#8#i####-$^$$$$"%S%%%%&H&y&&&'='n'''(2(c((((')X))))*M*~***+B+s+++,7,h,,,,,-]----!.R..../G/x///0<0?00p1@23345P6 7789`:0; <<=p>@?@@ABPC DDEF`G0H IIJpK@LMMNOPP QQRS`T0U VVWpX@YZZ[\P] ^^_``a0b ccdpe@fgghiPj kklm`n0o ppqpr@sttuvPw xxyz`{0| }}~p@P `0 Њp@P `0 Зp@P `0 Фp@ਰP `0 бp@൰P `0 оp@°ÀP ǐ`0 ˠp@ϰЀP Ԑ`0 ؠp@ܰ݀P `0 p@P `0 p@P `0 @0A0B0C0D0E0F0G0H0I0J0K0L0M0N0O0P0Q0R0S0T0U0V0W0X0Y0Z0[0\0]0^0_0`0a0b0c0d0e0f0g0h0i0j0k0l0m0n0o0p0q0r0s0t0u0v0w0x0y0z0{0|0}0~0000000000000000000000000000000000                                                                                                  1 b    &WL}Ar6g+\ QFw
;l0	a				%
V



K|@q
5
f



*[PEv	:k/`$UJ{?p4e)ZODu9j._#TIz
>o3d( Y    !N!!!!"C"t"""#8#i####-$^$$$$"%S%%%%&H&y&&&'='n'''(2(c((((')X))))*M*~***+B+s+++,7,h,,,,,-]----!.R..../G/x///0<0m000 112m3<4556x7G899:;R<!==>?]@,AABChD7EFFGsHBIJJK~LMMNNOPXQ'RRSTcU2VWWXnY=Z[[\y]H^__`aSb"ccde^f-gghiij8kllmtnCoppqrNsttuvYw(xxyzd{3|}}~o>
܁zI煶T#_.̎j9גuD▱O횼Z)ǟe4ңp?ݧ{J諷U$°`/ʹk:	ظvE㼲P[*ŗf5ɢq@ͭ|KѸ҇V%֒a0ڝl;
ިwFQ \+g6rA}LW&b1000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000                                                                                                  1 b    &WL}Ar6g+\ QFw
;l0	a				%
V



K|@q
5
f



*[PEv	:k/`$UJ{?p4e)ZODu9j._#TIz
>o3d( Y    !N!!!!"C"t"""#8#i####-$^$$$$"%S%%%%&H&y&&&'='n'''(2(c((((')X))))*M*~***+B+s+++,7,h,,,,,-]----!.R..../G/x///0<0m000001123l4;5
667w8F9::;<Q= >>?@\A+BBCDgE6FGGHrIAJKKL}MLNOOPQWR&SSTUbV1W XXYmZ<[\\]x^G_``abRc!ddef]g,hhijhk7lmmnsoBpqqr~sMtuuvwXx'yyz{c|2}~~n=ۂyH憵S"^-ˏi8֓tCᗰN웻Y(Ơd3Ѥo>
ܨzI笶T#_.̵j9׹uD⽱OZ)Ɩe4ʡp?ά{JҷӆU$ב`/ۜk:	ߧvEP[*f5q@|KV%a 111111111	1
111
1111111111111111111 1!1"1#1$1%1&1'1(1)1*1+1,1-1.1/1                                                  2 d    ,^&X RL~Fx@r:l4f.	`				(
Z



"TN
H
z


Bt
<n6h0b*\$VPJ|Dv>p8j 2d,^&X RL~Fx@r : l   !4!f!!!!."`""""(#Z####"$T$$$$%N%%%%&H&z&&&'B't'''
(<(n((()6)h))))0*b*****+\++++$,V,,,,-P----.J.|.../D/v///0>0p0001/11_2.3345j697889u:D;<<=>O?@@ABZC)DDEFeG4HIIJpK?LMMN{OJPQQRSUT$UUVW`X/YYZ[k\:]	^^_v`EabbcdPeffgh[i*jjklfm5noopqq@rsst|uKvwwxyVz%{{|}a~0΀l;
لwF䈳Q \+ɑg6ԕrAߙ}LꝹW&Ģb1 Ϧm<ڪxG宴R!𲿳],ʷh7ջsB࿯~MúĉX'Ȕc2̟n=ЪyHԵՄS"ُ^-ݚi8tCNY(d3o>
zIT#01112131415161718191:1;1<1=1>1?1@1A1B1C1D1E1F1G1H1I1J1K1L1M1N1O1P1Q1R1S1T1U1V1W1X1Y1Z1[1\1]1^1_1`1a1b1c1d1e1f1g1h1i1j1k1l1m1n1o1p1q1r1s1t1u1v1w1x1y1z1{1|1}1~111111111111111111                                                                                                  2 d    ,^&X RL~Fx@r:l4f.	`				(
Z



"TN
H
z


Bt
<n6h0b*\$VPJ|Dv>p8j 2d,^&X RL~Fx@r : l   !4!f!!!!."`""""(#Z####"$T$$$$%N%%%%&H&z&&&'B't'''
(<(n((()6)h))))0*b*****+\++++$,V,,,,-P----.J.|.../D/v///0>0p000181j111o2>3
445z6I7889:T;#<<=>_?.@@ABjC9DEEFuGDHIIJKOLMMNOZP)QQRSeT4UVVWpX?YZZ[{\J]^^_`Ua$bbcd`e/ffghki:j	kklvmEnoopqPrsstu[v*wwxyfz5{||}q~@ހ|K鄸V%Éa0΍l;
ّwF䕳Q \+ɞg6ԢrAߦ}LꪹW&įb1 ϳm<ڷxG廴R!],ęh7ȤsB̯~MкщX'Քc2ٟn=ݪyHS"^-i8tCNY(d31111111111111111                  2 d    ,^&X RL~Fx@r:l4f.	`				(
Z



"TN
H
z


Bt
<n6h0b*\$VPJ|Dv>p8j 2d,^&X RL~Fx@r : l   !4!f!!!!."`""""(#Z####"$T$$$$%N%%%%&H&z&&&'B't'''
(<(n((()6)h))))0*b*****+\++++$,V,,,,-P----.J.|.../D/v///0>0p000181j11112^3-4456i78899:t;C<==>?N@AABCYD(EEFGdH3IJJKoL>M
NNOzPIQRRSTTU#VVWX_Y.ZZ[\j]9^__`uaDbccdeOfgghiZj)kklmen4oppqpr?sttu{vJwxxyzU{$||}~`/́k:	؅vE㉲P[*Ȓf5Ӗq@ޚ|K鞸V%ãa0Χl;
٫wF䯳Q ﳾ\+ɸg6ԼrA}LĹňW&ɓb1 ͞m<ѩxGմփR!ٿڎ],ޙh7sB~MX'c2n=yHS"11111111111111111111111111111111                                  2 d    ,^&X RL~Fx@r:l4f.	`				(
Z



"TN
H
z


Bt
<n6h0b*\$VPJ|Dv>p8j 2d,^&X RL~Fx@r : l   !4!f!!!!."`""""(#Z####"$T$$$$%N%%%%&H&z&&&'B't'''
(<(n((()6)h))))0*b*****+\++++$,V,,,,-P----.J.|.../D/v///0>0p000181j1111 223j485667p8>9::;v<D=>>?|@JABBCDPEFFGHVI$JJKL\M*NNOPbQ0RRSThU6VWWXnY<Z
[[\t]B^__`zaHbccdeNfgghiTj"kklmZn(oopq`r.sstufv4wxxylz:{||}r~@܀xFℰ~L舶R X&^,ȕd2 Ιj8ԝp>ڡvD८|J橴P쭺V$\*ƶb0̺h6Ҿn<
¦tBƬzHʲˀNθφT"ҾӌZ(ג`.ۘf4ߞl:r@xF~LR X&^,d21111111111111111                  2 d    ,^&X RL~Fx@r:l4f.	`				(
Z



"TN
H
z


Bt
<n6h0b*\$VPJ|Dv>p8j 2d,^&X RL~Fx@r : l   !4!f!!!!."`""""(#Z####"$T$$$$%N%%%%&H&z&&&'B't'''
(<(n((()6)h))))0*b*****+\++++$,V,,,,-P----.J.|.../D/v///0>0p000181j1111 334g546778h95:;;<i=6>??@jA7BCCDkE8FGGHlI9JKKLmM:NOOPnQ;RSSToU<V	WWXpY=Z
[[\q]>^__`ra?bccdse@f
gghtiAjkklumBnoopvqCrsstwuDvwwxxyEz{{|y}F~zGხ{H⇯|I㋰}J䏱~K哲L旳M直N蟵O飶P꧷Q뫸R쯹S T!U"ﻼV#W$þċX%ǿȌY&̍Z'Ў[(ԏ\)ؐ]*ܑ^+_,`-a.b/c0d1e2f3 222222222	2
222
2222222222222222222 2!2"2#2$2%2&2'2(2)2*2+2,2-2.2/202122232425262728292:2;2<2=2>2?2@2A2B2C2D2E2F2G2H2I2J2K2L2M2N2O2P2Q2R2S2T2U2V2W2X2Y2Z2[2\2]2^2_2`2a2b2c2d2e2f2g2h2i2j2k2l2m2n2o2p2q2r2s2t2u2v2w2x2y2z2{2|2}2~2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222                                                                                                                                                                                                                                                                  3 f    2e1d0c/b.a-`,_+^*	]				)
\



(['Z&
Y



%X$W#V"U!T SRQPONMLK~J}I|H{Gz F y   !E!x!!!"D"w"""#C#v###$B$u$$$%A%t%%%
&@&s&&&'?'r'''(>(q(((
)=)p)))	*<*o***+;+n+++,:,m,,,-9-l---.8.k.../7/j///060i000151h111242g2222 445d607789`:,;;<=\>(??@AXB$CCDETF GGHIPJKKLMLNOOP|QHRSSTxUDVWWXtY@Z[[\p]<^__`la8bccdhe4f gghdi0jjkl`m,nnop\q(rrstXu$vvwxTy zz{|P}~~L䂰|HxD܊t@؎p<Ԓl8Жh4 ̚d0Ȟ`,Ģ\(X$𩼪T 쭸P豴L䵰|H๬xDܽt@p<Šl8ɜh4 ͘d0є`,Ր\(ٌX$ܼ݈T PL|HxDt@p<l8h4 333333333	3
333
3333333333333333333 3!3"3#3$3%3&3'3(3)3*3+3,3-3.3/303132333435363738393:3;3<3=3>3?3@3A3B3C3D3E3F3G3H3I3J3K3L3M3N3O3P3Q3R3S3T3U3V3W3X3Y3Z3[3\3]3^3_3`3a3b3c3d3e3f3g3h3i3j3k3l3m3n3o3p3q3r3s3t3u3v3w3x3y3z3{3|3}3~3333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333                                                                                                                                                                                                                                                                  4 h   8l<p@tDxH|LP T$	X				(
\



,`0d 
4
h


8l<p@tDxH|LP T$X(\,`0d 4h8l<p@tDxH| L    !P!!!! "T""""$#X####($\$$$$,%`%%%%0&d&&& '4'h'''(8(l((()<)p)))*@*t***+D+x+++,H,|,,,-L----.P.... /T////$0X0000(1\1111,2`222203d3333MsN&OOP?QQRXSTTqU$VVW=XXYVZ	[[o\"]]^;__`Tabbmc dde9ffgRhiikjkkl7mmnPoppiqrrs5ttuNvwwgxyyz3{{|L}}~eˀ~1䂗Jcɇ|/≕Haǎz-F_ŕx+ޗD]Üv)ܞB[t'ڥ@󧦨Yr%ج>񮤯W
p#ֳ<ﵢUn!Ժ:Sl8ÞQƷjȃ6ʜO͵hρ4њM Գf2ؘKڱd}0ߖIb{.G`y,E^w*C\u(AZ 4444N4h4444445585R5l5555556"6<6V6p6666667&7@7Z7t7777778*8D8^8x8888889.9H9b9|999999:2:L:f::::::;;6;P;j;;;;;;< <:<T<n<<<<<<
=$=>=X=r======>(>B>\>v>>>>>>?,?F?`?z??????@0@J@d@~@@@@@ AA4ANAhAAAAAABB8BRBlBBBBBBC"C<CVCpCCCCCCD&D@DZDtDDDDDDE*EDE^ExEEEEEEF.FHFbF|FFFFFFG2GLGfGGGGGGHH6HPHjHHHHHHI I:ITInIIIIII
J$J>JXJrJJJJJJK(KBK\KvKKKKKKL,LFL`LzLLLLLLM0MJMdM~MMMM                                                                                                                                                                                                                                                                 N   8"pZD.|fP:$	r		
\


F0~
h

R<&t^H2jT>(v`J4lV@*xbL   6!!! "n""
#X###B$$$,%z%%&d&& 'N'''8(((")p))*Z***D+++.,|,,-f--.P...:///$0r001\111F22203~334h445R555<666&7t778^888H9992:::;j;;<T<<<>===(>v>>?`???J@@@4AAABlBBCVCCC@DDD*ExEEFbFFFLGGG6HHH InII
JXJJJBKKK,LzLLMdMMM NNdOPPzQ,RRSBTTUXV
WWnX YYZ6[[\L]]^b_``xa*bbc@ddeVfgglhiij4kklJmmn`oppvq(rrs>ttuTvwwjxyyz2{{|H}}~^t&؂<Rh̉~0⋔F\r$֒:씞Pfʙ|.DZp"Ԣ8ꤜN dȩz,ޫBX
n Ҳ6贚Lbƹx*ܻ@򽤾Vl4ĘJƮ`v(ˌ>͢TиjҀ2ԖH֬^t&ۊ<ݠRh~0F\r$:Pf|.DZp"8NMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM                                                                  N   8"pZD.|fP:$	r		
\


F0~
h

R<&t^H2jT>(v`J4lV@*xbL   6!!! "n""
#X###B$$$,%z%%&d&& 'N'''8(((")p))*Z***D+++.,|,,-f--.P...:///$0r001\111F22203~334h445R555<666&7t778^888H9992:::;j;;<T<<<>===(>v>>?`???J@@@4AAABlBBCVCCC@DDD*ExEEFbFFFLGGG6HHH InII
JXJJJBKKK,LzLLMdMMM ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @à ` ŀ@Ơ ` Ȁ@ɠ ` ˀ@̠ ` ΀@Ϡ ` р@Ҡ ` Ԁ@ՠ ` ׀@ؠ ` ڀ@۠ ` ݀@ޠ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ ` @ NRNNNHOOO>PPP4QQQ*R|RR SrSSThTTU^UUVTVVVJWWW@XXX6YYY,Z~ZZ"[t[[\j\\]`]]^V^^^L___B```8aaa.bbb$cvccdlddebeefXfffNgggDhhh:iii0jjj&kxkklnllmdmmnZnnnPoooFppp<qqq2rrr(szsstpttufuu
v\vv wRwwwHxxx>yyy4zzz*{|{{ |r||}h}}~^~~TJ@6ڂ,~Ѓ"tƄj`VLB8܊.ҋ$vȌlbXND:ޒ0ԓ&xʔndZPF<2֛(z̜pf
\                                                                                                                                                                                                                                                                    @ ` @ `	 

@ 

` @ ` @ ` @ ` @  !!`" ##@$$% &&`' ((@))* ++`, --@../ 00`1 22@334 55`6 77@889 ::`; <<@==> ??`@ AA@BBC DD`E FF@GGH II`J KK@LLM NN`O PP@QQR SS`T UU@VVW XX`Y ZZ@[[\ ]]`^ __@``a bb`c dd@eef gg`h ii@jjk ll`m nn@oop qq`r ss@ttu vv`w xx@yyz {{`| }}@~~ ` @ ` @ ` @ ` @ ` @ ` @ `H \p̧(<PdxԬ0DXlȰ$ܱ8L`tе,@ThĹ |غ4H \p̾(<Pdx0ČDŠXƴl$Ȁ8ɔLʨ`˼t,͈@ΜTϰh |4ҐHӤ \Ըp(ք<טPجdx0یDܠXݴl$߀8L`t,@Th |4H \p(<Pdx0DXl$8L`t,@Th | 
#(-27<AFKPUZ_dinsx}àȠ͠Ҡנܠ	"',16;@EJOTY^chmrw|¡ǡ̡ѡ֡ۡ
!&+05:?DINSX]bglqv{ƢˢТբڢߢ %*/49>CHMRW\afkpuzţʣϣԣ٣ޣ$).38=BGLQV[`ejoty~                                                                                                                                                                                                                                              J9(ra		P

?
.xgVE4~#m\K:  !)""s#$$b%&&Q''(@))*/++y,--h.
//W001F2235445$66n788]9::L;;<;==>*??t@AAcBCCRDDEAFFG0HHzIJJiKLLXMMNGOOP6QQR%SSoTUU^VWWMXXY<ZZ[+\\u]^^d_	``SaabBccd1ee{f ggjhiiYjjkHllm7nno&pppqrr_sttNuuv=wwx,yyvz{{e|
}}T~~C耍2ׂ|!ƄkZI8݋'̍q`O>㔈-ҖwfUD靎3؟}"ǡl[Ф,@ThĨ |ة4H \p̭(<PdxԲ0DXlȶ$ܷ8L`tл,@ThĿ |4H¤ \øp(ń<ƘPǬdx0ʌDˠX̴l$΀8ϔLШ`Ѽt,ӈ@ԜTհh |4ؐH٤ \ڸp(܄<ݘPެdx0DXl$8L`t,@Th |4H \p(<Pdx0DXl$8L`¤äĤŤƤǤȤɤʤˤ̤ͤΤϤ                                                                   X\`dh	

lp
t x$|(,048<@  !D""#H$$%L&&'P(()T* ++X,--\.//`011d233h455l677p899t: ;;x<$==|>(??@,AAB0CCD4EEF8GGH<IIJ@KKLDMMNHOOPLQQRPSSTTU VVXWXX\YZZ`[\\d]^^h_``labbpcddte ffxg$hh|i(jjk,llm0nno4ppq8rrs<ttu@vvwDxxyHzz{L||}P~~T X\`dhlčpȏt ̑x$Г|(ԕ,ؗ0ܙ48䝐<蟔@졘D𣜤HLPT+T}ئ!Jsٜ@iڒڻ
6_ۈ۱,U~ܧ"KtݝAjޓ޼7`߉߲-V#LuBk8a.W$MvCl9b/X%NwDm:c0Y&OxEn;d1Z'PyFo<e	2[(QzGp=f
3\ )R{Hq>g4]*S| Ir?h ,Xܬ4`<hDpȯ Lxа(Tر0\8d@lĴHt̵$P|Զ ,Xܷ4`<hDpȺ Lxл(Tؼ0\8d@lĿHt$P| ,X°4`Ìø<hĔDpŜ LxƤ(TǀǬ0\Ȉȴ8dɐɼ@lʘHtˠ$P|̨ ,Ẍ́Ͱ4`Όθ<hϔDpМ LxѤ(TҀҬ0\ӈӴ8dԐԼ@l՘Ht֠$P|רׯ                                                                                                                                                                                                                                                                   `8pH	 


X0h@xP( `8  !"p#H$ %%&'(X)0*++,-h.@/0012x3P4(5 6678`98:;;<=p>H? @@ABCXD0EFFGHhI@JKKLMxNPO(P QQRS`T8UVVWXpYHZ [[\]^X_0`aabchd@effghxiPj(k llmn`o8pqqrsptHu vvwxyXz0{||}~h@ȂxP( ؇`8pH ВX0h@ȝxP( آ`8pH ЭX0ಸh@ȸxP( ؽ`8ØpH ȨɀX0͸ΐh@ӠxP(׀ۥ9^܃ܨ<a݆ݫ?dމޮBgߌ߱ Ej#Hm&Kp)Ns,Qv
/Ty
2W|5Z8];`>cAfDi"Gl %Jo(Mr+Pu	.Sx1V{4Y~7\:_=b@eCh!Fk$In'Lq*Ot-Rw0Uz3X}  $(,048<@DHLPTX\`dhlptx|؀؄؈،ؘؐؔ؜ؠؤبجذشظؼ  $(,048<@DHLPTX\`dhlptx|ـلؤٌِٜ٘٠٤٨٬ٰٴٸټ  $(,048<@DHLPTX\`dhlptx|ڀڄڈڌڐڔژڜڠڤڨڬڰڴڸڼ  $(,048<@DHLPTX\`dhlptx|                                                                                                                                                                                                                                    pL(t	P
,
xT0|X4\8 !`"<#$$%&'d(@)**+,-h.D/ 00123l4H5$6 7789p:L;(<==>?t@PA,BCCDExFTG0HIIJK|LXM4NOOPQR\S8TUUVWX`Y<Z[[\]^d_@`aabcdheDf gghijlkHl$m nnoppqLr(sttuvtwPx,yzz{|x}T~0ā|X4ȇ\8̍`<Гd@ԙhD ؟lH$ ܥpL(ૼtP,xT0ĸ|X4Ⱦ\8Ĩń`<ʬˈd@аьhD ִאlH$ $Hlܐܴ Dh݌ݰ@dވެ<`߄ߨ8\4X|0Tx,Pt(Lp $Hl Dh@d<`8\4X|0Tx,Pt(Lp $Hl Dh@d<`8\4X|0Tx,Pt(Lp $Hl Dh@d<`8\4X|0Tx,Pt(Lpہۂۃۄۅۆۇۈۉۊۋیۍێۏېۑےۓ۔ەۖۗۘۙۚۛۜ۝۞ۣ۟۠ۡۢۤۥۦۧۨ۩۪ۭ۫۬ۮۯ۰۱۲۳۴۵۶۷۸۹ۺۻۼ۽۾ۿ                                                                                                                                   pL(t	P
,
xT0|X4\8 !`"<#$$%&'d(@)**+,-h.D/ 00123l4H5$6 7789p:L;(<==>?t@PA,BCCDExFTG0HIIJK|LXM4NOOPQR\S8TUUVWX`Y<Z[[\]^d_@`aabcdheDf gghijlkHl$m nnoppqLr(sttuvtwPx,yzz{|x}T~0ā|X4ȇ\8̍`<Гd@ԙhD ؟lH$ ܥpL(ૼtP,xT0ĸ|X4Ⱦ\8Ĩń`<ʬˈd@аьhD ִאlH$  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  @`  $(,048<@DHLPTX\`dhlptx|܀܄܈܌ܐܔܘܜܠܤܨܬܴܸܼܰ  $(,048<@DHLPTX\`dhlptx|݄݈݀݌ݐݔݘݜݠݤݨݬݰݴݸݼ  $(,048<@DHLPTX\`dhlptx|ހބވތސޔޘޜޠޤިެް޴޸޼  $(,048<@DHLPTX\`dhlptx|߀߄߈ߌߐߔߘߜߠߤߨ߬߰ߴ߸߼                                                                                                                                                                                                                                                                 