# Copyright Gonzalo Brito Gadeschi 2015
# Distributed under the Boost Software License, Version 1.0.
# (See accompanying file LICENSE.md or copy at http://boost.org/LICENSE_1_0.txt)
#
# Detects the C++ compiler, system, build-type, etc.
include(CheckCXXCompilerFlag)

if("x${CMAKE_CXX_COMPILER_ID}" MATCHES "x.*Clang")
  if("x${CMAKE_CXX_SIMULATE_ID}" STREQUAL "xMSVC")
    set (RANGES_CXX_COMPILER_CLANGCL TRUE)
    if (RANGES_VERBOSE_BUILD)
      message("[range-v3]: compiler is clang-cl.")
    endif()
  else()
    set (RANGES_CXX_COMPILER_CLANG TRUE)
    if (RANGES_VERBOSE_BUILD)
      message("[range-v3]: compiler is clang.")
    endif()
  endif()
elseif(CMAKE_COMPILER_IS_GNUCXX)
  set (RANGES_CXX_COMPILER_GCC TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: compiler is gcc.")
  endif()
else()
  message("[range-v3 warning]: unknown compiler ${CMAKE_CXX_COMPILER_ID} !")
endif()

if(CMAKE_SYSTEM_NAME MATCHES "Darwin")
  set (RANGES_ENV_MACOSX TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: system is MacOSX.")
  endif()
elseif(CMAKE_SYSTEM_NAME MATCHES "Linux")
  set (RANGES_ENV_LINUX TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: system is Linux.")
  endif()
elseif(CMAKE_SYSTEM_NAME MATCHES "Windows")
  set (RANGES_ENV_WINDOWS TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: system is Windows.")
  endif()
else()
  message("[range-v3 warning]: unknown system ${CMAKE_SYSTEM_NAME} !")
endif()

# Clang-CL will blow up with various parts of the standard library
# if compiling with -std less than c++14.
if (RANGES_CXX_COMPILER_CLANGCL)
  if (RANGES_CXX_STD EQUAL 11)
    set(CMAKE_CXX_STANDARD 14)
    set(RANGES_CXX_STD 14)
  endif()
  target_compile_definitions(range-v3 INTERFACE _SILENCE_CXX17_TEMPORARY_BUFFER_DEPRECATION_WARNING)
endif()

# Build type
set(RANGES_DEBUG_BUILD FALSE)
set(RANGES_RELEASE_BUILD FALSE)

if (CMAKE_BUILD_TYPE STREQUAL "Debug")
  set(RANGES_DEBUG_BUILD TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: build type is debug.")
  endif()
elseif(CMAKE_BUILD_TYPE STREQUAL "Release")
  set(RANGES_RELEASE_BUILD TRUE)
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: build type is release.")
  endif()
else()
  message("[range-v3 warning]: unknown build type, defaults to release!")
  set(CMAKE_BUILD_TYPE "Release")
  set(RANGES_RELEASE_BUILD TRUE)
endif()

# Find Valgrind
find_program(MEMORYCHECK_COMMAND valgrind)
if(MEMORYCHECK_COMMAND)
  set(MEMORYCHECK_COMMAND_OPTIONS "--trace-children=yes --leak-check=full")
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3]: valgrind found at path: ${MEMORYCHECK_COMMAND}")
  endif()
else()
  if (RANGES_VERBOSE_BUILD)
    message("[range-v3 warning]: valgrind not found!")
  endif()
endif()

find_package(Doxygen)
find_package(Git)
