/****************************************/
/* This is the checkbpass module ...it  */
/* checks for the presence of the 	*/
/* password line in the grub or lilo 	*/
/* configuration file.			*/
/*					*/
/* See lsatmain.c for more details.	*/
/****************************************/
#include "lsatheader.h"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int checkbpass(distribution, filename, verbose, html)
int distribution;
const char *const filename;
int verbose;
int html;
{
    const char * header   =NULL;

    if (verbose >= 0)
    {
    	printf(" Running checkbpass module...\n");
    }

    /*first off, if we are on gentoo, /boot is not mounted...*/
    if (distribution == 4)
    {
	/*gentoo, warn user*/
	    header = "You are on Gentoo, /boot is not mounted, \ncan not check for presence of a bootloader password";
    }
    else
    {

    /* lets check grub first, look in the usual location */
    if ((system("test -r /boot/grub/grub.conf")) == 0)
    {
	/* it exists, check it */
        if ((system("grep -i -q password /boot/grub/grub.conf 2>/dev/null")) == 0)
        {
	    header = "Password keyword is in grub.conf, good.\n"; 
        }
	/* one more location to check */
	if ((system("test -r /boot/grub.conf")) == 0)
	{
	    if ((system("grep -i -q password /boot/grub/grub.conf 2>/dev/null")) == 0)
	    {
	        header = "Password keyword is in grub.conf, good.\n";
	    }
	}
	else 
	{
	    header = "Password keyword is not in grub.conf, please check.\n";
 	}
    }
    else
    {
        if ((system("test -r /etc/lilo.conf")) == 0)
        {
            if ((system("grep -i -q password /etc/lilo.conf 2>/dev/null")) == 0)
            {
                    header = "Password keyword found in lilo.conf, good.\n";
            }
            else
            {
                    header = "Password keyword is not in lilo.conf, please check.\n";
            }
        }
        else
        {
            header = "Can not locate grub or lilo conf files.\nPlease check that the password keyword is being used in them.\n";
        }
    }
    }
    /* ok, call dostuff to print out the header */
    /* to the output file... 			*/
    if ((dostuff(0, filename, 0, header, html)) < 0)
    {
        /* something went wrong */
	perror(" Creation of list failed.");
	return (-1);
    }


    
    if (verbose > 0)
    {
        printf(" Finished in checkbpass module.\n");
    }

    return(0);
}
