#include <time.h>
#include <sys/types.h>
#include "ptimec.hh"

bool ptime_f1(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_char('@', str, off, len)) return false;
    if (!ptime_at(dst, str, off, len)) return false;
    return true;
}

bool ptime_f2(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f3(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

bool ptime_f4(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f5(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_f(dst, str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f6(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('Z', str, off, len)) return false;
    return true;
}

bool ptime_f7(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('T', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f8(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f9(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    return true;
}

bool ptime_f10(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

bool ptime_f11(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    return true;
}

bool ptime_f12(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    return true;
}

bool ptime_f13(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_upto(' ', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char('.', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    return true;
}

bool ptime_f14(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_char('+', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    if (!ptime_char('0', str, off, len)) return false;
    return true;
}

bool ptime_f15(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_z(dst, str, off, len)) return false;
    return true;
}

bool ptime_f16(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f17(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_b(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_e(dst, str, off, len)) return false;
    if (!ptime_char(',', str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    return true;
}

bool ptime_f18(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f19(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_I(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_L(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_upto_end(str, off, len)) return false;
    return true;
}

bool ptime_f20(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_e(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_l(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_p(dst, str, off, len)) return false;
    return true;
}

bool ptime_f21(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f22(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f23(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f24(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    if (!ptime_char(' ', str, off, len)) return false;
    if (!ptime_H(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_M(dst, str, off, len)) return false;
    if (!ptime_char(':', str, off, len)) return false;
    if (!ptime_S(dst, str, off, len)) return false;
    return true;
}

bool ptime_f25(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    return true;
}

bool ptime_f26(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('-', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    return true;
}

bool ptime_f27(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_d(dst, str, off, len)) return false;
    return true;
}

bool ptime_f28(struct exttm *dst, const char *str, off_t &off, ssize_t len) {
    if (!ptime_Y(dst, str, off, len)) return false;
    if (!ptime_char('/', str, off, len)) return false;
    if (!ptime_m(dst, str, off, len)) return false;
    return true;
}

struct ptime_fmt PTIMEC_FORMATS[] = {
    { "@%@", ptime_f1 },
    { "%Y-%m-%d %H:%M:%S", ptime_f2 },
    { "%Y-%m-%d %H:%M", ptime_f3 },
    { "%Y-%m-%dT%H:%M:%S.%f%z", ptime_f4 },
    { "%y-%m-%dT%H:%M:%S.%f%z", ptime_f5 },
    { "%Y-%m-%dT%H:%M:%SZ", ptime_f6 },
    { "%Y-%m-%dT%H:%M:%S", ptime_f7 },
    { "%Y/%m/%d %H:%M:%S", ptime_f8 },
    { "%Y/%m/%d %H:%M", ptime_f9 },
    { "%a %b %d %H:%M:%S %Y", ptime_f10 },
    { "%a %b %d %H:%M:%S %Z %Y", ptime_f11 },
    { "%a %b %d %H:%M:%S ", ptime_f12 },
    { "%a %b %d %H:%M:%S.%L ", ptime_f13 },
    { "%d/%b/%Y:%H:%M:%S +0000", ptime_f14 },
    { "%d/%b/%Y:%H:%M:%S %z", ptime_f15 },
    { "%b %d %H:%M:%S", ptime_f16 },
    { "%b %e, %Y %l:%M:%S %p", ptime_f17 },
    { "%m/%d/%y %H:%M:%S", ptime_f18 },
    { "%m/%d/%Y %I:%M:%S:%L %p %Z", ptime_f19 },
    { "%m/%e/%Y %l:%M:%S %p", ptime_f20 },
    { "%m%d %H:%M:%S", ptime_f21 },
    { "%H:%M:%S", ptime_f22 },
    { "%M:%S", ptime_f23 },
    { "%m/%d %H:%M:%S", ptime_f24 },
    { "%Y-%m-%d", ptime_f25 },
    { "%Y-%m", ptime_f26 },
    { "%Y/%m/%d", ptime_f27 },
    { "%Y/%m", ptime_f28 },

    { NULL, NULL }
};
const char *PTIMEC_FORMAT_STR[] = {
    "@%@",
    "%Y-%m-%d %H:%M:%S",
    "%Y-%m-%d %H:%M",
    "%Y-%m-%dT%H:%M:%S.%f%z",
    "%y-%m-%dT%H:%M:%S.%f%z",
    "%Y-%m-%dT%H:%M:%SZ",
    "%Y-%m-%dT%H:%M:%S",
    "%Y/%m/%d %H:%M:%S",
    "%Y/%m/%d %H:%M",
    "%a %b %d %H:%M:%S %Y",
    "%a %b %d %H:%M:%S %Z %Y",
    "%a %b %d %H:%M:%S ",
    "%a %b %d %H:%M:%S.%L ",
    "%d/%b/%Y:%H:%M:%S +0000",
    "%d/%b/%Y:%H:%M:%S %z",
    "%b %d %H:%M:%S",
    "%b %e, %Y %l:%M:%S %p",
    "%m/%d/%y %H:%M:%S",
    "%m/%d/%Y %I:%M:%S:%L %p %Z",
    "%m/%e/%Y %l:%M:%S %p",
    "%m%d %H:%M:%S",
    "%H:%M:%S",
    "%M:%S",
    "%m/%d %H:%M:%S",
    "%Y-%m-%d",
    "%Y-%m",
    "%Y/%m/%d",
    "%Y/%m",

    NULL
};
