/*
 *  Copyright (c) 2013 Dmitry Kazakov <dimula73@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __KIS_SIMPLE_PROCESSING_VISITOR_H
#define __KIS_SIMPLE_PROCESSING_VISITOR_H

#include "kis_processing_visitor.h"


class KRITAIMAGE_EXPORT KisSimpleProcessingVisitor : public KisProcessingVisitor
{
public:
    ~KisSimpleProcessingVisitor();

    void visit(KisNode *node, KisUndoAdapter *undoAdapter);
    void visit(KisPaintLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisGroupLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisAdjustmentLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisExternalLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisGeneratorLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisCloneLayer *layer, KisUndoAdapter *undoAdapter);
    void visit(KisFilterMask *mask, KisUndoAdapter *undoAdapter);
    void visit(KisTransformMask *mask, KisUndoAdapter *undoAdapter);
    void visit(KisTransparencyMask *mask, KisUndoAdapter *undoAdapter);
    void visit(KisSelectionMask *mask, KisUndoAdapter *undoAdapter);
    void visit(KisColorizeMask *mask, KisUndoAdapter *undoAdapter);

protected:
    virtual void visitNodeWithPaintDevice(KisNode *node, KisUndoAdapter *undoAdapter) = 0;
    virtual void visitExternalLayer(KisExternalLayer *layer, KisUndoAdapter *undoAdapter) = 0;
    virtual void visitColorizeMask(KisColorizeMask *mask, KisUndoAdapter *undoAdapter) = 0;
};

#endif /* __KIS_SIMPLE_PROCESSING_VISITOR_H */
