/* $Id: arch_i386_gen.h,v 1.19 2012/02/23 15:11:54 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUcc Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ARCH_I386_GEN_H_INCLUDED
#define __ARCH_I386_GEN_H_INCLUDED

#include "scope.h"
#include "type.h"

extern struct type *
arch_i386_type_intptr_t(void);
extern struct type *
arch_i386_type_uintptr_t(void);
extern void
arch_i386_align_size(
	struct scope *scope,
	struct type *type,
	unsigned int *alignp,
	unsigned int *sizep);

extern void
arch_i386_gen_class_and_type_get(
	const char *name, unsigned int *classp, enum type_type *typep);
extern unsigned int
arch_i386_gen_class_or(unsigned int a, unsigned int b);
extern unsigned int
arch_i386_gen_class_and(unsigned int a, unsigned int b);

extern void
arch_i386_color_init(unsigned int *count);
extern void
arch_i386_color_add(unsigned int *count, unsigned int set, enum type_type type);
extern void
arch_i386_color_sub(unsigned int *count, unsigned int set, enum type_type type);
extern int
arch_i386_color_check(unsigned int *count, unsigned int set, enum type_type type);

extern void
arch_i386_gen_reg_init(uint32_t *conflicts);
extern void
arch_i386_gen_reg_add(uint32_t *conflicts, unsigned int reg);
extern int
arch_i386_gen_reg_get(uint32_t *conflicts, unsigned int class, enum type_type type);

extern void
arch_i386_gen(const char *out, struct scope *scope);

#endif /* __ARCH_I386_GEN_H_INCLUDED */
