We're proud to announce the new feature release of darktable, 4.0.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-4.0.0](https://github.com/darktable-org/darktable/releases/tag/release-4.0.0).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-4.0.0.tar.xz
??? darktable-4.0.0.tar.xz
$ sha256sum darktable-4.0.0.dmg
??? darktable-4.0.0.dmg
$ sha256sum darktable-4.0.0.exe
??? darktable-4.0.0.exe
```

When updating from the stable 3.8.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 3.8.x.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 3.8:

- Almost 1600 commits to darktable+rawspeed
- 540 pull requests handled
- 112 issues closed

## The Big Ones

The following is a summary of the main features added to darktable 4.0. These features
are described more fully in the user manual and accompanying blog post.

- Color and exposure mapping

  A new feature in the "exposure" and "color calibration" modules allows you to
  define and save a target color/exposure for the color pickers, in order to
  match any source object in the image against an arbitrary target
  color. This can be used to perform white balance
  (chromatic adaptation) against non-gray objects of known color, or to
  ensure the color consistency of an object across a series of images.

- Filmic v6

  Filmic v6 introduces new color science. This change removes the mandatory desaturation
  close to medium white and black and replaces it with a true gamut
  mapping against the output (or export) color space. This allows for more
  saturated colors, notably in blue skies.

  For users who still prefer the "desaturated highlights" look,
  you can still do this by disabling chroma preservation, but v6 adds a
  hue handcuff to prevent the traditional hue shift that comes with this
  method (where saturated blue skies degrade to cyan and saturated red to yellow).

  This gamut sanitization is the third and last to be added to darktable,
  which now has a fully-sanitized color pipeline from input (color calibration),
  through artistic changes (color balance rgb) to output (filmic v6). Users
  can now color-grade pictures safely in the knowledge that invalid input
  colors can be recovered in the least destructive fashion possible early
  in the pipeline, and valid colors can't be pushed out of gamut along the pipeline.

  Note: If modules are applied after filmic in the pipeline, they
  don't benefit from this gamut mapping and rely on LittleCMS2 (if
  enabled) at the final export stage, which does not gamut map as it
  should, and probably never did.

- Guided laplacian highlight reconstruction

  A new "guided laplacian" method has been added to the "highlight
  reconstruction" module. This uses an iterative and multi-scale wavelet
  scheme to extract valid details from non-clipped RGB channel(s) if any,
  uses these details to guide the reconstruction of clipped channels, and finally
  propagates the color gradients from neighboring valid regions using
  edge-aware color diffusion. This limits color bleeding through edges
  (preventing green leaves from bleeding color in the reconstruction of clipped
  blue sky, for example).

  A noise setting allows Poisson noise to be added to reconstructed highlights,
  in order to help blend them into noisy high-ISO images.

  This method is only available for Bayer sensors and cannot be adapted
  to X-Trans sensors.

- Introducing the darktable Uniform Color Space 2022

  The darktable UCS 22 is a perceptually uniform color space designed
  from psychoperceptual experimental data specifically for the purpose
  of artistic saturation changes, as performed in the *color balance RGB* module.
  It uses a brightness-saturation scheme that compensates for the Helmholtz-Kohlraush effect
  (accounting for the contribution of colorfulness in perceived brightness)
  and allows an efficient gamut-mapping against pipeline RGB at constant
  brightness. It will make the saturation control in *color balance RGB*
  better behaved.

- UI Rewrite

  The UI has been completely revamped again to improve look and consistency.
  Padding, margins, color, contrast, alignment, and icons have been reworked
  throughout.

  Collapsible sections within modules have also been redesigned so that
  their functionality is more obvious and better-looking.
  New collapsible sections have been added to avoid
  cluttering the UI in the following modules:

     - channel mixer rgb
     - exposure
     - color calibration

  The vignetting module has been split into two sections for clarity.

  Superfluous sections have been removed from the "crop" and "white balance".

  Support has been added for the IPAPGothic font.

  The module-description tooltips have been reworked to ensure better layout.

  Finally the default theme has been changed to Elegant Grey. The
  darktable default is now in line with the theme recommended by the
  team.

- Performance and OpenCL support changes

  All performance and OpenCL settings and pixelpipe optimizations have been
  fully reviewed and updated. Many new optimizations have been
  added and the user preferences have been simplified.

  All configurations are now per-device allowing each OpenCL
  device to be tuned separately.

  Performance configuration is now applied at runtime and no longer
  requires darktable to be restarted when changed.

  Some modules had incorrect or overly conservative tiling factors, which made
  darktable unnecessarily slow (since tiling was used when it was not required)
  The followimg modules have been updated

     - demosaic (X-Trans)
     - retouch

## Other Changes

- Color glossary

  The global color picker tool (in the darkroom's left sidebar) now displays
  the name of the picked color in the tooltip. This feature was
  requested by several color-disabled photographers, to assert the
  perceptual validity of their editing for an average observer.

  The color vocabulary contains 76 entries: 15 hues × 5 lightnesses +
  neutral (gray). It does not separate across the chroma axis, so all
  colors are registered the same no matter their colorfulness.

  The vocabulary also contains average skin colors for 3 body
  parts (forearm, forehead and cheek) of 6 ethnicities (Chinese, Thai,
  Kurdish, Mexican, Caucasian, African-American). These values come from
  the academic databases of cosmetology and dermatology available at the
  time of programming. They are only valid for a D65 illuminant and for
  an exposure setting that anchors diffuse white at 92% relative
  luminance.

- A new "contrast" parameter has been added to the guide line overlay
  settings, allowing for better visibility of the lines over images.

- A new "collection filters" module has been introduced, designed to be easier
  to use than the filtering in the current "collections" module.

  The new module allows the current collection to be sorted and filtered using multiple
  criteria. Each sort/filter rule can be pinned, which duplicates the appropriate control
  on the top tool bar for quick access.

  The following filters have been implemented (more to come in the next version):
    color labels, text search, date-time filters, exposure, ISO,
    focal length, aperture, aspect ratio, filename and extension,
    grouping, history, local copy, module order

  Presets can be created and a history button also allows previous configuration to be retrieved.

  All-new text and color filter widgets have been implemented.

- The "recently used collections" module is now incorporated into the
  "collections" module as a "history" button

- The darkroom's module search facility has been enhanced to also match on
  any user-defined module names.

- Support for EXR 16-bit (half) float export has been added.

- All usage of dates/times have been reworked to better support
  time-zones and differing operating systems. Support for
  milliseconds has also been added.

- All presets in the "tone equalizer" module have been updated to use
  scene-referred blending modes.

- The new input system introduced in version 3.8 now handles
  simultaneous shortcut presses and the responsiveness is
  greatly improved.

  MIDI configuration parameters are now specified in darktable
  resource files.

  Slider step sizes have been standardized and can now be
  configured individually.

  Extra pen tablet button clicks are now treated as key presses so that
  they can be used in shortcuts.

  Support for gamepad triggers has been added (treating them as buttons)
  allowing them to be used as shortcuts.

- Modifiers (<kbd>Ctrl</kbd>/<kbd>Shift</kbd>/<kbd>Ctrl+Shift</kbd>)
  can now be used when dragging sliders, to modify the precision of the
  value changes.

- When using the "copy" and "move" functionality in the lighttable, the last
  directories are remembered independently for each operation.

- It is now possible to scroll over a tabbed module to switch tabs.

- Improved monochrome images support:

  True monochrome images (like those from Leica) and images from cameras
  that have the color matrix filter in front of the sensor removed,
  are now treated the same in the user interface as much as possible.

- The tagging suggestion mode has been improved.

- The overlay layout in the print view has been enhanced.

- The "retouch" module's heal iteration limit has been increased for new edits.

- It is now possible to edit a single node on a brush path. You can
  change the size, opacity and hardness of each node independently.

- A new button in the "highlight reconstruction" module allows clipped pixels
  to be better visualized.

- The raw overexposure function now shows actual sensor clipping rather than being
  adjusted according to the white balance of the image. This is better
  suited to the default scene-referred workflow.

- Shortcuts can now be directed to the currently-focused processing module
  instance instead of the currently-expanded one.

- The control of the lighttable view has been improved by ensuring the up/down
  and left/right keys have the expected behavior.

- Apply a blur when color picking in area mode. This ensures that color picker
  measurements aren't overly influenced by image noise. This change particularly
  improves the stability of filmic's black relative exposure measurement.

- Add support for DNG GainMap EXIF information and update the pixel
  gain in raw-prepare module. This gives a better initial exposure
  to the imported DNG pictures.

## Bug Fixes

- Check for total memory on Linux is now more portable.

- MIDI buttons with light status are now properly updated.

- Tab shortcut tooltips are correctly displayed on tabbed modules.

- Misalignments between source and target patches in the retouch module
  have been resolved. "Jumpy" movements are also improved when adjusting
  nodes or segments.

- The start of culling mode is improved, especially where no images are
  selected and/or under the mouse.

- Local-copy status icon position fixed in block overlay.

- Crop handle positions fixed when using fast movements.

- RCD OpenCL tiling issues resolved.

- Tile stitching for X-Trans sensors

- Filmstrip update fixed if crop is left open when moving to next
  image.

- "collections" module now correctly updated when new images are imported.

- Landscape/portrait print handling was broken due to a recent CUPS change. We
  now rely on the CUPS filter for the proper orientation.

- Fixed possible PDF corruption in export and print modules due to
  duplicate written byte count.

- Fixed a possible race conditions in retouch and color reconstruction
  OpenCL code making darktable crash.

- Properly transform points for the rotation computation in
  perspective correction. This fixes an issue when the image is
  flipped making it impossible to use the rotation control.

- Removed RatingPercent in EXIF data as it is not standardized and
  can confuse the Windows image viewer.

- Fixed label/reject behavior when multiple images are selected:

  When attempting to reject multiple images, they will now be set to rejected if
  **any** of them are not currently rejected. They will be set to un-rejected if
  **all** of them are currently rejected.

  This allows for more predictable handling of images with inconsistent reject statuses.

  Similar changes have also been made when toggling color labels on/off.

- Fixed white balance preset lookup in the "white balance" module.

- Fixed some possible missing refresh of the metadata editor.

- Fixed possible translation issue on Windows.

## Lua


## Notes


## Changed Dependencies

N/A

## RawSpeed changes


## Camera support, compared to 3.8

### Base Support


### White Balance Presets

- Nikon D4S
- Panasonic DC-S5
- Sony ILCE-7M4

### Noise Profiles


### Custom Color Matrices

### Suspended Support

No samples on raw.pixls.us

- Canon EOS M2
- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm FinePix HS50EXR
- Fujifilm FinePix S6000fd
- Fujifilm FinePix S9600fd
- Fujifilm IS-1
- GoPro FUSION
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Leica D-LUX 6
- Minolta DiMAGE 5
- Nikon 1 J4
- Nikon 1 S1
- Nikon Coolpix P7700
- Nikon D1H
- Nikon D2H
- Nikon D3S
- Olympus E-10
- Olympus SP320
- Olympus SP570UZ
- Panasonic DMC-FX150
- Panasonic DMC-G2
- Pentax K200D
- Pentax K2000
- Pentax Q10
- Phase One IQ250
- Samsung GX10
- Samsung GX20
- Samsung NX5
- Samsung NX10
- Samsung NX11
- Samsung NX20
- Samsung NX2000
- Samsung EK-GN120
- Samsung SM-G920F
- Samsung SM-G935F
- Sinar Hy6/ Sinarback eXact
- Sony DSLR-A380
- Sony DSLR-A560
- ST Micro STV680

## Translations

- Czech
- German
- Esperanto
- European Spanish
- Finnish
- French
- Hebrew
- Hungarian
- Italian
- Japanese
- Dutch
- Brazilian Portuguese
- Russian
- Slovenian
- Turkish
- Ukrainian
- Chinese - China
