# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153522;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1481[25-9]\\d{5}',
                'geographic' => '1481[25-9]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              781|
              839
            )\\d|
            911[17]
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[0-3]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441808", "Tomatin",
"442870", "Coleraine",
"441912", "Tyneside",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441477", "Holmes\ Chapel",
"441865", "Oxford",
"441144", "Sheffield",
"44114708", "Sheffield",
"442881", "Newtownstewart",
"441889", "Rugeley",
"4413399", "Ballater",
"4418907", "Ayton",
"441706", "Rochdale",
"441835", "St\ Boswells",
"441577", "Kinross",
"441919", "Durham",
"441876", "Lochmaddy",
"441291", "Chepstow",
"441495", "Pontypool",
"4414307", "Market\ Weighton",
"441882", "Kinloch\ Rannoch",
"441404", "Honiton",
"441307", "Forfar",
"441778", "Bourne",
"441565", "Knutsford",
"441476", "Grantham",
"441508", "Brooke",
"441945", "Wisbech",
"4418908", "Coldstream",
"4413396", "Ballater",
"441895", "Uxbridge",
"441535", "Keighley",
"441959", "Westerham",
"441707", "Welwyn\ Garden\ City",
"441482", "Kingston\-upon\-Hull",
"441453", "Dursley",
"4414344", "Bellingham",
"441450", "Hawick",
"441261", "Banff",
"441626", "Newton\ Abbot",
"441408", "Golspie",
"441971", "Scourie",
"441465", "Girvan",
"441246", "Chesterfield",
"441877", "Callander",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441576", "Lockerbie",
"441489", "Bishops\ Waltham",
"4416864", "Llanidloes",
"441553", "Kings\ Lynn",
"441952", "Telford",
"441306", "Dorking",
"4418510", "Great\ Bernera\/Stornoway",
"441550", "Llandovery",
"441983", "Isle\ of\ Wight",
"441435", "Heathfield",
"441980", "Amesbury",
"441582", "Luton",
"4414308", "Market\ Weighton",
"441334", "St\ Andrews",
"442830", "Newry",
"441398", "Dulverton",
"442842", "Kircubbin",
"441322", "Dartford",
"441875", "Tranent",
"441467", "Inverurie",
"441364", "Ashburton",
"44281", "Northern\ Ireland",
"441496", "Port\ Ellen",
"441609", "Northallerton",
"441768", "Penrith",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441841", "Newquay\ \(Padstow\)",
"441738", "Perth",
"441329", "Fareham",
"441794", "Romsey",
"441947", "Whitby",
"442849", "Northern\ Ireland",
"441866", "Kilchrenan",
"441567", "Killin",
"4415074", "Alford\ \(Lincs\)",
"441305", "Dorchester",
"441259", "Alloa",
"441436", "Helensburgh",
"441368", "Dunbar",
"441625", "Macclesfield",
"441497", "Hay\-on\-Wye",
"442890", "Belfast",
"4418473", "Thurso",
"441394", "Felixstowe",
"441729", "Settle",
"441466", "Huntly",
"442893", "Ballyclare",
"441245", "Chelmsford",
"441575", "Kirriemuir",
"441536", "Kettering",
"441798", "Pulborough",
"441252", "Aldershot",
"441837", "Okehampton",
"441931", "Shap",
"441684", "Malvern",
"441280", "Buckingham",
"441283", "Burton\-on\-Trent",
"441566", "Launceston",
"441475", "Greenock",
"4413395", "Aboyne",
"441764", "Crieff",
"441946", "Whitehaven",
"4419753", "Strathdon",
"441722", "Salisbury",
"441597", "Llandrindod\ Wells",
"44241", "Coventry",
"441271", "Barnstaple",
"441896", "Galashiels",
"441795", "Sittingbourne",
"441376", "Braintree",
"441146", "Sheffield",
"4416862", "Llanidloes",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441382", "Dundee",
"4413885", "Stanhope\ \(Eastgate\)",
"441353", "Ely",
"441704", "Southport",
"441506", "Bathgate",
"441807", "Ballindalloch",
"441350", "Dunkeld",
"441308", "Bridport",
"4414342", "Bellingham",
"441874", "Brecon",
"4415396", "Sedbergh",
"44114707", "Sheffield",
"441777", "Retford",
"44292", "Cardiff",
"441692", "North\ Walsham",
"441389", "Dumbarton",
"441628", "Maidenhead",
"4417684", "Pooley\ Bridge",
"441406", "Holbeach",
"441335", "Ashbourne",
"441248", "Bangor\ \(Gwynedd\)",
"441578", "Lauder",
"441474", "Gravesend",
"441765", "Ripon",
"441377", "Driffield",
"441669", "Rothbury",
"441708", "Romford",
"441806", "Shetland",
"441685", "Merthyr\ Tydfil",
"441639", "Neath",
"441789", "Stratford\-upon\-Avon",
"4414301", "North\ Cave\/Market\ Weighton",
"441624", "Isle\ of\ Man",
"4418515", "Stornoway",
"441643", "Minehead",
"441223", "Cambridge",
"441776", "Stranraer",
"4412293", "Millom",
"4418901", "Coldstream\/Ayton",
"441395", "Budleigh\ Salterton",
"441244", "Chester",
"441750", "Selkirk",
"441753", "Slough",
"441304", "Dover",
"441878", "Lochboisdale",
"441407", "Holyhead",
"441782", "Stoke\-on\-Trent",
"441405", "Goole",
"4418519", "Great\ Bernera",
"441829", "Tarporley",
"441341", "Barmouth",
"441397", "Fort\ William",
"442821", "Martinstown",
"441366", "Downham\ Market",
"441494", "High\ Wycombe",
"44114703", "Sheffield",
"441438", "Stevenage",
"4415395", "Grange\-over\-Sands",
"441568", "Leominster",
"441737", "Redhill",
"441687", "Mallaig",
"441834", "Narberth",
"441505", "Johnstone",
"441948", "Whitchurch",
"441594", "Lydney",
"441796", "Pitlochry",
"441538", "Ipstones",
"441375", "Grays\ Thurrock",
"441822", "Tavistock",
"4415072", "Spilsby\ \(Horncastle\)",
"441767", "Sandy",
"441145", "Sheffield",
"441864", "Abington\ \(Crawford\)",
"441337", "Ladybank",
"4420", "London",
"441422", "Halifax",
"4419643", "Patrington",
"441367", "Faringdon",
"4418516", "Great\ Bernera",
"441775", "Spalding",
"441464", "Insch",
"441529", "Sleaford",
"441805", "Torrington",
"441534", "Jersey",
"441598", "Lynton",
"4413390", "Aboyne\/Ballater",
"441736", "Penzance",
"441651", "Oldmeldrum",
"441564", "Lapworth",
"441672", "Marlborough",
"4414233", "Boroughbridge",
"441766", "Porthmadog",
"441429", "Hartlepool",
"441838", "Dalmally",
"441920", "Ware",
"441944", "West\ Heslerton",
"441797", "Rye",
"441522", "Lincoln",
"441923", "Watford",
"441994", "St\ Clears",
"441747", "Shaftesbury",
"441823", "Taunton",
"441938", "Welshpool",
"441844", "Thame",
"4412292", "Barrow\-in\-Furness",
"441968", "Penicuik",
"4418905", "Ayton",
"4418511", "Great\ Bernera\/Stornoway",
"441278", "Bridgwater",
"441548", "Kingsbridge",
"441905", "Worcester",
"442826", "Northern\ Ireland",
"4414305", "North\ Cave",
"441346", "Fraserburgh",
"441361", "Duns",
"441206", "Colchester",
"441673", "Market\ Rasen",
"441761", "Temple\ Cloud",
"44116", "Leicester",
"441670", "Morpeth",
"441922", "Walsall",
"441274", "Bradford",
"441544", "Kington",
"441520", "Lochcarron",
"441746", "Bridgnorth",
"44113", "Leeds",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441934", "Weston\-super\-Mare",
"441848", "Thornhill",
"4414343", "Haltwhistle",
"441656", "Bridgend",
"441420", "Alton",
"441444", "Haywards\ Heath",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441347", "Easingwold",
"442827", "Ballymoney",
"441929", "Wareham",
"4416863", "Llanidloes",
"441207", "Consett",
"44238", "Southampton",
"441268", "Basildon",
"441978", "Wrexham",
"441359", "Pakenham",
"44114701", "Sheffield",
"441205", "Boston",
"4414232", "Harrogate",
"442825", "Ballymena",
"441294", "Ardrossan",
"441690", "Betws\-y\-Coed",
"4414306", "Market\ Weighton",
"441383", "Dunfermline",
"442884", "Northern\ Ireland",
"441380", "Devizes",
"4419642", "Hornsea",
"4418906", "Ayton",
"441501", "Harthill",
"4413398", "Aboyne",
"441352", "Mold",
"441371", "Great\ Dunmow",
"441141", "Sheffield",
"4414309", "Market\ Weighton",
"441298", "Buxton",
"441752", "Plymouth",
"4415073", "Louth",
"441234", "Bedford",
"441780", "Stamford",
"441630", "Market\ Drayton",
"441633", "Newport",
"441642", "Middlesbrough",
"441264", "Andover",
"44161", "Manchester",
"441974", "Llanon",
"44117", "Bristol",
"441771", "Maud",
"4418474", "Thurso",
"441663", "New\ Mills",
"441759", "Pocklington",
"441655", "Maybole",
"442888", "Northern\ Ireland",
"4418909", "Ayton",
"4419754", "Alford\ \(Aberdeen\)",
"4413397", "Ballater",
"441745", "Rhyl",
"442311", "Southampton",
"441591", "Llanwrtyd\ Wells",
"441547", "Knighton",
"441277", "Brentwood",
"4418900", "Coldstream\/Ayton",
"441967", "Strontian",
"442885", "Ballygawley",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441748", "Richmond",
"441937", "Wetherby",
"442840", "Banbridge",
"442824", "Northern\ Ireland",
"441344", "Bracknell",
"441320", "Fort\ Augustus",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441295", "Banbury",
"441323", "Eastbourne",
"441491", "Henley\-on\-Thames",
"4414300", "North\ Cave\/Market\ Weighton",
"441603", "Norwich",
"4417683", "Appleby",
"441600", "Monmouth",
"4418518", "Stornoway",
"441204", "Bolton",
"441561", "Laurencekirk",
"441276", "Camberley",
"441723", "Scarborough",
"441546", "Lochgilphead",
"441720", "Isles\ of\ Scilly",
"441744", "St\ Helens",
"441997", "Strathpeffer",
"442899", "Northern\ Ireland",
"441250", "Blairgowrie",
"441253", "Blackpool",
"441531", "Ledbury",
"441282", "Burnley",
"441654", "Machynlleth",
"441446", "Barry",
"44291", "Cardiff",
"4418517", "Stornoway",
"442892", "Lisburn",
"4412294", "Barrow\-in\-Furness",
"441461", "Gretna",
"441208", "Bodmin",
"442828", "Larne",
"441348", "Fishguard",
"441235", "Abingdon",
"441431", "Helmsdale",
"441289", "Berwick\-upon\-Tweed",
"441880", "Tarbert",
"4419752", "Alford\ \(Aberdeen\)",
"441883", "Caterham",
"441237", "Bideford",
"441852", "Kilmelford",
"4413391", "Aboyne\/Ballater",
"442879", "Magherafelt",
"441977", "Pontefract",
"441296", "Aylesbury",
"441871", "Castlebay",
"441267", "Carmarthen",
"4418472", "Thurso",
"442886", "Cookstown",
"441859", "Harris",
"441904", "York",
"441995", "Garstang",
"441913", "Durham",
"441845", "Thirsk",
"441910", "Tyneside\/Durham\/Sunderland",
"441953", "Wymondham",
"441301", "Arrochar",
"441950", "Sandwick",
"441236", "Coatbridge",
"441583", "Carradale",
"441982", "Builth\ Wells",
"441580", "Cranbrook",
"441445", "Gairloch",
"4419644", "Patrington",
"441621", "Maldon",
"441571", "Lochinver",
"441241", "Arbroath",
"441297", "Axminster",
"441483", "Guildford",
"441559", "Llandysul",
"441935", "Yeovil",
"441480", "Huntingdon",
"441989", "Ross\-on\-Wye",
"442887", "Dungannon",
"441452", "Gloucester",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4414234", "Boroughbridge",
"441275", "Clevedon",
"441545", "Llanarth",
"441908", "Milton\ Keynes",
"441689", "Orpington",
"441328", "Fakenham",
"442848", "Northern\ Ireland",
"441635", "Newbury",
"44114702", "Sheffield",
"441785", "Stafford",
"441608", "Chipping\ Norton",
"441769", "South\ Molton",
"441392", "Exeter",
"441665", "Alnwick",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441254", "Blackburn",
"441732", "Sevenoaks",
"441653", "Malton",
"441650", "Cemmaes\ Road",
"441676", "Meriden",
"441526", "Martin",
"441827", "Tamworth",
"441743", "Shrewsbury",
"4412298", "Barrow\-in\-Furness",
"441740", "Sedgefield",
"441724", "Scunthorpe",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441604", "Northampton",
"441200", "Clitheroe",
"441332", "Derby",
"441324", "Falkirk",
"441799", "Saffron\ Walden",
"441340", "Craigellachie\ \(Aberlour\)",
"442820", "Ballycastle",
"442844", "Downpatrick",
"441343", "Elgin",
"442823", "Northern\ Ireland",
"441362", "Dereham",
"441695", "Skelmersdale",
"441427", "Gainsborough",
"4418514", "Great\ Bernera",
"441728", "Saxmundham",
"4412297", "Millom",
"4416860", "Newtown\/Llanidloes",
"441527", "Redditch",
"441792", "Swansea",
"441258", "Blandford",
"441677", "Bedale",
"441369", "Dunoon",
"4419648", "Hornsea",
"4413392", "Aboyne",
"441675", "Coleshill",
"441525", "Leighton\ Buzzard",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441779", "Peterhead",
"441918", "Tyneside",
"4415394", "Hawkshead",
"441484", "Huddersfield",
"441387", "Dumfries",
"441425", "Ringwood",
"4414376", "Haverfordwest",
"4414238", "Harrogate",
"441888", "Turriff",
"441697", "Brampton",
"441641", "Strathy",
"441666", "Malmesbury",
"441772", "Preston",
"4418471", "Thurso\/Tongue",
"441751", "Pickering",
"44115", "Nottingham",
"441809", "Tomdoun",
"441954", "Madingley",
"441636", "Newark\-on\-Trent",
"441786", "Stirling",
"441584", "Ludlow",
"441488", "Hungerford",
"441825", "Uckfield",
"441914", "Tyneside",
"441372", "Esher",
"441142", "Sheffield",
"441409", "Holsworthy",
"4419647", "Patrington",
"441386", "Evesham",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441903", "Worthing",
"441900", "Workington",
"441502", "Lowestoft",
"441379", "Diss",
"441667", "Nairn",
"441588", "Bishops\ Castle",
"441884", "Tiverton",
"4414237", "Harrogate",
"441787", "Sudbury",
"441637", "Newquay",
"441509", "Loughborough",
"4414379", "Haverfordwest",
"441539", "Kendal",
"441955", "Wick",
"441432", "Hereford",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441440", "Haverhill",
"441424", "Hastings",
"441569", "Stonehaven",
"4418512", "Stornoway",
"441443", "Pontypridd",
"441462", "Hitchin",
"441899", "Biggar",
"442847", "Northern\ Ireland",
"4418903", "Coldstream",
"441949", "Whatton",
"442891", "Bangor\ \(Co\.\ Down\)",
"4412291", "Barrow\-in\-Furness\/Millom",
"441327", "Daventry",
"441828", "Coupar\ Angus",
"441256", "Basingstoke",
"441933", "Wellingborough",
"441485", "Hunstanton",
"4414303", "North\ Cave",
"4415079", "Alford\ \(Lincs\)",
"441439", "Helmsley",
"441562", "Kidderminster",
"4416974", "Raughton\ Head",
"441963", "Wincanton",
"441674", "Montrose",
"441524", "Lancaster",
"441540", "Kingussie",
"441270", "Crewe",
"441942", "Wigan",
"441543", "Cannock",
"441892", "Tunbridge\ Wells",
"441273", "Brighton",
"441726", "St\ Austell",
"441469", "Killingholme",
"441885", "Pencombe",
"441606", "Northwich",
"441428", "Haslemere",
"441326", "Falmouth",
"4414345", "Haltwhistle",
"442846", "Northern\ Ireland",
"441599", "Kyle",
"441869", "Bicester",
"441492", "Colwyn\ Bay",
"441678", "Bala",
"4413882", "Stanhope\ \(Eastgate\)",
"441528", "Laggan",
"441257", "Coppull",
"441832", "Clopton",
"441592", "Kirkcaldy",
"441727", "St\ Albans",
"441843", "Thanet",
"441840", "Camelford",
"441824", "Ruthin",
"441915", "Sunderland",
"4415076", "Louth",
"441993", "Witney",
"441499", "Inveraray",
"4416865", "Newtown",
"441862", "Tain",
"441388", "Bishop\ Auckland",
"4414231", "Harrogate\/Boroughbridge",
"441629", "Matlock",
"441472", "Grimsby",
"441249", "Chippenham",
"441579", "Liskeard",
"441917", "Sunderland",
"441725", "Rockbourne",
"4418478", "Thurso",
"441309", "Forres",
"441255", "Clacton\-on\-Sea",
"441451", "Stow\-on\-the\-Wold",
"4416869", "Newtown",
"441263", "Cromer",
"441479", "Grantown\-on\-Spey",
"441622", "Maidstone",
"4419641", "Hornsea\/Patrington",
"441260", "Congleton",
"44121", "Birmingham",
"441664", "Melton\ Mowbray",
"4419758", "Strathdon",
"441572", "Oakham",
"441242", "Cheltenham",
"441970", "Aberystwyth",
"441233", "Ashford\ \(Kent\)",
"4414349", "Bellingham",
"441302", "Doncaster",
"441634", "Medway",
"441981", "Wormbridge",
"441784", "Staines",
"441586", "Campbeltown",
"441887", "Aberfeldy",
"441698", "Motherwell",
"442871", "Londonderry",
"4416866", "Newtown",
"441916", "Tyneside",
"441879", "Scarinish",
"4415075", "Spilsby\ \(Horncastle\)",
"442883", "Northern\ Ireland",
"4415242", "Hornby",
"441384", "Dudley",
"442880", "Carrickmore",
"441487", "Warboys",
"441702", "Southend\-on\-Sea",
"4418477", "Tongue",
"441872", "Truro",
"441325", "Darlington",
"442845", "Northern\ Ireland",
"441293", "Crawley",
"441290", "Cumnock",
"441694", "Church\ Stretton",
"441638", "Newmarket",
"4414346", "Hexham",
"441788", "Rugby",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"44114709", "Sheffield",
"44114705", "Sheffield",
"441957", "Mid\ Yell",
"4419757", "Strathdon",
"4413394", "Ballater",
"441668", "Bamburgh",
"441709", "Rotherham",
"441951", "Colonsay",
"441754", "Skegness",
"441303", "Folkestone",
"4416861", "Newtown\/Llanidloes",
"441556", "Castle\ Douglas",
"441857", "Sanday",
"441300", "Cerne\ Abbas",
"441581", "New\ Luce",
"44283", "Northern\ Ireland",
"441986", "Bungay",
"441620", "North\ Berwick",
"441644", "New\ Galloway",
"4414377", "Haverfordwest",
"441262", "Bridlington",
"441623", "Mansfield",
"441573", "Kelso",
"441243", "Chichester",
"442895", "Belfast",
"4414239", "Boroughbridge",
"441570", "Lampeter",
"441224", "Aberdeen",
"441972", "Glenborrodale",
"44286", "Northern\ Ireland",
"441481", "Guernsey",
"441239", "Cardigan",
"441285", "Cirencester",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441456", "Glenurquhart",
"441269", "Ammanford",
"441473", "Ipswich",
"4417687", "Keswick",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441358", "Ellon",
"442877", "Limavady",
"4419649", "Hornsea",
"442889", "Fivemiletown",
"441987", "Ebbsfleet",
"4414236", "Harrogate",
"4414378", "Haverfordwest",
"441856", "Orkney",
"441557", "Kirkcudbright",
"441228", "Carlisle",
"441870", "Isle\ of\ Benbecula",
"4414302", "North\ Cave",
"441873", "Abergavenny",
"441292", "Ayr",
"441758", "Pwllheli",
"441457", "Glossop",
"4412295", "Barrow\-in\-Furness",
"4419646", "Patrington",
"442882", "Omagh",
"4418902", "Coldstream",
"441700", "Rothesay",
"441354", "Chatteris",
"4418513", "Stornoway",
"4419467", "Gosforth",
"441299", "Bewdley",
"441911", "Tyneside\/Durham\/Sunderland",
"44287", "Northern\ Ireland",
"441962", "Winchester",
"44151", "Liverpool",
"441560", "Moscow",
"4412299", "Millom",
"441449", "Stowmarket",
"441563", "Kilmarnock",
"441542", "Keith",
"441721", "Peebles",
"441924", "Wakefield",
"441943", "Guiseley",
"441932", "Weybridge",
"441530", "Coalville",
"441286", "Caernarfon",
"441455", "Hinckley",
"441442", "Hemel\ Hempstead",
"442867", "Lisnaskea",
"441969", "Leyburn",
"441460", "Chard",
"44141", "Glasgow",
"442896", "Belfast",
"441279", "Bishops\ Stortford",
"441463", "Inverness",
"441549", "Lairg",
"441555", "Lanark",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441939", "Wem",
"442837", "Armagh",
"441433", "Hathersage",
"441985", "Warminster",
"441590", "Lymington",
"441992", "Lea\ Valley",
"4418470", "Thurso\/Tongue",
"441593", "Lybster",
"441842", "Thetford",
"441863", "Ardgay",
"441287", "Guisborough",
"4419645", "Hornsea",
"441833", "Barnard\ Castle",
"4412296", "Barrow\-in\-Furness",
"441928", "Runcorn",
"441830", "Kirkwhelpington",
"442897", "Saintfield",
"442841", "Rostrevor",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"44247", "Coventry",
"442866", "Enniskillen",
"441490", "Corwen",
"441493", "Great\ Yarmouth",
"441855", "Ballachulish",
"4414235", "Harrogate",
"441756", "Skipton",
"441554", "Llanelli",
"4413873", "Langholm",
"4414348", "Hexham",
"44118", "Reading",
"441631", "Oban",
"441984", "Watchet\ \(Williton\)",
"441646", "Milford\ Haven",
"4419759", "Alford\ \(Aberdeen\)",
"4418904", "Coldstream",
"441770", "Isle\ of\ Arran",
"441858", "Market\ Harborough",
"441773", "Ripley",
"441226", "Barnsley",
"441661", "Prudhoe",
"4416868", "Newtown",
"441357", "Strathaven",
"441803", "Torquay",
"441454", "Chipping\ Sodbury",
"4414304", "North\ Cave",
"4418479", "Tongue",
"4416973", "Wigton",
"442310", "Portsmouth",
"441925", "Warrington",
"441403", "Horsham",
"441400", "Honington",
"441854", "Ullapool",
"4419756", "Strathdon",
"441909", "Worksop",
"441757", "Selby",
"441558", "Llandeilo",
"441227", "Canterbury",
"441988", "Wigtown",
"441647", "Moretonhampstead",
"4414347", "Hexham",
"441691", "Oswestry",
"44114704", "Sheffield",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441381", "Fortrose",
"441503", "Looe",
"441356", "Brechin",
"441902", "Wolverhampton",
"4418476", "Tongue",
"441373", "Frome",
"4412290", "Barrow\-in\-Furness\/Millom",
"4416867", "Llanidloes",
"44239", "Portsmouth",
"441458", "Glastonbury",
"441143", "Sheffield",
"441140", "Sheffield",
"441671", "Newton\ Stewart",
"441763", "Royston",
"441760", "Swaffham",
"441926", "Warwick",
"441733", "Peterborough",
"441683", "Moffat",
"441730", "Petersfield",
"4415078", "Alford\ \(Lincs\)",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441284", "Bury\ St\ Edmunds",
"441652", "Brigg",
"441749", "Shepton\ Mallet",
"442894", "Antrim",
"442838", "Portadown",
"441225", "Bath",
"441659", "Sanquhar",
"442868", "Kesh",
"441821", "Kinrossie",
"441793", "Swindon",
"4415077", "Louth",
"442829", "Kilrea",
"441349", "Dingwall",
"441790", "Spilsby",
"4419640", "Hornsea\/Patrington",
"441288", "Bude",
"4418475", "Thurso",
"441355", "East\ Kilbride",
"441209", "Redruth",
"441342", "East\ Grinstead",
"442822", "Northern\ Ireland",
"44131", "Edinburgh",
"441360", "Killearn",
"441363", "Crediton",
"4414230", "Harrogate\/Boroughbridge",
"44280", "Northern\ Ireland",
"4419755", "Alford\ \(Aberdeen\)",
"441202", "Bournemouth",
"44114700", "Sheffield",
"441330", "Banchory",
"4413393", "Aboyne",
"442898", "Belfast",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-9]\d{5})$|0|180020)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;