#!/usr/bin/perl -w

# Copyright 2015, 2016, 2017, 2018, 2019 Kevin Ryde
#
# This file is part of Graph-Maker-Other.
#
# Graph-Maker-Other is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Graph-Maker-Other is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Graph-Maker-Other.  If not, see <http://www.gnu.org/licenses/>.

use 5.005;
use strict;
use List::Util 'min';
use Math::BaseCnv 'cnv';

use FindBin;
use File::Spec;
use lib File::Spec->catdir($FindBin::Bin, File::Spec->updir, 'devel', 'lib');
use MyGraphs;
$|=1;

# uncomment this to run the ### lines
# use Smart::Comments;


{
  # vpar_count_free(11) == 235
  # vpar_count_free(12) == 551

  # first 0 = path
  # last  M = star

  my @coeffs = (
                [[1],
                ],
                [[1, 0],
                ],
                [[1, 2, 0],
                ],
                [[1, 4, 3, 0],
                ],
                [[1, 6, 10, 4, 0],
                 [1, 6, 9, 4, 0],
                ],
                [[1, 8, 21, 20, 5, 0],
                 [1, 8, 20, 18, 5, 0],
                 [1, 8, 18, 16, 5, 0],
                ],
                [[1, 10, 36, 56, 35, 6, 0],
                 [1, 10, 35, 52, 32, 6, 0],
                 [1, 10, 34, 48, 29, 6, 0],
                 [1, 10, 35, 52, 31, 6, 0],
                 [1, 10, 33, 46, 28, 6, 0],
                 [1, 10, 30, 40, 25, 6, 0],
                ],
                [[1, 12, 55, 120, 126, 56, 7, 0],
                 [1, 12, 54, 114, 116, 52, 7, 0],
                 [1, 12, 54, 114, 115, 50, 7, 0],
                 [1, 12, 52, 104, 102, 46, 7, 0],
                 [1, 12, 53, 108, 107, 48, 7, 0],
                 [1, 12, 53, 108, 105, 46, 7, 0],
                 [1, 12, 51, 98, 93, 42, 7, 0],
                 [1, 12, 54, 114, 114, 48, 7, 0],
                 [1, 12, 52, 104, 100, 44, 7, 0],
                 [1, 12, 49, 92, 87, 40, 7, 0],
                 [1, 12, 45, 80, 75, 36, 7, 0],
                ],
                [[1, 14, 78, 220, 330, 252, 84, 8, 0],
                 [1, 14, 77, 212, 309, 232, 79, 8, 0],
                 [1, 14, 76, 204, 289, 214, 74, 8, 0],
                 [1, 14, 77, 212, 308, 228, 76, 8, 0],
                 [1, 14, 76, 204, 288, 210, 71, 8, 0],
                 [1, 14, 76, 204, 286, 204, 68, 8, 0],
                 [1, 14, 77, 212, 308, 228, 75, 8, 0],
                 [1, 14, 75, 198, 277, 204, 71, 8, 0],
                 [1, 14, 76, 204, 287, 208, 70, 8, 0],
                 [1, 14, 77, 212, 307, 224, 72, 8, 0],
                 [1, 14, 75, 198, 275, 198, 67, 8, 0],
                 [1, 14, 72, 180, 241, 174, 62, 8, 0],
                 [1, 14, 74, 190, 259, 188, 66, 8, 0],
                 [1, 14, 74, 190, 256, 182, 63, 8, 0],
                 [1, 14, 72, 176, 229, 162, 58, 8, 0],
                 [1, 14, 75, 196, 267, 190, 65, 8, 0],
                 [1, 14, 76, 204, 286, 204, 67, 8, 0],
                 [1, 14, 74, 190, 255, 180, 62, 8, 0],
                 [1, 14, 71, 172, 223, 158, 57, 8, 0],
                 [1, 14, 75, 198, 273, 192, 64, 8, 0],
                 [1, 14, 72, 180, 238, 168, 59, 8, 0],
                 [1, 14, 68, 160, 205, 146, 54, 8, 0],
                 [1, 14, 63, 140, 175, 126, 49, 8, 0],
                ],
                [[1, 16, 105, 364, 715, 792, 462, 120, 9, 0],
                 [1, 16, 104, 354, 679, 736, 427, 114, 9, 0],
                 [1, 16, 104, 354, 678, 730, 417, 110, 9, 0],
                 [1, 16, 104, 354, 678, 730, 416, 108, 9, 0],
                 [1, 16, 102, 336, 621, 654, 377, 104, 9, 0],
                 [1, 16, 103, 344, 642, 674, 381, 102, 9, 0],
                 [1, 16, 103, 344, 644, 684, 395, 108, 9, 0],
                 [1, 16, 103, 344, 643, 678, 386, 104, 9, 0],
                 [1, 16, 103, 344, 643, 678, 384, 102, 9, 0],
                 [1, 16, 101, 326, 588, 608, 349, 98, 9, 0],
                 [1, 16, 102, 334, 608, 626, 352, 96, 9, 0],
                 [1, 16, 103, 344, 642, 672, 375, 98, 9, 0],
                 [1, 16, 101, 326, 586, 598, 335, 92, 9, 0],
                 [1, 16, 104, 354, 677, 724, 406, 104, 9, 0],
                 [1, 16, 102, 336, 619, 644, 363, 98, 9, 0],
                 [1, 16, 103, 344, 642, 672, 376, 100, 9, 0],
                 [1, 16, 103, 344, 641, 668, 371, 98, 9, 0],
                 [1, 16, 101, 326, 587, 602, 340, 94, 9, 0],
                 [1, 16, 102, 334, 606, 616, 340, 92, 9, 0],
                 [1, 16, 103, 344, 640, 662, 361, 94, 9, 0],
                 [1, 16, 101, 326, 583, 586, 322, 88, 9, 0],
                 [1, 16, 104, 354, 677, 724, 405, 102, 9, 0],
                 [1, 16, 102, 336, 619, 644, 361, 96, 9, 0],
                 [1, 16, 99, 312, 552, 564, 323, 92, 9, 0],
                 [1, 16, 101, 326, 585, 596, 334, 92, 9, 0],
                 [1, 16, 103, 344, 641, 668, 370, 96, 9, 0],
                 [1, 16, 101, 326, 584, 592, 329, 90, 9, 0],
                 [1, 16, 102, 336, 617, 634, 348, 92, 9, 0],
                 [1, 16, 99, 312, 549, 552, 308, 86, 9, 0],
                 [1, 16, 95, 284, 480, 476, 271, 80, 9, 0],
                 [1, 16, 98, 302, 522, 524, 298, 86, 9, 0],
                 [1, 16, 98, 302, 518, 512, 286, 82, 9, 0],
                 [1, 16, 99, 308, 536, 540, 307, 88, 9, 0],
                 [1, 16, 100, 316, 552, 550, 306, 86, 9, 0],
                 [1, 16, 101, 326, 584, 590, 325, 88, 9, 0],
                 [1, 16, 99, 308, 530, 522, 289, 82, 9, 0],
                 [1, 16, 96, 284, 470, 456, 256, 76, 9, 0],
                 [1, 16, 102, 334, 606, 616, 338, 90, 9, 0],
                 [1, 16, 100, 316, 550, 544, 300, 84, 9, 0],
                 [1, 16, 101, 326, 582, 582, 317, 86, 9, 0],
                 [1, 16, 98, 302, 516, 506, 280, 80, 9, 0],
                 [1, 16, 94, 274, 450, 436, 246, 74, 9, 0],
                 [1, 16, 102, 336, 615, 624, 334, 88, 9, 0],
                 [1, 16, 99, 312, 546, 540, 295, 82, 9, 0],
                 [1, 16, 95, 284, 476, 464, 259, 76, 9, 0],
                 [1, 16, 90, 254, 410, 396, 226, 70, 9, 0],
                 [1, 16, 84, 224, 350, 336, 196, 64, 9, 0],
                ],
                [[1, 18, 136, 560, 1365, 2002, 1716, 792, 165, 10, 0],
                 [1, 18, 135, 548, 1310, 1882, 1590, 736, 158, 10, 0],
                 [1, 18, 134, 536, 1256, 1768, 1474, 684, 151, 10, 0],
                 [1, 18, 135, 548, 1309, 1874, 1569, 716, 153, 10, 0],
                 [1, 18, 134, 536, 1255, 1760, 1454, 666, 146, 10, 0],
                 [1, 18, 134, 536, 1254, 1752, 1434, 648, 141, 10, 0],
                 [1, 18, 135, 548, 1309, 1874, 1568, 712, 150, 10, 0],
                 [1, 18, 134, 536, 1255, 1760, 1453, 662, 143, 10, 0],
                 [1, 18, 134, 536, 1254, 1752, 1432, 642, 138, 10, 0],
                 [1, 18, 134, 536, 1253, 1746, 1420, 632, 135, 10, 0],
                 [1, 18, 135, 548, 1309, 1874, 1568, 712, 149, 10, 0],
                 [1, 18, 133, 526, 1218, 1698, 1408, 654, 146, 10, 0],
                 [1, 18, 134, 536, 1254, 1754, 1442, 656, 143, 10, 0],
                 [1, 18, 134, 536, 1255, 1760, 1452, 660, 142, 10, 0],
                 [1, 18, 135, 548, 1308, 1866, 1547, 692, 145, 10, 0],
                 [1, 18, 133, 526, 1216, 1684, 1376, 626, 138, 10, 0],
                 [1, 18, 134, 536, 1253, 1746, 1421, 636, 137, 10, 0],
                 [1, 18, 135, 548, 1308, 1866, 1546, 688, 141, 10, 0],
                 [1, 18, 133, 526, 1216, 1684, 1374, 620, 134, 10, 0],
                 [1, 18, 130, 496, 1104, 1488, 1210, 564, 131, 10, 0],
                 [1, 18, 132, 514, 1163, 1576, 1270, 578, 130, 10, 0],
                 [1, 18, 132, 514, 1166, 1594, 1306, 608, 139, 10, 0],
                 [1, 18, 132, 514, 1165, 1586, 1288, 592, 134, 10, 0],
                 [1, 18, 132, 514, 1165, 1586, 1285, 586, 131, 10, 0],
                 [1, 18, 130, 492, 1080, 1436, 1158, 540, 127, 10, 0],
                 [1, 18, 134, 536, 1253, 1746, 1420, 632, 134, 10, 0],
                 [1, 18, 132, 514, 1162, 1570, 1258, 568, 127, 10, 0],
                 [1, 18, 133, 524, 1201, 1646, 1337, 610, 136, 10, 0],
                 [1, 18, 133, 524, 1200, 1638, 1317, 592, 131, 10, 0],
                 [1, 18, 133, 524, 1199, 1632, 1305, 582, 128, 10, 0],
                 [1, 18, 131, 502, 1113, 1482, 1183, 540, 124, 10, 0],
                 [1, 18, 132, 512, 1146, 1524, 1200, 536, 121, 10, 0],
                 [1, 18, 133, 524, 1202, 1652, 1345, 612, 135, 10, 0],
                 [1, 18, 134, 536, 1254, 1752, 1433, 644, 138, 10, 0],
                 [1, 18, 132, 514, 1164, 1580, 1276, 582, 131, 10, 0],
                 [1, 18, 133, 524, 1200, 1638, 1316, 590, 130, 10, 0],
                 [1, 18, 134, 536, 1254, 1752, 1431, 638, 134, 10, 0],
                 [1, 18, 132, 514, 1164, 1580, 1272, 574, 127, 10, 0],
                 [1, 18, 129, 484, 1055, 1396, 1123, 524, 124, 10, 0],
                 [1, 18, 131, 502, 1112, 1478, 1177, 536, 123, 10, 0],
                 [1, 18, 133, 524, 1200, 1638, 1315, 586, 127, 10, 0],
                 [1, 18, 131, 502, 1111, 1472, 1165, 526, 120, 10, 0],
                 [1, 18, 132, 514, 1162, 1566, 1243, 552, 122, 10, 0],
                 [1, 18, 129, 484, 1052, 1378, 1087, 494, 115, 10, 0],
                 [1, 18, 133, 526, 1214, 1670, 1343, 596, 129, 10, 0],
                 [1, 18, 134, 536, 1253, 1744, 1412, 624, 133, 10, 0],
                 [1, 18, 134, 536, 1252, 1738, 1399, 612, 130, 10, 0],
                 [1, 18, 132, 514, 1164, 1578, 1267, 570, 126, 10, 0],
                 [1, 18, 133, 524, 1198, 1624, 1285, 564, 123, 10, 0],
                 [1, 18, 134, 536, 1251, 1730, 1378, 592, 125, 10, 0],
                 [1, 18, 130, 496, 1101, 1470, 1174, 534, 122, 10, 0],
                 [1, 18, 132, 514, 1163, 1572, 1256, 564, 126, 10, 0],
                 [1, 18, 132, 514, 1161, 1562, 1239, 552, 123, 10, 0],
                 [1, 18, 130, 492, 1078, 1422, 1128, 514, 119, 10, 0],
                 [1, 18, 131, 502, 1109, 1458, 1139, 508, 116, 10, 0],
                 [1, 18, 132, 514, 1160, 1554, 1219, 534, 118, 10, 0],
                 [1, 18, 130, 492, 1072, 1392, 1078, 480, 111, 10, 0],
                 [1, 18, 133, 524, 1198, 1624, 1286, 568, 125, 10, 0],
                 [1, 18, 134, 536, 1252, 1738, 1399, 612, 129, 10, 0],
                 [1, 18, 132, 514, 1161, 1562, 1238, 550, 122, 10, 0],
                 [1, 18, 129, 484, 1054, 1388, 1105, 508, 119, 10, 0],
                 [1, 18, 131, 502, 1110, 1464, 1150, 516, 118, 10, 0],
                 [1, 18, 133, 524, 1198, 1624, 1284, 562, 122, 10, 0],
                 [1, 18, 131, 502, 1108, 1454, 1133, 504, 115, 10, 0],
                 [1, 18, 132, 514, 1159, 1548, 1208, 528, 117, 10, 0],
                 [1, 18, 129, 484, 1048, 1358, 1054, 472, 110, 10, 0],
                 [1, 18, 135, 548, 1308, 1866, 1545, 684, 138, 10, 0],
                 [1, 18, 134, 536, 1253, 1746, 1419, 628, 131, 10, 0],
                 [1, 18, 133, 526, 1214, 1670, 1341, 590, 126, 10, 0],
                 [1, 18, 130, 496, 1101, 1470, 1171, 528, 119, 10, 0],
                 [1, 18, 126, 460, 980, 1276, 1018, 476, 115, 10, 0],
                 [1, 18, 129, 484, 1051, 1376, 1087, 496, 116, 10, 0],
                 [1, 18, 132, 514, 1162, 1568, 1249, 556, 122, 10, 0],
                 [1, 18, 130, 492, 1074, 1406, 1104, 498, 115, 10, 0],
                 [1, 18, 133, 524, 1199, 1632, 1303, 576, 124, 10, 0],
                 [1, 18, 132, 514, 1160, 1556, 1226, 540, 119, 10, 0],
                 [1, 18, 129, 484, 1049, 1366, 1069, 482, 112, 10, 0],
                 [1, 18, 133, 526, 1212, 1656, 1309, 564, 121, 10, 0],
                 [1, 18, 130, 496, 1098, 1452, 1137, 504, 114, 10, 0],
                 [1, 18, 126, 460, 976, 1256, 982, 448, 107, 10, 0],
                 [1, 18, 121, 420, 855, 1076, 843, 396, 100, 10, 0],
                 [1, 18, 125, 448, 935, 1196, 943, 440, 108, 10, 0],
                 [1, 18, 125, 448, 930, 1176, 913, 420, 103, 10, 0],
                 [1, 18, 127, 462, 975, 1256, 993, 462, 112, 10, 0],
                 [1, 18, 128, 472, 1002, 1284, 1000, 456, 109, 10, 0],
                 [1, 18, 129, 484, 1050, 1368, 1069, 480, 111, 10, 0],
                 [1, 18, 127, 462, 967, 1224, 945, 430, 104, 10, 0],
                 [1, 18, 124, 432, 870, 1076, 828, 384, 97, 10, 0],
                 [1, 18, 129, 480, 1026, 1320, 1029, 468, 111, 10, 0],
                 [1, 18, 131, 502, 1110, 1464, 1147, 510, 115, 10, 0],
                 [1, 18, 129, 480, 1023, 1308, 1011, 456, 108, 10, 0],
                 [1, 18, 130, 492, 1072, 1392, 1077, 478, 110, 10, 0],
                 [1, 18, 127, 462, 966, 1220, 939, 426, 103, 10, 0],
                 [1, 18, 123, 426, 855, 1056, 813, 378, 96, 10, 0],
                 [1, 18, 132, 512, 1146, 1524, 1196, 528, 117, 10, 0],
                 [1, 18, 131, 502, 1107, 1448, 1121, 494, 112, 10, 0],
                 [1, 18, 128, 472, 998, 1268, 976, 440, 105, 10, 0],
                 [1, 18, 132, 514, 1158, 1542, 1195, 516, 114, 10, 0],
                 [1, 18, 129, 484, 1046, 1348, 1037, 460, 107, 10, 0],
                 [1, 18, 125, 448, 927, 1164, 895, 408, 100, 10, 0],
                 [1, 18, 120, 408, 810, 996, 768, 360, 93, 10, 0],
                 [1, 18, 130, 496, 1095, 1434, 1102, 480, 109, 10, 0],
                 [1, 18, 126, 460, 972, 1236, 949, 426, 102, 10, 0],
                 [1, 18, 121, 420, 850, 1056, 813, 376, 95, 10, 0],
                 [1, 18, 115, 378, 735, 896, 693, 330, 88, 10, 0],
                 [1, 18, 108, 336, 630, 756, 588, 288, 81, 10, 0],
                ],
                [[1, 20, 171, 816, 2380, 4368, 5005, 3432, 1287, 220, 11, 0],
                 [1, 20, 170, 802, 2302, 4148, 4675, 3180, 1203, 212, 11, 0],
                 [1, 20, 170, 802, 2301, 4138, 4639, 3124, 1168, 206, 11, 0],
                 [1, 20, 170, 802, 2301, 4138, 4638, 3118, 1158, 202, 11, 0],
                 [1, 20, 170, 802, 2301, 4138, 4638, 3118, 1157, 200, 11, 0],
                 [1, 20, 168, 776, 2168, 3798, 4183, 2816, 1077, 198, 11, 0],
                 [1, 20, 169, 788, 2223, 3918, 4308, 2866, 1074, 194, 11, 0],
                 [1, 20, 169, 788, 2224, 3926, 4329, 2886, 1078, 192, 11, 0],
                 [1, 20, 169, 788, 2225, 3936, 4366, 2948, 1124, 204, 11, 0],
                 [1, 20, 169, 788, 2224, 3926, 4331, 2896, 1092, 198, 11, 0],
                 [1, 20, 169, 788, 2224, 3926, 4330, 2890, 1083, 194, 11, 0],
                 [1, 20, 169, 788, 2224, 3926, 4330, 2890, 1081, 192, 11, 0],
                 [1, 20, 167, 762, 2093, 3600, 3906, 2612, 1006, 190, 11, 0],
                 [1, 20, 168, 774, 2147, 3714, 4021, 2658, 1004, 186, 11, 0],
                 [1, 20, 168, 774, 2148, 3722, 4041, 2676, 1007, 184, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4295, 2838, 1051, 188, 11, 0],
                 [1, 20, 167, 762, 2091, 3582, 3850, 2536, 960, 180, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3986, 2606, 970, 178, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4294, 2832, 1040, 182, 11, 0],
                 [1, 20, 167, 762, 2091, 3582, 3848, 2526, 946, 174, 11, 0],
                 [1, 20, 170, 802, 2300, 4128, 4602, 3062, 1123, 196, 11, 0],
                 [1, 20, 168, 776, 2166, 3780, 4125, 2734, 1027, 188, 11, 0],
                 [1, 20, 169, 788, 2222, 3908, 4272, 2810, 1038, 186, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4296, 2844, 1061, 192, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4295, 2838, 1051, 188, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4294, 2834, 1046, 186, 11, 0],
                 [1, 20, 167, 762, 2092, 3590, 3873, 2566, 978, 184, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3987, 2610, 975, 180, 11, 0],
                 [1, 20, 168, 774, 2147, 3712, 4006, 2624, 975, 178, 11, 0],
                 [1, 20, 169, 788, 2222, 3906, 4260, 2786, 1020, 182, 11, 0],
                 [1, 20, 167, 762, 2090, 3572, 3817, 2490, 932, 174, 11, 0],
                 [1, 20, 168, 774, 2145, 3694, 3951, 2554, 939, 172, 11, 0],
                 [1, 20, 169, 788, 2222, 3906, 4258, 2776, 1005, 176, 11, 0],
                 [1, 20, 167, 762, 2090, 3572, 3813, 2474, 914, 168, 11, 0],
                 [1, 20, 170, 802, 2300, 4128, 4601, 3056, 1112, 190, 11, 0],
                 [1, 20, 168, 776, 2166, 3780, 4123, 2724, 1013, 182, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4293, 2828, 1038, 184, 11, 0],
                 [1, 20, 169, 788, 2222, 3908, 4271, 2804, 1028, 182, 11, 0],
                 [1, 20, 167, 762, 2092, 3590, 3872, 2560, 969, 180, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3985, 2600, 963, 176, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3984, 2596, 958, 174, 11, 0],
                 [1, 20, 169, 788, 2222, 3906, 4258, 2776, 1006, 178, 11, 0],
                 [1, 20, 167, 762, 2090, 3572, 3814, 2478, 919, 170, 11, 0],
                 [1, 20, 168, 774, 2144, 3686, 3928, 2524, 921, 168, 11, 0],
                 [1, 20, 169, 788, 2221, 3898, 4234, 2742, 983, 172, 11, 0],
                 [1, 20, 167, 762, 2088, 3558, 3778, 2434, 893, 164, 11, 0],
                 [1, 20, 170, 802, 2300, 4128, 4601, 3056, 1111, 188, 11, 0],
                 [1, 20, 168, 776, 2166, 3780, 4123, 2724, 1011, 180, 11, 0],
                 [1, 20, 165, 740, 1997, 3384, 3634, 2420, 936, 180, 11, 0],
                 [1, 20, 167, 762, 2090, 3576, 3837, 2522, 952, 178, 11, 0],
                 [1, 20, 167, 762, 2092, 3590, 3870, 2554, 963, 178, 11, 0],
                 [1, 20, 169, 788, 2222, 3908, 4271, 2804, 1028, 182, 11, 0],
                 [1, 20, 167, 762, 2089, 3568, 3814, 2492, 934, 174, 11, 0],
                 [1, 20, 168, 774, 2145, 3696, 3963, 2576, 952, 174, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4293, 2828, 1035, 180, 11, 0],
                 [1, 20, 167, 762, 2091, 3582, 3846, 2520, 940, 172, 11, 0],
                 [1, 20, 168, 776, 2164, 3762, 4066, 2648, 973, 176, 11, 0],
                 [1, 20, 169, 788, 2221, 3898, 4235, 2748, 993, 176, 11, 0],
                 [1, 20, 165, 740, 1994, 3360, 3565, 2330, 882, 168, 11, 0],
                 [1, 20, 167, 762, 2088, 3558, 3780, 2444, 905, 168, 11, 0],
                 [1, 20, 169, 788, 2221, 3898, 4235, 2748, 992, 174, 11, 0],
                 [1, 20, 167, 762, 2088, 3558, 3779, 2440, 900, 166, 11, 0],
                 [1, 20, 170, 802, 2300, 4128, 4600, 3050, 1101, 184, 11, 0],
                 [1, 20, 169, 788, 2222, 3908, 4270, 2798, 1017, 176, 11, 0],
                 [1, 20, 168, 776, 2164, 3762, 4064, 2638, 958, 170, 11, 0],
                 [1, 20, 165, 740, 1994, 3360, 3562, 2318, 867, 162, 11, 0],
                 [1, 20, 161, 696, 1805, 2952, 3090, 2036, 796, 160, 11, 0],
                 [1, 20, 164, 726, 1921, 3176, 3321, 2158, 822, 160, 11, 0],
                 [1, 20, 164, 726, 1925, 3204, 3393, 2246, 874, 172, 11, 0],
                 [1, 20, 164, 726, 1924, 3194, 3363, 2206, 849, 166, 11, 0],
                 [1, 20, 164, 726, 1924, 3194, 3359, 2194, 837, 162, 11, 0],
                 [1, 20, 167, 762, 2089, 3566, 3801, 2464, 909, 166, 11, 0],
                 [1, 20, 165, 736, 1959, 3246, 3386, 2184, 822, 158, 11, 0],
                 [1, 20, 166, 748, 2016, 3386, 3581, 2340, 889, 170, 11, 0],
                 [1, 20, 166, 748, 2015, 3376, 3548, 2294, 861, 164, 11, 0],
                 [1, 20, 166, 748, 2014, 3368, 3526, 2266, 844, 160, 11, 0],
                 [1, 20, 165, 736, 1965, 3288, 3494, 2316, 900, 176, 11, 0],
                 [1, 20, 166, 748, 2017, 3392, 3595, 2356, 898, 172, 11, 0],
                 [1, 20, 166, 748, 2018, 3400, 3611, 2366, 897, 170, 11, 0],
                 [1, 20, 167, 762, 2091, 3580, 3839, 2514, 941, 174, 11, 0],
                 [1, 20, 165, 736, 1963, 3270, 3442, 2248, 858, 166, 11, 0],
                 [1, 20, 166, 748, 2016, 3382, 3560, 2304, 864, 164, 11, 0],
                 [1, 20, 167, 762, 2091, 3580, 3836, 2502, 926, 168, 11, 0],
                 [1, 20, 165, 736, 1963, 3270, 3436, 2230, 840, 160, 11, 0],
                 [1, 20, 162, 700, 1803, 2922, 3035, 1992, 780, 158, 11, 0],
                 [1, 20, 164, 722, 1890, 3088, 3199, 2070, 791, 156, 11, 0],
                 [1, 20, 166, 748, 2016, 3382, 3559, 2298, 855, 160, 11, 0],
                 [1, 20, 164, 722, 1889, 3080, 3177, 2042, 774, 152, 11, 0],
                 [1, 20, 165, 736, 1961, 3252, 3385, 2168, 807, 154, 11, 0],
                 [1, 20, 162, 700, 1800, 2898, 2969, 1908, 729, 146, 11, 0],
                 [1, 20, 168, 774, 2145, 3696, 3961, 2566, 938, 168, 11, 0],
                 [1, 20, 167, 762, 2087, 3550, 3756, 2410, 882, 162, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3985, 2600, 961, 174, 11, 0],
                 [1, 20, 168, 774, 2145, 3694, 3950, 2548, 929, 168, 11, 0],
                 [1, 20, 168, 774, 2144, 3686, 3926, 2514, 908, 164, 11, 0],
                 [1, 20, 164, 726, 1919, 3162, 3285, 2114, 796, 154, 11, 0],
                 [1, 20, 166, 748, 2015, 3378, 3559, 2312, 872, 166, 11, 0],
                 [1, 20, 166, 748, 2014, 3368, 3525, 2264, 843, 160, 11, 0],
                 [1, 20, 166, 748, 2012, 3354, 3491, 2226, 823, 156, 11, 0],
                 [1, 20, 167, 760, 2070, 3500, 3698, 2392, 893, 168, 11, 0],
                 [1, 20, 167, 760, 2070, 3500, 3696, 2386, 887, 166, 11, 0],
                 [1, 20, 168, 774, 2145, 3694, 3951, 2552, 934, 170, 11, 0],
                 [1, 20, 166, 748, 2015, 3374, 3539, 2280, 852, 162, 11, 0],
                 [1, 20, 167, 760, 2068, 3482, 3642, 2320, 853, 160, 11, 0],
                 [1, 20, 168, 774, 2144, 3686, 3927, 2518, 911, 164, 11, 0],
                 [1, 20, 166, 748, 2013, 3360, 3503, 2236, 826, 156, 11, 0],
                 [1, 20, 163, 712, 1852, 3014, 3118, 2020, 775, 154, 11, 0],
                 [1, 20, 165, 734, 1940, 3178, 3270, 2084, 781, 152, 11, 0],
                 [1, 20, 167, 760, 2068, 3482, 3640, 2310, 841, 156, 11, 0],
                 [1, 20, 165, 734, 1938, 3164, 3236, 2046, 761, 148, 11, 0],
                 [1, 20, 166, 748, 2011, 3342, 3449, 2170, 792, 150, 11, 0],
                 [1, 20, 163, 712, 1846, 2972, 3016, 1906, 715, 142, 11, 0],
                 [1, 20, 168, 774, 2147, 3712, 4005, 2618, 964, 172, 11, 0],
                 [1, 20, 166, 748, 2017, 3392, 3587, 2332, 874, 164, 11, 0],
                 [1, 20, 167, 762, 2089, 3564, 3793, 2456, 909, 168, 11, 0],
                 [1, 20, 168, 774, 2145, 3694, 3949, 2544, 926, 168, 11, 0],
                 [1, 20, 164, 726, 1922, 3180, 3327, 2162, 823, 160, 11, 0],
                 [1, 20, 166, 748, 2014, 3368, 3525, 2264, 843, 160, 11, 0],
                 [1, 20, 168, 774, 2145, 3694, 3949, 2544, 924, 166, 11, 0],
                 [1, 20, 166, 748, 2014, 3368, 3523, 2258, 837, 158, 11, 0],
                 [1, 20, 169, 788, 2223, 3916, 4292, 2822, 1026, 176, 11, 0],
                 [1, 20, 168, 774, 2146, 3704, 3983, 2590, 947, 168, 11, 0],
                 [1, 20, 167, 762, 2089, 3564, 3789, 2440, 891, 162, 11, 0],
                 [1, 20, 164, 726, 1922, 3180, 3321, 2144, 805, 154, 11, 0],
                 [1, 20, 160, 682, 1737, 2792, 2885, 1890, 742, 152, 11, 0],
                 [1, 20, 163, 712, 1850, 3004, 3098, 2000, 765, 152, 11, 0],
                 [1, 20, 166, 748, 2015, 3376, 3545, 2282, 846, 158, 11, 0],
                 [1, 20, 164, 722, 1887, 3070, 3157, 2022, 764, 150, 11, 0],
                 [1, 20, 167, 760, 2070, 3500, 3694, 2376, 873, 160, 11, 0],
                 [1, 20, 166, 748, 2013, 3360, 3501, 2230, 820, 154, 11, 0],
                 [1, 20, 163, 712, 1848, 2990, 3062, 1956, 739, 146, 11, 0],
                 [1, 20, 167, 762, 2087, 3546, 3733, 2366, 851, 156, 11, 0],
                 [1, 20, 164, 726, 1919, 3156, 3257, 2070, 768, 148, 11, 0],
                 [1, 20, 160, 682, 1733, 2764, 2813, 1802, 690, 140, 11, 0],
                 [1, 20, 168, 776, 2162, 3744, 4006, 2558, 915, 164, 11, 0],
                 [1, 20, 165, 740, 1991, 3336, 3495, 2238, 827, 156, 11, 0],
                 [1, 20, 167, 762, 2088, 3554, 3758, 2404, 878, 162, 11, 0],
                 [1, 20, 167, 762, 2086, 3540, 3722, 2362, 856, 158, 11, 0],
                 [1, 20, 169, 788, 2221, 3896, 4223, 2724, 975, 172, 11, 0],
                 [1, 20, 167, 762, 2089, 3562, 3781, 2432, 891, 164, 11, 0],
                 [1, 20, 168, 774, 2143, 3676, 3893, 2472, 890, 162, 11, 0],
                 [1, 20, 169, 788, 2220, 3888, 4198, 2686, 948, 166, 11, 0],
                 [1, 20, 167, 762, 2087, 3548, 3743, 2382, 861, 158, 11, 0],
                 [1, 20, 164, 726, 1923, 3184, 3329, 2154, 812, 156, 11, 0],
                 [1, 20, 166, 748, 2013, 3358, 3493, 2220, 816, 154, 11, 0],
                 [1, 20, 168, 774, 2143, 3676, 3891, 2462, 876, 158, 11, 0],
                 [1, 20, 166, 748, 2011, 3344, 3457, 2178, 794, 150, 11, 0],
                 [1, 20, 167, 762, 2085, 3530, 3687, 2310, 825, 152, 11, 0],
                 [1, 20, 164, 726, 1917, 3142, 3221, 2028, 746, 144, 11, 0],
                 [1, 20, 161, 696, 1801, 2924, 3018, 1948, 744, 148, 11, 0],
                 [1, 20, 164, 726, 1921, 3170, 3294, 2116, 795, 154, 11, 0],
                 [1, 20, 164, 726, 1918, 3152, 3254, 2074, 774, 150, 11, 0],
                 [1, 20, 165, 736, 1961, 3252, 3386, 2172, 812, 156, 11, 0],
                 [1, 20, 166, 748, 2012, 3350, 3472, 2200, 810, 154, 11, 0],
                 [1, 20, 167, 762, 2087, 3548, 3744, 2386, 864, 158, 11, 0],
                 [1, 20, 165, 736, 1957, 3228, 3332, 2114, 782, 150, 11, 0],
                 [1, 20, 162, 700, 1801, 2904, 2983, 1924, 738, 148, 11, 0],
                 [1, 20, 164, 722, 1886, 3056, 3117, 1976, 741, 146, 11, 0],
                 [1, 20, 166, 748, 2012, 3350, 3469, 2188, 797, 150, 11, 0],
                 [1, 20, 164, 722, 1883, 3038, 3077, 1934, 720, 142, 11, 0],
                 [1, 20, 165, 736, 1955, 3210, 3279, 2050, 749, 144, 11, 0],
                 [1, 20, 162, 700, 1792, 2850, 2863, 1798, 675, 136, 11, 0],
                 [1, 20, 168, 774, 2143, 3676, 3892, 2468, 885, 160, 11, 0],
                 [1, 20, 166, 748, 2011, 3344, 3458, 2184, 801, 152, 11, 0],
                 [1, 20, 169, 788, 2221, 3898, 4234, 2742, 982, 170, 11, 0],
                 [1, 20, 168, 774, 2144, 3686, 3926, 2514, 906, 162, 11, 0],
                 [1, 20, 167, 762, 2086, 3540, 3721, 2358, 851, 156, 11, 0],
                 [1, 20, 164, 726, 1918, 3152, 3252, 2068, 768, 148, 11, 0],
                 [1, 20, 160, 682, 1736, 2782, 2855, 1850, 717, 146, 11, 0],
                 [1, 20, 163, 712, 1848, 2986, 3050, 1944, 735, 146, 11, 0],
                 [1, 20, 166, 748, 2013, 3358, 3491, 2214, 810, 152, 11, 0],
                 [1, 20, 164, 722, 1884, 3046, 3097, 1956, 731, 144, 11, 0],
                 [1, 20, 167, 760, 2068, 3482, 3638, 2304, 835, 154, 11, 0],
                 [1, 20, 166, 748, 2010, 3336, 3435, 2154, 783, 148, 11, 0],
                 [1, 20, 163, 712, 1844, 2962, 2996, 1886, 705, 140, 11, 0],
                 [1, 20, 167, 762, 2084, 3522, 3664, 2282, 812, 150, 11, 0],
                 [1, 20, 164, 726, 1915, 3128, 3187, 1994, 732, 142, 11, 0],
                 [1, 20, 160, 682, 1728, 2734, 2747, 1734, 657, 134, 11, 0],
                 [1, 20, 168, 776, 2164, 3762, 4062, 2628, 945, 166, 11, 0],
                 [1, 20, 167, 762, 2089, 3566, 3800, 2458, 900, 162, 11, 0],
                 [1, 20, 167, 762, 2087, 3550, 3754, 2400, 870, 158, 11, 0],
                 [1, 20, 168, 776, 2162, 3744, 4004, 2548, 901, 160, 11, 0],
                 [1, 20, 165, 740, 1991, 3336, 3492, 2226, 814, 152, 11, 0],
                 [1, 20, 161, 696, 1801, 2924, 3014, 1936, 732, 144, 11, 0],
                 [1, 20, 156, 646, 1605, 2532, 2585, 1686, 666, 140, 11, 0],
                 [1, 20, 160, 682, 1732, 2762, 2815, 1810, 697, 142, 11, 0],
                 [1, 20, 164, 726, 1920, 3166, 3287, 2106, 785, 150, 11, 0],
                 [1, 20, 162, 700, 1795, 2874, 2923, 1864, 708, 142, 11, 0],
                 [1, 20, 166, 748, 2014, 3368, 3523, 2254, 829, 154, 11, 0],
                 [1, 20, 165, 736, 1957, 3228, 3331, 2110, 777, 148, 11, 0],
                 [1, 20, 162, 700, 1794, 2868, 2909, 1848, 699, 140, 11, 0],
                 [1, 20, 166, 748, 2011, 3346, 3467, 2192, 800, 150, 11, 0],
                 [1, 20, 167, 762, 2085, 3532, 3697, 2324, 829, 152, 11, 0],
                 [1, 20, 164, 726, 1916, 3138, 3217, 2028, 747, 144, 11, 0],
                 [1, 20, 160, 682, 1729, 2744, 2773, 1762, 670, 136, 11, 0],
                 [1, 20, 165, 740, 1988, 3312, 3424, 2144, 774, 146, 11, 0],
                 [1, 20, 161, 696, 1797, 2896, 2945, 1860, 695, 138, 11, 0],
                 [1, 20, 156, 646, 1600, 2502, 2515, 1606, 621, 130, 11, 0],
                 [1, 20, 150, 592, 1407, 2142, 2135, 1380, 552, 122, 11, 0],
                 [1, 20, 155, 632, 1542, 2392, 2410, 1560, 617, 132, 11, 0],
                 [1, 20, 155, 632, 1536, 2362, 2350, 1500, 587, 126, 11, 0],
                 [1, 20, 158, 656, 1623, 2542, 2575, 1668, 656, 138, 11, 0],
                 [1, 20, 159, 668, 1664, 2602, 2610, 1664, 643, 134, 11, 0],
                 [1, 20, 160, 682, 1731, 2752, 2785, 1770, 672, 136, 11, 0],
                 [1, 20, 158, 656, 1613, 2492, 2475, 1568, 606, 128, 11, 0],
                 [1, 20, 159, 664, 1650, 2592, 2630, 1704, 669, 140, 11, 0],
                 [1, 20, 161, 686, 1728, 2722, 2740, 1746, 671, 138, 11, 0],
                 [1, 20, 163, 712, 1848, 2986, 3046, 1932, 723, 142, 11, 0],
                 [1, 20, 161, 686, 1724, 2702, 2700, 1706, 651, 134, 11, 0],
                 [1, 20, 162, 700, 1793, 2856, 2875, 1808, 678, 136, 11, 0],
                 [1, 20, 159, 664, 1638, 2532, 2510, 1584, 609, 128, 11, 0],
                 [1, 20, 155, 620, 1470, 2212, 2170, 1380, 545, 120, 11, 0],
                 [1, 20, 164, 722, 1887, 3064, 3133, 1986, 740, 144, 11, 0],
                 [1, 20, 162, 696, 1761, 2772, 2775, 1752, 666, 136, 11, 0],
                 [1, 20, 165, 734, 1940, 3178, 3264, 2066, 763, 146, 11, 0],
                 [1, 20, 164, 722, 1883, 3038, 3075, 1928, 714, 140, 11, 0],
                 [1, 20, 161, 686, 1722, 2692, 2680, 1686, 641, 132, 11, 0],
                 [1, 20, 165, 736, 1955, 3210, 3277, 2042, 741, 142, 11, 0],
                 [1, 20, 162, 700, 1791, 2844, 2849, 1782, 666, 134, 11, 0],
                 [1, 20, 158, 656, 1611, 2482, 2455, 1548, 596, 126, 11, 0],
                 [1, 20, 153, 606, 1428, 2142, 2100, 1338, 531, 118, 11, 0],
                 [1, 20, 165, 734, 1936, 3150, 3200, 2002, 735, 142, 11, 0],
                 [1, 20, 166, 748, 2009, 3328, 3411, 2120, 762, 144, 11, 0],
                 [1, 20, 163, 712, 1842, 2948, 2962, 1848, 685, 136, 11, 0],
                 [1, 20, 159, 668, 1658, 2572, 2550, 1604, 613, 128, 11, 0],
                 [1, 20, 164, 726, 1913, 3114, 3151, 1952, 710, 138, 11, 0],
                 [1, 20, 160, 682, 1725, 2716, 2707, 1692, 636, 130, 11, 0],
                 [1, 20, 155, 632, 1532, 2342, 2310, 1460, 567, 122, 11, 0],
                 [1, 20, 149, 578, 1344, 2002, 1960, 1254, 503, 114, 11, 0],
                 [1, 20, 165, 740, 1985, 3288, 3355, 2060, 735, 140, 11, 0],
                 [1, 20, 161, 696, 1793, 2868, 2875, 1784, 659, 132, 11, 0],
                 [1, 20, 156, 646, 1595, 2472, 2449, 1538, 588, 124, 11, 0],
                 [1, 20, 150, 592, 1401, 2112, 2075, 1320, 522, 116, 11, 0],
                 [1, 20, 143, 536, 1218, 1792, 1750, 1128, 461, 108, 11, 0],
                 [1, 20, 135, 480, 1050, 1512, 1470, 960, 405, 100, 11, 0],
                ],
                ,
               );
  require Graph;
  my @graphs;
  foreach my $n (
                 # 11,
                 7 .. $#coeffs,
                ) {
    print "N=$n\n";
    my $aref = $coeffs[$n];
    my $graph = Graph->new;
    my %seen;
    foreach my $i (0 .. $#$aref) {
      my $key = join(',',@{$aref->[$i]});
      if ($seen{$key}++) {
        print "  duplicate $key\n";
        next;
      }

      foreach my $j (0 .. $#$aref) {
        if ($i!=$j && aref_all_ge($aref->[$j], $aref->[$i])) {
          # $graph->add_edge(join(',',@{$aref->[$i]}),
          #                  join(',',@{$aref->[$j]}));

          $graph->add_edge($i,$j);
          # unless ($graph->is_reachable($i,$j)) {
          # }
        }
      }
    }
    my $num_components = $graph->undirected_copy->connected_components;
    my $is_cyclic = $graph->is_cyclic ? 1 : 0;
    print "  num components $num_components  cyclic $is_cyclic\n";

    my @vertices = $graph->vertices;
    my %vertex_to_index;
    @vertex_to_index{@vertices} = (0 .. $#vertices);
    my $reachable = MyGraphs::Graph_reachable_matrix($graph,
                                                     \@vertices,
                                                     \%vertex_to_index);

    $graph = MyGraphs::Graph_covers($graph);

    my $covers_reachable = MyGraphs::Graph_reachable_matrix($graph,
                                                            \@vertices,
                                                            \%vertex_to_index);
    foreach my $i (0 .. $#vertices) {
      foreach my $j (0 .. $#vertices) {
        if (($reachable->[$i]->[$j]||0)
            != ($covers_reachable->[$i]->[$j]||0)) {
          print "$i,$j\n";
        }
      }
    }

    $graph->set_graph_attribute (name => "N=$n Covers");
    $graph->set_graph_attribute (flow => 'east');
    push @graphs, $graph;
    MyGraphs::Graph_view($graph);

    my $num_vertices = $graph->vertices;
    my $num_edges = $graph->edges;
    print "  vertices $num_vertices edges $num_edges\n";

    $num_components = $graph->undirected_copy->connected_components;
    print "  num components $num_components\n";

    my $minmax = MyGraphs::Graph_lattice_minmax_hash($graph);
    print "  lattice check: ",MyGraphs::Graph_lattice_minmax_reason($graph,$minmax),"\n";
  }
  MyGraphs::hog_searches_html(@graphs);
  exit 0;
}

sub aref_all_ge {
  my ($x, $y) = @_;
  foreach my $i (0 .. $#$x) {
    $x->[$i] >= $y->[$i] or return 0;
  }
  return 1;
}
