
use strict;
use warnings;

use FindBin;

BEGIN { require "$FindBin::Bin/test-helper-s3-api.pl" }

plan tests => 6;

use Shared::Examples::Net::Amazon::S3::API qw[ expect_api_object_delete ];

expect_api_object_delete 'delete object' => (
	with_bucket             => 'some-bucket',
	with_key                => 'some-key',
	expect_request          => { DELETE => 'https://some-bucket.s3.amazonaws.com/some-key' },
	expect_data             => bool (1),
);

expect_api_object_delete 'error access denied' => (
	with_bucket             => 'some-bucket',
	with_key                => 'some-key',
	with_response_fixture ('error::access_denied'),
	expect_request          => { DELETE => 'https://some-bucket.s3.amazonaws.com/some-key' },
	expect_data             => bool (0),
	expect_s3_err           => 'AccessDenied',
	expect_s3_errstr        => 'Access denied error message',
);

expect_api_object_delete 'error no such bucket' => (
	with_bucket             => 'some-bucket',
	with_key                => 'some-key',
	with_response_fixture ('error::no_such_bucket'),
	expect_request          => { DELETE => 'https://some-bucket.s3.amazonaws.com/some-key' },
	expect_data             => bool (0),
	expect_s3_err           => 'NoSuchBucket',
	expect_s3_errstr        => 'No such bucket error message',
);

expect_api_object_delete 'error no such key' => (
	with_bucket             => 'some-bucket',
	with_key                => 'some-key',
	with_response_fixture ('error::no_such_key'),
	expect_request          => { DELETE => 'https://some-bucket.s3.amazonaws.com/some-key' },
	expect_data             => bool (0),
	expect_s3_err           => 'NoSuchKey',
	expect_s3_errstr        => 'No such key error message',
);

expect_api_object_delete 'HTTP error - 400 Bad Request' => (
	with_bucket             => 'some-bucket',
	with_key                => 'some-key',
	with_response_fixture ('error::http_bad_request'),
	expect_request          => { DELETE => 'https://some-bucket.s3.amazonaws.com/some-key' },
	expect_data             => bool (0),
	expect_s3_err           => '400',
	expect_s3_errstr        => 'Bad Request',
);

had_no_warnings;

done_testing;
