# Generated by default/object.tt
package Paws::MediaConnect::VpcInterface;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has NetworkInterfaceIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'networkInterfaceIds', traits => ['NameInRequest'], required => 1);
  has NetworkInterfaceType => (is => 'ro', isa => 'Str', request_name => 'networkInterfaceType', traits => ['NameInRequest'], required => 1);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest'], required => 1);
  has SecurityGroupIds => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'securityGroupIds', traits => ['NameInRequest'], required => 1);
  has SubnetId => (is => 'ro', isa => 'Str', request_name => 'subnetId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConnect::VpcInterface

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConnect::VpcInterface object:

  $service_obj->Method(Att1 => { Name => $value, ..., SubnetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConnect::VpcInterface object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

The settings for a VPC Source.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

Immutable and has to be a unique against other VpcInterfaces in this
Flow


=head2 B<REQUIRED> NetworkInterfaceIds => ArrayRef[Str|Undef]

IDs of the network interfaces created in customer's account by
MediaConnect.


=head2 B<REQUIRED> NetworkInterfaceType => Str

The type of network interface.


=head2 B<REQUIRED> RoleArn => Str

Role Arn MediaConnect can assumes to create ENIs in customer's account


=head2 B<REQUIRED> SecurityGroupIds => ArrayRef[Str|Undef]

Security Group IDs to be used on ENI.


=head2 B<REQUIRED> SubnetId => Str

Subnet must be in the AZ of the Flow



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConnect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

