package Shipment::Purolator::WSDLV2::Types::ArrayOfServiceRule;
$Shipment::Purolator::WSDLV2::Types::ArrayOfServiceRule::VERSION = '3.09';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://purolator.com/pws/datatypes/v2' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ServiceRule_of :ATTR(:get<ServiceRule>);

__PACKAGE__->_factory(
    [ qw(        ServiceRule

    ) ],
    {
        'ServiceRule' => \%ServiceRule_of,
    },
    {
        'ServiceRule' => 'Shipment::Purolator::WSDLV2::Types::ServiceRule',
    },
    {

        'ServiceRule' => 'ServiceRule',
    }
);

} # end BLOCK







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::Purolator::WSDLV2::Types::ArrayOfServiceRule

=head1 VERSION

version 3.09

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ArrayOfServiceRule from the namespace http://purolator.com/pws/datatypes/v2.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ServiceRule (min/maxOccurs: 0/unbounded)

=back

=head1 NAME

Shipment::Purolator::WSDLV2::Types::ArrayOfServiceRule

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::Purolator::WSDLV2::Types::ArrayOfServiceRule
   ServiceRule =>  { # Shipment::Purolator::WSDLV2::Types::ServiceRule
     ServiceID =>  $some_value, # string
     MinimumTotalPieces =>  $some_value, # int
     MaximumTotalPieces =>  $some_value, # int
     MinimumTotalWeight =>  { # Shipment::Purolator::WSDLV2::Types::Weight
       Value =>  $some_value, # decimal
       WeightUnit => $some_value, # WeightUnit
     },
     MaximumTotalWeight => {}, # Shipment::Purolator::WSDLV2::Types::Weight
     MinimumPieceWeight => {}, # Shipment::Purolator::WSDLV2::Types::Weight
     MaximumPieceWeight => {}, # Shipment::Purolator::WSDLV2::Types::Weight
     MinimumPieceLength =>  { # Shipment::Purolator::WSDLV2::Types::Dimension
       Value =>  $some_value, # decimal
       DimensionUnit => $some_value, # DimensionUnit
     },
     MaximumPieceLength => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MinimumPieceWidth => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MaximumPieceWidth => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MinimumPieceHeight => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MaximumPieceHeight => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MaximumSize => {}, # Shipment::Purolator::WSDLV2::Types::Dimension
     MaximumDeclaredValue =>  $some_value, # decimal
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
