package Shipment::UPS::WSDL::TrackTypes::AppointmentType;
$Shipment::UPS::WSDL::TrackTypes::AppointmentType::VERSION = '3.01';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %Made_of : ATTR(:get<Made>);
    my %Requested_of : ATTR(:get<Requested>);
    my %BeginTime_of : ATTR(:get<BeginTime>);
    my %EndTime_of : ATTR(:get<EndTime>);

    __PACKAGE__->_factory(
        [   qw(        Made
              Requested
              BeginTime
              EndTime

              )
        ],
        {   'Made'      => \%Made_of,
            'Requested' => \%Requested_of,
            'BeginTime' => \%BeginTime_of,
            'EndTime'   => \%EndTime_of,
        },
        {   'Made'      => 'Shipment::UPS::WSDL::TrackTypes::DateTimeType',
            'Requested' => 'Shipment::UPS::WSDL::TrackTypes::DateTimeType',
            'BeginTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
            'EndTime'   => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'Made'      => 'Made',
            'Requested' => 'Requested',
            'BeginTime' => 'BeginTime',
            'EndTime'   => 'EndTime',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::AppointmentType

=head1 VERSION

version 3.01

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AppointmentType from the namespace http://www.ups.com/XMLSchema/XOLTWS/Track/v2.0.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Made

=item * Requested

=item * BeginTime

=item * EndTime

=back

=head1 NAME

Shipment::UPS::WSDL::TrackTypes::AppointmentType

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::UPS::WSDL::TrackTypes::AppointmentType
   Made =>  { # Shipment::UPS::WSDL::TrackTypes::DateTimeType
     Date =>  $some_value, # string
     Time =>  $some_value, # string
   },
   Requested =>  { # Shipment::UPS::WSDL::TrackTypes::DateTimeType
     Date =>  $some_value, # string
     Time =>  $some_value, # string
   },
   BeginTime =>  $some_value, # string
   EndTime =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
