/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.couchbase.mock.memcached.MemcachedServer;

public class VBucketInfo {
    private final int REPLICAS_MAX = 3;
    private MemcachedServer owner;
    private final List<MemcachedServer> replicas = new ArrayList<MemcachedServer>();
    private volatile long uuid;

    public VBucketInfo(MemcachedServer owner) {
        this.owner = owner;
    }

    public VBucketInfo() {
        this.owner = null;
        this.regenerateUuid();
    }

    public synchronized void setOwner(MemcachedServer server) {
        this.owner = server;
    }

    public synchronized void setReplicas(List<MemcachedServer> rl) {
        this.replicas.clear();
        if (rl.size() > 3) {
            rl = rl.subList(0, 3);
        }
        this.replicas.addAll(rl);
    }

    public List<MemcachedServer> getAllServers() {
        ArrayList<MemcachedServer> allServers = new ArrayList<MemcachedServer>();
        allServers.addAll(this.replicas);
        allServers.add(this.owner);
        return allServers;
    }

    public synchronized List<MemcachedServer> getReplicas() {
        return new ArrayList<MemcachedServer>(this.replicas);
    }

    public synchronized MemcachedServer getOwner() {
        return this.owner;
    }

    public boolean hasAccess(MemcachedServer server) {
        if (server == this.owner) {
            return true;
        }
        for (MemcachedServer replica : this.replicas) {
            if (replica != server) continue;
            return true;
        }
        return false;
    }

    public void regenerateUuid() {
        this.uuid = new Random().nextLong();
    }

    public long getUuid() {
        return this.uuid;
    }
}

