/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextBytesAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuickButCruddyTextExtractor {
    private POIFSFileSystem fs;
    private InputStream is;
    private byte[] pptContents;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tQuickButCruddyTextExtractor <file>");
            System.exit(1);
        }
        String file = args[0];
        QuickButCruddyTextExtractor ppe = new QuickButCruddyTextExtractor(file);
        System.out.println(ppe.getTextAsString());
        ppe.close();
    }

    public QuickButCruddyTextExtractor(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public QuickButCruddyTextExtractor(InputStream iStream) throws IOException {
        this(new POIFSFileSystem(iStream));
        this.is = iStream;
    }

    public QuickButCruddyTextExtractor(POIFSFileSystem poifs) throws IOException {
        this.fs = poifs;
        DocumentEntry docProps = (DocumentEntry)this.fs.getRoot().getEntry("PowerPoint Document");
        this.pptContents = new byte[docProps.getSize()];
        this.fs.createDocumentInputStream("PowerPoint Document").read(this.pptContents);
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        this.fs = null;
    }

    public String getTextAsString() {
        StringBuffer ret = new StringBuffer();
        Vector<String> textV = this.getTextAsVector();
        for (String text : textV) {
            ret.append(text);
            if (text.endsWith("\n")) continue;
            ret.append('\n');
        }
        return ret.toString();
    }

    public Vector<String> getTextAsVector() {
        Vector<String> textV = new Vector<String>();
        int walkPos = 0;
        while (walkPos != -1) {
            int newPos;
            walkPos = newPos = this.findTextRecords(walkPos, textV);
        }
        return textV;
    }

    public int findTextRecords(int startPos, Vector<String> textV) {
        int newPos;
        CString cs;
        String text;
        int len = (int)LittleEndian.getUInt(this.pptContents, startPos + 4);
        byte opt = this.pptContents[startPos];
        int container = opt & 0xF;
        if (container == 15) {
            return startPos + 8;
        }
        long type = LittleEndian.getUShort(this.pptContents, startPos + 2);
        TextRun trun = null;
        if (type == (long)RecordTypes.TextBytesAtom.typeID) {
            TextBytesAtom tba = (TextBytesAtom)Record.createRecordForType(type, this.pptContents, startPos, len + 8);
            trun = new TextRun((TextHeaderAtom)null, tba, (StyleTextPropAtom)null);
        }
        if (type == (long)RecordTypes.TextCharsAtom.typeID) {
            TextCharsAtom tca = (TextCharsAtom)Record.createRecordForType(type, this.pptContents, startPos, len + 8);
            trun = new TextRun((TextHeaderAtom)null, tca, (StyleTextPropAtom)null);
        }
        if (type == (long)RecordTypes.CString.typeID && !(text = (cs = (CString)Record.createRecordForType(type, this.pptContents, startPos, len + 8)).getText()).equals("___PPT10") && !text.equals("Default Design")) {
            textV.add(text);
        }
        if (trun != null) {
            textV.add(trun.getText());
        }
        if ((newPos = startPos + 8 + len) > this.pptContents.length - 8) {
            newPos = -1;
        }
        return newPos;
    }
}

