/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver.xml.sax;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.xml.ExternalDTDSubsetIdentifier;
import com.thaiopensource.resolver.xml.ExternalEntityIdentifier;
import com.thaiopensource.resolver.xml.ExternalIdentifier;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class SAX {
    private SAX() {
    }

    public static Resolver createResolver(EntityResolver entityResolver, boolean bl) {
        return new EntityResolverWrapper(entityResolver, bl);
    }

    public static EntityResolver2 createEntityResolver(Resolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        return new EntityResolverImpl(resolver);
    }

    public static Input createInput(InputSource inputSource) {
        Input input = new Input();
        SAX.setInput(input, inputSource);
        return input;
    }

    public static void setInput(Input input, InputSource inputSource) {
        input.setByteStream(inputSource.getByteStream());
        input.setCharacterStream(inputSource.getCharacterStream());
        input.setUri(inputSource.getSystemId());
        input.setEncoding(inputSource.getEncoding());
    }

    public static Exception getWrappedException(SAXException sAXException) {
        if (sAXException.getMessage() != null) {
            return null;
        }
        return sAXException.getException();
    }

    public static ResolverException toResolverException(SAXException sAXException) {
        Exception exception = SAX.getWrappedException(sAXException);
        if (exception != null) {
            if (exception instanceof ResolverException) {
                return (ResolverException)exception;
            }
            return new ResolverException(exception);
        }
        return new ResolverException(sAXException);
    }

    public static SAXException toSAXException(ResolverException resolverException) {
        Throwable throwable = resolverException.getCause();
        if (throwable != null && throwable instanceof SAXException) {
            return (SAXException)throwable;
        }
        return new SAXException(resolverException);
    }

    static InputSource createInputSource(Input input) {
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(input.getByteStream());
        inputSource.setCharacterStream(input.getCharacterStream());
        inputSource.setEncoding(input.getEncoding());
        inputSource.setSystemId(input.getUri());
        return inputSource;
    }

    static String getSystemId(Identifier identifier) {
        try {
            return BasicResolver.resolveUri(identifier);
        }
        catch (ResolverException resolverException) {
            return identifier.getUriReference();
        }
    }

    static InputSource createInputSource(Identifier identifier, Input input) {
        InputSource inputSource = SAX.createInputSource(input);
        if (identifier instanceof ExternalIdentifier) {
            inputSource.setPublicId(((ExternalIdentifier)identifier).getPublicId());
        }
        if (inputSource.getSystemId() == null) {
            inputSource.setSystemId(SAX.getSystemId(identifier));
        }
        return inputSource;
    }

    private static class EntityResolverImpl
    implements EntityResolver2 {
        private final Resolver resolver;

        private EntityResolverImpl(Resolver resolver) {
            this.resolver = resolver;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2 == null) {
                return null;
            }
            ExternalIdentifier externalIdentifier = new ExternalIdentifier(string2, null, string);
            Input input = new Input();
            try {
                this.resolver.resolve(externalIdentifier, input);
            }
            catch (ResolverException resolverException) {
                throw SAX.toSAXException(resolverException);
            }
            if (input.isResolved()) {
                return SAX.createInputSource(externalIdentifier, input);
            }
            return null;
        }

        public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
            if (string4 == null) {
                return null;
            }
            ExternalIdentifier externalIdentifier = "[doc]".equals(string) ? new ExternalDTDSubsetIdentifier(string4, string3, string2, null) : (string == null || string.indexOf(91) >= 0 || string.indexOf(35) >= 0 ? new ExternalIdentifier(string4, string3, string2) : new ExternalEntityIdentifier(string4, string3, string2, string));
            Input input = new Input();
            try {
                this.resolver.resolve(externalIdentifier, input);
            }
            catch (ResolverException resolverException) {
                throw SAX.toSAXException(resolverException);
            }
            if (input.isResolved()) {
                return SAX.createInputSource(externalIdentifier, input);
            }
            return null;
        }

        public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
            return null;
        }
    }

    private static final class EntityResolverWrapper
    extends AbstractResolver {
        private final EntityResolver entityResolver;
        private final EntityResolver2 entityResolver2;
        private final boolean promiscuous;

        private EntityResolverWrapper(EntityResolver entityResolver, boolean bl) {
            this.entityResolver = entityResolver;
            this.entityResolver2 = entityResolver instanceof EntityResolver2 ? (EntityResolver2)entityResolver : null;
            this.promiscuous = bl;
        }

        public void open(Input input) throws IOException, ResolverException {
            URI uRI;
            if (!input.isUriDefinitive()) {
                return;
            }
            try {
                uRI = new URI(input.getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ResolverException(uRISyntaxException);
            }
            if (!uRI.isAbsolute()) {
                throw new ResolverException("cannot open relative URI: " + uRI);
            }
            URL uRL = new URL(uRI.toASCIIString());
            input.setByteStream(uRL.openStream());
        }

        public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
            String string;
            if (input.isResolved()) {
                return;
            }
            String string2 = null;
            if (identifier instanceof ExternalIdentifier) {
                string = ((ExternalIdentifier)identifier).getPublicId();
                if (identifier instanceof ExternalEntityIdentifier) {
                    string2 = ((ExternalEntityIdentifier)identifier).getEntityName();
                } else if (identifier instanceof ExternalDTDSubsetIdentifier) {
                    string2 = "[dtd]";
                }
            } else {
                if (!this.promiscuous) {
                    return;
                }
                string = null;
            }
            try {
                InputSource inputSource = string2 != null && this.entityResolver2 != null ? this.entityResolver2.resolveEntity(string2, string, identifier.getBase(), identifier.getUriReference()) : this.entityResolver.resolveEntity(string, SAX.getSystemId(identifier));
                if (inputSource != null) {
                    SAX.setInput(input, inputSource);
                }
            }
            catch (SAXException sAXException) {
                throw SAX.toResolverException(sAXException);
            }
        }
    }
}

