/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLLeafNodeConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLText
extends XSLLeafNodeConstructor {
    private boolean disable = false;
    private StringValue value;

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws XPathException {
        String disableAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("disable-output-escaping")) {
                disableAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (disableAtt != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either 'yes' or 'no'", "XTSE0020");
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        Object child;
        AxisIterator kids = this.iterateAxis((byte)3);
        this.value = StringValue.EMPTY_STRING;
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                ((StyleElement)child).compileError("xsl:text must not contain child elements", "XTSE0010");
                return;
            }
            this.value = StringValue.makeStringValue(child.getStringValueCS());
        }
        super.validate(decl);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return null;
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        return new ValueOf(Literal.makeLiteral(this.value), this.disable, false);
    }
}

