/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Dictionaries {
    public final Set<String> reportVerb = new HashSet<String>(Arrays.asList("accuse", "acknowledge", "add", "admit", "advise", "agree", "alert", "allege", "announce", "answer", "apologize", "argue", "ask", "assert", "assure", "beg", "blame", "boast", "caution", "charge", "cite", "claim", "clarify", "command", "comment", "compare", "complain", "concede", "conclude", "confirm", "confront", "congratulate", "contend", "contradict", "convey", "counter", "criticize", "debate", "decide", "declare", "defend", "demand", "demonstrate", "deny", "describe", "determine", "disagree", "disclose", "discount", "discover", "discuss", "dismiss", "dispute", "disregard", "doubt", "emphasize", "encourage", "endorse", "equate", "estimate", "expect", "explain", "express", "extoll", "fear", "feel", "find", "forbid", "forecast", "foretell", "forget", "gather", "guarantee", "guess", "hear", "hint", "hope", "illustrate", "imagine", "imply", "indicate", "inform", "insert", "insist", "instruct", "interpret", "interview", "invite", "issue", "justify", "learn", "maintain", "mean", "mention", "negotiate", "note", "observe", "offer", "oppose", "order", "persuade", "pledge", "point", "point out", "praise", "pray", "predict", "prefer", "present", "promise", "prompt", "propose", "protest", "prove", "provoke", "question", "quote", "raise", "rally", "read", "reaffirm", "realise", "realize", "rebut", "recall", "reckon", "recommend", "refer", "reflect", "refuse", "refute", "reiterate", "reject", "relate", "remark", "remember", "remind", "repeat", "reply", "report", "request", "respond", "restate", "reveal", "rule", "say", "see", "show", "signal", "sing", "slam", "speculate", "spoke", "spread", "state", "stipulate", "stress", "suggest", "support", "suppose", "surmise", "suspect", "swear", "teach", "tell", "testify", "think", "threaten", "told", "uncover", "underline", "underscore", "urge", "voice", "vow", "warn", "welcome", "wish", "wonder", "worry", "write"));
    public final Set<String> nonWords = new HashSet<String>(Arrays.asList("mm", "hmm", "ahem", "um"));
    public final Set<String> copulas = new HashSet<String>(Arrays.asList("is", "are", "were", "was", "be", "been", "become", "became", "becomes", "seem", "seemed", "seems", "remain", "remains", "remained"));
    public final Set<String> quantifiers = new HashSet<String>(Arrays.asList("not", "every", "any", "none", "everything", "anything", "nothing", "all", "enough"));
    public final Set<String> parts = new HashSet<String>(Arrays.asList("half", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "hundred", "thousand", "million", "billion", "tens", "dozens", "hundreds", "thousands", "millions", "billions", "group", "groups", "bunch", "number", "numbers", "pinch", "amount", "amount", "total", "all", "mile", "miles", "pounds"));
    public final Set<String> temporals = new HashSet<String>(Arrays.asList("second", "minute", "hour", "day", "week", "month", "year", "decade", "century", "millennium", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "now", "yesterday", "tomorrow", "age", "time", "era", "epoch", "morning", "evening", "day", "night", "noon", "afternoon", "semester", "trimester", "quarter", "term", "winter", "spring", "summer", "fall", "autumn", "season", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"));
    public final Set<String> femalePronouns = new HashSet<String>(Arrays.asList("her", "hers", "herself", "she"));
    public final Set<String> malePronouns = new HashSet<String>(Arrays.asList("he", "him", "himself", "his"));
    public final Set<String> neutralPronouns = new HashSet<String>(Arrays.asList("it", "its", "itself", "where", "here", "there", "which"));
    public final Set<String> possessivePronouns = new HashSet<String>(Arrays.asList("my", "your", "his", "her", "its", "our", "their", "whose"));
    public final Set<String> otherPronouns = new HashSet<String>(Arrays.asList("who", "whom", "whose", "where", "when", "which"));
    public final Set<String> thirdPersonPronouns = new HashSet<String>(Arrays.asList("he", "him", "himself", "his", "she", "her", "herself", "hers", "her", "it", "itself", "its", "one", "oneself", "one's", "they", "them", "themself", "themselves", "theirs", "their", "they", "them", "'em", "themselves"));
    public final Set<String> secondPersonPronouns = new HashSet<String>(Arrays.asList("you", "yourself", "yours", "your", "yourselves"));
    public final Set<String> firstPersonPronouns = new HashSet<String>(Arrays.asList("i", "me", "myself", "mine", "my", "we", "us", "ourself", "ourselves", "ours", "our"));
    public final Set<String> moneyPercentNumberPronouns = new HashSet<String>(Arrays.asList("it", "its"));
    public final Set<String> dateTimePronouns = new HashSet<String>(Arrays.asList("when"));
    public final Set<String> organizationPronouns = new HashSet<String>(Arrays.asList("it", "its", "they", "their", "them", "which"));
    public final Set<String> locationPronouns = new HashSet<String>(Arrays.asList("it", "its", "where", "here", "there"));
    public final Set<String> inanimatePronouns = new HashSet<String>(Arrays.asList("it", "itself", "its", "where", "when"));
    public final Set<String> animatePronouns = new HashSet<String>(Arrays.asList("i", "me", "myself", "mine", "my", "we", "us", "ourself", "ourselves", "ours", "our", "you", "yourself", "yours", "your", "yourselves", "he", "him", "himself", "his", "she", "her", "herself", "hers", "her", "one", "oneself", "one's", "they", "them", "themself", "themselves", "theirs", "their", "they", "them", "'em", "themselves", "who", "whom", "whose"));
    public final Set<String> indefinitePronouns = new HashSet<String>(Arrays.asList("another", "anybody", "anyone", "anything", "each", "either", "enough", "everybody", "everyone", "everything", "less", "little", "much", "neither", "no one", "nobody", "nothing", "one", "other", "plenty", "somebody", "someone", "something", "both", "few", "fewer", "many", "others", "several", "all", "any", "more", "most", "none", "some", "such"));
    public final Set<String> relativePronouns = new HashSet<String>(Arrays.asList("that", "who", "which", "whom", "where", "whose"));
    public final Set<String> GPEPronouns = new HashSet<String>(Arrays.asList("it", "itself", "its", "they", "where"));
    public final Set<String> pluralPronouns = new HashSet<String>(Arrays.asList("we", "us", "ourself", "ourselves", "ours", "our", "yourself", "yourselves", "they", "them", "themself", "themselves", "theirs", "their"));
    public final Set<String> singularPronouns = new HashSet<String>(Arrays.asList("i", "me", "myself", "mine", "my", "yourself", "he", "him", "himself", "his", "she", "her", "herself", "hers", "her", "it", "itself", "its", "one", "oneself", "one's"));
    public final Set<String> facilityVehicleWeaponPronouns = new HashSet<String>(Arrays.asList("it", "itself", "its", "they", "where"));
    public final Set<String> miscPronouns = new HashSet<String>(Arrays.asList("it", "itself", "its", "they", "where"));
    public final Set<String> reflexivePronouns = new HashSet<String>(Arrays.asList("myself", "yourself", "yourselves", "himself", "herself", "itself", "ourselves", "themselves", "oneself"));
    public final Set<String> transparentNouns = new HashSet<String>(Arrays.asList("bunch", "group", "breed", "class", "ilk", "kind", "half", "segment", "top", "bottom", "glass", "bottle", "box", "cup", "gem", "idiot", "unit", "part", "stage", "name", "division", "label", "group", "figure", "series", "member", "members", "first", "version", "site", "side", "role", "largest", "title", "fourth", "third", "second", "number", "place", "trio", "two", "one", "longest", "highest", "shortest", "head", "resident", "collection", "result", "last"));
    public final Set<String> stopWords = new HashSet<String>(Arrays.asList("a", "an", "the", "of", "at", "on", "upon", "in", "to", "from", "out", "as", "so", "such", "or", "and", "those", "this", "these", "that", "for", ",", "is", "was", "am", "are", "'s", "been", "were"));
    public final Set<String> notOrganizationPRP = new HashSet<String>(Arrays.asList("i", "me", "myself", "mine", "my", "yourself", "he", "him", "himself", "his", "she", "her", "herself", "hers", "here"));
    public final Set<String> personPronouns = new HashSet<String>();
    public final Set<String> allPronouns = new HashSet<String>();
    public final Map<String, String> statesAbbreviation = new HashMap<String, String>();
    public final Map<String, Set<String>> demonyms = new HashMap<String, Set<String>>();
    public final Set<String> demonymSet = new HashSet<String>();
    public final Set<String> adjectiveNation = new HashSet<String>();
    public final Set<String> countries = new HashSet<String>();
    public final Set<String> statesAndProvinces = new HashSet<String>();
    public final Set<String> neutralWords = new HashSet<String>();
    public final Set<String> femaleWords = new HashSet<String>();
    public final Set<String> maleWords = new HashSet<String>();
    public final Set<String> pluralWords = new HashSet<String>();
    public final Set<String> singularWords = new HashSet<String>();
    public final Set<String> inanimateWords = new HashSet<String>();
    public final Set<String> animateWords = new HashSet<String>();
    public final Map<List<String>, int[]> genderNumber = new HashMap<List<String>, int[]>();

    private void setPronouns() {
        for (String s : this.animatePronouns) {
            this.personPronouns.add(s);
        }
        this.allPronouns.addAll(this.firstPersonPronouns);
        this.allPronouns.addAll(this.secondPersonPronouns);
        this.allPronouns.addAll(this.thirdPersonPronouns);
        this.allPronouns.addAll(this.otherPronouns);
        this.stopWords.addAll(this.allPronouns);
    }

    public void loadStateAbbreviation(String statesFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(statesFile)));
            while (reader.ready()) {
                String[] tokens = reader.readLine().split("\t");
                this.statesAbbreviation.put(tokens[1], tokens[0]);
                this.statesAbbreviation.put(tokens[2], tokens[0]);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(reader);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(reader);
    }

    private void loadDemonymLists(String demonymFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(demonymFile)));
            while (reader.ready()) {
                String[] line = reader.readLine().split("\t");
                if (line[0].startsWith("#")) continue;
                HashSet<String> set = new HashSet<String>();
                for (String s : line) {
                    set.add(s.toLowerCase());
                    this.demonymSet.add(s.toLowerCase());
                }
                this.demonyms.put(line[0].toLowerCase(), set);
            }
            this.adjectiveNation.addAll(this.demonymSet);
            this.adjectiveNation.removeAll(this.demonyms.keySet());
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(reader);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(reader);
    }

    private static void getWordsFromFile(String filename, Set<String> resultSet, boolean lowercase) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename)));
        while (reader.ready()) {
            if (lowercase) {
                resultSet.add(reader.readLine().toLowerCase());
                continue;
            }
            resultSet.add(reader.readLine());
        }
        IOUtils.closeIgnoringExceptions(reader);
    }

    private void loadAnimacyLists(String animateWordsFile, String inanimateWordsFile) {
        try {
            Dictionaries.getWordsFromFile(animateWordsFile, this.animateWords, false);
            Dictionaries.getWordsFromFile(inanimateWordsFile, this.inanimateWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadGenderLists(String maleWordsFile, String neutralWordsFile, String femaleWordsFile) {
        try {
            Dictionaries.getWordsFromFile(maleWordsFile, this.maleWords, false);
            Dictionaries.getWordsFromFile(neutralWordsFile, this.neutralWords, false);
            Dictionaries.getWordsFromFile(femaleWordsFile, this.femaleWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadNumberLists(String pluralWordsFile, String singularWordsFile) {
        try {
            Dictionaries.getWordsFromFile(pluralWordsFile, this.pluralWords, false);
            Dictionaries.getWordsFromFile(singularWordsFile, this.singularWords, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadStatesLists(String file) {
        try {
            Dictionaries.getWordsFromFile(file, this.statesAndProvinces, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadCountriesLists(String file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(file)));
            while (reader.ready()) {
                String line = reader.readLine();
                this.countries.add(line.split("\t")[1].toLowerCase());
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadGenderNumber(String file) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(file)));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\t");
                ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(split[0].split(" ")));
                String[] countStr = split[1].split(" ");
                int[] counts = new int[]{Integer.parseInt(countStr[0]), Integer.parseInt(countStr[1]), Integer.parseInt(countStr[2]), Integer.parseInt(countStr[3])};
                this.genderNumber.put(tokens, counts);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void loadExtraGender(String file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(file)));
            while (reader.ready()) {
                String[] split = reader.readLine().split("\t");
                if (split[1].equals("MALE")) {
                    this.maleWords.add(split[0]);
                    continue;
                }
                if (!split[1].equals("FEMALE")) continue;
                this.femaleWords.add(split[0]);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeIgnoringExceptions(reader);
                throw throwable;
            }
        }
        IOUtils.closeIgnoringExceptions(reader);
    }

    public Dictionaries(Properties props) {
        this(props.getProperty("dcoref.demonym", "edu/stanford/nlp/models/dcoref/demonyms.txt"), props.getProperty("dcoref.animate", "edu/stanford/nlp/models/dcoref/animate.unigrams.txt"), props.getProperty("dcoref.inanimate", "edu/stanford/nlp/models/dcoref/inanimate.unigrams.txt"), props.getProperty("dcoref.male", "edu/stanford/nlp/models/dcoref/male.unigrams.txt"), props.getProperty("dcoref.neutral", "edu/stanford/nlp/models/dcoref/neutral.unigrams.txt"), props.getProperty("dcoref.female", "edu/stanford/nlp/models/dcoref/female.unigrams.txt"), props.getProperty("dcoref.plural", "edu/stanford/nlp/models/dcoref/plural.unigrams.txt"), props.getProperty("dcoref.singular", "edu/stanford/nlp/models/dcoref/singular.unigrams.txt"), props.getProperty("dcoref.states", "edu/stanford/nlp/models/dcoref/state-abbreviations.txt"), props.getProperty("dcoref.big.gender.number", "edu/stanford/nlp/models/dcoref/gender.data.gz"), props.getProperty("dcoref.countries", "edu/stanford/nlp/models/dcoref/countries"), props.getProperty("dcoref.states.provinces", "edu/stanford/nlp/models/dcoref/statesandprovinces"), props.getProperty("dcoref.extra.gender", "edu/stanford/nlp/models/dcoref/namegender.combine.txt"), Boolean.parseBoolean(props.getProperty("dcoref.use.big.gender.number", "false")) || Boolean.parseBoolean(props.getProperty("dcoref.replicate.conll", "false")));
    }

    public static String signature(Properties props) {
        StringBuilder os = new StringBuilder();
        os.append("dcoref.demonym:" + props.getProperty("dcoref.demonym", "edu/stanford/nlp/models/dcoref/demonyms.txt"));
        os.append("dcoref.animate:" + props.getProperty("dcoref.animate", "edu/stanford/nlp/models/dcoref/animate.unigrams.txt"));
        os.append("dcoref.inanimate:" + props.getProperty("dcoref.inanimate", "edu/stanford/nlp/models/dcoref/inanimate.unigrams.txt"));
        os.append("dcoref.male:" + props.getProperty("dcoref.male", "edu/stanford/nlp/models/dcoref/male.unigrams.txt"));
        os.append("dcoref.neutral:" + props.getProperty("dcoref.neutral", "edu/stanford/nlp/models/dcoref/neutral.unigrams.txt"));
        os.append("dcoref.female:" + props.getProperty("dcoref.female", "edu/stanford/nlp/models/dcoref/female.unigrams.txt"));
        os.append("dcoref.plural:" + props.getProperty("dcoref.plural", "edu/stanford/nlp/models/dcoref/plural.unigrams.txt"));
        os.append("dcoref.singular:" + props.getProperty("dcoref.singular", "edu/stanford/nlp/models/dcoref/singular.unigrams.txt"));
        os.append("dcoref.states:" + props.getProperty("dcoref.states", "edu/stanford/nlp/models/dcoref/state-abbreviations.txt"));
        os.append("dcoref.big.gender.number:" + props.getProperty("dcoref.big.gender.number", "edu/stanford/nlp/models/dcoref/gender.data.gz"));
        os.append("dcoref.countries:" + props.getProperty("dcoref.countries", "edu/stanford/nlp/models/dcoref/countries"));
        os.append("dcoref.states.provinces:" + props.getProperty("dcoref.states.provinces", "edu/stanford/nlp/models/dcoref/statesandprovinces"));
        os.append("dcoref.extra.gender:" + props.getProperty("dcoref.extra.gender", "edu/stanford/nlp/models/dcoref/namegender.combine.txt"));
        os.append("dcoref.use.big.gender.number:" + props.getProperty("dcoref.use.big.gender.number", "false"));
        os.append("dcoref.replicate.conll:" + props.getProperty("dcoref.replicate.conll", "false"));
        return os.toString();
    }

    public Dictionaries(String demonymWords, String animateWords, String inanimateWords, String maleWords, String neutralWords, String femaleWords, String pluralWords, String singularWords, String statesWords, String genderNumber, String countries, String states, String extraGender, boolean loadBigGenderNumber) {
        this.loadDemonymLists(demonymWords);
        this.loadStateAbbreviation(statesWords);
        this.loadAnimacyLists(animateWords, inanimateWords);
        this.loadGenderLists(maleWords, neutralWords, femaleWords);
        this.loadNumberLists(pluralWords, singularWords);
        if (loadBigGenderNumber) {
            this.loadGenderNumber(genderNumber);
        }
        this.loadCountriesLists(countries);
        this.loadStatesLists(states);
        this.loadExtraGender(extraGender);
        this.setPronouns();
    }

    public Dictionaries() {
        this(new Properties());
    }

    public static enum Person {
        I,
        YOU,
        HE,
        SHE,
        WE,
        THEY,
        IT,
        UNKNOWN;

    }

    public static enum Animacy {
        ANIMATE,
        INANIMATE,
        UNKNOWN;

    }

    public static enum Number {
        SINGULAR,
        PLURAL,
        UNKNOWN;

    }

    public static enum Gender {
        MALE,
        FEMALE,
        NEUTRAL,
        UNKNOWN;

    }

    public static enum MentionType {
        PRONOMINAL,
        NOMINAL,
        PROPER;

    }
}

