package t::lib;
use v5.14;
use warnings;

our $reference = <<'EOF';
#include <stdio.h>

int main(void) {
	int a, b;
	scanf("%d%d", &a, &b);
	printf("%d\n", a + b);
	return 0;
}
EOF

our $long_code = <<'EOF';
#include <stdio.h>
#include <time.h>

int main(void) {
	int time_start;
	int a, b, c;
	time_start = time(NULL);
	scanf("%d%d", &a, &b);
	c = a + b;
	if (c == a + b) {
		printf("%d\n", c);
	} else
		puts("FATAL ERROR: addition failed");
	fprintf(stderr, "time taken: %ld", time(NULL) - time_start);
	return 0;
}
EOF

our $long_code_with_bug = $long_code =~ s/%ld/%d/r;

our $cpp_very_long_function = <<'EOF';
int func(void) {
	// https://thedailywtf.com/articles/The_FOR-CASE_paradigm
	// we use modified cyclomatic complexity in Code::Quality
	// therefore this function has low complexity
	int arr[10];
	for(int i = 0 ; i < 10 ; i++) {
		switch(i) {
		case 0:
			arr[i] = var0.field;
			break;
		case 1:
			arr[i] = var1.field;
			break;
		case 2:
			arr[i] = var2.field;
			break;
		case 3:
			arr[i] = var3.field;
			break;
		case 4:
			arr[i] = var4.field;
			break;
		case 5:
			arr[i] = var5.field;
			break;
		case 6:
			arr[i] = var6.field;
			break;
		case 7:
			arr[i] = var7.field;
			break;
		case 8:
			arr[i] = var8.field;
			break;
		case 9:
			arr[i] = var9.field;
			break;
		}
	}
}
EOF

our $cpp_long_function = <<'EOF';
bool returns_true() {
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	;
	return true;
}
EOF

our $c_complex_function = <<'EOF';
// http://www.bombmanual.com/
void defuse_bomb(int color, char *text, int num_batteries, int indicators) {
	int hold = 1;
	if(color == COLOR_BLUE && strcmp(text, "Abort") == 0)
		hold = 1;
	else if(num_batteries > 1 && strcmp(text, "Detonate") == 0)
		hold = 0;
	else if(color == COLOR_WHITE && (indicators & INDICATOR_CAR))
		hold = 1;
	else if(num_batteries > 2 && (indicators & INDICATOR_FRK))
		hold = 0;
	else if(color == COLOR_YELLOW)
		hold = 1;
	else if(color == COLOR_RED && strcmp(text, "Hold") == 0)
		hold = 0;

	if(hold) {
		int strip = hold_button();
		int timer_digit = 1;
		if(strip == COLOR_BLUE)
			timer_digit = 4;
		else if(strip == COLOR_WHITE)
			timer_digit = 1;
		else if(strip == COLOR_YELLOW)
			timer_digit = 5;
		release_button_when_timer_contains(timer_digit);
	} else
		press_and_release_button();
}
EOF
1;

our $java_very_complex_function = <<'EOF';
class WhatIf {
	public static bool myfunc() {
		if(this && that && other_thing) {
			if(this && that) { /* defensive programming */
				return true;
			} else {
				throw new LogicError();
			}
		} else if(a && e && i && o && u) {
			return false;
		} else if(r || p || s) {
			if(a)
				return true;
			else if(b)
				return false;
			else if(c)
				return true;
		}
		if(do_for_loop)
			for(int i = 0; i < 100; i++)
				for(int j = 0; j < 100; j++)
					for(int k = 0; k < 100; k++)
						return i % 2 == j % 2;
		if(ccn && ccn2 && ccn3) {
			if(ccn4 || ccn5)
				return false;
		}
	}
}
EOF
1;
