package Dist::Zilla::Plugin::Acme::MetaSyntactic;

our $DATE = '2017-02-04'; # DATE
our $VERSION = '0.001'; # VERSION

use Moose;
with 'Dist::Zilla::Role::FileGatherer';
with 'Dist::Zilla::Role::PrereqSource';

use namespace::autoclean;

sub register_prereqs {
    # performed in gather_files
}

sub gather_files {
    my ($self) = @_;

    unless (grep { $_->name eq 't/meta.t' } @{ $self->zilla->files }) {
        my $content = <<EOF;
#!perl

# This file was automatically generated by ${\( __PACKAGE__ )}.

use Test::MetaSyntactic;
all_themes_ok();
EOF
        my $filename = 'xt/release/meta.t';
        $self->log(["Adding %s ...", $filename]);
        require Dist::Zilla::File::InMemory;
        $self->add_file(
            Dist::Zilla::File::InMemory->new({
                name => $filename,
                content => $content,
            })
          );
        $self->zilla->register_prereqs(
            {
                type  => 'requires',
                phase => 'test',
            },
            'Test::MetaSyntactic' => '0',
        );
    }
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Plugin to use when building Acme-MetaSyntactic-* theme distribution

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Acme::MetaSyntactic - Plugin to use when building Acme-MetaSyntactic-* theme distribution

=head1 VERSION

This document describes version 0.001 of Dist::Zilla::Plugin::Acme::MetaSyntactic (from Perl distribution Dist-Zilla-Plugin-Acme-MetaSyntactic), released on 2017-02-04.

=head1 SYNOPSIS

In F<dist.ini>:

 [Acme::MetaSyntactic]

=head1 DESCRIPTION

This plugin can be used when building Acme-MetaSyntactic-* theme distribution.
It currently does the following:

=over

=item * Add a test script F<xt/release/meta.t> (which will become F<t/release-meta.t>) unless F<t/meta.t> or F<t/meta.t> already exists

The test script is something like:

 use Test::MetaSyntactic;
 all_themes_ok();

=back

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-Acme-MetaSyntactic>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-Acme-MetaSyntactic>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-Acme-MetaSyntactic>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
