use Test::More;

use Parse::Range qw(parse_range);

my @tests = (
	[q()] => [qw()],
	[q(1,3,5,7-9)] => [qw(1 3 5 7 8 9)],
	[q(1,3,5,9-7)] => [qw(1 3 5 7 8 9)],
	[q(1,3,5,7-7)] => [qw(1 3 5 7)],
	[q(1-3,3,5,7-9)] => [qw(1 2 3 5 7 8 9)],
	# NOT operator
	[q(^1-3,3,5,7-9)] => [qw(3 5 7 8 9)],
	[q(1,3,5,7-9,^3-4)] => [qw(1 5 7 8 9)],
	[q(1,3,5,7-9,^1-9)] => [qw()],
	[q(1,3,5,^5-7,7-9)] => [qw(1 3 7 8 9)],
	[q(1,3,5,^5,7-9)] => [qw(1 3 7 8 9)],
	[q(1-9,^5)] => [qw(1 2 3 4 6 7 8 9)],
	[q(1 - 9, ^ 5)] => [qw(1 2 3 4 6 7 8 9)],
	# non-numeric values
	[q(a,2,b,)] => [qw(2)],
	# nested ranges
	[q((1,2,3),4,5,(6,(7,8)))] => [qw(1 2 3 4 5 6 7 8)],
	[q(1-9,3,^(5,6,7))] => [qw(1 2 3 4 8 9)],
	[q(1-9,^(5-9,^(8-9)))] => [qw(1 2 3 4 8 9)],
	# negative values
	[q(-1,3,5,7-7)] => [qw(-1 3 5 7)],
	[q(-1-1,-2--1)] => [qw(-1 0 1 -2)],
	[q(-1-1,-2-(-1))] => [qw(-1 0 1 -2)],
	# syntax errors
	[q{(1,2,3)}] => [qw(1 2 3)],
	[q{((1,2,3)}] => [qw(1 2 3)],
	[q{((1,2,(3,4)}] => [qw(1 2 3 4)],
	[q{1,(2,(3),4,5}] => [qw(1 2 3 4 5)],
	[q{(1,2,3))}] => [qw(1 2 3)],
	[q{((1),2,3))}] => [qw(1 2 3)],
	[q{(1,2),3))}] => [qw(1 2 3)],
	[q{1,2))),3}] => [qw(1 2 3)],
	[q{((-4)-(-2)}] => [qw(-4 -3 -2)],
	
	
	
);

for(my $i = 0; $i < @tests; $i++) {
	is_deeply([parse_range(@{$tests[$i]})], $tests[++$i], $tests[$i-1]->[0] . "\tbecomes\t" . join(', ', @{$tests[$i]}));
}
done_testing;