package Acme::MetaSyntactic::simpsons;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.001';
__PACKAGE__->init();

our %Remote = (
    source  => 'https://simpsons.fandom.com/wiki/Portal:All_Simpson_Characters',
    extract => sub {
        my $i = 1;
        return
          grep !/^(?:The_Simpsons|Simpson_family)$/, map {
            s/%27//g;
            s/%C3%9C/U/g;
            s/%C3%A9/e/g;
            s/%C3%B6/o/g;
            s/%C3%BC/u/g;
            s/5th/Fifth/g;
            s/4/Four/g;
            y/-().,/_/d;
            $_;
          }
          grep $i++ % 2,
          $_[0] =~ m{<a href="/wiki/([^"]+)" title="([^"]*)">\2</a>}g;
    }
);

1;

=head1 NAME

Acme::MetaSyntactic::simpsons - The Simpsons theme

=head1 DESCRIPTION

Characters from the Simpsons serial.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat.

=head1 CHANGES

=over 4

=item *

2019-07-29 - v1.001

New data source: L<https://simpsons.fandom.com/wiki/Portal:All_Simpson_Characters>.
Updated from the source web site in Acme-MetaSyntactic-Themes version 1.053.

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-07-24

Made updatable with L<http://tim.rawle.org/simpsons/chars.htm>
(link provided on January 16, 2005 by Matthew Musgrove)
in Acme-MetaSyntactic version 0.84.

=item *

2005-06-13

Re-introduced in Acme-MetaSyntactic version 0.26.

=item *

2005-03-06

Disappeared in Acme-MetaSyntactic version 0.12.

=item *

2005-01-15

Introduced in Acme-MetaSyntactic version 0.04, published on January 15, 2005.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Abraham_Simpson_I
Abraham_Simpson_II
Addem_up_Spuckler
Adrian_Belew
Agnes_Flanders
Agnes_Skinner
Akira
Alex_Whitney
Alice_Glick
Alien_couch_gag
Allison_Taylor
Alvarine_Bisque
Amber_Simpson
American_Spy
Amish_Man
Anastasia
Andy_Hamilton
Angelica
Annie_Ant
Annie_Dubinsky
Annika_Van_Houten
Anoop_Nahasapeemapetilon
Apu_Nahasapeemapetilon
Apu_Nahasapeemapetilon_Sr
Apus_Mother
Aristotle_Amadopolis
Arnie_Pye
Arnold_Schwarzenegger
Arthur_Crandall
Arthur_Student
Artie_Ziff
Art_teacher
Ashley
Audrey_McConnells_Student_1
Audrey_McConnells_Student_2
Audrey_McConnells_Student_8
Audrey_McConnells_Student_Four
Augusta_Flanders
Babysitting_Lady
Ballet_Teacher
Bambi_Petitbois
Barking_Dog
Barney_Gumble
Barrow_Spuckler
Bart_Simpson
Bart_Simpson_Jr
Bashir_bin_Laden
Beggar_Relative
Benjamin_nerd
Benzine_girl
Bernice_Hibbert
Bill_KBBL_DJ
Billy_actor
Birch_Barlow
Birthday_Spuckler
Bitey
Black_hole_aliens
Black_Weasel
Bleeding_Gums_Murphy
Blinky
Blue_Haired_Lawyer
Bluella
Bodhi
Bolivian_Tree_Lizard
Bomb_Disarming_Robot
Bonnie_Flanders
Booberella
Boy_with_bangs
Boy_with_freckles
Boy_with_glasses
Boy_with_shades
Brandine_Spuckler
Brittany_Brockman
Brittany_Spuckler
Brothers_and_sisters_of_Chin_Ho_and_Chan_Ho
Brown_haired_girl
Brunella_Pommelhorst
Buck_toothed_boy
Buck_toothed_girl
Bumblebee_Man
Burns_Dog
Burns_Elephant
Burns_Flying_Monkeys
Butterfly
Canadian_Flanders
Canary_M_Burns
Capital_City_Goofball
Captain_Jack
Captain_Lance_Murdock
Caribbean_Boy
Carl_Carlson
Cassidy_Spuckler
Cecil_Terwilliger
Celeste
Cesar
Charles_Montgomery_Burns
Charlie_SNPP
Chazz_Busby
Chester_Bouvier
Chester_J_Lampwick
Chet_Simpson
Chew_My_Shoe
Chez_Paree_Lobsters
Chicagoan_man
Chin_Ho
Chocolate_rabbits
Christmas_Tree_Farm_Hounds
Chuck_Berger
Chuck_Muntz
Clancy_Bouvier
Clancy_Wiggum
Claretta_Simpson
Cleo_Bouvier
Cletus_Spuckler
Clifford_Burns
Clowta_Stillman
Coach_Krupt
Cody_Spuckler
Colin
Coltrane
Comic_Book_Guy
Congressman_1
Congressman_2
Congressman_3
Connie_Flanders
Cookie_Kwan
Cora
Cornelia_Hernandez
Cornelius_Burns
Corporal_Punishment
Cosine_Tangent
Coward
Cowboy_Bob
Crystal_Meth_Spuckler
Curious_Bear_Cub
Cute_Lamb
Cyrus_Simpson
Dame_Judith_Terwilliger
Daphne_Burns
Darryl
Dash_Dingo
Database
Dave_Shutton
Declan_Desmond
Dermott_Spuckler
Dewey_Largo
Dia_Betty
Didi_Bouvier
Diggs
Disco_Stu
Dog_O_War
Dog_SNPP
Dog_The_Lastest_Gun_in_the_West
Dog_with_Ham
Dolph_Starbeam
Don_Brodka
Donna
Donnas_friend
Donny_The_Debarted
Don_Vittorio_DiMaggio
Doreena_Burns
Doris_Freedman
Doug_nerd
Drederick_Tatum
Dr_Hector_von_Colossus
Dr_Hibberts_Second_Daughter
Dr_Hibberts_Second_Son
Dr_Simpson
Dr_Velimirovic
Dubya_Spuckler
Duffman
Duff_McShark
Dulcine_Simpson
Duncan
Dwight_Diddlehopper
Dwight_Diddlehoppers_Accomplice
Dylan_Spuckler
Eartha_Kitt_character
Eckhardt_Simpson
Eddie
Eddie_Muntz
Edna_Krabappel
Eleanor_Abernathy
Elizabeth_Hoover
Eliza_Simpson
E_mail
Embry_Joe_Spuckler
Emily_Winthrop
EPA_Scientist
Eric_Von_Burns
Erik
Erin
Ernst
Esquilax
Estonian_Dwarf
Evelyn_Graycomb
Evil_Homer
Faceless_Man
Fallout_Boy
Fat_Tony
FBI_Agent_2_Homerland
Female_Mail_Carrier
Female_Twin
Feral_Things
Fido
Fifth_grade_girl
Flanders_pet_woodpecker
Floradora_Flannery
Fluffy
Fontanelle_Spuckler
Four_H_leader
Francesca_Terwilliger
Francine_Rhenquist
Frank_Grimes
Frank_Grimes_Jr
Frankie_the_Squealer
Franklin_Jefferson_Burns
Freddy
Freddy_Quimby
Fred_Kanneke
Freedom
Frog_Prince
Furious_George
Gabbo
Gabby_Crouse
Garwood_Simpson
Gary_Chalmers
Gary_nerd
Gary_the_Unicorn
Gavin
Gay_Colonel
Geech
General_Sherman
George_Burns_character
Gerald_Samson
German_Santa_Girl
Gheet_Nahasapeemapetilon
Gil_Gunderson
Gina_Vendetti
Ginger_Flanders
Gino_Terwilliger
Girl_with_glasses
Girl_with_ponytail
Gitmo_Spuckler
Giuseppe
Gladys_Gurney
Gloria_Jailbird
Glorias_Daughter
Glorias_Husband
Glorias_Older_Son
Glorias_Younger_Son
Gloria_White_Christmas_Blues
God
Gorilla_the_Conqueror
Grady
Grandma_Flanders
Grandma_Van_Houten
Grandpa_Van_Houten
Great_Son
Greta_Wolfcastle
Gretchen
Greyhound_Puppies
Groundskeeper_Willie
Guard_Dog
Gummy_Sue_Spuckler
Gunter
Gus_Huebner
Ham
Hamster_Number_1
Hamster_Number_2
Handsome_Pete
Hank_Scorpio
Hans_Moleman
Harper_Jambowski
Heather_Spuckler
Helen_Lovejoy
Henry_the_Canary
Herbert_Powell
Hercules
Herman_Hermann
Hippie
Hiram_Simpson
Holly_Hippie
Homer_Jr
Homer_Simpson
Homer_the_Thief
Honore_Bouvier
Horatio_McCallister
Hortense_Simpson
Howard
Howland_Simpson
Hubert_Simpson
Hugo_Simpson_I
Hugo_Simpson_II
Humphrey_Little_Goat
Hungry_Spuckler_Baby
Hurt_Leg_Simpson_Relative
Ian_Very_Tall_Man
Ice_Cream_Lady
Iggy_Wiggum
Incest_Spuckler
Indian_Nerd
International_Harvester_Spuckler
Ironfist_Burns
Isabel_Gutierrez
Itchy
Ivy_Simpson
Jack_Deforest
Jack_Lassen
Jack_Marley
Jacqueline_Bouvier
Jacques
Jake_Boyman
Jake_the_Barber
Jamie
Jane_Nervous_Goat
Janey_Powell
Jasper_Beardly
Jay_Sherman
Jebediah_Springfield
Jehoshaphat_Flanders
Jenda_Simpson
Jenny
Jeremy_Freedman
Jeremy_Jailbird
Jericho
Jessica_Lovejoy
Jimbo_Jones
Jitney_Spuckler
J_Loren_Pryor
Joe_Puffing_Goat
Joe_Quimby
Joey_Crusher
Joey_mafia
John_Homers_Phobia
Johnny_Tightlips
JoJo_Bouvier
Jonathan_Frink
Jordan_Spuckler
Jose_Flanders
Jub_Jub
Judge_Constance_Harm
Judge_Muntz
Jug_Band_Manager
Juliet_Hobbes
Julio
Julius_Hibbert
Just_Stamp_the_Ticket_Man
Kang
Kavi_Nahasapeemapetilon
Kearney_Zzyzwicz
Kearney_Zzyzwicz_Jr
Kent_Brockman
Kevin_Stealing_First_Base
Khlav_Kalash_vendor
Kirk_Simpson
Kirk_Van_Houten
Kodos
Krustys_son
Krusty_the_Clown
Kumiko_Albertson
Kwik_E_Mart_President
Kyle_3rd_Grader
Kyle_LaBianco
Kyles_Father
Kyles_Mother
Kyles_Sister
Lady_Nedderly_Flanders
Lady_Nedebel_Flanders
Lady_Nedwina_Dredful
Lambert_Simpson
Langdon_Alger
Lard_Lad
Larry_barfly
Larry_Burns
Legs
Lenny_Leonard
Leon_Kompowsky
Leopold
Leprechaun
Lewis_Clark
Lewis_lookalike
Lily_Bancroft
Lindsey_Naegle
Ling_Bouvier
Lionel_Hutz
Lisa_and_Nelsons_children
Lisas_Friend_2
Lisas_Friend_3
Lisas_Friend_Four
Lisa_Simpson
Little_Bearded_Woman
Little_Moe_Szyslak
Llewellyn_Sinclair
Loch_Ness_Monster
Lois_Pennycandy
Long_haired_girl
Lord_Nose
Lord_Thistlewick_Flanders
Lord_Thistlewick_of_Flanders
Lou
Louie_mafia
Lowblow
Luann_Van_Houten
Lucas_Bortner
Lucille_Botzcowski
Lucius_Sweet
Lugash
Luigi_Risotto
Luke_Perry_character
Lumpy
Lurleen_Lumpkin
Lyla
Lyle_Lanley
Mabel_Simpson
MacArthur_Parker
Maggies_Husband
Maggie_Simpson
Maggie_Simpson_Jr
Male_Twin
Manjula_Nahasapeemapetilon
Manjulas_Father
Manjulas_Mother
Marcel_Bouvier
Marges_demons
Marge_Simpson
Martha_Prince
Martha_Quimby
Martin_Prince
Martin_Prince_Sr
Marty_KBBL_DJ
Marvin_Monroe
Mary_Bailey
Mary_Frowning_Cloud
Mary_Spuckler
Master_Sushi_Chef
Mathemagician
Matt_Groening_character
Maude_Flanders
Maude_Flanders_ghost
Maw_Spuckler
Maxine_Lombard
Max_Spuckler
Mayor_Quimbys_Body_Guards
Medicine_Woman
Megan
Melody_Juniper
Melvin_Van_Horne
Melvin_Van_Hornes_grandchildren
Melvin_Van_Hornes_son
Melvis_Spuckler
Merl
Mervin_Monroe
Mia_Farrow
Michael_DAmico
Mikes_Student_1
Mikes_Student_2
Mikes_Student_3
Milford_Van_Houten
Milhouse_Van_Houten
Millionaire_Actor
Milo
Mimsy_Bancroft
Mindy_Simmons
Minimum_Wade_Spuckler
Miss_Springfield
Moe_Szyslak
Mojo_the_Helper_Monkey
Mona_Simpson
Moshe_Bernstein
Mr_Burns_older_siblings
Mr_Costington
Mr_McGreg
Mrs_Muntz
Mrs_Vanderbilt
Mr_Teeny
Mr_Vanderbilt
Mr_Winfield
Ms_Albright
Mugger
Multi_eyed_squirrel
My_Ding_a_Ling_Kid
Nabendu_Nahasapeemapetilon
Nana_Sophie_Mussolini
Ned_Flanders
Nedgar_Flanders
Nediana_Flanders
Nedmond_Flanders
Nedna_Flanders
Neduchadnezzar_Flanders
Nedward_Flanders_Sr
Nedwynn_Flanders
Neil_Terwilliger
Nelson_Muntz
Nelson_Muntz_Jr
Nick_Riviera
Nikki_McKenna
Nina_Skalka
Noah_Father_Knows_Worst
Norbert_Van_Houten
Normal_Head_Joe_Spuckler
Norman_Van_Horne
Number_One
Old_Jewish_Man
Opal
Orville_Simpson
Otto_Graycomb
Otto_Mann
Oxycontin_Spuckler
Pahusacheta_Nahasapeemapetilon
Patches
Patty_Bouvier
Pediculus_Spuckler
Pepe_Bouvier
Pepita_Hernandez
Pete_Spuckler
Phillips
Photo_Girl
Picard_Simpson
Pigeon_Rat
Pippa_Simpson
Playground_ghost
Plopper
Pokey
Poochie
Poonam_Nahasapeemapetilon
Poor_Violet
Popular_Girl_1
Popular_Girl_2
Popular_Girl_3
Popular_Girl_Four
Portuguese_Boy
Pria_Nahasapeemapetilon
Princess_Kashmir
Princess_Penelope
Prison_Snitch_Simpson_Relative
Professor_Lombardo
Professor_Werner_von_Brawn
Prudence_Simpson
Prune_Juice_Nerd
Pyro
Q_Bert_Spuckler
Rabbi_Hyman_Krustofsky
Rachel_Jordan
Rachel_Krustofsky
Radioactive_Man_character
Rainier_Wolfcastle
Ralph_Moaning_Lisa
Ralph_Wiggum
Rangemaster
Raphael
Rasputin_the_Friendly_Russian
Reilly_Muntz
Report_Card
Rest_Stop_Spuckler
Rex_Banner
Rex_I_Love_Lisa
Richard
Robber_Homer_and_Apu
Robert_Terwilliger
Rod_Flanders
Roger_Meyers_Jr
Rosa_Barks
Ross
Roy
Roy_Snyder
Rubella_Scabies_Spuckler
Rumor_Spuckler
Rupert_Simpson
Russ_Cargill
Ruth_Powers
Sailor_Kid
Samantha_Stankey
Sam_barfly
Sandeep_Nahasapeemapetilon
Sandwich_Delivery_Guy
Sanjay_Nahasapeemapetilon
Santas_Little_Helper
Sarah_Wiggum
Sara_Student
Sashi_Nahasapeemapetilon
Saul_Bernstein
Scott_Christian
Scout_Spuckler
Scratchy
Screamapillar
Sebastian_Cobb
Selma_Bouvier
Serak_the_Preparer
Sexy_Assistant
Seymour_Skinner
Seymour_Skinner_real
Shary_Bobbins
Shauna_Chalmers
Shelby
Sheldon_Skinner
Sherri_and_Terris_children
Sherri_Mackleberry
Singaporean_Girl
Singing_Girl
Sir_Nederick_Flanders
Smilin_Joe_Fission
Smug_Girl
Snake_Jailbird
Snowball_II
Snowball_V
Sophie_Jensen
Sophie_Krustofsky
Spirit_Guide
Springfield_bears
Springfield_Nuclear_Power_Plant_employee
Springfield_Pet_Shop_owner
Stabbed_in_Jail_Spuckler
Stampy
Stanley_Simpson
State_Comptroller_Atkins
Stingy
Strangles
Sven_Simpson
Sylvia_Winfield
Taffy
Tanya
Taquito
Tattoo_Annie
Taylor_Spuckler
Ted_Flanders
Terri_Mackleberry
The_Human_Fly
The_Leader
The_Nahasapeemapetilon_Octuplets
The_Nahasapeemapetilon_Octuplets_Octuplets
The_Rich_Texan
The_Warden
The_Yes_Guy
Three_Unnamed_Spuckler_Babies
Tiffany_Spuckler
Timothy_Lovejoy_Jr
Tina_Ballerina
Titania
Todd_Flanders
Tommy
Toshiro
Tripod_Spuckler
Trixie_Simpson
Troy_McClure
Tumi
Two_nicorn
Tyler_Moms_Id_Like_to_Forget
Tyrone_Simpson
Ugolin
Uma_Nahasapeemapetilon
Unborn_Spuckler_Baby
Unnamed_Latino_Man
Unnamed_smoking_man
Unnamed_Spuckler_Baby
Uter_Zorker
Veterinarian
Victor_Bouvier
Victor_Bouvier_II
Virgil_Simpson
Wainwright_Montgomery_Burns
Wanda
Warren_Camper
Waverly_Hills_Boy_1
Waverly_Hills_Boy_2
Waverly_Hills_Boy_3
Waverly_Hills_Boy_Four
Waverly_Hills_Girl_1
Waylon_Smithers_Jr
Wendell_Borton
Wesley_Spuckler
Wesley_Wiggum
Wheel_Spuckler
White_Haired_Girl
White_Kid
Whitney_Spuckler
Wilhelmina_Dumperdorf
Winifred_Running_Goat
Winifred_Trout
Woody_Allen
Worm_eating_boy
Yellow_Weasel
Yuma_Hickman
Yves_Bouvier
Zeke_Simpson
Zeph_Burns
Zia_Simpson
Zoe_Spuckler
Zorina_Ovadia
