#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include <xcb/xcb.h>
#include <xcb/xinerama.h>
#include <xcb/xcb_icccm.h>

#include "ppport.h"

#include "typedefs.h"
#include "xs_object_magic.h"

typedef xcb_connection_t XCBConnection;
typedef xcb_icccm_wm_hints_t X11_XCB_ICCCM_WMHints;
typedef xcb_size_hints_t X11_XCB_ICCCM_SizeHints;

#include "XCB.inc"

typedef int intArray;

intArray *intArrayPtr(int num) {
        intArray *array;

        New(0, array, num, intArray);

        return array;
}

static SV *
_new_event_object(xcb_generic_event_t *event)
{
    int type;
    char *objname;
    HV* hash = newHV();

    hv_store(hash, "response_type", strlen("response_type"), newSViv(event->response_type), 0);
    hv_store(hash, "sequence", strlen("sequence"), newSViv(event->sequence), 0);

    // Strip highest bit (set when the event was generated by another client)
    type = (event->response_type & 0x7F);

    switch (type) {
        case XCB_MAP_NOTIFY:
        {
            objname = "X11::XCB::Event::MapNotify";
            xcb_map_notify_event_t *e = (xcb_map_notify_event_t*)event;
            hv_store(hash, "event", strlen("event"), newSViv(e->event), 0);
            hv_store(hash, "window", strlen("window"), newSViv(e->window), 0);
            hv_store(hash, "override_redirect", strlen("override_redirect"), newSViv(e->override_redirect), 0);
        }
        break;

        case XCB_FOCUS_IN:
        case XCB_FOCUS_OUT:
        {
            objname = "X11::XCB::Event::Focus";
            xcb_focus_in_event_t *e = (xcb_focus_in_event_t*)event;
            hv_store(hash, "event", strlen("event"), newSViv(e->event), 0);
            hv_store(hash, "mode", strlen("mode"), newSViv(e->mode), 0);
        }
        break;

        case XCB_CLIENT_MESSAGE:
        {
            objname = "X11::XCB::Event::ClientMessage";
            xcb_client_message_event_t *e = (xcb_client_message_event_t*)event;
            hv_store(hash, "window", strlen("window"), newSViv(e->window), 0);
            hv_store(hash, "type", strlen("type"), newSViv(e->type), 0);
            hv_store(hash, "data", strlen("data"), newSVpvn(&(e->data), 20), 0);
        }
        break;

        default:
            objname = "X11::XCB::Event::Generic";
            break;
    }


    return sv_bless(newRV_noinc((SV*)hash), gv_stashpv(objname, 1));
}


MODULE = X11::XCB PACKAGE = X11::XCB

BOOT:
{
    HV *stash = gv_stashpvn("X11::XCB", strlen("X11::XCB"), FALSE);
    HV *export_tags = get_hv("X11::XCB::EXPORT_TAGS", FALSE);
    SV **export_tags_all = hv_fetch(export_tags, "all", strlen("all"), 0);
    SV *tmpsv;
    AV *tags_all;

    if (!(export_tags_all &&
        SvROK(*export_tags_all) &&
        (tmpsv = (SV*)SvRV(*export_tags_all)) &&
        SvTYPE(tmpsv) == SVt_PVAV &&
        (tags_all = (AV*)tmpsv)))
    {
        croak("$EXPORT_TAGS{all} is not an array reference");
    }

    boot_constants(stash, tags_all);
}

void
_connect_and_attach_struct(self)
    SV *self
  PREINIT:
    XCBConnection *xcbconnbuf;
  CODE:
    assert(sv_derivered_from(self, __PACKAGE__));
    SV **disp = hv_fetch((HV*)SvRV(self), "display", strlen("display"), 0);
    if(!disp)
        croak("Attribute 'display' is required");

    const char *displayname = SvPV_nolen(*disp);
    int screenp;

    xcbconnbuf = xcb_connect(displayname, &screenp);
    /* XXX: error checking */
    xs_object_magic_attach_struct(aTHX_ SvRV(self), xcbconnbuf);

void
DESTROY(self)
    XCBConnection *self
  CODE:
    Safefree(self);

int
has_error(self)
    XCBConnection * self
  CODE:
    RETVAL = xcb_connection_has_error(self);
  OUTPUT:
    RETVAL


int
get_file_descriptor(self)
    XCBConnection * self
  CODE:
    RETVAL = xcb_get_file_descriptor(self);
  OUTPUT:
    RETVAL


SV *
wait_for_event(self)
    XCBConnection * self
  PREINIT:
    HV * hash;
    SV * result;
    xcb_generic_event_t * event;
  CODE:
    event = xcb_wait_for_event(self);
    if (event == NULL) {
        RETVAL = &PL_sv_undef;
    } else {
        RETVAL = _new_event_object(event);
    }
  OUTPUT:
    RETVAL


SV *
poll_for_event(self)
    XCBConnection * self
  PREINIT:
    HV * hash;
    SV * result;
    xcb_generic_event_t * event;
  CODE:
    event = xcb_poll_for_event(self);
    if (event == NULL) {
        RETVAL = &PL_sv_undef;
    } else {
        RETVAL = _new_event_object(event);
    }
  OUTPUT:
    RETVAL


int
get_root_window(conn)
    XCBConnection *conn
  CODE:
    RETVAL = xcb_setup_roots_iterator(xcb_get_setup(conn)).data->root;
  OUTPUT:
    RETVAL


int
generate_id(conn)
    XCBConnection *conn
  CODE:
    RETVAL = xcb_generate_id(conn);
  OUTPUT:
    RETVAL

void
flush(conn)
    XCBConnection *conn
  CODE:
    xcb_flush(conn);


INCLUDE: XCB_util.inc

INCLUDE: XCB_xs.inc
