# Generated by default/object.tt
package Paws::ComputeOptimizer::ExportDestination;
  use Moose;
  has S3 => (is => 'ro', isa => 'Paws::ComputeOptimizer::S3Destination', request_name => 's3', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::ExportDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::ExportDestination object:

  $service_obj->Method(Att1 => { S3 => $value, ..., S3 => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::ExportDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->S3

=head1 DESCRIPTION

Describes the destination of the recommendations export and metadata
files.

=head1 ATTRIBUTES


=head2 S3 => L<Paws::ComputeOptimizer::S3Destination>

An object that describes the destination Amazon Simple Storage Service
(Amazon S3) bucket name and object keys of a recommendations export
file, and its associated metadata file.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

