# Generated by default/object.tt
package Paws::LexRuntimeV2::ConfigurationEvent;
  use Moose;
  has ClientTimestampMillis => (is => 'ro', isa => 'Int', request_name => 'clientTimestampMillis', traits => ['NameInRequest']);
  has DisablePlayback => (is => 'ro', isa => 'Bool', request_name => 'disablePlayback', traits => ['NameInRequest']);
  has EventId => (is => 'ro', isa => 'Str', request_name => 'eventId', traits => ['NameInRequest']);
  has RequestAttributes => (is => 'ro', isa => 'Paws::LexRuntimeV2::StringMap', request_name => 'requestAttributes', traits => ['NameInRequest']);
  has ResponseContentType => (is => 'ro', isa => 'Str', request_name => 'responseContentType', traits => ['NameInRequest'], required => 1);
  has SessionState => (is => 'ro', isa => 'Paws::LexRuntimeV2::SessionState', request_name => 'sessionState', traits => ['NameInRequest']);
  has WelcomeMessages => (is => 'ro', isa => 'ArrayRef[Paws::LexRuntimeV2::Message]', request_name => 'welcomeMessages', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::ConfigurationEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::ConfigurationEvent object:

  $service_obj->Method(Att1 => { ClientTimestampMillis => $value, ..., WelcomeMessages => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::ConfigurationEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->ClientTimestampMillis

=head1 DESCRIPTION

The initial event sent from the application to Amazon Lex V2 to
configure the conversation, including session and request attributes
and the response content type.

=head1 ATTRIBUTES


=head2 ClientTimestampMillis => Int

A timestamp set by the client of the date and time that the event was
sent to Amazon Lex V2.


=head2 DisablePlayback => Bool

Determines whether Amazon Lex V2 should send audio responses to the
client application. When this parameter if C<false>, the client
application needs to create responses for the user.


=head2 EventId => Str

A unique identifier that your application assigns to the event. You can
use this to identify events in logs.


=head2 RequestAttributes => L<Paws::LexRuntimeV2::StringMap>

Request-specific information passed between the client application and
Amazon Lex V2.

The namespace C<x-amz-lex:> is reserved for special attributes. Don't
create any request attributes for prefix C<x-amz-lex:>.


=head2 B<REQUIRED> ResponseContentType => Str

The message that Amazon Lex V2 returns in the response can be either
text or speech based on the C<responseContentType> value.

=over

=item *

If the value is C<text/plain;charset=utf-8>, Amazon Lex V2 returns text
in the response.

=item *

If the value begins with C<audio/>, Amazon Lex V2 returns speech in the
response. Amazon Lex V2 uses Amazon Polly to generate the speech using
the configuration that you specified in the C<requestContentType>
parameter. For example, if you specify C<audio/mpeg> as the value,
Amazon Lex V2 returns speech in the MPEG format.

=item *

If the value is C<audio/pcm>, the speech returned is audio/pcm in
16-bit, little-endian format.

=item *

The following are the accepted values:

=over

=item *

audio/mpeg

=item *

audio/ogg

=item *

audio/pcm

=item *

audio/* (defaults to mpeg)

=item *

text/plain; charset=utf-8

=back

=back



=head2 SessionState => L<Paws::LexRuntimeV2::SessionState>




=head2 WelcomeMessages => ArrayRef[L<Paws::LexRuntimeV2::Message>]

A list of messages to send to the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

