#!/usr/bin/env raku

use Terminal::ANSI;

save-screen;
clear-screen;
home;
for 0..255 {
  set-bg-color($_);
  my $fg = do {
    when 0..6 { 255 }
    when 8 { 255 }
    when -> $i { $i ∈ any ( ( 16, 52, 88 ... 196 ) Z.. (33, 69, 105 ... 213 ) ) } { 255 }
    when 232..243 { 255 }
    default { 0 }
  };
  set-fg-color($fg);
  my $fmt = do {
    when 0..15 { '%7d  ' }
    when 232..255 { '%4d  '}
    default { '%4d' }
    };
  print .fmt($fmt);
  print "\n" if $_ ∈ ( 15, 51, 87 ... 255 );
}
print "\n";
set-fg-color(255);
set-bg-color(0);
prompt "press return>";
restore-screen;
