#!/usr/bin/perl -w
#
#    dateFormat.pl
#
#    $Id: dateFormat.pl,v 1.2 2001/02/11 03:27:53 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License 
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno strftime);
use Time::Local;
use utf8;

use ExtUtils::testlib;
use ICU;
use ICU::DateFormat qw( :EStyle :EField);
use ICU::Locale;
use ICU::TimeZone;

print "<pre>\n";
# for testing: pick a constant time to format / parse
# TODO: need to set timezone
my $time_to_format = (60*60*24*365) + (60*60*24*60);
print "time_to_format = $time_to_format\n";
my $tz_pst = ICU::TimeZone->createTimeZone('PST');
ICU::TimeZone->setDefault($tz_pst);


# TODO: need to use FieldPosition

#
# Decide what to show
#
my $show_default_DateTime_format = 1;
my $show_DateTime_formats = 1;
my $show_DateTime_formats_all_Date_formats = 1;
my $show_DateTime_formats_all_DateTime_formats = 1;
my $show_DateTime_formats_all_Time_formats = 1;
my $show_DateTime_formats_fieldPosition = 1;
my $show_toPattern = 1;
my $show_locales = 1;
my $show_locales_show_max = 0; # 0 means all
my $show_enums = 1;
my $show_japanese = 1;
my $show_parsing = 1;

if ($show_default_DateTime_format) {
    print "show default date/time formats:\n";
    show_default_DateTime_format($time_to_format,'en_US');
}

if ($show_DateTime_formats) {
    print "show date/time formats:\n";
    show_formats($time_to_format, 'en_US');
    show_formats($time_to_format, 'de_DE');
    if ($show_japanese) {
        show_formats($time_to_format, 'ja_JP');
    }
}

if ($show_DateTime_formats_fieldPosition) {
    show_format_fieldPosition($time_to_format,'en_US');
}

if ($show_enums) {
    print "show enums:\n";
    show_enums();
}

if ($show_parsing) {
    my $en_l = new ICU::Locale('en_US');
    my $en_dtf = ICU::DateFormat->createDateTimeInstance(kFull, kFull, $en_l);
    my $en_datetime_str = 'Monday, March 1, 1971 4:00:00 PM PST';
    print "        en parsing: '$en_datetime_str'\n";
    my $en_parsed_time = $en_dtf->parse($en_datetime_str);
    print "              en gmtime($en_parsed_time) = ".gmtime($en_parsed_time/1000)."\n";
    print "              en localtime($en_parsed_time) = ".localtime($en_parsed_time/1000)."\n";

    my $l_ja = new ICU::Locale('ja_JP');
    my $dtf_ja = ICU::DateFormat->createDateTimeInstance(kFull, kFull, $l_ja);
    my $ja_datetime_str = '1971年3月1日 16時00分00秒GMT-08:00';
    print "        ja parsing: '$ja_datetime_str'\n";
    my $ja_parsed_time = $dtf_ja->parse($ja_datetime_str);
    print "              ja gmtime($ja_parsed_time) = ".gmtime($ja_parsed_time/1000)."\n";
    print "              ja localtime($ja_parsed_time) = ".localtime($ja_parsed_time/1000)."\n";
}

sub show_toPattern {
    if (!$show_toPattern) {
        return;
    }

    my ($df, $indent) = @_;
    my $pattern = $df->toPattern();
        print "${indent}pattern = \"$pattern\"\n";
}

sub show_default_DateTime_format {
    my $df = ICU::DateFormat->createInstance();
    print "show date/time default format:\n";
    print "    default date/time: ".$df->format($time_to_format*000)."\n";
}

sub show_enums {
    print "kNone       = ".kNone."\n";
    print "kFull       = ".kFull."\n";
    print "kLong       = ".kLong."\n";
    print "kMedium     = ".kMedium."\n";
    print "kDefault    = ".kDefault."\n";
    print "kShort      = ".kShort."\n";
    print "kDateOffset = ".kDateOffset."\n";
    print "kDateTime   = ".kDateTime."\n";


    print "kEraField              = ".kEraField."\n";
    print "kYearField             = ".kYearField."\n";
    print "kMonthField            = ".kMonthField."\n";
    print "kDateField             = ".kDateField."\n";
    print "kHourOfDay1Field       = ".kHourOfDay1Field."\n";
    print "kHourOfDay0Field       = ".kHourOfDay0Field."\n";
    print "kMinuteField           = ".kMinuteField."\n";
    print "kSecondField           = ".kSecondField."\n";
    print "kMillisecondField      = ".kMillisecondField."\n";
    print "kDayOfWeekField        = ".kDayOfWeekField."\n";
    print "kDayOfYearField        = ".kDayOfYearField."\n";
    print "kDayOfWeekInMonthField = ".kDayOfWeekInMonthField."\n";
    print "kWeekOfYearField       = ".kWeekOfYearField."\n";
    print "kWeekOfMonthField      = ".kWeekOfMonthField."\n";
    print "kAmPmField             = ".kAmPmField."\n";
    print "kHour1Field            = ".kHour1Field."\n";
    print "kHour0Field            = ".kHour0Field."\n";
    print "kTimezoneField         = ".kTimezoneField."\n";
    print "kYearWOYField          = ".kYearWOYField."\n";
    print "kDOWLocalField         = ".kDOWLocalField."\n";
}

sub show_format_fieldPosition {
    my $df = ICU::DateFormat->createInstance();
    print "show date/time using FieldPosition:\n";
    print "    date/time fpos = 1: ".$df->format($time_to_format*1000, 1)."\n";
    print "    date/time fpos = 2: ".$df->format($time_to_format*1000, 2)."\n";
    print "    date/time fpos = 3: ".$df->format($time_to_format*1000, 3)."\n";
}

sub show_formats {
    my ($time, $locale_str) = @_;

    print "    locale: $locale_str\n";
    my $locale = new ICU::Locale($locale_str);

    my $df = ICU::DateFormat->createInstance();
    print "      default date/time: ".$df->format($time*1000)."\n";
    show_toPattern($df,'    ');
    #print __FILE__ . ' ' . __LINE__ . "\n";
    $df = undef;
    #print __FILE__ . ' ' . __LINE__ . "\n";

    my $dff = ICU::DateFormat->createDateInstance(kFull, $locale);
    #print __FILE__ . ' ' . __LINE__ . "\n";
    print "      date(kFull) in locale: ".$dff->format($time*1000)."\n";
    my $dff_dl = ICU::DateFormat->createDateInstance(kFull);
    print "      date(kFull) in default locale: ".$dff_dl->format($time*1000)."\n";
    show_toPattern($dff,'    ');
    if ($show_DateTime_formats_all_Date_formats) {
        my $df = ICU::DateFormat->createDateInstance();
        print "      date: ".$df->format($time*1000)."\n";
        show_toPattern($df,'    ');
        my $dfl = ICU::DateFormat->createDateInstance(kLong, $locale);
        print "      date(kLong): ".$dfl->format($time*1000)."\n";
        show_toPattern($dfl,'    ');
        my $dfm = ICU::DateFormat->createDateInstance(kMedium, $locale);
        print "      date(kMedium): ".$dfm->format($time*1000)."\n";
        show_toPattern($dfm,'    ');
        my $dfs = ICU::DateFormat->createDateInstance(kShort, $locale);
        print "      date(kShort): ".$dfs->format($time*1000)."\n";
        show_toPattern($dfs,'    ');
        my $dfdo = ICU::DateFormat->createDateInstance(kDateOffset, $locale);
        print "      date(kDateOffset): ".$dfdo->format($time*1000)."\n";
        show_toPattern($dfdo,'    ');
        my $dfdt = ICU::DateFormat->createDateInstance(kDateTime, $locale);
        print "      date(kDateTime): ".$dfdt->format($time*1000)."\n";
        show_toPattern($dfdt,'    ');
    }

    my $tff = ICU::DateFormat->createTimeInstance(kFull, $locale);
    print "      time(kFull): ".$tff->format($time*1000)."\n";
    show_toPattern($tff,'    ');
    if ($show_DateTime_formats_all_Time_formats) {
        my $tf = ICU::DateFormat->createTimeInstance();
        print "      time(default): ".$tf->format($time*1000)."\n";
        show_toPattern($tf,'    ');
        my $tfl = ICU::DateFormat->createTimeInstance(kLong, $locale);
        print "      time(kLong): ".$tfl->format($time*1000)."\n";
        show_toPattern($tfl,'    ');
        my $tfm = ICU::DateFormat->createTimeInstance(kMedium, $locale);
        print "      time(kMedium): ".$tfm->format($time*1000)."\n";
        show_toPattern($tfm,'    ');
        my $tfs = ICU::DateFormat->createTimeInstance(kShort, $locale);
        print "      time(kShort): ".$tfs->format($time*1000)."\n";
        show_toPattern($tfs,'    ');
        my $tfdo = ICU::DateFormat->createTimeInstance(kDateOffset, $locale);
        print "      time(kDateOffset): ".$tfdo->format($time*1000)."\n";
        show_toPattern($tfdo,'    ');
        my $tfdt = ICU::DateFormat->createTimeInstance(kDateTime, $locale);
        print "      time(kDateTime): ".$tfdt->format($time*1000)."\n";
        show_toPattern($tfdt,'    ');
    }

    my $dtff = ICU::DateFormat->createDateTimeInstance(kFull, kFull, $locale);
    print "      dateTime(kFull, kFull): ".$dtff->format($time*1000)."\n";
    show_toPattern($dtff,'    ');
    if ($show_DateTime_formats_all_DateTime_formats) {
        my $dtf = ICU::DateFormat->createDateTimeInstance();
        print "      dateTime(default): ".$dtf->format($time*1000)."\n";
        show_toPattern($dtf,'    ');
        my $dtfl = ICU::DateFormat->createDateTimeInstance(kLong, kLong, $locale);
        print "      dateTime(kLong, kLong): ".$dtfl->format($time*1000)."\n";
        show_toPattern($dtfl,'    ');
        my $dtfm = ICU::DateFormat->createDateTimeInstance(kMedium, kMedium, $locale);
        print "      dateTime(kMedium, kMedium): ".$dtfm->format($time*1000)."\n";
        show_toPattern($dtfm,'    ');
        my $dtfs = ICU::DateFormat->createDateTimeInstance(kShort, kShort, $locale);
        print "      dateTime(kShort, kShort): ".$dtfs->format($time*1000)."\n";
        show_toPattern($dtfs,'    ');
        my $dtfdo = ICU::DateFormat->createDateTimeInstance(kDateOffset, kDateOffset, $locale);
        print "      dateTime(kDateOffset, kDateOffset): ".$dtfdo->format($time*1000)."\n";
        show_toPattern($dtfdo,'    ');
        my $dtfdt = ICU::DateFormat->createDateTimeInstance(kDateTime, kDateTime, $locale);
        print "      dateTime(kDateTime, kDateTime): ".$dtfdt->format($time*1000)."\n";
        show_toPattern($dtfdt,'    ');
    }
}

if ($show_locales) {
    my @locales = ICU::DateFormat->getAvailableLocales();
    my $locale_length = scalar(@locales);
    print "lenght of \@locales is $locale_length\n";
    for (my $i=0; $i<$locale_length; $i++) { 
        if (($show_locales_show_max) && ($i >= $show_locales_show_max)) {
            if ($i == $show_locales_show_max) {
              print "    ... (".($locale_length-$i)." remaining locales not shown)\n";
            }
            next;
        }
        print "    locale[$i] = ".($locales[$i])->getName()."\n";
    }
    print "\n";
}

ICU::DateFormat::setDebugLevel(155);
print "</pre>\n";
exit(0);
