### The switching system to parse a message

sub new {
  my ($class, $newprinter, $newcompiler) = @_;

  $self = { printer => $newprinter,
	    scanner => $newscanner,
	    compiler => $newcompiler,
	    messagequeue => ParserAIMessageQueue->new,
	  };

  bless $self, $class;
}

sub runOnce {
  my $self = shift;

  ### FIXME
}

### the following does not use the messagequeue, the message is a specialization
sub sendImmediate {
  my ($self, $wrappedmessage) = @_;

  $self->switch($wrappedmessage);
}

sub send {
  my ($self, $wrappedmessage) = @_;

  
}

sub switch {
  my ($self, $mesg) = @_;

  return $self->parseMessage($mesg);
}

sub parseMessage {
  my ($self, $mesg) = @_;

  given($mesg->getTypeString) {

    ### This parses commands from the shell although other commands exist
    ### out of this given-when switch
    when ("command!") {
      given ($mesg->getCarry) {
	when ("load") {
	  ### FIXME adds load component with $self->{compiler}
	}
	when ("select") {
	  ### FIXME adds select component with $self->{compiler}
	}
	### NOTE
	default {
	  $self->{printer}->println("I am not sure what you mean by this command. type in help if you do not what to do.");
	}
      }
    }
    when ("print") {
      $tobeprinted = $mesg->getCarry->getData;
      $self->{printer}->println($tobeprinted);
    }
    when ("scan") {
      $self->{scanner}->scanLine();
    }
    when ("load") {
      ### FIXME adds load component with $self->{compiler}
    }
    when ("select") {
      ### FIXME adds select component with $self->{compiler}
    }
    default {
      $self->{printer}->println("Unknown message.");
    }
  }
}

1;
