#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::CommentTypeCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CommentTypeCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::CommentTypeCodeType

=head1 DESCRIPTION

These are the codes used to specify the type of feedback/comments in a single feedback record. Additional information about feedback is available in the
online Help of the eBay website.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Positive

Positive feedback. Increases total feedback score.



=cut


use constant Positive => scalar('Positive');


=head2 Neutral

Neutral feedback. No effect on total feedback score.



=cut


use constant Neutral => scalar('Neutral');


=head2 Negative

Negative feedback. Decreases total feedback score.



=cut


use constant Negative => scalar('Negative');


=head2 Withdrawn

Withdrawn feedback. Removes the effect of the original
feedback on total feedback score. Comments from withdrawn feedback
are still visible.



=cut


use constant Withdrawn => scalar('Withdrawn');


=head2 IndependentlyWithdrawn

Applies to the eBay Motors site only. Feedback is withdrawn based on
the decision of a third party.



=cut


use constant IndependentlyWithdrawn => scalar('IndependentlyWithdrawn');


=head2 CustomCode

Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
