/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.HTMLURIEscaper;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class EscapeURI
extends SystemFunction
implements CallableExpression {
    public static final int ENCODE_FOR_URI = 1;
    public static final int IRI_TO_URI = 2;
    public static final int HTML_URI = 3;
    public static boolean[] allowedASCII = new boolean[128];
    private static final String hex = "0123456789ABCDEF";
    private static String hexDigits;
    private static int[] UTF8RepresentationLength;

    public Item evaluateItem(XPathContext c) throws XPathException {
        Item item = this.argument[0].evaluateItem(c);
        return this.evalEscapeURI(item, c);
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        return Value.asIterator(this.evalEscapeURI((Item)arguments[0].next(), context));
    }

    private Item evalEscapeURI(Item item, XPathContext c) throws XPathException {
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence s = item.getStringValueCS();
        switch (this.operation) {
            case 1: {
                return StringValue.makeStringValue(EscapeURI.escape(s, "-_.~"));
            }
            case 2: {
                return StringValue.makeStringValue(EscapeURI.iriToUri(s));
            }
            case 3: {
                return StringValue.makeStringValue(HTMLURIEscaper.escapeURL(s, false, c.getConfiguration()));
            }
        }
        throw new UnsupportedOperationException("Unknown escape operation");
    }

    public static CharSequence iriToUri(CharSequence s) {
        if (EscapeURI.allAllowedAscii(s)) {
            return s;
        }
        FastStringBuffer sb = new FastStringBuffer(s.length() + 20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u007f' || !allowedASCII[c]) {
                EscapeURI.escapeChar(c, i + 1 < s.length() ? s.charAt(i + 1) : (char)' ', sb);
                continue;
            }
            sb.append(c);
        }
        return sb;
    }

    private static boolean allAllowedAscii(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\u007f' && allowedASCII[c]) continue;
            return false;
        }
        return true;
    }

    public static CharSequence escape(CharSequence s, String allowedPunctuation) {
        FastStringBuffer sb = new FastStringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                EscapeURI.escapeChar(c, i + 1 < s.length() ? s.charAt(i + 1) : (char)' ', sb);
                continue;
            }
            if (allowedPunctuation.indexOf(c) >= 0) {
                sb.append(c);
                continue;
            }
            EscapeURI.escapeChar(c, ' ', sb);
        }
        return sb;
    }

    private static void escapeChar(char c, char c2, FastStringBuffer sb) {
        byte[] array = new byte[4];
        int used = UTF8CharacterSet.getUTF8Encoding(c, c2, array);
        for (int b = 0; b < used; ++b) {
            int v = array[b] & 0xFF;
            sb.append('%');
            sb.append(hex.charAt(v / 16));
            sb.append(hex.charAt(v % 16));
        }
    }

    public static void checkPercentEncoding(String uri) throws XPathException {
        int i = 0;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '%') {
                int h2;
                if (i + 2 >= uri.length()) {
                    throw new XPathException("% sign in URI must be followed by two hex digits" + Err.wrap(uri));
                }
                int h1 = hexDigits.indexOf(uri.charAt(i + 1));
                if (h1 > 15) {
                    h1 -= 6;
                }
                if ((h2 = hexDigits.indexOf(uri.charAt(i + 2))) > 15) {
                    h2 -= 6;
                }
                if (h1 >= 0 && h2 >= 0) {
                    int b = h1 << 4 | h2;
                    int expectedOctets = UTF8RepresentationLength[h1];
                    if (expectedOctets == -1) {
                        throw new XPathException("First %-encoded octet in URI is not valid as the start of a UTF-8 character: first two bits must not be '10'" + Err.wrap(uri));
                    }
                    byte[] bytes = new byte[expectedOctets];
                    bytes[0] = (byte)b;
                    i += 3;
                    for (int q = 1; q < expectedOctets; ++q) {
                        if (i + 2 > uri.length() || uri.charAt(i) != '%') {
                            throw new XPathException("Incomplete %-encoded UTF-8 octet sequence in URI " + Err.wrap(uri));
                        }
                        h1 = hexDigits.indexOf(uri.charAt(i + 1));
                        if (h1 > 15) {
                            h1 -= 6;
                        }
                        if ((h2 = hexDigits.indexOf(uri.charAt(i + 2))) > 15) {
                            h2 -= 6;
                        }
                        if (h1 < 0 || h2 < 0) {
                            throw new XPathException("Invalid %-encoded UTF-8 octet sequence in URI" + Err.wrap(uri));
                        }
                        if (UTF8RepresentationLength[h1] != -1) {
                            throw new XPathException("In a URI, a %-encoded UTF-8 octet after the first must have '10' as the first two bits" + Err.wrap(uri));
                        }
                        b = h1 << 4 | h2;
                        bytes[q] = (byte)b;
                        i += 3;
                    }
                    continue;
                }
                throw new XPathException("% sign in URI must be followed by two hex digits" + Err.wrap(uri));
            }
            ++i;
        }
    }

    static {
        Arrays.fill(allowedASCII, 0, 32, false);
        Arrays.fill(allowedASCII, 33, 127, true);
        EscapeURI.allowedASCII[34] = false;
        EscapeURI.allowedASCII[60] = false;
        EscapeURI.allowedASCII[62] = false;
        EscapeURI.allowedASCII[92] = false;
        EscapeURI.allowedASCII[94] = false;
        EscapeURI.allowedASCII[96] = false;
        EscapeURI.allowedASCII[123] = false;
        EscapeURI.allowedASCII[124] = false;
        EscapeURI.allowedASCII[125] = false;
        hexDigits = "0123456789abcdefABCDEF";
        UTF8RepresentationLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 2, 2, 3, 4};
    }
}

