# Generated by default/object.tt
package Paws::DevOpsGuru::ResourceCollection;
  use Moose;
  has CloudFormation => (is => 'ro', isa => 'Paws::DevOpsGuru::CloudFormationCollection');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ResourceCollection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ResourceCollection object:

  $service_obj->Method(Att1 => { CloudFormation => $value, ..., CloudFormation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ResourceCollection object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudFormation

=head1 DESCRIPTION

A collection of AWS resources supported by DevOps Guru. The one type of
AWS resource collection supported is AWS CloudFormation stacks. DevOps
Guru can be configured to analyze only the AWS resources that are
defined in the stacks. You can specify up to 500 AWS CloudFormation
stacks.

=head1 ATTRIBUTES


=head2 CloudFormation => L<Paws::DevOpsGuru::CloudFormationCollection>

An array of the names of AWS CloudFormation stacks. The stacks define
AWS resources that DevOps Guru analyzes. You can specify up to 500 AWS
CloudFormation stacks.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

