/*
 * This function writes the RR_graph generated by VPR into a file in XML format
 * Information included in the file includes rr nodes, rr switches, the grid, block info, node indices
 */

#ifndef RR_GRAPH_WRITER_H
#define RR_GRAPH_WRITER_H

#include "rr_node.h"
#include "rr_graph_type.h"
#include "rr_graph_builder.h"
#include "rr_graph_view.h"
#include "device_grid.h"
#include "physical_types.h"

void write_rr_graph(RRGraphBuilder* rr_graph_builder,
                    RRGraphView* rr_graph,
                    const std::vector<t_physical_tile_type>& physical_tile_types,
                    vtr::vector<RRIndexedDataId, t_rr_indexed_data>* rr_indexed_data,
                    std::vector<t_rr_rc_data>* rr_rc_data,
                    const DeviceGrid& grid,
                    const std::vector<t_arch_switch_inf>& arch_switch_inf,
                    const t_arch* arch,
                    t_chan_width* chan_width,
                    const char* file_name,
                    bool echo_enabled,
                    const char* echo_file_name,
                    bool is_flat);

#endif
