/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbc.translators;

import java.sql.*;
import com.sap.dbtech.jdbc.*;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.util.*;

/**
 *
 */
class GetvalLob
    extends Getval
    implements java.sql.Blob, java.sql.Clob
{
    /**
     * Getval constructor comment.
     */
    public GetvalLob(
        ConnectionSapDB connection,
        byte [] descriptor,
        StructuredMem dataPart,
        int dataKind)
    {
        super (connection, descriptor, dataPart, dataKind);
    }
    /**
     * Returns as an array of bytes part or all of the <code>BLOB</code>
     * value that this <code>Blob</code> object designates.  The byte
     * array contains up to <code>length</code> consecutive bytes
     * starting at position <code>pos</code>.
     * @param pos the ordinal position of the first byte in the
     * <code>BLOB</code> value to be extracted; the first byte is at
     * position 1
     * @param length is the number of consecutive bytes to be copied
     * @return a byte array containing up to <code>length</code>
     * consecutive bytes from the <code>BLOB</code> value designated
     * by this <code>Blob</code> object, starting with the
     * byte at position <code>pos</code>.
     * @exception SQLException if there is an error accessing the
     * <code>BLOB</code>
     */
    public byte[] getBytes(long pos, int length) throws SQLException
    {
        byte [] result;
        pos = pos - 1; // Lobs start at 1
        try {
            if (pos < this.longPosition) {
                throw new NotSupportedException(MessageTranslator.translate(MessageKey.ERROR_MOVEBACKWARDINBLOB));
            }
            java.io.InputStream stream = this.getBinaryStream ();
            if (pos > this.longPosition) {
                stream.skip(pos - this.longPosition);
            }
            result = new byte [length];
            int bytesRead = stream.read (result, 0, length);
            if (bytesRead < length) {
                byte [] tmp = new byte [bytesRead];
                System.arraycopy (result, 0, tmp, 0, bytesRead);
                result = tmp;
            }
        }
        catch (StreamIOException sioExc) {
            throw sioExc.getSqlException();
        }
        catch (java.io.IOException ioExc) {
            throw new JDBCDriverException (ioExc.getMessage());
        }
        return result;
    }
    /**
     * Returns a copy of the specified substring
     * in the <code>CLOB</code> value
     * designated by this <code>Clob</code> object.
     * The substring begins at position
     * <code>pos</code> and has up to <code>length</code> consecutive
     * characters.
     * @param pos the first character of the substring to be extracted.
     *            The first character is at position 1.
     * @param length the number of consecutive characters to be copied
     * @return a <code>String</code> that is the specified substring in
     *         the <code>CLOB</code> value designated by this <code>Clob</code> object
     * @exception SQLException if there is an error accessing the
     * <code>CLOB</code>
     */
    public String getSubString(long pos, int length) throws SQLException
    {
        byte [] bytes = this.getBytes (pos, length);
        return new String (bytes);
    }
    /**
     * Determines the byte position at which the specified byte
     * <code>pattern</code> begins within the <code>BLOB</code>
     * value that this <code>Blob</code> object represents.  The
     * search for <code>pattern</code. begins at position
     * <code>start</code>.
     * @param pattern the byte array for which to search
     * @param start the position at which to begin searching; the
     *        first position is 1
     * @return the position at which the pattern appears, else -1.
     * @exception SQLException if there is an error accessing the
     * <code>BLOB</code>
     */
    public long position(byte pattern[], long start) throws SQLException
    {
        throw new NotImplemented (
            MessageTranslator.translate(MessageKey.ERROR_POSITION_NOTIMPLEMENTED)
        );
    }
    /**
     * Determines the byte position in the <code>BLOB</code> value
     * designated by this <code>Blob</code> object at which
     * <code>pattern</code> begins.  The search begins at position
     * <code>start</code>.
     * @param pattern the <code>Blob</code> object designating
     * the <code>BLOB</code> value for which to search
     * @param start the position in the <code>BLOB</code> value
     *        at which to begin searching; the first position is 1
     * @return the position at which the pattern begins, else -1
     * @exception SQLException if there is an error accessing the
     * <code>BLOB</code>
     */
    public long position(java.sql.Blob pattern, long start) throws SQLException
    {
        byte [] patternBytes = pattern.getBytes (1, (int)pattern.length ());
        return this.position (patternBytes, start);
    }

}
