/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import java.sql.*;
import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.vsp00.*;
import com.sap.dbtech.util.*;
/**
 *
 */
public class DatabaseMetaDataSapDB
implements
    java.sql.DatabaseMetaData
{
    public final static String defaultCatalogName = "";
    private ConnectionSapDB connection;

    private VersionInfo dbVersionInfo = null;
    private String dbVersion = null;
    private String dbName = null;
    private final String typename2odbc_C =
          "'CHAR', 1, "
        + "'CHAR() ASCII', 1, "
        + "'CHAR() EBCDIC', 1, "
        + "'CHAR() UNICODE', 1, "
        + "'CHAR() BYTE', -2, "
        + "'VARCHAR', 12, "
        + "'VARCHAR() ASCII', 12, "
        + "'VARCHAR() EBCDIC', 12, "
        + "'VARCHAR() UNICODE', 12, "
        + "'VARCHAR() BYTE', -3, "
        + "'LONG', -1, "
        + "'LONG ASCII', -1, "
        + "'LONG EBCDIC', -1, "
        + "'LONG UNICODE', -1, "
        + "'LONG BYTE', -4, "
        + "'LONG RAW', -4, "
        + "'FIXED', 3, "
        + "'DECIMAL', 3, "
        + "'REAL', 7, "
        + "'FLOAT', 6, "
        + "'DOUBLE PRECISION', 8, "
        + "'SMALLINT', 5, "
        + "'INTEGER', 4, "
        + "'BOOLEAN', -7, "
        + "'TIME', 92, "
        + "'DATE', 91, "
        + "'TIMESTAMP', 93, "
        + "'NUMBER', 2, "
        + "1111";

    private final String DataTypeSuffix_C =
          "'CHAR','CHAR()',"
        + "'VARCHAR','VARCHAR()',"
        + "'LONG','LONG',"
        + "'LONG RAW','LONG',"
        + "datatype";

    /**
     * DatabaseMetaDataSapDBTech constructor comment.
     */
    DatabaseMetaDataSapDB(ConnectionSapDB connection, VersionInfo mydbVersionInfo)
        throws SQLException
    {
        this.connection = connection;
        this.dbName = connection.getConnectProperty(DriverSapDB.dbName_C);
        this.dbVersionInfo =   mydbVersionInfo;
    }
    /**
     * allProceduresAreCallable method comment.
     */
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }
    /**
     * allTablesAreSelectable method comment.
     */
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }
    /**
     * dataDefinitionCausesTransactionCommit method comment.
     */
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }
    /**
     * dataDefinitionIgnoredInTransactions method comment.
     */
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether or not a visible row delete can be detected by
     * calling ResultSet.rowDeleted().  If deletesAreDetected()
     * returns false, then deleted rows are removed from the result set.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return true if changes are detected by the resultset type
     * @exception SQLException if a database access error occurs
     */
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }
    /**
     * doesMaxRowSizeIncludeBlobs method comment.
     */
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }
    /**
     * getBestRowIdentifier method comment.
     */
    public ResultSet getBestRowIdentifier(
        String catalog,
        String schema,
        String table,
        int scope,
        boolean nullable)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();
        ResultSet result;

        cmd.append ("SELECT "
            + "2 SCOPE, "     // bestRowSession
            + "columnname COLUMN_NAME, "
            + "decode (((decode (datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype))), "
            + typename2odbc_C + ") DATA_TYPE, "
            + "(decode(datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype)) TYPE_NAME, "
            + "len COLUMN_SIZE, "
            + "NULL BUFFER_LENGTH, "
            + "dec DECIMAL_DIGITS, "
            + "1 PSEUDO_COLUMN "   // bestRowNotPseudo
            + "FROM domain.columns ");
        cmd.append ("WHERE tablename = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append ("AND owner = '" + schema + "' ");
        }
        cmd.append ("AND keypos is not null ");
        try {
            result=this.connection.createStatement().executeQuery (cmd.toString ());
            try { ((ResultSetSapDB)result).setFromMetaData(true); } catch(ClassCastException ccx) {}
        }
        catch (SQLException exc) {
            if (exc.getErrorCode () == 100) {
                String [] colHeadings = {"SCOPE", "COLUMN_NAME",
                        "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE",
                        "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
                Object [][] rows = { {
                    new Integer (DatabaseMetaData.bestRowSession),
                    "SYSKEY",
                    new Integer (Types.BINARY),
                    "CHARBYTE",
                    new Integer (8),
                    null,
                    null,
                    new Integer (DatabaseMetaData.bestRowPseudo),
                    }};
                result = new MemoryResultSetSapDB (colHeadings, rows);
            }
            else {
                throw exc;
            }
        }
        return result;
    }
    /**
     * getCatalogs method comment.
     */
    public ResultSet getCatalogs() throws SQLException {
        ResultSet result;
        String [] colHeadings = {"TABLE_CAT"};
        Object [][] rows = {{defaultCatalogName},};

        result = new MemoryResultSetSapDB (colHeadings, rows);
        return result;
    }
    /**
     * getCatalogSeparator method comment.
     */
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }
    /**
     * getCatalogTerm method comment.
     */
    public String getCatalogTerm() throws SQLException {
        return "DATABASE";
    }
    /**
     * getColumnPrivileges method comment.
     */
    public ResultSet getColumnPrivileges(
        String catalog,
        String schema,
        String table,
        String columnNamePattern)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' TABLE_CAT, "
            + "table_owner TABLE_SCHEM, "
            + "TABLE_NAME, "
            + "COLUMN_NAME, "
            + "GRANTOR, "
            + "GRANTEE, "
            + "PRIVILEGE, "
            + "IS_GRANTABLE "
            + "FROM domain.columnprivileges WHERE ");
        cmd.append ("table_name = '" + table + "' ");
        if (this.realQualification (schema)) {
            cmd.append ("AND table_owner = '" + schema + "' ");
        }
        if (this.realPatternQualification (columnNamePattern)) {
            cmd.append ("AND column_name LIKE '" + columnNamePattern + "' ");
        }
        cmd.append (" ORDER BY column_name, privilege ");
        return this.internalQuery (cmd.toString (), "getColumnPrivileges");
    }
    /**
     * getColumns method comment.
     */
    public ResultSet getColumns(
        String catalog,
        String schemaPattern,
        String tableNamePattern,
        String columnNamePattern)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();
        StringBuffer qualification = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' TABLE_CAT, "
            + "owner TABLE_SCHEM, "
            + "tablename TABLE_NAME, "
            + "columnname COLUMN_NAME, "
            + "decode (((decode (datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype))), "
            + typename2odbc_C + ") DATA_TYPE, "
            + "(decode(datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype)) TYPE_NAME, "
            + "len COLUMN_SIZE, "
            + "NULL BUFFER_LENGTH, "
            + "dec DECIMAL_DIGITS, "
            + "10 NUM_PREC_RADIX, "
            + "decode (mode, 'OPT', 1, 0) NULLABLE, "
            + "comment REMARKS, "
            + "\"DEFAULT\" COLUMN_DEF, "
            + "NULL SQL_DATA_TYPE, "
            + "NULL SQL_DATETIME_SUB, "
            + "len CHAR_OCTET_LENGTH, ");
            if (this.connection.isSQLModeOracle)
              cmd.append( "ROWNUM ORDINAL_POSITION, ");
            else
              cmd.append( "ROWNO ORDINAL_POSITION, ");
            cmd.append( "decode (mode, 'OPT', 'YES', 'NO') IS_NULLABLE "
            + "FROM domain.columns ");
        if (this.realPatternQualification (schemaPattern)) {
            qualification.append ("AND owner LIKE '" + schemaPattern + "' ");
        }
        if (this.realPatternQualification (tableNamePattern)) {
            qualification.append ("AND tablename LIKE '" + tableNamePattern + "' ");
        }
        if (this.realPatternQualification (columnNamePattern)) {
            qualification.append ("AND columnname LIKE '" + columnNamePattern + "' ");
        }
        if (qualification.length () > 0) {
            cmd.append (" WHERE 1 = 1 ");
            cmd.append (qualification.toString ());
        }
        cmd.append (" ORDER BY owner, tablename, pos ");
        return this.internalQuery (cmd.toString (), "getColumns");
    }
    /**
     * JDBC 2.0
     * Retrieves the connection that produced this metadata object.
     *
     * @return the connection that produced this metadata object
     */
    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }
    /**
     * getCrossReference method comment.
     */
    public ResultSet getCrossReference(
        String primaryCatalog,
        String primarySchema,
        String primaryTable,
        String foreignCatalog,
        String foreignSchema,
        String foreignTable)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' PKTABLE_CAT, "
            + "PKTABLE_OWNER PKTABLE_SCHEM, "
            + "PKTABLE_NAME, "
            + "PKCOLUMN_NAME, "
            + "'"+defaultCatalogName+"' FKTABLE_CAT, "
            + "FKTABLE_OWNER FKTABLE_SCHEM, "
            + "FKTABLE_NAME, "
            + "FKCOLUMN_NAME, "
            + "KEY_SEQ, "
            + DatabaseMetaData.importedKeyRestrict+" UPDATE_RULE,"
            + "DELETE_RULE, "
            + "FK_NAME, "
            + "PK_NAME, "
            + DatabaseMetaData.importedKeyRestrict+" DEFERRABILITY "   // importedKeyNotDeferrable
            + "FROM sysodbcforeignkeys ");
        cmd.append ("WHERE pktable_name = '" + primaryTable + "' ");
        cmd.append ("AND fktable_name = '" + foreignTable + "' ");
        if (this.realQualification(primarySchema)) {
            cmd.append ("AND PKTABLE_OWNER = '" + primarySchema + "' ");
        }
        if (this.realQualification(foreignSchema)) {
            cmd.append ("AND FKTABLE_OWNER = '" + foreignSchema + "' ");
        }
        String fullCmd = cmd.toString ();
        return this.internalQuery (fullCmd, "getCrossReference");
    }
    /**
     * getDatabaseProductName method comment.
     */
    public String getDatabaseProductName() throws SQLException {
        return DriverSapDB.driverName_C;
    }
    /**
     * getDatabaseProductVersion method comment.
     */
    public String getDatabaseProductVersion() throws SQLException {
        if (this.dbVersion != null) {
            return this.dbVersion;
        }
        String result;

        ResultSet resultSet = this.internalQuery (
            "Select kernel from domain.versions", "getDatabaseProductVersion");
        resultSet.next ();
        result = resultSet.getString (1);
        this.dbVersion = result;
        resultSet.close ();
        return result;
    }
    /**
     * getDefaultTransactionIsolation method comment.
     */
    public int getDefaultTransactionIsolation() throws SQLException {
        return Connection.TRANSACTION_READ_COMMITTED;
    }
    /**
     * getDriverMajorVersion method comment.
     */
    public int getDriverMajorVersion() {
        return DriverSapDB.singleton ().getMajorVersion ();
    }
    /**
     * getDriverMinorVersion method comment.
     */
    public int getDriverMinorVersion() {
        return DriverSapDB.singleton ().getMinorVersion ();
    }
    /**
     * getDriverName method comment.
     */
    public String getDriverName() throws SQLException {
        return  DriverSapDB.singleton ().getName ();
    }
    /**
     * getDriverVersion method comment.
     */
    public String getDriverVersion() throws SQLException {
        return  DriverSapDB.singleton ().getVersionString ();
    }
    /**
     * getExportedKeys method comment.
     */
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' PKTABLE_CAT, "
            + "PKTABLE_OWNER PKTABLE_SCHEM, "
            + "PKTABLE_NAME, "
            + "PKCOLUMN_NAME, "
            + "'"+defaultCatalogName+"' FKTABLE_CAT, "
            + "FKTABLE_OWNER FKTABLE_SCHEM, "
            + "FKTABLE_NAME, "
            + "FKCOLUMN_NAME, "
            + "KEY_SEQ, "
            + DatabaseMetaData.importedKeyRestrict+" UPDATE_RULE,"
            + "DELETE_RULE, "
            + "FK_NAME, "
            + "PK_NAME, "
            + DatabaseMetaData.importedKeyRestrict+" DEFERRABILITY "   // importedKeyNotDeferrable
            + "FROM sysodbcforeignkeys ");
        cmd.append ("WHERE pktable_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append ("AND PKTABLE_OWNER = '" + schema + "' ");
        }
        return this.internalQuery (cmd.toString (), "getExportedKeys");
    }
    /**
     * getExtraNameCharacters method comment.
     */
    public String getExtraNameCharacters() throws SQLException {
        return "#@$";
    }
    /**
     * getIdentifierQuoteString method comment.
     */
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }
    /**
     * getImportedKeys method comment.
     */
    public ResultSet getImportedKeys(
        String catalog,
        String schema,
        String table)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' PKTABLE_CAT, "
            + "PKTABLE_OWNER PKTABLE_SCHEM, "
            + "PKTABLE_NAME, "
            + "PKCOLUMN_NAME, "
            + "'"+defaultCatalogName+"' FKTABLE_CAT, "
            + "FKTABLE_OWNER FKTABLE_SCHEM, "
            + "FKTABLE_NAME, "
            + "FKCOLUMN_NAME, "
            + "KEY_SEQ, "
            + DatabaseMetaData.importedKeyRestrict+" UPDATE_RULE,"
            + "DELETE_RULE, "
            + "FK_NAME, "
            + "PK_NAME, "
            + DatabaseMetaData.importedKeyRestrict+" DEFERRABILITY "   // importedKeyNotDeferrable
            + "FROM sysodbcforeignkeys ");
        cmd.append ("WHERE fktable_name = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append ("AND FKTABLE_OWNER = '" + schema + "' ");
        }
        return this.internalQuery (cmd.toString (), "getImportedKeys");
    }
    /**
     * getIndexInfo method comment.
     */
    public ResultSet getIndexInfo(
        String catalog,
        String schema,
        String table,
        boolean unique,
        boolean approximate)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' TABLE_CAT, "
            + "table_owner TABLE_SCHEM, "
            + "TABLE_NAME, "
            + "decode (non_unique, 1, 'true', 'false') NON_UNIQUE, "
            + "INDEX_QUALIFIER, "
            + "INDEX_NAME, "
            + "TYPE, "
            + "seq_in_index ORDINAL_POSITION, "
            + "COLUMN_NAME, "
            + "collation ASC_OR_DESC, "
            + "CARDINALITY, "
            + "PAGES, "
            + "FILTER_CONDITION "
            + "FROM sysodbcindexes ");
        cmd.append ("WHERE INDEX_NAME <> 'SYSPRIMARYKEYINDEX' ");
        cmd.append ("AND table_name = '" + table + "' ");
        if (this.realQualification (schema)) {
            cmd.append ("AND table_owner = '" + schema + "' ");
        }
        if (unique) {
            cmd.append ("AND non_unique = 0 ");
        }
        return this.internalQuery (cmd.toString (), "getIndexInfo");
    }
    /**
     * getMaxBinaryLiteralLength method comment.
     */
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 8000;
    }
    /**
     * getMaxCatalogNameLength method comment.
     */
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }
    /**
     * getMaxCharLiteralLength method comment.
     */
    public int getMaxCharLiteralLength() throws SQLException {
        return 4000;
    }
    /**
     * getMaxColumnNameLength method comment.
     */
    public int getMaxColumnNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getMaxColumnsInGroupBy method comment.
     */
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }
    /**
     * getMaxColumnsInIndex method comment.
     */
    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }
    /**
     * getMaxColumnsInOrderBy method comment.
     */
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }
    /**
     * getMaxColumnsInSelect method comment.
     */
    public int getMaxColumnsInSelect() throws SQLException {
        return 254;
    }
    /**
     * getMaxColumnsInTable method comment.
     */
    public int getMaxColumnsInTable() throws SQLException {
        return 254;
    }
    /**
     * getMaxConnections method comment.
     */
    public int getMaxConnections() throws SQLException {
      try {
          ResultSet rs = this.connection.createStatement().executeQuery(
            "select value from dbparameters "
           +"   where description = 'MAXUSERTASKS'"
          );
        rs.next();
        int max = rs.getInt(1);
        rs.close();
        return max;
      }
      catch (SQLException ex) {
        return 0;
      }
    }
    /**
     * getMaxCursorNameLength method comment.
     */
    public int getMaxCursorNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getMaxIndexLength method comment.
     */
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }
    /**
     * getMaxProcedureNameLength method comment.
     */
    public int getMaxProcedureNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getMaxRowSize method comment.
     */
    public int getMaxRowSize() throws SQLException {
        return 0;
    }
    /**
     * getMaxSchemaNameLength method comment.
     */
    public int getMaxSchemaNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getMaxStatementLength method comment.
     */
    public int getMaxStatementLength() throws SQLException {
        return this.connection.maxStatementLength ();
    }
    /**
     * getMaxStatements method comment.
     */
    public int getMaxStatements() throws SQLException {
        return Integer.MAX_VALUE;
    }
    /**
     * getMaxTableNameLength method comment.
     */
    public int getMaxTableNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getMaxTablesInSelect method comment.
     */
    public int getMaxTablesInSelect() throws SQLException {
        return 16;
    }
    /**
     * getMaxUserNameLength method comment.
     */
    public int getMaxUserNameLength() throws SQLException {
        return Vsp00Const.KnlIdentifier_C;
    }
    /**
     * getNumericFunctions method comment.
     */
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }
    /**
     * getPrimaryKeys method comment.
     */
    public ResultSet getPrimaryKeys(
        String catalog,
        String schema,
        String table)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' TABLE_CAT, "
            + "owner TABLE_SCHEM , "
            + "tablename TABLE_NAME, "
            + "columnname COLUMN_NAME, "
            + "keypos KEY_SEQ, "
            + "null PK_NAME "
            + "FROM domain.columns ");
        cmd.append ("WHERE tablename = '" + table + "' ");
        if (this.realQualification(schema)) {
            cmd.append ("AND owner = '" + schema + "' ");
        }
        cmd.append ("AND keypos is not null ");
        cmd.append (" ORDER BY column_name ");
        return this.internalQuery (cmd.toString (), "getPrimaryKeys");
    }
    /**
     * getProcedureColumns method comment.
     */
    public ResultSet getProcedureColumns(
        String catalog,
        String schemaPattern,
        String procedureNamePattern,
        String columnNamePattern)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();
        StringBuffer qualification = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' PROCEDURE_CAT, "
            + "owner PROCEDURE_SCHEM, "
            + "dbprocname PROCEDURE_NAME, "
            + "parametername COLUMN_NAME, "
            + "decode (\"IN/OUT-TYPE\", 'IN', 1, '   OUT', 2, 'IN/OUT', 4, 0) COLUMN_TYPE, "
            + "decode (((decode (datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype))), "
            + typename2odbc_C + ") DATA_TYPE, "
            + "(decode(datatype,"+DataTypeSuffix_C+"))|| (' ' || (codetype)) TYPE_NAME, "
            + "len PRECISION, "
            + "len \"LENGTH\", "
            + "dec SCALE, "
            + "10 RADIX, "
            + "2 NULLABLE, "
            + "NULL REMARKS "
            + "FROM domain.dbprocparams ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append ("AND owner like '" + schemaPattern + "' ");
        }
        if (this.realPatternQualification(procedureNamePattern)) {
            qualification.append ("AND dbprocname like '" + procedureNamePattern + "' ");
        }
        if (this.realPatternQualification(columnNamePattern)) {
            qualification.append ("AND parametername like '" + columnNamePattern + "' ");
        }
        if (qualification.length () > 0) {
            cmd.append ("WHERE TRUE ");
            cmd.append (qualification.toString ());
        }
        cmd.append ("ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME, pos ");
        return this.internalQuery (cmd.toString (), "getProcedureColumns");
    }
    /**
     * getProcedures method comment.
     */
    public ResultSet getProcedures(
        String catalog,
        String schemaPattern,
        String procedureNamePattern)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();
        StringBuffer qualification = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' PROCEDURE_CAT, "
            + "owner PROCEDURE_SCHEM, "
            + "dbprocname PROCEDURE_NAME, "
            + "NULL RESERVED4, "
            + "NULL RESERVED5, "
            + "NULL RESERVED6, "
            + "comment REMARKS, "
            + "1 PROCEDURE_TYPE "
            + "FROM domain.DBPROCEDURES ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append ("AND owner like '" + schemaPattern + "' ");
        }
        if (this.realPatternQualification(procedureNamePattern)) {
            qualification.append ("AND dbprocname like '" + procedureNamePattern + "' ");
        }
        if (qualification.length () > 0) {
            cmd.append ("WHERE 1 = 1 ");
            cmd.append (qualification.toString ());
        }
        return this.internalQuery (cmd.toString (), "getProcedures");
    }
    /**
     * getProcedureTerm method comment.
     */
    public String getProcedureTerm() throws SQLException {
        return "StoredProcedure";
    }
    /**
     * getSchemas method comment.
     */
    public ResultSet getSchemas() throws SQLException {
        return this.internalQuery ("Select username TABLE_SCHEM from domain.users  WHERE USERMODE <> 'COLDUSER' order by TABLE_SCHEM", "getSchemas");
    }
    /**
     * getSchemaTerm method comment.
     */
    public String getSchemaTerm() throws SQLException {
        return "SCHEM";
    }
    /**
     * getSearchStringEscape method comment.
     */
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }
    /**
     * getSQLKeywords method comment.
     */
    public String getSQLKeywords() throws SQLException {
        return "ABS,ACOS,ADDDATE,ADDTIME,ALPHA,ASCII,ASIN,ATAN,ATAN2,BINARY,BOOLEAN,BYTE,CEIL,CEILING,CHR,CONCAT,CONNECTED,COS,COSH,COT,CURDATE,CURTIME,DATABASE,DATEDIFF,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,DBYTE,DECODE,DEFAULT,DEGREES,DIGITS,DIRECT,EBCDIC,ENTRY,ENTRYDEF,EXP,EXPAND,FIXED,FLOOR,GRAPHIC,GREATEST,HEX,IFNULL,INITCAP,INT,INTERNAL,LCASE,LEAST,LENGTH,LFILL,LINK,LIST,LN,LOCALSYSDBA,LOCATE,LOG,LOG10,LONG,LPAD,LTRIM,MAKEDATE,MAKETIME,MAPCHAR,MBCS,MICROSECOND,MOD,MONTHNAME,NOROUND,NOW,NUM,OBJECT,PACKED,PI,POWER,PREV,RADIANS,REAL,REFERENCED,REJECT,REPLACE,RFILL,ROUND,ROWID,ROWNO,RPAD,RTRIM,SELUPD,SHOW,SIGN,SIN,SINH,SOUNDEX,SPACE,SQRT,STAMP,STATISTICS,STDDEV,SUBDATE,SUBSTR,SUBTIME,SYSDBA,TAN,TANH,TIMEDIFF,TIMEZONE,TOIDENTIFIER,TRIM,TRUNC,TRUNCATE,UCASE,UNICODE,USERGROUP,VARGRAPHIC,VARIANCE,WEEK,WEEKOFYEAR,ZONED";
    }
    /**
     * getStringFunctions method comment.
     */
    public String getStringFunctions() throws SQLException {
        return "ASCII,CONCAT,LCASE,LEFT,LENGTH,LOCATE,LOCATE_2,LTRIM,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,SUBSTRING,UCASE,ISNULL";
    }
    /**
     * getSystemFunctions method comment.
     */
    public String getSystemFunctions() throws SQLException {
        return "DBNAME,IFNULL,USERNAME";
    }
    /**
     * getTablePrivileges method comment.
     */
    public ResultSet getTablePrivileges(
        String catalog,
        String schemaPattern,
        String tableNamePattern)
            throws SQLException
    {
        StringBuffer cmd = new StringBuffer ();
        StringBuffer qualification = new StringBuffer ();

        cmd.append ("SELECT "
            + "'"+defaultCatalogName+"' TABLE_CAT, "
            + "OWNER TABLE_SCHEM, "
            + "TABLENAME TABLE_NAME, "
            + "GRANTOR, "
            + "GRANTEE, "
            + "PRIVILEGE, "
            + "IS_GRANTABLE "
            + "FROM domain.tableprivileges ");
        if (this.realPatternQualification(schemaPattern)) {
            qualification.append ("AND owner LIKE '" + schemaPattern + "' ");
        }
        if (this.realPatternQualification(tableNamePattern)) {
            qualification.append ("AND tablename LIKE '" + tableNamePattern + "' ");
        }
        if (qualification.length () > 0) {
            cmd.append ("WHERE 1 = 1 ");
            cmd.append (qualification.toString ());
        }
        cmd.append (" ORDER BY owner, tablename ");
        return this.internalQuery (cmd.toString (), "getTablePrivileges");
    }
    /**
     * getTables method comment.
     */
    public ResultSet
    getTables(
        String catalog,
        String schemaPattern,
        String tableNamePattern,
        java.lang.String[] types)
    throws
        SQLException
    {
        StringBuffer buf = new StringBuffer ();

        buf.append ("SELECT '"+defaultCatalogName+"' TABLE_CAT, owner TABLE_SCHEM, ");
        buf.append ("tablename TABLE_NAME, type TABLE_TYPE, ");
        buf.append ("comment REMARKS from domain.tables WHERE 1 = 1 ");
        if (this.realPatternQualification (schemaPattern)) {
            buf.append ("AND owner LIKE '" + schemaPattern + "' ");
        }
        if (this.realPatternQualification (tableNamePattern)) {
            buf.append ("AND tablename LIKE '" + tableNamePattern + "' ");
        }
        if (types == null) {
            buf.append ("AND type <> 'RESULT' ");
        }
        else if ((types != null) && (types.length > 0)) {
            buf.append ("AND type in ('" + types [0] + "'");
            for (int i = 1; i < types.length; ++i) {
                buf.append (",'" + types [i] + "'");
            }
            buf.append (") ");
        }
        buf.append ("ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        return this.internalQuery (buf.toString (), "getTables");
    }
    /**
     * getTableTypes method comment.
     */
    public ResultSet getTableTypes() throws SQLException {
        ResultSet result;
        String [] colHeadings = {"TABLE_TYPE"};
        Object [][] rows = {
            {"RESULT"},
            {"SYNONYM"},
            {"SYSTEM"},
            {"TABLE"},
            {"VIEW"},
            };

        result = new MemoryResultSetSapDB (colHeadings, rows);
        return result;
    }
    /**
     * getTimeDateFunctions method comment.
     */
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,SECOND,WEEK,YEAR";
    }
    /**
     * getTypeInfo method comment.
     */
    public ResultSet getTypeInfo() throws SQLException {
        // to do: cache result in a memory resultset
        StringBuffer cmd = new StringBuffer ();
        cmd.append ("SELECT "
            + "TYPE_NAME, "
            + "decode (TYPE_NAME, " + typename2odbc_C + ") DATA_TYPE, "
            + "PRECISION, "                 //!!! COLUMN_SIZE
            + "LITERAL_PREFIX, "
            + "LITERAL_SUFFIX, "
            + "CREATE_PARAMS, "
            + "NULLABLE, "
            + "CASE_SENSITIVE, "
            + "SEARCHABLE, "
            + "UNSIGNED_ATTRIBUTE, "
            + "money FIXED_PREC_SCALE , "   //!!! FIXED_PREC_SCALE
            + "AUTO_INCREMENT, "             //!!! AUTO_UNIQUE_VALUE
            + "LOCAL_TYPE_NAME, "
            + "MINIMUM_SCALE, "
            + "MAXIMUM_SCALE, "
            + "NULL SQL_DATA_TYPE , "       //!!! definiert
            + "NULL SQL_DATETIME_SUB , "    //!!! definiert
            + "10 NUM_PREC_RADIX "
                                             //!!! INTERVAL_PRECISION
            + "FROM sysodbctypes ");
            if (this.connection.isSQLModeOracle){
              cmd.append("WHERE TYPE_NAME NOT IN ('TIMESTAMP','TIME','BOOLEAN','FIXED') ");
            }
            cmd.append("ORDER BY DATA_TYPE ");

        return this.internalQuery (cmd.toString (), "getTypeInfo");
    }
    /**
     * JDBC 2.0
     *
     * Gets a description of the user-defined types defined in a particular
     * schema.  Schema-specific UDTs may have type JAVA_OBJECT, STRUCT,
     * or DISTINCT.
     *
     * <P>Only types matching the catalog, schema, type name and type
     * criteria are returned.  They are ordered by DATA_TYPE, TYPE_SCHEM
     * and TYPE_NAME.  The type name parameter may be a fully-qualified
     * name.  In this case, the catalog and schemaPattern parameters are
     * ignored.
     *
     * <P>Each type description has the following columns:
     *  <OL>
     *  <LI><B>TYPE_CAT</B> String => the type's catalog (may be null)
     *  <LI><B>TYPE_SCHEM</B> String => type's schema (may be null)
     *  <LI><B>TYPE_NAME</B> String => type name
     *  <LI><B>CLASS_NAME</B> String => Java class name
     *  <LI><B>DATA_TYPE</B> String => type value defined in java.sql.Types.
     *  One of JAVA_OBJECT, STRUCT, or DISTINCT
     *  <LI><B>REMARKS</B> String => explanatory comment on the type
     *  </OL>
     *
     * <P><B>Note:</B> If the driver does not support UDTs, an empty
     * result set is returned.
     *
     * @param catalog a catalog name; "" retrieves those without a
     * catalog; null means drop catalog name from the selection criteria
     * @param schemaPattern a schema name pattern; "" retrieves those
     * without a schema
     * @param typeNamePattern a type name pattern; may be a fully-qualified
     * name
     * @param types a list of user-named types to include (JAVA_OBJECT,
     * STRUCT, or DISTINCT); null returns all types
     * @return ResultSet - each row is a type description
     * @exception SQLException if a database access error occurs
     */
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern,
                  String typeNamePattern, int[] types)
      throws SQLException {
        return new MemoryResultSetSapDB(new String []{"TYPE_CAT",
                                         "TYPE_SCHEM",
                                         "TYPE_NAME",
                                         "CLASS_NAME",
                                         "DATA_TYPE",
                                         "REMARKS" ,
                                         "BASE_TYPE"},
                                         new Object [] [] {} );
    }
    /**
     * getURL method comment.
     */
    public String getURL() throws SQLException {
        return this.connection.getConnectProperty ("dburl");
    }
    /**
     * getUserName method comment.
     */
    public String getUserName() throws SQLException {
        return this.connection.getConnectProperty ("user");
    }
    /**
     * getVersionColumns method comment.
     */
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
      return new MemoryResultSetSapDB(new String []{"SCOPE",
                                         "COLUMN_NAME",
                                         "DATA_TYPE",
                                         "TYPE_NAME",
                                         "COLUMN_SIZE",
                                         "BUFFER_LENGTH" ,
                                         "DECIMAL_DIGITS" ,
                                         "PSEUDO_COLUMN"},
                                         new Object [] [] {} );
    }
    /**
     *
     * @return boolean
     * @param resultSetType int
     * @exception java.sql.SQLException The exception description.
     */
    public boolean insertsAreDetected (int resultSetType) throws SQLException {
        return false;
    }
    /**
     *
     * @return java.sql.ResultSet
     * @param cmd java.lang.String
     * @param routine java.lang.String
     * @exception java.sql.SQLException The exception description.
     */
    private ResultSet internalQuery (String cmd, String routine) throws SQLException {
        ResultSet result;
        com.sap.dbtech.util.Tracer.println("<Internal Query routine="+routine+" >\n"+cmd+"\n</Internal Query>\n");
        try {
            result = this.connection.createStatement().executeQuery (cmd);
            try { ((ResultSetSapDB)result).setFromMetaData(true); } catch(ClassCastException ccx) {}
        }
        catch (DatabaseException dbExc) {
            throw new InternalJDBCError (routine, dbExc);
        }
        return result;
    }
    /**
     * isCatalogAtStart method comment.
     */
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }
    /**
     * isReadOnly method comment.
     */
    public boolean isReadOnly() throws SQLException {
        return false;
    }
    /**
     * nullPlusNonNullIsNull method comment.
     */
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }
    /**
     * nullsAreSortedAtEnd method comment.
     */
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }
    /**
     * nullsAreSortedAtStart method comment.
     */
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }
    /**
     * nullsAreSortedHigh method comment.
     */
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }
    /**
     * nullsAreSortedLow method comment.
     */
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether deletes made by others are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if deletes made by others
     * are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean othersDeletesAreVisible(int type) throws SQLException
    {
        return false;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether inserts made by others are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return true if updates are visible for the result set type
     * @return <code>true</code> if inserts made by others
     * are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean othersInsertsAreVisible(int type) throws SQLException
    {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether updates made by others are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if updates made by others
     * are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether a result set's own deletes are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if deletes are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether a result set's own inserts are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if inserts are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether a result set's own updates are visible.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if updates are visible for the result set type;
     *        <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }
    /**
     *
     * @return boolean
     * @param pattern java.lang.String
     */
    private boolean realPatternQualification (String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.length () == 0) {
            return false;
        }
        if (pattern.equals ("*")) {
            return false;
        }
        return true;
    }
    /**
     *
     * @return boolean
     * @param pattern java.lang.String
     */
    private boolean realQualification (String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.length () == 0) {
            return false;
        }
        return true;
    }
    /**
     * storesLowerCaseIdentifiers method comment.
     */
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }
    /**
     * storesLowerCaseQuotedIdentifiers method comment.
     */
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }
    /**
     * storesMixedCaseIdentifiers method comment.
     */
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }
    /**
     * storesMixedCaseQuotedIdentifiers method comment.
     */
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }
    /**
     * storesUpperCaseIdentifiers method comment.
     */
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }
    /**
     * storesUpperCaseQuotedIdentifiers method comment.
     */
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }
    /**
     * supportsAlterTableWithAddColumn method comment.
     */
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }
    /**
     * supportsAlterTableWithDropColumn method comment.
     */
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }
    /**
     * supportsANSI92EntryLevelSQL method comment.
     */
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }
    /**
     * supportsANSI92FullSQL method comment.
     */
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }
    /**
     * supportsANSI92IntermediateSQL method comment.
     */
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }
    /**
     *
     * @return boolean
     * @exception java.sql.SQLException The exception description.
     */
    public boolean supportsBatchUpdates () throws SQLException {
        return true;
    }
    /**
     * supportsCatalogsInDataManipulation method comment.
     */
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }
    /**
     * supportsCatalogsInIndexDefinitions method comment.
     */
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }
    /**
     * supportsCatalogsInPrivilegeDefinitions method comment.
     */
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }
    /**
     * supportsCatalogsInProcedureCalls method comment.
     */
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }
    /**
     * supportsCatalogsInTableDefinitions method comment.
     */
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }
    /**
     * supportsColumnAliasing method comment.
     */
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }
    /**
     * supportsConvert method comment.
     */
    public boolean supportsConvert() throws SQLException {
        return false;
    }
    /**
     * supportsConvert method comment.
     */
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }
    /**
     * supportsCoreSQLGrammar method comment.
     */
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }
    /**
     * supportsCorrelatedSubqueries method comment.
     */
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }
    /**
     * supportsDataDefinitionAndDataManipulationTransactions method comment.
     */
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }
    /**
     * supportsDataManipulationTransactionsOnly method comment.
     */
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }
    /**
     * supportsDifferentTableCorrelationNames method comment.
     */
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }
    /**
     * supportsExpressionsInOrderBy method comment.
     */
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }
    /**
     * supportsExtendedSQLGrammar method comment.
     */
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }
    /**
     * supportsFullOuterJoins method comment.
     */
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }
    /**
     * supportsGroupBy method comment.
     */
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }
    /**
     * supportsGroupByBeyondSelect method comment.
     */
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }
    /**
     * supportsGroupByUnrelated method comment.
     */
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }
    /**
     * supportsIntegrityEnhancementFacility method comment.
     */
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }
    /**
     * supportsLikeEscapeClause method comment.
     */
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }
    /**
     * supportsLimitedOuterJoins method comment.
     */
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }
    /**
     * supportsMinimumSQLGrammar method comment.
     */
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }
    /**
     * supportsMixedCaseIdentifiers method comment.
     */
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }
    /**
     * supportsMixedCaseQuotedIdentifiers method comment.
     */
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }
    /**
     * supportsMultipleResultSets method comment.
     */
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }
    /**
     * supportsMultipleTransactions method comment.
     */
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }
    /**
     * supportsNonNullableColumns method comment.
     */
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }
    /**
     * supportsOpenCursorsAcrossCommit method comment.
     */
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }
    /**
     * supportsOpenCursorsAcrossRollback method comment.
     */
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }
    /**
     * supportsOpenStatementsAcrossCommit method comment.
     */
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }
    /**
     * supportsOpenStatementsAcrossRollback method comment.
     */
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }
    /**
     * supportsOrderByUnrelated method comment.
     */
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }
    /**
     * supportsOuterJoins method comment.
     */
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }
    /**
     * supportsPositionedDelete method comment.
     */
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }
    /**
     * supportsPositionedUpdate method comment.
     */
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Does the database support the concurrency type in combination
     * with the given result set type?
     *
     * @param type defined in <code>java.sql.ResultSet</code>
     * @param concurrency type defined in <code>java.sql.ResultSet</code>
     * @return <code>true</code> if so; <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     * @see Connection
     */
    public boolean supportsResultSetConcurrency(int type, int concurrency)
      throws SQLException
    {
        switch (type) {
            case java.sql.ResultSet.TYPE_FORWARD_ONLY:
            case java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE:
            case java.sql.ResultSet.TYPE_SCROLL_SENSITIVE:
                break;
            default:
                throw new InvalidArgumentValue ("resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
        }
        switch (concurrency) {
            case java.sql.ResultSet.CONCUR_READ_ONLY:
            case java.sql.ResultSet.CONCUR_UPDATABLE:
                // OK
                break;
            default:
                throw new InvalidArgumentValue ("resultSetConcurrency", "CONCUR_READ_ONLY, CONCUR_UPDATABLE");
        }
        return true;
    }
    //--------------------------JDBC 2.0-----------------------------

    /**
     * JDBC 2.0
     *
     * Does the database support the given result set type?
     *
     * @param type defined in <code>java.sql.ResultSet</code>
     * @return <code>true</code> if so; <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     * @see Connection
     */
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case java.sql.ResultSet.TYPE_FORWARD_ONLY:
            case java.sql.ResultSet.TYPE_SCROLL_INSENSITIVE:
            case java.sql.ResultSet.TYPE_SCROLL_SENSITIVE:
                break;
            default:
                throw new InvalidArgumentValue ("resultSetType", "TYPE_FORWARD_ONLY, TYPE_SCROLL_INSENSITIVE, TYPE_SCROLL_SENSITIVE");
        }
        return true;
    }
    /**
     * supportsSchemasInDataManipulation method comment.
     */
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }
    /**
     * supportsSchemasInIndexDefinitions method comment.
     */
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }
    /**
     * supportsSchemasInPrivilegeDefinitions method comment.
     */
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }
    /**
     * supportsSchemasInProcedureCalls method comment.
     */
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }
    /**
     * supportsSchemasInTableDefinitions method comment.
     */
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }
    /**
     * supportsSelectForUpdate method comment.
     */
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }
    /**
     * supportsStoredProcedures method comment.
     */
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }
    /**
     * supportsSubqueriesInComparisons method comment.
     */
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }
    /**
     * supportsSubqueriesInExists method comment.
     */
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }
    /**
     * supportsSubqueriesInIns method comment.
     */
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }
    /**
     * supportsSubqueriesInQuantifieds method comment.
     */
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }
    /**
     * supportsTableCorrelationNames method comment.
     */
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }
    /**
     * supportsTransactionIsolationLevel method comment.
     */
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (level == Connection.TRANSACTION_NONE) {
            return false;
        }
        else {
            return true;
        }
    }
    /**
     * supportsTransactions method comment.
     */
    public boolean supportsTransactions() throws SQLException {
        return true;
    }
    /**
     * supportsUnion method comment.
     */
    public boolean supportsUnion() throws SQLException {
        return true;
    }
    /**
     * supportsUnionAll method comment.
     */
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }
    /**
     * JDBC 2.0
     *
     * Indicates whether or not a visible row update can be detected by
     * calling the method <code>ResultSet.rowUpdated</code>.
     *
     * @param result set type, i.e. ResultSet.TYPE_XXX
     * @return <code>true</code> if changes are detected by the result set type;
     *         <code>false</code> otherwise
     * @exception SQLException if a database access error occurs
     */
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }
    /**
     * usesLocalFilePerTable method comment.
     */
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }
    /**
     * usesLocalFiles method comment.
     */
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
  /**
   * Retrieves whether this database supports savepoints.
   * @return <code>true</code> if savepoints are supported;
   * <code>false</code> otherwise
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public boolean supportsSavepoints() throws java.sql.SQLException {
    return true;
  }
  /**
   * Retrieves whether this database supports named parameters to callable statements.
   * @return <code>true</code> if named parameters are supported;
   * <code>false</code> otherwise
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public boolean supportsNamedParameters() throws java.sql.SQLException {
    return true;
  }
  /**
   * Retrieves whether it is possible to have multiple <code>ResultSet</code> objects
   * returned from a <code>CallableStatement</code> object
   * simultaneously.
   * @return <code>true</code> if a <code>CallableStatement</code> object
   * can return multiple <code>ResultSet</code> objects
   * simultaneously; <code>false</code> otherwise
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public boolean supportsMultipleOpenResults() throws java.sql.SQLException {
    return false;
  }
  /**
   * Retrieves whether auto-generated keys can be retrieved after
   * a statement has been executed.
   * @return <code>true</code> if auto-generated keys can be retrieved
   * after a statement has executed; <code>false</code> otherwise
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public boolean supportsGetGeneratedKeys() throws java.sql.SQLException {
    return false;
  }
  /**
   * Retrieves a description of the user-defined type (UDT) hierarchies defined in a
   * particular schema in this database. Only the immediate super type/
   * sub type relationship is modeled.
   *
   * Only supertype information for UDTs matching the catalog,
   * schema, and type name is returned. The type name parameter
   * may be a fully-qualified name. When the UDT name supplied is a
   * fully-qualified name, the catalog and schemaPattern parameters are
   * ignored.
   *
   * If a UDT does not have a direct super type, it is not listed here.
   * A row of the <code>ResultSet</code> object returned by this method
   * describes the designated UDT and a direct supertype. A row has the following
   * columns:
   * <OL>
   * <LI><B>TYPE_CAT</B> String => the UDT's catalog (may be <code>null</code>)
   * <LI><B>TYPE_SCHEM</B> String => UDT's schema (may be <code>null</code>)
   * <LI><B>TYPE_NAME</B> String => type name of the UDT
   * <LI><B>SUPERTYPE_CAT</B> String => the direct super type's catalog
   * (may be <code>null</code>)
   * <LI><B>SUPERTYPE_SCHEM</B> String => the direct super type's schema
   * (may be <code>null</code>)
   * <LI><B>SUPERTYPE_NAME</B> String => the direct super type's name
   * </OL>
   *
   * <P><B>Note:</B> If the driver does not support type hierarchies, an
   * empty result set is returned.
   * @param catalog - a catalog name; "" retrieves those without a catalog;
   * <code>null</code> means drop catalog name from the selection criteria
   * @param schemaPattern - a schema name pattern; "" retrieves those
   * without a schema
   * @param typeNamePattern - a UDT name pattern; may be a fully-qualified
   * name
   * @return object in which a row gives information
   * about the designated UDT
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws java.sql.SQLException {
          return new MemoryResultSetSapDB(new String []{"TYPE_CAT",
                                                        "TYPE_SCHEM",
                                                        "TYPE_NAME",
                                                        "SUPERTYPE_CAT",
                                                        "SUPERTYPE_SCHEM",
                                                        "SUPERTYPE_NAME"},
                                                        new Object [] [] {} );
  }

  /**
   * Retrieves a description of the table hierarchies defined in a particular
   * schema in this database.
   *
   * <P>Only supertable information for tables matching the catalog, schema
   * and table name are returned. The table name parameter may be a fully-
   * qualified name, in which case, the catalog and schemaPattern parameters
   * are ignored. If a table does not have a super table, it is not listed here.
   * Supertables have to be defined in the same catalog and schema as the
   * sub tables. Therefore, the type description does not need to include
   * this information for the supertable.
   *
   * <P>Each type description has the following columns:
   * <OL>
   * <LI><B>TABLE_CAT</B> String => the type's catalog (may be <code>null</code>)
   * <LI><B>TABLE_SCHEM</B> String => type's schema (may be <code>null</code>)
   * <LI><B>TABLE_NAME</B> String => type name
   * <LI><B>SUPERTABLE_NAME</B> String => the direct super type's name
   * </OL>
   *
   * <P><B>Note:</B> If the driver does not support type hierarchies, an
   * empty result set is returned.
   * </P>
   * @param catalog - a catalog name; "" retrieves those without a catalog;
   * <code>null</code> means drop catalog name from the selection criteria
   * @param schemaPattern - a schema name pattern; "" retrieves those
   * without a schema
   * @param tableNamePattern - a table name pattern; may be a fully-qualified
   * name
   * @return a <code>ResultSet</code> object in which each row is a type description
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4
   *
   */
  public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws java.sql.SQLException {
            return new MemoryResultSetSapDB(new String []{"TABLE_CAT",
                                                        "TABLE_SCHEM",
                                                        "TABLE_NAME",
                                                        "SUPERTABLE_NAME"},
                                                        new Object [] [] {}  );
  }
  /**
   * Retrieves a description of the given attribute of the given type
   * for a user-defined type (UDT) that is available in the given schema
   * and catalog.
   * <P>
   * Descriptions are returned only for attributes of UDTs matching the
   * catalog, schema, type, and attribute name criteria. They are ordered by
   * TYPE_SCHEM, TYPE_NAME and ORDINAL_POSITION. This description
   * does not contain inherited attributes.
   * <P>
   * The <code>ResultSet</code> object that is returned has the following
   * columns:
   * <OL>
   * <LI><B>TYPE_CAT</B> String => type catalog (may be <code>null</code>)
   * <LI><B>TYPE_SCHEM</B> String => type schema (may be <code>null</code>)
   * <LI><B>TYPE_NAME</B> String => type name
   * <LI><B>ATTR_NAME</B> String => attribute name
   * <LI><B>DATA_TYPE</B> short => attribute type SQL type from java.sql.Types
   * <LI><B>ATTR_TYPE_NAME</B> String => Data source dependent type name.
   * For a UDT, the type name is fully qualified. For a REF, the type name is
   * fully qualified and represents the target type of the reference type.
   * <LI><B>ATTR_SIZE</B> int => column size.  For char or date
   * types this is the maximum number of characters; for numeric or
   * decimal types this is precision.
   * <LI><B>DECIMAL_DIGITS</B> int => the number of fractional digits
   * <LI><B>NUM_PREC_RADIX</B> int => Radix (typically either 10 or 2)
   * <LI><B>NULLABLE</B> int => whether NULL is allowed
   * <UL>
   * <LI> attributeNoNulls - might not allow NULL values
   * <LI> attributeNullable - definitely allows NULL values
   * <LI> attributeNullableUnknown - nullability unknown
   * </UL>
   * <LI><B>REMARKS</B> String => comment describing column (may be <code>null</code>)
   * <LI><B>ATTR_DEF</B> String => default value (may be <code>null</code>)
   * <LI><B>SQL_DATA_TYPE</B> int => unused
   * <LI><B>SQL_DATETIME_SUB</B> int => unused
   * <LI><B>CHAR_OCTET_LENGTH</B> int => for char types the
   * maximum number of bytes in the column
   * <LI><B>ORDINAL_POSITION</B> int	=> index of column in table
   * (starting at 1)
   * <LI><B>IS_NULLABLE</B> String => "NO" means column definitely
   * does not allow NULL values; "YES" means the column might
   * allow NULL values.  An empty string means unknown.
   * <LI><B>SCOPE_CATALOG</B> String => catalog of table that is the
   * scope of a reference attribute (<code>null</code> if DATA_TYPE isn't REF)
   * <LI><B>SCOPE_SCHEMA</B> String => schema of table that is the
   * scope of a reference attribute (<code>null</code> if DATA_TYPE isn't REF)
   * <LI><B>SCOPE_TABLE</B> String => table name that is the scope of a
   * reference attribute (<code>null</code> if the DATA_TYPE isn't REF)
   * <LI><B>SOURCE_DATA_TYPE</B> short => source type of a distinct type or user-generated
   * Ref type,SQL type from java.sql.Types (<code>null</code> if DATA_TYPE
   * isn't DISTINCT or user-generated REF)
   * </OL>
   * @param catalog - a catalog name; must match the catalog name as it
   * is stored in the database; "" retrieves those without a catalog;
   * <code>null</code> means that the catalog name should not be used to narrow
   * the search
   * @param schemaPattern - a schema name pattern; must match the schema name
   * as it is stored in the database; "" retrieves those without a schema;
   * <code>null</code> means that the schema name should not be used to narrow
   * the search
   * @param typeNamePattern - a type name pattern; must match the
   * type name as it is stored in the database
   * @param attributeNamePattern - an attribute name pattern; must match the attribute
   * name as it is declared in the database
   * @return a <code>ResultSet</code> object in which each row is an
   * attribute description
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public ResultSet getAttributes(String catalog,
                               String schemaPattern,
                               String typeNamePattern,
                               String attributeNamePattern) throws java.sql.SQLException {
          return new MemoryResultSetSapDB(new String []{"TYPE_CAT",
                                                        "TYPE_SCHEM",
                                                        "TYPE_NAME",
                                                        "ATTR_NAME",
                                                        "DATA_TYPE",
                                                        "ATTR_TYPE_NAME",
                                                        "ATTR_SIZE",
                                                        "DECIMAL_DIGITS",
                                                        "NUM_PREC_RADIX",
                                                        "NULLABLE",
                                                        "REMARKS",
                                                        "ATTR_DEF",
                                                        "SQL_DATA_TYPE",
                                                        "SQL_DATETIME_SUB",
                                                        "CHAR_OCTET_LENGTH",
                                                        "ORDINAL_POSITION",
                                                        "IS_NULLABLE",
                                                        "SCOPE_CATALOG",
                                                        "SCOPE_SCHEMA",
                                                        "SCOPE_TABLE",
                                                        "SOURCE_DATA_TYPE"},
                                                        new Object [] [] {} );
  }
  /**
   * Retrieves whether this database supports the given result set holdability.
   * @param holdability - one of the following constants:
   * <code>ResultSet.HOLD_CURSORS_OVER_COMMIT</code> or
   * <code>ResultSet.CLOSE_CURSORS_AT_COMMIT<code>
   * @return <code>true</code> if so; <code>false</code> otherwise
   * @throws java.sql.SQLException - if a database access error occurs1
   * @since 1.4 JDBC 3.0
   *
   */
  public boolean supportsResultSetHoldability(int holdability) throws java.sql.SQLException {
    return true;
  }
  /**
   * Retrieves the default holdability of this <code>ResultSet</code>
   * object.
   * @return the default holdability; either
   * <code>ResultSet.HOLD_CURSORS_OVER_COMMIT</code> or
   * <code>ResultSet.CLOSE_CURSORS_AT_COMMIT</code>
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getResultSetHoldability() throws java.sql.SQLException {
    return ResultSet.HOLD_CURSORS_OVER_COMMIT;
  }
  /**
   * Retrieves the major version number of the underlying database.
   * @return the underlying database's major version
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getDatabaseMajorVersion() throws java.sql.SQLException {
     return this.dbVersionInfo.getMajorVersion();
  }
  /**
   * Retrieves the minor version number of the underlying database.
   * @return underlying database's minor version
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getDatabaseMinorVersion() throws java.sql.SQLException {
     return this.dbVersionInfo.getMinorVersion();
  }
  /**
   * Retrieves the major JDBC version number for this
   *  driver.
   * @return JDBC version major number
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getJDBCMajorVersion() throws java.sql.SQLException {
     return 3;
  }
  /**
   * Retrieves the minor JDBC version number for this
   *  driver.
   * @return JDBC version minor number
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getJDBCMinorVersion() throws java.sql.SQLException {
     return 0;
  }
  /**
   * Indicates whether the SQLSTATEs returned by <code>SQLException.getSQLState</code>
   * is X/Open (now known as Open Group) SQL CLI or SQL99.
   * @return the type of SQLSTATEs, one of:
   * sqlStateXOpen or
   * sqlStateSQL99
   * @throws java.sql.SQLException - if a database access error occurs
   * @since 1.4 JDBC 3.0
   *
   */
  public int getSQLStateType() throws java.sql.SQLException {
    return DatabaseMetaData.sqlStateSQL99;
  }
  public boolean locatorsUpdateCopy() throws SQLException {
    return false;
  }
  public boolean supportsStatementPooling() throws SQLException {
    return (this.connection.parseCache != null)?true:false;
  }
}
